/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;

public class NilCheckResolver
extends ErrorReportingASTVisitor {
    private static final IOSMethodBinding NIL_CHK_DECL = IOSMethodBinding.newFunction("nil_chk", Types.resolveIOSType("id"), null, Types.resolveIOSType("id"));
    private final ArrayList<Set<IVariableBinding>> safeVarsStack = Lists.newArrayList();
    private Set<IVariableBinding> safeVarsTrue = Sets.newHashSet();
    private Set<IVariableBinding> safeVarsFalse = Sets.newHashSet();

    private void pushScope() {
        this.safeVarsStack.add(Sets.newHashSet());
    }

    private void popScope() {
        this.safeVarsStack.remove(this.safeVarsStack.size() - 1);
    }

    private void clearConditionalSafeVars() {
        this.safeVarsTrue.clear();
        this.safeVarsFalse.clear();
    }

    private void addSafeVar(IVariableBinding iVariableBinding) {
        if (this.safeVarsStack.size() > 0) {
            this.safeVarsStack.get(this.safeVarsStack.size() - 1).add(iVariableBinding);
        }
    }

    private void addSafeVars(Set<IVariableBinding> set) {
        if (this.safeVarsStack.size() > 0) {
            this.safeVarsStack.get(this.safeVarsStack.size() - 1).addAll(set);
        }
    }

    private void removeSafeVar(IVariableBinding iVariableBinding) {
        for (Set<IVariableBinding> set : this.safeVarsStack) {
            set.remove(iVariableBinding);
        }
    }

    private Set<IVariableBinding> getAllSafeVars() {
        HashSet hashSet = Sets.newHashSet();
        for (Set<IVariableBinding> set : this.safeVarsStack) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private boolean isSafeVar(IVariableBinding iVariableBinding) {
        for (Set<IVariableBinding> set : this.safeVarsStack) {
            if (!set.contains(iVariableBinding)) continue;
            return true;
        }
        return false;
    }

    private boolean needsNilCheck(Expression expression) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        if (iVariableBinding != null) {
            return !this.isSafeVar(iVariableBinding) && !iVariableBinding.getName().startsWith("this$") && !iVariableBinding.getName().equals("outer$");
        }
        IMethodBinding iMethodBinding = Types.getMethodBinding(expression);
        if (iMethodBinding != null) {
            return !iMethodBinding.isConstructor() && !iMethodBinding.getName().equals("getClass") && (!Types.isBoxedPrimitive(iMethodBinding.getDeclaringClass()) || !iMethodBinding.getName().equals("valueOf"));
        }
        if (expression instanceof ParenthesizedExpression) {
            return this.needsNilCheck(((ParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof CastExpression) {
            return this.needsNilCheck(((CastExpression)expression).getExpression());
        }
        switch (expression.getNodeType()) {
            case 2: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    private static Expression stripCastsAndParentheses(Expression expression) {
        if (expression instanceof ParenthesizedExpression) {
            return NilCheckResolver.stripCastsAndParentheses(((ParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof CastExpression) {
            return NilCheckResolver.stripCastsAndParentheses(((CastExpression)expression).getExpression());
        }
        return expression;
    }

    private void addNilCheck(Expression expression, boolean bl) {
        Expression expression2 = NilCheckResolver.stripCastsAndParentheses(expression);
        if (!this.needsNilCheck(expression2)) {
            return;
        }
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        if (iVariableBinding != null) {
            this.addSafeVar(iVariableBinding);
            this.safeVarsTrue.add(iVariableBinding);
            this.safeVarsFalse.add(iVariableBinding);
        }
        if (bl) {
            Types.addNilCheck(expression2);
        } else {
            AST aST = expression.getAST();
            IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newTypedInvocation(NIL_CHK_DECL, Types.getTypeBinding(expression));
            MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
            ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(aST, expression2));
            ASTUtil.setProperty((ASTNode)expression, (ASTNode)methodInvocation);
        }
    }

    public void endVisit(ArrayAccess arrayAccess) {
        this.addNilCheck(arrayAccess.getArray(), false);
    }

    public void endVisit(FieldAccess fieldAccess) {
        this.addNilCheck(fieldAccess.getExpression(), false);
    }

    public boolean visit(QualifiedName qualifiedName) {
        if (!this.needsNilCheck((Expression)qualifiedName.getQualifier())) {
            return true;
        }
        IVariableBinding iVariableBinding = Types.getVariableBinding(qualifiedName);
        IVariableBinding iVariableBinding2 = Types.getVariableBinding(qualifiedName.getQualifier());
        if (iVariableBinding != null && iVariableBinding2 != null && BindingUtil.isStatic((IBinding)iVariableBinding) && !BindingUtil.isStatic((IBinding)iVariableBinding2)) {
            return true;
        }
        FieldAccess fieldAccess = ASTFactory.convertToFieldAccess(qualifiedName);
        fieldAccess.accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodInvocation);
        if (BindingUtil.isStatic((IBinding)iMethodBinding)) {
            return;
        }
        Expression expression = methodInvocation.getExpression();
        if (expression != null) {
            this.addNilCheck(expression, true);
        }
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        assert (this.safeVarsStack.isEmpty());
        Block block = methodDeclaration.getBody();
        if (block != null) {
            this.pushScope();
            block.accept((ASTVisitor)this);
            this.popScope();
        }
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        return this.handleConditional(ifStatement.getExpression(), (ASTNode)ifStatement.getThenStatement(), (ASTNode)ifStatement.getElseStatement());
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        return this.handleConditional(conditionalExpression.getExpression(), (ASTNode)conditionalExpression.getThenExpression(), (ASTNode)conditionalExpression.getElseExpression());
    }

    private boolean handleConditional(Expression expression, ASTNode aSTNode, ASTNode aSTNode2) {
        this.clearConditionalSafeVars();
        expression.accept((ASTVisitor)this);
        Set<IVariableBinding> set = this.getAllSafeVars();
        set.addAll(this.safeVarsFalse);
        this.pushScope();
        this.addSafeVars(this.safeVarsTrue);
        aSTNode.accept((ASTVisitor)this);
        this.popScope();
        if (aSTNode2 != null) {
            this.pushScope();
            this.addSafeVars(set);
            aSTNode2.accept((ASTVisitor)this);
            this.popScope();
        }
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        boolean bl;
        boolean bl2;
        InfixExpression.Operator operator = infixExpression.getOperator();
        boolean bl3 = operator == InfixExpression.Operator.CONDITIONAL_AND;
        boolean bl4 = bl2 = operator == InfixExpression.Operator.CONDITIONAL_OR;
        if (bl3 || bl2) {
            return this.handleConditionalOperator(infixExpression, bl3);
        }
        boolean bl5 = operator == InfixExpression.Operator.EQUALS;
        boolean bl6 = bl = operator == InfixExpression.Operator.NOT_EQUALS;
        if (bl5 || bl) {
            Expression expression = infixExpression.getLeftOperand();
            Expression expression2 = infixExpression.getRightOperand();
            IVariableBinding iVariableBinding = null;
            if (expression instanceof NullLiteral) {
                iVariableBinding = Types.getVariableBinding(expression2);
            } else if (expression2 instanceof NullLiteral) {
                iVariableBinding = Types.getVariableBinding(expression);
            }
            if (iVariableBinding != null) {
                if (bl5) {
                    this.safeVarsFalse.add(iVariableBinding);
                } else {
                    this.safeVarsTrue.add(iVariableBinding);
                }
            }
        }
        return true;
    }

    private boolean handleConditionalOperator(InfixExpression infixExpression, boolean bl) {
        HashSet hashSet = Sets.newHashSet();
        HashSet hashSet2 = Sets.newHashSet();
        this.clearConditionalSafeVars();
        infixExpression.getLeftOperand().accept((ASTVisitor)this);
        if (bl) {
            hashSet.addAll(this.safeVarsTrue);
        } else {
            hashSet2.addAll(this.safeVarsFalse);
        }
        this.pushScope();
        this.addSafeVars(bl ? this.safeVarsTrue : this.safeVarsFalse);
        int n = 1;
        this.clearConditionalSafeVars();
        infixExpression.getRightOperand().accept((ASTVisitor)this);
        if (bl) {
            hashSet.addAll(this.safeVarsTrue);
        } else {
            hashSet2.addAll(this.safeVarsFalse);
        }
        for (Expression expression : ASTUtil.getExtendedOperands(infixExpression)) {
            this.pushScope();
            this.addSafeVars(bl ? this.safeVarsTrue : this.safeVarsFalse);
            ++n;
            this.clearConditionalSafeVars();
            expression.accept((ASTVisitor)this);
            if (bl) {
                hashSet.addAll(this.safeVarsTrue);
                continue;
            }
            hashSet2.addAll(this.safeVarsFalse);
        }
        while (n-- > 0) {
            this.popScope();
        }
        this.safeVarsTrue = hashSet;
        this.safeVarsFalse = hashSet2;
        return false;
    }

    private void handleAssignment(IVariableBinding iVariableBinding, Expression expression) {
        if (this.needsNilCheck(expression)) {
            this.removeSafeVar(iVariableBinding);
        } else {
            this.addSafeVar(iVariableBinding);
        }
    }

    public void endVisit(Assignment assignment) {
        if (assignment.getOperator() == Assignment.Operator.ASSIGN) {
            this.handleAssignment(Types.getVariableBinding(assignment.getLeftHandSide()), assignment.getRightHandSide());
        }
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (expression != null) {
            this.handleAssignment(Types.getVariableBinding(variableDeclarationFragment), expression);
        }
    }

    public boolean visit(DoStatement doStatement) {
        this.pushScope();
        doStatement.getBody().accept((ASTVisitor)this);
        doStatement.getExpression().accept((ASTVisitor)this);
        this.popScope();
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.addNilCheck(enhancedForStatement.getExpression(), false);
        enhancedForStatement.getExpression().accept((ASTVisitor)this);
        this.pushScope();
        enhancedForStatement.getBody().accept((ASTVisitor)this);
        this.popScope();
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        for (Expression object : ASTUtil.getInitializers(forStatement)) {
            object.accept((ASTVisitor)this);
        }
        Expression expression = forStatement.getExpression();
        if (expression != null) {
            expression.accept((ASTVisitor)this);
        }
        this.pushScope();
        forStatement.getBody().accept((ASTVisitor)this);
        for (Expression expression2 : ASTUtil.getUpdaters(forStatement)) {
            expression2.accept((ASTVisitor)this);
        }
        this.popScope();
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        switchStatement.getExpression().accept((ASTVisitor)this);
        this.pushScope();
        for (Statement statement : ASTUtil.getStatements(switchStatement)) {
            statement.accept((ASTVisitor)this);
        }
        this.popScope();
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        this.popScope();
        this.pushScope();
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.pushScope();
        for (VariableDeclarationExpression variableDeclarationExpression : ASTUtil.getResources(tryStatement)) {
            variableDeclarationExpression.accept((ASTVisitor)this);
        }
        tryStatement.getBody().accept((ASTVisitor)this);
        this.popScope();
        for (CatchClause catchClause : ASTUtil.getCatchClauses(tryStatement)) {
            this.pushScope();
            catchClause.accept((ASTVisitor)this);
            this.popScope();
        }
        Block block = tryStatement.getFinally();
        if (block != null) {
            block.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        whileStatement.getExpression().accept((ASTVisitor)this);
        this.pushScope();
        whileStatement.getBody().accept((ASTVisitor)this);
        this.popScope();
        return false;
    }
}

