/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class OperatorRewriter
extends ErrorReportingASTVisitor {
    private final IOSMethodBinding retainedAssignBinding;

    public OperatorRewriter() {
        ITypeBinding iTypeBinding = Types.resolveIOSType("id");
        this.retainedAssignBinding = IOSMethodBinding.newFunction("JreOperatorRetainedAssign", iTypeBinding, null, new PointerTypeBinding(iTypeBinding), iTypeBinding, iTypeBinding);
    }

    public void endVisit(Assignment assignment) {
        AST aST = assignment.getAST();
        Assignment.Operator operator = assignment.getOperator();
        Expression expression = assignment.getLeftHandSide();
        Expression expression2 = assignment.getRightHandSide();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression2);
        if (operator == Assignment.Operator.ASSIGN) {
            IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
            if (iVariableBinding == null || iVariableBinding.getType().isPrimitive() || !Options.useReferenceCounting()) {
                return;
            }
            if (BindingUtil.isStatic((IBinding)iVariableBinding)) {
                ASTUtil.setProperty((ASTNode)assignment, (ASTNode)this.newStaticAssignInvocation(aST, iVariableBinding, expression2));
            } else if (iVariableBinding.isField() && !BindingUtil.isWeakReference(iVariableBinding)) {
                Types.addDeferredFieldSetter((Expression)assignment);
            }
        } else if (operator == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            if (!iTypeBinding.getName().equals("char")) {
                ASTUtil.setProperty((ASTNode)assignment, (ASTNode)OperatorRewriter.newUnsignedRightShift(aST, iTypeBinding, expression, expression2));
            }
        } else if (operator == Assignment.Operator.REMAINDER_ASSIGN && (this.isFloatingPoint(iTypeBinding) || this.isFloatingPoint(iTypeBinding2))) {
            ASTUtil.setProperty((ASTNode)assignment, (ASTNode)OperatorRewriter.newModAssign(aST, iTypeBinding, iTypeBinding2, expression, expression2));
        }
    }

    public void endVisit(InfixExpression infixExpression) {
        InfixExpression.Operator operator = infixExpression.getOperator();
        ITypeBinding iTypeBinding = Types.getTypeBinding(infixExpression);
        if (operator == InfixExpression.Operator.REMAINDER && this.isFloatingPoint(iTypeBinding)) {
            AST aST = infixExpression.getAST();
            String string = iTypeBinding.getName().equals("float") ? "fmodf" : "fmod";
            IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newFunction(string, iTypeBinding, null, iTypeBinding, iTypeBinding);
            MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
            List<Expression> list = ASTUtil.getArguments(methodInvocation);
            list.add(NodeCopier.copySubtree(aST, infixExpression.getLeftOperand()));
            list.add(NodeCopier.copySubtree(aST, infixExpression.getRightOperand()));
            ASTUtil.setProperty((ASTNode)infixExpression, (ASTNode)methodInvocation);
        }
    }

    private boolean isFloatingPoint(ITypeBinding iTypeBinding) {
        return iTypeBinding.getName().equals("double") || iTypeBinding.getName().equals("float");
    }

    private MethodInvocation newStaticAssignInvocation(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, this.retainedAssignBinding, null);
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        list.add((Expression)ASTFactory.newAddressOf(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding)));
        list.add((Expression)ASTFactory.newNullLiteral(aST));
        list.add(NodeCopier.copySubtree(aST, expression));
        return methodInvocation;
    }

    private static MethodInvocation newUnsignedRightShift(AST aST, ITypeBinding iTypeBinding, Expression expression, Expression expression2) {
        String string = "URShiftAssign" + NameTable.capitalize(iTypeBinding.getName());
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newFunction(string, iTypeBinding, null, new PointerTypeBinding(iTypeBinding), Types.resolveJavaType("int"));
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        list.add((Expression)ASTFactory.newAddressOf(aST, NodeCopier.copySubtree(aST, expression)));
        list.add(NodeCopier.copySubtree(aST, expression2));
        return methodInvocation;
    }

    private static MethodInvocation newModAssign(AST aST, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2, Expression expression, Expression expression2) {
        String string = "ModAssign" + NameTable.capitalize(iTypeBinding.getName());
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newFunction(string, iTypeBinding, null, new PointerTypeBinding(iTypeBinding), iTypeBinding2);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        list.add((Expression)ASTFactory.newAddressOf(aST, NodeCopier.copySubtree(aST, expression)));
        list.add(NodeCopier.copySubtree(aST, expression2));
        return methodInvocation;
    }
}

