/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class UnsequencedExpressionRewriter
extends ErrorReportingASTVisitor {
    private IMethodBinding currentMethod = null;
    private int count = 1;
    private List<VariableAccess> orderedAccesses = Lists.newArrayList();
    private ASTNode currentTopNode = null;
    private boolean currentIsConditional = false;
    private boolean hasModification = false;

    private void addVariableAccess(IVariableBinding iVariableBinding, Expression expression, boolean bl) {
        if (iVariableBinding != null) {
            this.hasModification |= bl;
            this.orderedAccesses.add(new VariableAccess(iVariableBinding, expression, bl, this.currentIsConditional));
        }
    }

    private void newExpression(ASTNode aSTNode) {
        this.orderedAccesses.clear();
        this.currentTopNode = aSTNode;
        this.hasModification = false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.currentMethod = Types.getMethodBinding(methodDeclaration);
        this.count = 1;
        return true;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.currentMethod = null;
    }

    private List<VariableAccess> getUnsequencedAccesses() {
        if (!this.hasModification) {
            return Collections.emptyList();
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (VariableAccess object2 : this.orderedAccesses) {
            arrayListMultimap.put((Object)object2.variable, (Object)object2);
        }
        HashSet hashSet = Sets.newHashSet();
        for (Object object : arrayListMultimap.keySet()) {
            this.findUnsequenced(arrayListMultimap.get(object), hashSet);
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)hashSet.size());
        for (VariableAccess variableAccess : this.orderedAccesses) {
            if (!hashSet.contains(variableAccess)) continue;
            arrayList.add(variableAccess);
        }
        return arrayList;
    }

    private void extractUnsequenced(Statement statement) {
        List<VariableAccess> list = this.getUnsequencedAccesses();
        if (!list.isEmpty()) {
            this.extractOrderedAccesses(statement.getAST(), ASTUtil.asStatementList(statement).subList(0, 0), this.currentTopNode, list);
        }
    }

    private void extractOrderedAccesses(AST aST, List<Statement> list, ASTNode aSTNode, List<VariableAccess> list2) {
        for (int i = 0; i < list2.size(); ++i) {
            VariableAccess variableAccess = list2.get(i);
            ASTNode aSTNode2 = this.getTopConditional((ASTNode)variableAccess.expression, aSTNode);
            if (aSTNode2 != null) {
                int n;
                for (n = i + 1; n < list2.size() && this.getTopConditional((ASTNode)list2.get(n).expression, aSTNode) == aSTNode2; ++n) {
                }
                if (aSTNode2 instanceof InfixExpression) {
                    this.extractInfixConditional(aST, list, (InfixExpression)aSTNode2, list2.subList(i, n));
                } else if (aSTNode2 instanceof ConditionalExpression) {
                    this.extractConditionalExpression(aST, list, (ConditionalExpression)aSTNode2, list2.subList(i, n));
                } else {
                    throw new AssertionError((Object)("Unexpected conditional node type: " + aSTNode2.getClass().toString()));
                }
                i = n - 1;
                continue;
            }
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("unseq$" + this.count++, 0, Types.getTypeBinding(variableAccess.expression), false, false, null, this.currentMethod);
            list.add((Statement)ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, NodeCopier.copySubtree(aST, variableAccess.expression)));
            ASTUtil.setProperty((ASTNode)variableAccess.expression, (ASTNode)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        }
    }

    private ASTNode getTopConditional(ASTNode aSTNode, ASTNode aSTNode2) {
        ASTNode aSTNode3 = null;
        while (aSTNode != aSTNode2) {
            if (!this.isConditional(aSTNode = aSTNode.getParent())) continue;
            aSTNode3 = aSTNode;
        }
        return aSTNode3;
    }

    private void extractConditionalExpression(AST aST, List<Statement> list, ConditionalExpression conditionalExpression, List<VariableAccess> list2) {
        Expression expression;
        Expression expression2 = conditionalExpression.getExpression();
        Expression expression3 = conditionalExpression.getThenExpression();
        Expression expression4 = conditionalExpression.getElseExpression();
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        boolean bl = false;
        for (VariableAccess variableAccess : list2) {
            expression = variableAccess.expression;
            while (expression.getParent() != conditionalExpression) {
                expression = expression.getParent();
            }
            if (expression == expression2) {
                arrayList.add(variableAccess);
            } else if (expression == expression3) {
                arrayList2.add(variableAccess);
            } else if (expression == expression4) {
                arrayList3.add(variableAccess);
            } else {
                throw new AssertionError();
            }
            if (expression == expression2 || !variableAccess.isModification) continue;
            bl = true;
        }
        this.extractOrderedAccesses(aST, list, (ASTNode)expression2, arrayList);
        expression2 = conditionalExpression.getExpression();
        if (bl) {
            VariableAccess variableAccess;
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("unseq$" + this.count++, 0, Types.getTypeBinding(conditionalExpression), false, false, null, this.currentMethod);
            ASTUtil.setProperty((ASTNode)conditionalExpression, (ASTNode)ASTFactory.newSimpleName(aST, generatedVariableBinding));
            list.add((Statement)ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, null));
            variableAccess = aST.newIfStatement();
            variableAccess.setExpression(NodeCopier.copySubtree(aST, expression2));
            list.add((Statement)variableAccess);
            expression = aST.newBlock();
            variableAccess.setThenStatement((Statement)expression);
            List<Statement> list3 = ASTUtil.getStatements((Block)expression);
            this.extractOrderedAccesses(aST, list3, (ASTNode)expression3, arrayList2);
            expression3 = conditionalExpression.getThenExpression();
            list3.add((Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding), NodeCopier.copySubtree(aST, expression3))));
            Block block = aST.newBlock();
            variableAccess.setElseStatement((Statement)block);
            List<Statement> list4 = ASTUtil.getStatements(block);
            this.extractOrderedAccesses(aST, list4, (ASTNode)expression4, arrayList3);
            expression3 = conditionalExpression.getElseExpression();
            list4.add((Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding), NodeCopier.copySubtree(aST, expression4))));
        } else {
            this.extractOrderedAccesses(aST, list, (ASTNode)expression3, arrayList2);
            this.extractOrderedAccesses(aST, list, (ASTNode)expression4, arrayList3);
        }
    }

    private void extractInfixConditional(AST aST, List<Statement> list, InfixExpression infixExpression, List<VariableAccess> list2) {
        InfixExpression.Operator operator = infixExpression.getOperator();
        List<Expression> list3 = this.getBranches(infixExpression);
        int n = 0;
        GeneratedVariableBinding generatedVariableBinding = null;
        int n2 = 0;
        Expression expression = null;
        for (int i = 0; i < list2.size(); ++i) {
            VariableAccess variableAccess = list2.get(i);
            Expression expression2 = variableAccess.expression;
            while (expression2.getParent() != infixExpression) {
                expression2 = expression2.getParent();
            }
            assert (expression2 instanceof Expression);
            Expression expression3 = expression2;
            if (expression != null && expression3 != expression) {
                this.extractOrderedAccesses(aST, list, (ASTNode)expression, list2.subList(n2, i));
                list3 = this.getBranches(infixExpression);
                n2 = i;
            }
            expression = expression3;
            if (!variableAccess.isModification || expression3 == list3.get(n)) continue;
            if (generatedVariableBinding == null) {
                generatedVariableBinding = new GeneratedVariableBinding("unseq$" + this.count++, 0, Types.resolveJavaType("boolean"), false, false, null, this.currentMethod);
                ASTUtil.setProperty((ASTNode)infixExpression, (ASTNode)ASTFactory.newSimpleName(aST, generatedVariableBinding));
                list.add((Statement)ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, null));
            }
            List<Expression> list4 = list3.subList(n, list3.indexOf(expression3));
            IfStatement ifStatement = aST.newIfStatement();
            Assignment assignment = ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding), this.conditionalFromSubBranches(aST, list4, operator));
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                assignment = ASTFactory.newPrefixExpression(aST, PrefixExpression.Operator.NOT, (Expression)ASTFactory.newParenthesizedExpression(aST, (Expression)assignment), "boolean");
            }
            ifStatement.setExpression((Expression)assignment);
            list.add((Statement)ifStatement);
            Block block = aST.newBlock();
            list = ASTUtil.getStatements(block);
            ifStatement.setThenStatement((Statement)block);
            n = list3.indexOf(expression3);
        }
        this.extractOrderedAccesses(aST, list, (ASTNode)expression, list2.subList(n2, list2.size()));
        list3 = this.getBranches(infixExpression);
        if (generatedVariableBinding != null) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(ASTFactory.newSimpleName(aST, generatedVariableBinding));
            arrayList.addAll(list3.subList(n, list3.size()));
            list.add((Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding), this.conditionalFromSubBranches(aST, arrayList, operator))));
        }
    }

    private List<Expression> getBranches(InfixExpression infixExpression) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(infixExpression.getLeftOperand());
        arrayList.add(infixExpression.getRightOperand());
        arrayList.addAll(ASTUtil.getExtendedOperands(infixExpression));
        return arrayList;
    }

    private Expression conditionalFromSubBranches(AST aST, List<Expression> list, InfixExpression.Operator operator) {
        assert (list.size() >= 1);
        if (list.size() == 1) {
            return (Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(0));
        }
        InfixExpression infixExpression = ASTFactory.newInfixExpression(aST, (Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(0)), operator, (Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(1)), Types.resolveJavaType("boolean"));
        for (int i = 2; i < list.size(); ++i) {
            ASTUtil.getExtendedOperands(infixExpression).add(list.get(i));
        }
        return infixExpression;
    }

    private boolean isConditional(ASTNode aSTNode) {
        InfixExpression infixExpression;
        InfixExpression.Operator operator;
        return aSTNode instanceof InfixExpression ? (operator = (infixExpression = (InfixExpression)aSTNode).getOperator()) == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR : aSTNode instanceof ConditionalExpression;
    }

    private void findUnsequenced(List<VariableAccess> list, Set<VariableAccess> set) {
        if (list.size() == 1) {
            return;
        }
        HashSet hashSet = Sets.newHashSet();
        for (VariableAccess variableAccess : list) {
            if (!variableAccess.isModification) continue;
            hashSet.add(variableAccess);
        }
        for (VariableAccess variableAccess : hashSet) {
            Set<ASTNode> set2 = this.getAncestors((ASTNode)variableAccess.expression);
            boolean bl = false;
            for (VariableAccess variableAccess2 : list) {
                if (variableAccess == variableAccess2) {
                    bl = true;
                    continue;
                }
                if (!this.isUnsequenced(variableAccess, set2, variableAccess2)) continue;
                set.add(bl ? variableAccess : variableAccess2);
            }
        }
    }

    private Set<ASTNode> getAncestors(ASTNode aSTNode) {
        HashSet hashSet = Sets.newHashSet();
        while (aSTNode != this.currentTopNode) {
            hashSet.add(aSTNode);
            aSTNode = aSTNode.getParent();
        }
        return hashSet;
    }

    private boolean isUnsequenced(VariableAccess variableAccess, Set<ASTNode> set, VariableAccess variableAccess2) {
        ASTNode aSTNode = this.currentTopNode;
        for (Expression expression = variableAccess2.expression; expression != this.currentTopNode; expression = expression.getParent()) {
            if (!set.contains(expression)) continue;
            aSTNode = expression;
            break;
        }
        if (this.isWithinConditionalBranch((ASTNode)variableAccess.expression, aSTNode) || this.isWithinConditionalBranch((ASTNode)variableAccess2.expression, aSTNode)) {
            return false;
        }
        if (aSTNode instanceof Assignment) {
            return variableAccess2.expression instanceof PrefixExpression || variableAccess2.expression instanceof PostfixExpression;
        }
        return true;
    }

    private boolean isWithinConditionalBranch(ASTNode aSTNode, ASTNode aSTNode2) {
        while (aSTNode != aSTNode2) {
            ASTNode aSTNode3 = aSTNode.getParent();
            if (this.isConditional(aSTNode3) && this.getConditionChild(aSTNode3) != aSTNode) {
                return true;
            }
            aSTNode = aSTNode3;
        }
        return false;
    }

    private Expression getConditionChild(ASTNode aSTNode) {
        if (aSTNode instanceof InfixExpression) {
            return ((InfixExpression)aSTNode).getLeftOperand();
        }
        if (aSTNode instanceof ConditionalExpression) {
            return ((ConditionalExpression)aSTNode).getExpression();
        }
        throw new AssertionError((Object)("Unexpected conditional node type: " + aSTNode.getClass().toString()));
    }

    public void endVisit(SimpleName simpleName) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(simpleName);
        this.addVariableAccess(iVariableBinding, (Expression)simpleName, false);
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        this.newExpression((ASTNode)expression);
        expression.accept((ASTVisitor)this);
        this.extractUnsequenced((Statement)expressionStatement);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            this.newExpression((ASTNode)expression);
            expression.accept((ASTVisitor)this);
            this.extractUnsequenced((Statement)returnStatement);
        }
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        Expression expression = assertStatement.getExpression();
        this.newExpression((ASTNode)expression);
        expression.accept((ASTVisitor)this);
        this.extractUnsequenced((Statement)assertStatement);
        Expression expression2 = assertStatement.getMessage();
        if (expression2 != null) {
            this.newExpression((ASTNode)expression2);
            expression2.accept((ASTVisitor)this);
            List<VariableAccess> list = this.getUnsequencedAccesses();
            if (!list.isEmpty()) {
                AST aST = assertStatement.getAST();
                GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("unseq$" + this.count++, 0, Types.getTypeBinding(expression), false, false, null, this.currentMethod);
                ASTUtil.insertBefore((Statement)assertStatement, (Statement)ASTFactory.newVariableDeclarationStatement(aST, generatedVariableBinding, NodeCopier.copySubtree(aST, assertStatement.getExpression())));
                assertStatement.setExpression((Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
                this.extractOrderedAccesses(aST, ASTUtil.asStatementList((Statement)assertStatement).subList(0, 0), this.currentTopNode, list);
            }
        }
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.newExpression((ASTNode)constructorInvocation);
        for (Expression expression : ASTUtil.getArguments(constructorInvocation)) {
            expression.accept((ASTVisitor)this);
        }
        this.extractUnsequenced((Statement)constructorInvocation);
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        Expression expression = enhancedForStatement.getExpression();
        this.newExpression((ASTNode)expression);
        expression.accept((ASTVisitor)this);
        this.extractUnsequenced((Statement)enhancedForStatement);
        enhancedForStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.extractVariableDeclarationFragments(variableDeclarationStatement.getAST(), ASTUtil.getFragments(variableDeclarationStatement), ASTUtil.asStatementList((Statement)variableDeclarationStatement).subList(0, 0));
        return false;
    }

    private IfStatement createLoopTermination(Expression expression) {
        AST aST = expression.getAST();
        IfStatement ifStatement = aST.newIfStatement();
        ifStatement.setExpression((Expression)ASTFactory.newPrefixExpression(aST, PrefixExpression.Operator.NOT, (Expression)ASTFactory.newParenthesizedExpression(aST, NodeCopier.copySubtree(aST, expression)), "boolean"));
        ifStatement.setThenStatement((Statement)aST.newBreakStatement());
        return ifStatement;
    }

    public boolean visit(WhileStatement whileStatement) {
        whileStatement.getBody().accept((ASTVisitor)this);
        this.newExpression((ASTNode)whileStatement.getExpression());
        whileStatement.getExpression().accept((ASTVisitor)this);
        List<VariableAccess> list = this.getUnsequencedAccesses();
        if (!list.isEmpty()) {
            AST aST = whileStatement.getAST();
            List<Statement> list2 = ASTUtil.asStatementList(whileStatement.getBody()).subList(0, 0);
            this.extractOrderedAccesses(aST, list2, this.currentTopNode, list);
            list2.add((Statement)this.createLoopTermination(whileStatement.getExpression()));
            whileStatement.setExpression((Expression)ASTFactory.newBooleanLiteral(aST, true));
        }
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        doStatement.getBody().accept((ASTVisitor)this);
        this.newExpression((ASTNode)doStatement.getExpression());
        doStatement.getExpression().accept((ASTVisitor)this);
        List<VariableAccess> list = this.getUnsequencedAccesses();
        if (!list.isEmpty()) {
            AST aST = doStatement.getAST();
            List<Statement> list2 = ASTUtil.asStatementList(doStatement.getBody());
            this.extractOrderedAccesses(aST, list2, this.currentTopNode, list);
            list2.add((Statement)this.createLoopTermination(doStatement.getExpression()));
            doStatement.setExpression((Expression)ASTFactory.newBooleanLiteral(aST, true));
        }
        return false;
    }

    private void extractVariableDeclarationFragments(AST aST, List<VariableDeclarationFragment> list, List<Statement> list2) {
        for (int i = 0; i < list.size(); ++i) {
            VariableDeclarationFragment variableDeclarationFragment = list.get(i);
            Expression expression = variableDeclarationFragment.getInitializer();
            if (expression == null) continue;
            this.newExpression((ASTNode)expression);
            expression.accept((ASTVisitor)this);
            List<VariableAccess> list3 = this.getUnsequencedAccesses();
            if (list3.isEmpty()) continue;
            if (i > 0) {
                VariableDeclarationStatement variableDeclarationStatement = ASTFactory.newVariableDeclarationStatement(aST, (VariableDeclarationFragment)NodeCopier.copySubtree(aST, (ASTNode)list.get(0)));
                for (int j = 1; j < i; ++j) {
                    ASTUtil.getFragments(variableDeclarationStatement).add((VariableDeclarationFragment)NodeCopier.copySubtree(aST, (ASTNode)list.get(j)));
                }
                list2.add((Statement)variableDeclarationStatement);
                list.subList(0, i).clear();
            }
            this.extractOrderedAccesses(aST, list2, this.currentTopNode, list3);
            i = 0;
        }
    }

    private void extractExpressionList(AST aST, List<Expression> list, List<Statement> list2, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            this.newExpression((ASTNode)expression);
            expression.accept((ASTVisitor)this);
            List<VariableAccess> list3 = this.getUnsequencedAccesses();
            if (list3.isEmpty()) continue;
            int n = bl ? i + 1 : i;
            for (int j = 0; j < i; ++j) {
                list2.add((Statement)aST.newExpressionStatement((Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(j))));
            }
            list.subList(0, i).clear();
            this.extractOrderedAccesses(aST, list2, this.currentTopNode, list3);
            i = 0;
            if (!bl) continue;
            list2.add((Statement)aST.newExpressionStatement((Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(0))));
            list.remove(0);
            i = -1;
        }
    }

    public boolean visit(ForStatement forStatement) {
        VariableDeclarationExpression variableDeclarationExpression;
        AST aST = forStatement.getAST();
        List<Expression> list = ASTUtil.getInitializers(forStatement);
        if (list.size() == 1 && list.get(0) instanceof VariableDeclarationExpression) {
            variableDeclarationExpression = (VariableDeclarationExpression)list.get(0);
            this.extractVariableDeclarationFragments(aST, ASTUtil.getFragments(variableDeclarationExpression), ASTUtil.asStatementList((Statement)forStatement).subList(0, 0));
        } else {
            this.extractExpressionList(aST, list, ASTUtil.asStatementList((Statement)forStatement).subList(0, 0), false);
        }
        variableDeclarationExpression = forStatement.getExpression();
        if (variableDeclarationExpression != null) {
            this.newExpression((ASTNode)variableDeclarationExpression);
            variableDeclarationExpression.accept((ASTVisitor)this);
            List<VariableAccess> list2 = this.getUnsequencedAccesses();
            if (!list2.isEmpty()) {
                List<Statement> list3 = ASTUtil.asStatementList(forStatement.getBody()).subList(0, 0);
                this.extractOrderedAccesses(aST, list3, this.currentTopNode, list2);
                list3.add((Statement)this.createLoopTermination(forStatement.getExpression()));
                forStatement.setExpression(null);
            }
        }
        this.extractExpressionList(aST, ASTUtil.getUpdaters(forStatement), ASTUtil.asStatementList(forStatement.getBody()), true);
        forStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Assignment assignment) {
        assignment.getRightHandSide().accept((ASTVisitor)this);
        this.addVariableAccess(Types.getVariableBinding(assignment.getLeftHandSide()), (Expression)assignment, true);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
            this.addVariableAccess(Types.getVariableBinding(prefixExpression.getOperand()), (Expression)prefixExpression, true);
        } else {
            prefixExpression.getOperand().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        PostfixExpression.Operator operator = postfixExpression.getOperator();
        assert (operator == PostfixExpression.Operator.INCREMENT || operator == PostfixExpression.Operator.DECREMENT);
        this.addVariableAccess(Types.getVariableBinding(postfixExpression.getOperand()), (Expression)postfixExpression, true);
        return false;
    }

    private class VariableAccess {
        private final IVariableBinding variable;
        private final Expression expression;
        private final boolean isModification;
        private final boolean isConditional;

        private VariableAccess(IVariableBinding iVariableBinding, Expression expression, boolean bl, boolean bl2) {
            this.variable = iVariableBinding;
            this.expression = expression;
            this.isModification = bl;
            this.isConditional = bl2;
        }
    }
}

