/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import com.google.devtools.j2objc.util.DeadCodeMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProGuardUsageParser {
    private static final Pattern proGuardMethodPattern = Pattern.compile("    (\\d+:\\d+:)?((public|private|protected|static|synchronized|varargs|bridge|native|abstract|strictfp|final|synthetic)\\s)*((\\S+)\\s)?(\\S+)\\((\\S*)\\)");

    private ProGuardUsageParser() {
    }

    private static String buildTypeSignature(String string) {
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("void")) {
            return "V";
        }
        if (string.endsWith("[]")) {
            return "[" + ProGuardUsageParser.buildTypeSignature(string.substring(0, string.length() - 2));
        }
        if (string.length() == 0) {
            return "";
        }
        return "L" + string.replace('.', '/') + ";";
    }

    private static String buildMethodSignature(String string, String string2) {
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder().append("(");
        for (String string3 : stringArray) {
            stringBuilder.append(ProGuardUsageParser.buildTypeSignature(string3));
        }
        stringBuilder.append(")");
        stringBuilder.append(ProGuardUsageParser.buildTypeSignature(string != null ? string : "void"));
        return stringBuilder.toString();
    }

    public static DeadCodeMap parse(InputSupplier<? extends Reader> inputSupplier) throws IOException {
        return (DeadCodeMap)CharStreams.readLines(inputSupplier, (LineProcessor)new LineProcessor<DeadCodeMap>(){
            DeadCodeMap.Builder dead = DeadCodeMap.builder();
            String lastClass;

            public DeadCodeMap getResult() {
                return this.dead.build();
            }

            private void handleClass(String string) {
                if (string.endsWith(":")) {
                    this.lastClass = string.substring(0, string.length() - 1);
                } else {
                    this.dead.addDeadClass(string);
                }
            }

            private void handleMethod(String string) throws IOException {
                Matcher matcher = proGuardMethodPattern.matcher(string);
                if (!matcher.matches()) {
                    throw new AssertionError((Object)"Line doesn't match expected ProGuard format!");
                }
                if (this.lastClass == null) {
                    throw new IOException("Bad listing format: method not attached to a class");
                }
                String string2 = matcher.group(5);
                String string3 = matcher.group(6);
                String string4 = matcher.group(7);
                String string5 = ProGuardUsageParser.buildMethodSignature(string2, string4);
                this.dead.addDeadMethod(this.lastClass, string3, string5);
            }

            private void handleField(String string) throws IOException {
                String string2 = string.substring(string.lastIndexOf(" ") + 1);
                this.dead.addDeadField(this.lastClass, string2);
            }

            public boolean processLine(String string) throws IOException {
                if (!string.startsWith("ProGuard, version") && !string.startsWith("Reading ")) {
                    if (!string.startsWith("    ")) {
                        this.handleClass(string);
                    } else if (string.startsWith("    ") && !string.contains("(")) {
                        this.handleField(string);
                    } else {
                        this.handleMethod(string);
                    }
                }
                return true;
            }
        });
    }

    public static void main(String[] stringArray) throws IOException {
        ProGuardUsageParser.parse((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)new File(stringArray[0]), (Charset)Charset.defaultCharset()));
    }
}

