/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.Plugin;
import com.google.devtools.j2objc.gen.ObjectiveCHeaderGenerator;
import com.google.devtools.j2objc.gen.ObjectiveCImplementationGenerator;
import com.google.devtools.j2objc.gen.ObjectiveCSegmentedHeaderGenerator;
import com.google.devtools.j2objc.translate.AnonymousClassConverter;
import com.google.devtools.j2objc.translate.ArrayRewriter;
import com.google.devtools.j2objc.translate.Autoboxer;
import com.google.devtools.j2objc.translate.ComplexExpressionExtractor;
import com.google.devtools.j2objc.translate.CopyAllFieldsWriter;
import com.google.devtools.j2objc.translate.DeadCodeEliminator;
import com.google.devtools.j2objc.translate.DestructorGenerator;
import com.google.devtools.j2objc.translate.GwtConverter;
import com.google.devtools.j2objc.translate.InitializationNormalizer;
import com.google.devtools.j2objc.translate.InnerClassExtractor;
import com.google.devtools.j2objc.translate.JavaToIOSMethodTranslator;
import com.google.devtools.j2objc.translate.JavaToIOSTypeConverter;
import com.google.devtools.j2objc.translate.NilCheckResolver;
import com.google.devtools.j2objc.translate.OperatorRewriter;
import com.google.devtools.j2objc.translate.OuterReferenceFixer;
import com.google.devtools.j2objc.translate.OuterReferenceResolver;
import com.google.devtools.j2objc.translate.Rewriter;
import com.google.devtools.j2objc.translate.TypeSorter;
import com.google.devtools.j2objc.translate.UnsequencedExpressionRewriter;
import com.google.devtools.j2objc.types.HeaderImportCollector;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.ImplementationImportCollector;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTNodeException;
import com.google.devtools.j2objc.util.DeadCodeMap;
import com.google.devtools.j2objc.util.NameTable;
import com.google.devtools.j2objc.util.ProGuardUsageParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class J2ObjC {
    private static String currentFileName;
    private static CompilationUnit currentUnit;
    private static ArrayDeque<String> pendingFiles;
    private static List<String> translatedFiles;
    private static int nErrors;
    private static int nWarnings;
    private static final Logger logger;

    static void translate() throws IOException {
        while (!pendingFiles.isEmpty()) {
            String string = pendingFiles.remove();
            if (translatedFiles.contains(string)) continue;
            translatedFiles.add(string);
            J2ObjC.printInfo("translating " + string);
            J2ObjC.translate(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void translate(String string) throws IOException {
        long l;
        long l2 = System.currentTimeMillis();
        int n = J2ObjC.getCurrentErrorLevel();
        logger.finest("reading " + string);
        currentFileName = string;
        String string2 = J2ObjC.getSource(string);
        if (string2 == null) {
            J2ObjC.error("no such file: " + string);
            return;
        }
        long l3 = J2ObjC.logTime("read source", l2);
        currentUnit = J2ObjC.parse(string, string2);
        long l4 = J2ObjC.logTime("parse", l3);
        if (J2ObjC.getCurrentErrorLevel() > n) {
            return;
        }
        logger.finest("translating " + string);
        long l5 = 0L;
        J2ObjC.initializeTranslation(currentUnit);
        try {
            J2ObjC.translate(currentUnit);
            l5 = System.currentTimeMillis();
            if (currentUnit.types().isEmpty()) {
                logger.finest("skipping dead file " + string);
            } else {
                if (Options.printConvertedSources()) {
                    J2ObjC.saveConvertedSource(string, string2, currentUnit);
                }
                logger.finest("writing output file(s) to " + Options.getOutputDirectory().getAbsolutePath());
                if (Options.generateSegmentedHeaders()) {
                    ObjectiveCSegmentedHeaderGenerator.generate(string, string2, currentUnit);
                } else {
                    ObjectiveCHeaderGenerator.generate(string, string2, currentUnit);
                }
                l = J2ObjC.logTime("header generation", l5);
                ObjectiveCImplementationGenerator.generate(string, Options.getLanguage(), currentUnit, string2);
                J2ObjC.logTime("implementation generation", l);
                if (Options.buildClosure()) {
                    J2ObjC.checkDependencies(string, currentUnit);
                }
            }
        }
        catch (ASTNodeException aSTNodeException) {
            J2ObjC.error(aSTNodeException);
        }
        finally {
            J2ObjC.cleanup();
        }
        l = System.currentTimeMillis();
        J2ObjC.printTimingInfo(l3 - l2, l4 - l3, l5 - l4, l - l5, l - l2);
    }

    private static void checkDependencies(String string, CompilationUnit compilationUnit) {
        HeaderImportCollector headerImportCollector = new HeaderImportCollector();
        headerImportCollector.collect((ASTNode)compilationUnit);
        ImplementationImportCollector implementationImportCollector = new ImplementationImportCollector();
        implementationImportCollector.collect(compilationUnit, string);
        Set<Import> set = headerImportCollector.getForwardDeclarations();
        set.addAll(headerImportCollector.getSuperTypes());
        set.addAll(implementationImportCollector.getImports());
        for (Import import_ : set) {
            J2ObjC.maybeAddToClosure(import_.getType());
        }
    }

    private static void maybeAddToClosure(ITypeBinding iTypeBinding) {
        if (iTypeBinding instanceof IOSTypeBinding) {
            return;
        }
        String string = iTypeBinding.getErasure().getQualifiedName().replace('.', '/') + ".java";
        boolean bl = false;
        for (String string2 : Options.getSourcePathEntries()) {
            if (J2ObjC.lastModified(string2, string) <= 0L) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        File file = new File(Options.getOutputDirectory(), string.replace(".java", ".h"));
        for (String string3 : Options.getSourcePathEntries()) {
            long l = J2ObjC.lastModified(string3, string);
            if (l == 0L) continue;
            if (l < file.lastModified()) {
                return;
            }
            File file2 = new File(string3);
            if (file2.isDirectory()) {
                J2ObjC.addSourceFile(string3 + '/' + string);
            } else {
                J2ObjC.addSourceFile(string);
            }
            return;
        }
        J2ObjC.warning("could not find source path for " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long lastModified(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            File file2 = new File(string, string2);
            return file2.exists() ? file2.lastModified() : 0L;
        }
        if (file.isFile() && (string.endsWith(".jar") || string.endsWith(".zip"))) {
            long l;
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry = zipFile.getEntry(string2);
                l = zipEntry != null ? file.lastModified() : 0L;
            }
            catch (Throwable throwable) {
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            zipFile.close();
            return l;
        }
        return 0L;
    }

    private static CompilationUnit parse(String string, String string2) {
        logger.finest("parsing " + string);
        ASTParser aSTParser = ASTParser.newParser((int)4);
        Map<String, String> map = Options.getCompilerOptions();
        aSTParser.setCompilerOptions(map);
        aSTParser.setSource(string2.toCharArray());
        aSTParser.setResolveBindings(true);
        J2ObjC.setPaths(aSTParser);
        aSTParser.setUnitName(string);
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        for (IProblem iProblem : J2ObjC.getCompilationErrors(compilationUnit)) {
            if (!iProblem.isError()) continue;
            J2ObjC.error(String.format("%s:%s: %s", string, iProblem.getSourceLineNumber(), iProblem.getMessage()));
        }
        return compilationUnit;
    }

    private static List<IProblem> getCompilationErrors(CompilationUnit compilationUnit) {
        ArrayList arrayList = Lists.newArrayList();
        for (IProblem iProblem : compilationUnit.getProblems()) {
            if (!iProblem.isError() || (iProblem.getID() & 0x10000000) > 0 && Options.ignoreMissingImports()) continue;
            arrayList.add(iProblem);
        }
        return arrayList;
    }

    private static void cleanup() {
        NameTable.cleanup();
        Types.cleanup();
        OuterReferenceResolver.cleanup();
    }

    public static String removeDeadCode(CompilationUnit compilationUnit, String string) {
        if (Options.getDeadCodeMap() == null) {
            return string;
        }
        logger.finest("removing dead code");
        new DeadCodeEliminator(Options.getDeadCodeMap()).run((ASTNode)compilationUnit);
        Document document = new Document(string);
        TextEdit textEdit = compilationUnit.rewrite((IDocument)document, Options.getCompilerOptions());
        try {
            textEdit.apply((IDocument)document);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new AssertionError((Object)malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
        return document.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] removeDeadCode(String[] stringArray) throws IOException {
        J2ObjC.loadDeadCodeMap();
        if (Options.getDeadCodeMap() != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                Object object2;
                String string = stringArray[i];
                logger.finest("reading " + string);
                if (string.endsWith(".java")) {
                    object2 = J2ObjC.getSource(string);
                    if (object2 == null) {
                        J2ObjC.error("no such file: " + string);
                        return stringArray;
                    }
                    object = J2ObjC.removeDeadCode(string, (String)object2);
                    if (string.equals(object)) continue;
                    stringArray[i] = object;
                    continue;
                }
                if (!string.endsWith(".jar") || !((File)(object2 = new File(string))).exists() || !((File)object2).isFile()) continue;
                object = new ZipFile((File)object2);
                try {
                    Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        String string2 = zipEntry.getName();
                        if (!string2.endsWith(".java")) continue;
                        J2ObjC.removeDeadCode(string2, J2ObjC.getSource(string2));
                    }
                    continue;
                }
                finally {
                    ((ZipFile)object).close();
                }
            }
        }
        Options.insertSourcePath(0, Options.getTemporaryDirectory());
        return stringArray;
    }

    private static String removeDeadCode(String string, String string2) throws IOException {
        long l = System.currentTimeMillis();
        int n = J2ObjC.getCurrentErrorLevel();
        CompilationUnit compilationUnit = J2ObjC.parse(string, string2);
        if (J2ObjC.getCurrentErrorLevel() > n) {
            return string;
        }
        J2ObjC.initializeTranslation(compilationUnit);
        String string3 = J2ObjC.removeDeadCode(compilationUnit, string2);
        if (!string3.equals(string2)) {
            String string4 = compilationUnit.getPackage().getName().getFullyQualifiedName();
            File file = new File(Options.getTemporaryDirectory(), string4.replace('.', File.separatorChar));
            file.mkdirs();
            int n2 = string.lastIndexOf(File.separatorChar);
            String string5 = n2 >= 0 ? string.substring(n2 + 1) : string;
            File file2 = new File(file, string5);
            Files.write((CharSequence)string3, (File)file2, (Charset)Options.getCharset());
            string = file2.getAbsolutePath();
        }
        long l2 = System.currentTimeMillis() - l;
        if (logger.getLevel().intValue() <= Level.FINE.intValue()) {
            System.out.println(String.format("dead-code elimination time: %.3f", Float.valueOf(J2ObjC.inSeconds(l2))));
        }
        return string;
    }

    private static long logTime(String string, long l) {
        long l2 = System.currentTimeMillis();
        if (logger.getLevel().intValue() <= Level.FINEST.intValue()) {
            System.out.printf("%5d ms  %s\n", l2 - l, string);
        }
        return l2;
    }

    public static void translate(CompilationUnit compilationUnit) {
        long l = System.currentTimeMillis();
        new GwtConverter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("GwtConverter", l);
        new Rewriter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("Rewriter", l);
        new Autoboxer(compilationUnit.getAST()).run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("Autoboxer", l);
        new AnonymousClassConverter(compilationUnit).run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("AnonymousClassConverter", l);
        new InnerClassExtractor(compilationUnit).run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("InnerClassConverter", l);
        new InitializationNormalizer().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("InitializationNormalizer", l);
        new OuterReferenceFixer().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("OuterReferenceFixer", l);
        if (Options.extractUnsequencedModifications()) {
            new UnsequencedExpressionRewriter().run((ASTNode)compilationUnit);
            l = J2ObjC.logTime("UnsequencedExpressionRewriter", l);
        }
        new ComplexExpressionExtractor().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("ComplexExpressionExtractor", l);
        new NilCheckResolver().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("NilCheckResolver", l);
        new JavaToIOSTypeConverter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("JavaToIOSTypeConverter", l);
        Map<String, String> map = Options.getMethodMappings();
        if (map.isEmpty()) {
            J2ObjC.loadMappingFiles();
        }
        new JavaToIOSMethodTranslator(compilationUnit.getAST(), map).run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("JavaToIOSMethodTranslator", l);
        new ArrayRewriter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("ArrayRewriter", l);
        TypeSorter.sortTypes(compilationUnit);
        l = J2ObjC.logTime("TypeSorter", l);
        new DestructorGenerator().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("DestructorGenerator", l);
        new CopyAllFieldsWriter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("CopyAllFieldsWriter", l);
        new OperatorRewriter().run((ASTNode)compilationUnit);
        l = J2ObjC.logTime("OperatorRewriter", l);
        for (Plugin plugin : Options.getPlugins()) {
            plugin.processUnit(compilationUnit);
        }
        Types.verifyNode((ASTNode)compilationUnit);
    }

    public static void initializeTranslation(CompilationUnit compilationUnit) {
        compilationUnit.recordModifications();
        NameTable.initialize(compilationUnit);
        Types.initialize(compilationUnit);
        OuterReferenceResolver.resolve((ASTNode)compilationUnit);
    }

    private static void saveConvertedSource(String string, String string2, CompilationUnit compilationUnit) {
        try {
            Document document = new Document(string2);
            TextEdit textEdit = compilationUnit.rewrite((IDocument)document, Options.getCompilerOptions());
            textEdit.apply((IDocument)document);
            File file = new File(Options.getOutputDirectory(), string);
            file.getParentFile().mkdirs();
            Files.write((CharSequence)document.get(), (File)file, (Charset)Options.getCharset());
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new AssertionError((Object)malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException.getMessage());
        }
    }

    private static void setPaths(ASTParser aSTParser) {
        ArrayList arrayList = Lists.newArrayList();
        String[] stringArray = Options.getClassPathEntries();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        String string = Options.getBootClasspath();
        for (String string2 : string.split(":")) {
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory() && !string2.endsWith(".jar")) continue;
            arrayList.add(string2);
        }
        aSTParser.setEnvironment(arrayList.toArray(new String[0]), Options.getSourcePathEntries(), Options.getFileEncodings(), true);
        try {
            Field field = aSTParser.getClass().getDeclaredField("bits");
            field.setAccessible(true);
            int n = field.getInt(aSTParser);
            field.setInt(aSTParser, n &= 0xFFFFFFDF);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static String getSource(String string) throws IOException {
        File file = J2ObjC.findSourceFile(string);
        if (file == null) {
            return J2ObjC.findArchivedSource(string);
        }
        return Files.toString((File)file, (Charset)Options.getCharset());
    }

    private static File findSourceFile(String string) {
        File file = J2ObjC.getFileOrNull(string);
        if (file != null) {
            return file;
        }
        for (String string2 : Options.getSourcePathEntries()) {
            file = J2ObjC.getFileOrNull(string2 + File.separatorChar + string);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findArchivedSource(String string) throws IOException {
        for (String string2 : Options.getSourcePathEntries()) {
            ZipFile zipFile;
            File file = new File(string2);
            if (!file.exists() || !file.isFile()) continue;
            try {
                zipFile = new ZipFile(file);
            }
            catch (ZipException zipException) {
                continue;
            }
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) continue;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(zipFile.getInputStream(zipEntry));
                String string3 = CharStreams.toString((Readable)inputStreamReader);
                return string3;
            }
            finally {
                zipFile.close();
            }
        }
        return null;
    }

    private static File getFileOrNull(String string) {
        File file = new File(string);
        return file.exists() ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translateSourceJar(String string) throws IOException {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            ZipFile zipFile = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith(".java")) continue;
                    J2ObjC.printInfo("translating " + string2);
                    J2ObjC.translate(string2);
                }
            }
            catch (ZipException zipException) {
                return;
            }
            finally {
                zipFile.close();
            }
        }
    }

    public static void addSourceFile(String string) {
        if (!translatedFiles.contains(string) && !pendingFiles.contains(string)) {
            pendingFiles.add(string);
        }
    }

    private static void addAtFiles(String string) throws IOException {
        String[] stringArray;
        File file;
        if (string.isEmpty()) {
            J2ObjC.error("no @ file specified");
            J2ObjC.exit();
        }
        if (!(file = new File(string)).exists()) {
            J2ObjC.error("no such file: " + string);
            J2ObjC.exit();
        }
        String string2 = J2ObjC.getSource(string);
        for (String string3 : stringArray = string2.split("\\s+")) {
            J2ObjC.addSourceFile(string3);
        }
    }

    public static void error(String string) {
        System.err.println("error: " + string);
        J2ObjC.error();
    }

    public static void error() {
        ++nErrors;
    }

    public static void error(ASTNodeException aSTNodeException) {
        System.err.println(String.format("Internal error, translating %s, line %d\nStack trace:", currentFileName, currentUnit.getLineNumber(aSTNodeException.getSourcePosition())));
        ++nErrors;
        aSTNodeException.getCause().printStackTrace(System.err);
    }

    public static void warning(String string) {
        System.err.println("warning: " + string);
        if (Options.treatWarningsAsErrors()) {
            ++nErrors;
        } else {
            ++nWarnings;
        }
    }

    @VisibleForTesting
    static void resetWarnings() {
        nWarnings = 0;
    }

    @VisibleForTesting
    static void resetErrors() {
        nErrors = 0;
    }

    public static void error(ASTNode aSTNode, String string) {
        int n = J2ObjC.getNodeLine(aSTNode);
        J2ObjC.error(String.format("%s:%s: %s", currentFileName, n, string));
    }

    public static void warning(ASTNode aSTNode, String string) {
        int n = J2ObjC.getNodeLine(aSTNode);
        J2ObjC.warning(String.format("%s:%s: %s", currentFileName, n, string));
    }

    private static int getCurrentErrorLevel() {
        return Options.treatWarningsAsErrors() ? nErrors + nWarnings : nErrors;
    }

    private static int getNodeLine(ASTNode aSTNode) {
        CompilationUnit compilationUnit = (CompilationUnit)aSTNode.getRoot();
        return compilationUnit.getLineNumber(aSTNode.getStartPosition());
    }

    private static void loadDeadCodeMap() {
        DeadCodeMap deadCodeMap = null;
        File file = Options.getProGuardUsageFile();
        if (file != null) {
            try {
                deadCodeMap = ProGuardUsageParser.parse((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)file, (Charset)Charset.defaultCharset()));
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        Options.setDeadCodeMap(deadCodeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMappingFiles() {
        for (String string : Options.getMappingFiles()) {
            Object object;
            Object object2;
            Properties properties;
            block13: {
                properties = new Properties();
                try {
                    object2 = new File(string);
                    if (((File)object2).exists()) {
                        object = new FileReader((File)object2);
                        try {
                            properties.load((Reader)object);
                            break block13;
                        }
                        finally {
                            ((InputStreamReader)object).close();
                        }
                    }
                    object = J2ObjC.class.getResourceAsStream(string);
                    if (object == null) {
                        J2ObjC.error(string + " not found");
                        break block13;
                    }
                    try {
                        properties.load((InputStream)object);
                    }
                    finally {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
            }
            object2 = properties.propertyNames();
            while (object2.hasMoreElements()) {
                String string2;
                object = (String)object2.nextElement();
                if (((String)object).indexOf(40) > 0) {
                    string2 = properties.getProperty((String)object);
                    Options.getMethodMappings().put((String)object, string2);
                    continue;
                }
                string2 = properties.getProperty((String)object);
                Options.getClassMappings().put((String)object, string2);
            }
        }
    }

    @VisibleForTesting
    static void reset() {
        nErrors = 0;
        nWarnings = 0;
        currentFileName = null;
        currentUnit = null;
    }

    public static int getErrorCount() {
        return nErrors;
    }

    public static int getWarningCount() {
        return nWarnings;
    }

    private static void exit() {
        int n = translatedFiles.size();
        J2ObjC.printInfo(String.format("Translated %d %s: %d errors, %d warnings", n, n == 1 ? "file" : "files", nErrors, nWarnings));
        Options.deleteTemporaryDirectory();
        System.exit(nErrors);
    }

    private static void printInfo(String string) {
        if (logger.getLevel().intValue() <= Level.INFO.intValue()) {
            System.out.println(string);
        }
    }

    private static void printTimingInfo(long l, long l2, long l3, long l4, long l5) {
        if (logger.getLevel().intValue() <= Level.FINE.intValue()) {
            System.out.println(String.format("time: read=%.3f compile=%.3f translate=%.3f write=%.3f total=%.3f", Float.valueOf(J2ObjC.inSeconds(l)), Float.valueOf(J2ObjC.inSeconds(l2)), Float.valueOf(J2ObjC.inSeconds(l3)), Float.valueOf(J2ObjC.inSeconds(l4)), Float.valueOf(J2ObjC.inSeconds(l5))));
        }
    }

    private static float inSeconds(long l) {
        return (float)l / 1000.0f;
    }

    public static String getFileHeader(String string) {
        String string2 = System.getProperty("user.name");
        Date date = new Date();
        String string3 = DateFormat.getDateInstance(3).format(date);
        return String.format(Options.getFileHeader(), string, string2, string3);
    }

    /*
     * Exception decompiling
     */
    private static void initPlugins(String[] var0, String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void error(Exception exception) {
        logger.log(Level.SEVERE, "Exiting due to exception", exception);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Options.help(true);
        }
        String[] stringArray2 = null;
        try {
            stringArray2 = Options.load(stringArray);
            if (stringArray2.length == 0) {
                Options.usage("no source files");
            }
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException.getMessage());
            System.exit(1);
        }
        try {
            J2ObjC.initPlugins(Options.getPluginPathEntries(), Options.getPluginOptionString());
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException);
        }
        int n = J2ObjC.getCurrentErrorLevel();
        try {
            stringArray2 = J2ObjC.removeDeadCode(stringArray2);
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException.getMessage());
        }
        if (J2ObjC.getCurrentErrorLevel() > n) {
            return;
        }
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].endsWith(".java")) {
                    pendingFiles.add(stringArray2[i]);
                } else if (stringArray2[i].endsWith(".jar")) {
                    J2ObjC.translateSourceJar(stringArray2[i]);
                } else if (stringArray2[i].startsWith("@")) {
                    J2ObjC.addAtFiles(stringArray2[i].substring(1));
                }
                J2ObjC.translate();
            }
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException.getMessage());
        }
        for (Plugin plugin : Options.getPlugins()) {
            plugin.endProcessing(Options.getOutputDirectory());
        }
        J2ObjC.exit();
    }

    static {
        pendingFiles = new ArrayDeque();
        translatedFiles = Lists.newArrayList();
        nErrors = 0;
        nWarnings = 0;
        ClassLoader classLoader = J2ObjC.class.getClassLoader();
        if (classLoader != null) {
            classLoader.setPackageAssertionStatus(J2ObjC.class.getPackage().getName(), true);
        }
        logger = Logger.getLogger(J2ObjC.class.getName());
    }

    private static class JarFileLoader
    extends URLClassLoader {
        public JarFileLoader() {
            super(new URL[0]);
        }

        public void addJarFile(String string) throws MalformedURLException {
            String string2 = "jar:file://" + string + "!/";
            this.addURL(new URL(string2));
        }
    }

    public static enum Language {
        OBJECTIVE_C(".m"),
        OBJECTIVE_CPP(".mm");

        private final String suffix;

        private Language(String string2) {
            this.suffix = string2;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

