/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.AbstractTypeBinding;
import com.google.devtools.j2objc.types.GeneratedPackageBinding;
import java.util.Set;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class GeneratedTypeBinding
extends AbstractTypeBinding {
    protected final String name;
    private final IPackageBinding packageBinding;
    private final ITypeBinding superClass;
    private final boolean isInterface;
    private final ITypeBinding componentType;
    private final Set<IVariableBinding> fields = Sets.newHashSet();
    private final Set<IMethodBinding> methods = Sets.newHashSet();

    public GeneratedTypeBinding(String string, IPackageBinding iPackageBinding, ITypeBinding iTypeBinding, boolean bl, ITypeBinding iTypeBinding2) {
        this.name = string;
        this.packageBinding = iPackageBinding;
        this.superClass = iTypeBinding;
        this.isInterface = bl;
        this.componentType = iTypeBinding2;
    }

    public static GeneratedTypeBinding newTypeBinding(String string, ITypeBinding iTypeBinding, boolean bl) {
        int n = string.lastIndexOf(46);
        GeneratedPackageBinding generatedPackageBinding = null;
        if (n >= 0) {
            generatedPackageBinding = new GeneratedPackageBinding(string.substring(0, n));
            string = string.substring(n + 1);
        }
        return new GeneratedTypeBinding(string, generatedPackageBinding, iTypeBinding, bl, null);
    }

    public static GeneratedTypeBinding newArrayType(ITypeBinding iTypeBinding) {
        return new GeneratedTypeBinding(iTypeBinding.getName() + "[]", null, null, false, iTypeBinding);
    }

    public String getKey() {
        return this.name;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding instanceof GeneratedTypeBinding) {
            return this.name.equals(((GeneratedTypeBinding)iBinding).name);
        }
        return false;
    }

    @Override
    public String getBinaryName() {
        return this.getQualifiedName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.packageBinding != null) {
            return this.packageBinding.getName() + "." + this.name;
        }
        return this.name;
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public boolean isClass() {
        return !this.isInterface;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public ITypeBinding getComponentType() {
        return this.componentType;
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        return this.fields.toArray(new IVariableBinding[0]);
    }

    public void addField(IVariableBinding iVariableBinding) {
        this.fields.add(iVariableBinding);
    }

    @Override
    public IMethodBinding[] getDeclaredMethods() {
        return this.methods.toArray(new IMethodBinding[0]);
    }

    public void addMethod(IMethodBinding iMethodBinding) {
        this.methods.add(iMethodBinding);
    }

    @Override
    public int getDeclaredModifiers() {
        return 1;
    }

    @Override
    public int getDimensions() {
        if (this.componentType != null) {
            return this.componentType.getDimensions() + 1;
        }
        return 0;
    }

    @Override
    public ITypeBinding getElementType() {
        ITypeBinding iTypeBinding;
        for (iTypeBinding = this.componentType; iTypeBinding != null && iTypeBinding.isArray(); iTypeBinding = iTypeBinding.getComponentType()) {
        }
        return iTypeBinding;
    }

    @Override
    public IPackageBinding getPackage() {
        return this.packageBinding;
    }

    @Override
    public ITypeBinding getSuperclass() {
        return this.superClass;
    }

    public boolean isAssignmentCompatible(ITypeBinding iTypeBinding) {
        if (this.componentType != null && iTypeBinding.isArray()) {
            return this.componentType.isAssignmentCompatible(iTypeBinding.getComponentType());
        }
        return this.isEqualTo((IBinding)iTypeBinding);
    }

    @Override
    public boolean isCastCompatible(ITypeBinding iTypeBinding) {
        return this.isEqualTo((IBinding)iTypeBinding);
    }

    public String toString() {
        return this.name;
    }
}

