/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSParameter;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.j2objc.annotations.ObjectiveCName;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class NameTable {
    private static NameTable instance;
    private final Map<IBinding, String> renamings = Maps.newHashMap();
    public static final String INIT_NAME = "init";
    public static final String CLINIT_NAME = "initialize";
    public static final String ID_TYPE = "id";
    private static final Logger logger;
    public static final List<String> reservedNames;
    public static final List<String> nsObjectMessages;
    private final Map<String, String> prefixMap;
    private static final ImmutableMap<String, String> PRIMITIVE_TYPE_MAP;

    private NameTable(Map<String, String> map) {
        this.prefixMap = map;
    }

    public static void initialize(CompilationUnit compilationUnit) {
        instance = new NameTable(Options.getPackagePrefixes());
    }

    public static void cleanup() {
        instance = null;
    }

    public static String getName(IBinding iBinding) {
        assert (iBinding != null);
        String string = NameTable.instance.renamings.get(iBinding = NameTable.getBindingDeclaration(iBinding));
        if (string != null) {
            return string;
        }
        String string2 = iBinding.getName();
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (NameTable.isReservedName(string2)) {
                string2 = string2 + "_";
            }
            if (iVariableBinding.isField()) {
                ITypeBinding iTypeBinding = ((IVariableBinding)iBinding).getDeclaringClass();
                for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
                    if (!iMethodBinding.getName().equals(string2)) continue;
                    string2 = string2 + '_';
                    break;
                }
            }
        }
        return string2;
    }

    private static IBinding getBindingDeclaration(IBinding iBinding) {
        if (iBinding instanceof IVariableBinding) {
            return ((IVariableBinding)iBinding).getVariableDeclaration();
        }
        if (iBinding instanceof IMethodBinding) {
            return ((IMethodBinding)iBinding).getMethodDeclaration();
        }
        if (iBinding instanceof ITypeBinding) {
            return ((ITypeBinding)iBinding).getTypeDeclaration();
        }
        return iBinding;
    }

    public static String getName(SimpleName simpleName) {
        return NameTable.getName(Types.getBinding(simpleName));
    }

    public static boolean isRenamed(IBinding iBinding) {
        return NameTable.instance.renamings.containsKey(iBinding);
    }

    public static boolean isRenamed(SimpleName simpleName) {
        return NameTable.isRenamed(Types.getBinding(simpleName));
    }

    public static void rename(IBinding iBinding, String string) {
        String string2 = NameTable.instance.renamings.get(iBinding = NameTable.getBindingDeclaration(iBinding));
        if (string2 != null && !string2.equals(string)) {
            logger.fine(String.format("Changing previous rename: %s => %s, now: %s => %s", iBinding.toString(), string2, iBinding, string));
        }
        NameTable.rename(iBinding, string, false);
    }

    public static void rename(IBinding iBinding, String string, boolean bl) {
        NameTable.instance.renamings.put(NameTable.getBindingDeclaration(iBinding), string);
    }

    public static void rename(SimpleName simpleName, String string) {
        NameTable.rename(Types.getBinding(simpleName), string);
    }

    public static String capitalize(String string) {
        return string.length() > 0 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string;
    }

    public static String camelCaseQualifiedName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\\.")) {
            stringBuilder.append(NameTable.capitalize(string2));
        }
        return stringBuilder.toString();
    }

    public static String primitiveTypeToObjC(PrimitiveType primitiveType) {
        PrimitiveType.Code code = primitiveType.getPrimitiveTypeCode();
        return NameTable.primitiveTypeToObjC(code.toString());
    }

    public static String primitiveTypeToObjC(String string) {
        String string2 = (String)PRIMITIVE_TYPE_MAP.get((Object)string);
        return string2 != null ? string2 : string;
    }

    private static String getArrayTypeParameterKeyword(ITypeBinding iTypeBinding, int n) {
        Object object;
        if (iTypeBinding.isParameterizedType()) {
            iTypeBinding = iTypeBinding.getErasure();
        }
        if (iTypeBinding.isCapture()) {
            iTypeBinding = iTypeBinding.getWildcard();
        }
        if (iTypeBinding.isWildcardType() && (object = iTypeBinding.getBound()) != null) {
            iTypeBinding = object;
        }
        object = NameTable.getFullName(iTypeBinding) + "Array";
        if (n > 1) {
            object = (String)object + n;
        }
        return object;
    }

    private static boolean isIdType(ITypeBinding iTypeBinding) {
        return iTypeBinding == Types.resolveIOSType(ID_TYPE) || iTypeBinding == Types.resolveIOSType("NSObject") || Types.isJavaObjectType(iTypeBinding);
    }

    private static String getParameterTypeKeyword(ITypeBinding iTypeBinding) {
        if (NameTable.isIdType(iTypeBinding) || iTypeBinding.isTypeVariable()) {
            return ID_TYPE;
        }
        if (iTypeBinding.isPrimitive()) {
            return iTypeBinding.getName();
        }
        if (iTypeBinding.isArray()) {
            return NameTable.getArrayTypeParameterKeyword(iTypeBinding.getElementType(), iTypeBinding.getDimensions());
        }
        return NameTable.getFullName(iTypeBinding);
    }

    public static String parameterKeyword(ITypeBinding iTypeBinding) {
        return "with" + NameTable.capitalize(NameTable.getParameterTypeKeyword(iTypeBinding));
    }

    public static String getMethodSelector(IMethodBinding iMethodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iMethodBinding.isConstructor()) {
            stringBuilder.append(INIT_NAME);
        } else {
            stringBuilder.append(NameTable.getName((IBinding)iMethodBinding));
        }
        IOSMethod iOSMethod = IOSMethodBinding.getIOSMethod(iMethodBinding);
        if (iOSMethod != null) {
            List<IOSParameter> list = iOSMethod.getParameters();
            for (int i = 0; i < list.size() && !list.get(i).isVarArgs(); ++i) {
                if (i != 0) {
                    stringBuilder.append(list.get(i).getParameterName());
                }
                stringBuilder.append(":");
            }
        } else {
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            for (int i = 0; i < iTypeBindingArray.length; ++i) {
                String string = NameTable.parameterKeyword(iTypeBindingArray[i]);
                if (i == 0) {
                    string = NameTable.capitalize(string);
                }
                stringBuilder.append(string).append(":");
            }
        }
        return stringBuilder.toString();
    }

    public static String getSpecificObjCType(ITypeBinding iTypeBinding) {
        return NameTable.getObjCTypeInner(iTypeBinding, null, true);
    }

    public static String getSpecificObjCType(IVariableBinding iVariableBinding) {
        String string = null;
        if (iVariableBinding instanceof GeneratedVariableBinding) {
            string = ((GeneratedVariableBinding)iVariableBinding).getTypeQualifiers();
        }
        return NameTable.getObjCTypeInner(iVariableBinding.getType(), string, true);
    }

    public static String getObjCType(ITypeBinding iTypeBinding) {
        return NameTable.getObjCTypeInner(iTypeBinding, null, false);
    }

    private static String getObjCTypeInner(ITypeBinding iTypeBinding, String string, boolean bl) {
        String string2;
        if (iTypeBinding instanceof PointerTypeBinding) {
            int n;
            String string3 = null;
            if (string != null && (n = string.indexOf(42)) != -1) {
                string3 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            string2 = (string2 = NameTable.getObjCTypeInner(((PointerTypeBinding)iTypeBinding).getPointeeType(), string3, bl)).endsWith("*") ? string2 + "*" : string2 + " *";
        } else if (iTypeBinding.isTypeVariable()) {
            if (bl) {
                ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeBounds();
                while (iTypeBindingArray.length > 0 && iTypeBindingArray[0].isTypeVariable()) {
                    iTypeBinding = iTypeBindingArray[0];
                    iTypeBindingArray = iTypeBinding.getTypeBounds();
                }
                string2 = NameTable.constructObjCType(iTypeBindingArray);
            } else {
                string2 = ID_TYPE;
            }
        } else {
            string2 = iTypeBinding.isPrimitive() ? NameTable.primitiveTypeToObjC(iTypeBinding.getName()) : NameTable.constructObjCType(iTypeBinding.getErasure());
        }
        if (string != null && !(string = string.trim()).isEmpty()) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    private static String constructObjCType(ITypeBinding ... iTypeBindingArray) {
        String string = null;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)iTypeBindingArray.length);
        for (ITypeBinding iTypeBinding : iTypeBindingArray) {
            if (iTypeBinding == null || NameTable.isIdType(iTypeBinding) || Types.isJavaVoidType(iTypeBinding)) continue;
            if (iTypeBinding.isInterface()) {
                arrayList.add(NameTable.getFullName(iTypeBinding));
                continue;
            }
            assert (string == null);
            string = NameTable.getFullName(iTypeBinding);
        }
        String string2 = arrayList.isEmpty() ? "" : "<" + Joiner.on((String)", ").join((Iterable)arrayList) + ">";
        return string == null ? ID_TYPE + string2 : string + string2 + " *";
    }

    public static String fieldNames(List<?> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)obj;
                stringBuffer.append(variableDeclarationFragment.getName().getIdentifier());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
                continue;
            }
            throw new AssertionError((Object)("unknown fragment type: " + obj.getClass()));
        }
        return stringBuffer.toString();
    }

    public static String getFullName(AbstractTypeDeclaration abstractTypeDeclaration) {
        return NameTable.getFullName(Types.getTypeBinding(abstractTypeDeclaration));
    }

    public static String getFullName(ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2;
        String string = (iTypeBinding = Types.mapType(iTypeBinding.getErasure())).isEnum() ? "Enum" : "";
        String string2 = "";
        IMethodBinding iMethodBinding = iTypeBinding.getDeclaringMethod();
        if (iMethodBinding != null && !iTypeBinding.isAnonymous()) {
            string2 = string2 + "_" + iMethodBinding.getName();
        }
        if ((iTypeBinding2 = iTypeBinding.getDeclaringClass()) != null) {
            String string3 = NameTable.getFullName(iTypeBinding2) + string2 + '_' + NameTable.getName((IBinding)iTypeBinding);
            return iTypeBinding2.isEnum() && iTypeBinding.isAnonymous() ? string3 : string3 + string;
        }
        String string4 = iTypeBinding.getQualifiedName();
        IAnnotationBinding iAnnotationBinding = BindingUtil.getAnnotation((IBinding)iTypeBinding, ObjectiveCName.class);
        if (iAnnotationBinding != null) {
            string4 = (String)BindingUtil.getAnnotationValue(iAnnotationBinding, "value");
            return string4 + string;
        }
        if (Options.getClassMappings().containsKey(string4)) {
            string4 = Options.getClassMappings().get(string4);
            return string4 + string;
        }
        IPackageBinding iPackageBinding = iTypeBinding.getPackage();
        String string5 = iPackageBinding != null ? NameTable.getPrefix(iPackageBinding.getName()) : "";
        return string5 + iTypeBinding.getName() + string;
    }

    public static String makeFunctionName(AbstractTypeDeclaration abstractTypeDeclaration, MethodDeclaration methodDeclaration) {
        return NameTable.getFullName(abstractTypeDeclaration) + '_' + methodDeclaration.getName().getIdentifier();
    }

    public static boolean isReservedName(String string) {
        return reservedNames.contains(string) || nsObjectMessages.contains(string);
    }

    public static String getMainJavaName(CompilationUnit compilationUnit, String string) {
        String string2 = NameTable.getClassNameFromSourceFileName(string);
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        if (packageDeclaration != null) {
            string2 = packageDeclaration.getName().getFullyQualifiedName() + '.' + string2;
        }
        return string2;
    }

    private static String getClassNameFromSourceFileName(String string) {
        int n = string.lastIndexOf(File.separatorChar) + 1;
        int n2 = string.lastIndexOf(".java");
        String string2 = string.substring(n, n2);
        return string2;
    }

    public static String getMainTypeName(CompilationUnit compilationUnit, String string) {
        String string2 = NameTable.getClassNameFromSourceFileName(string);
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        if (packageDeclaration != null) {
            String string3 = NameTable.getPrefix(packageDeclaration.getName().getFullyQualifiedName());
            return string3 + string2;
        }
        return string2;
    }

    public static String getStaticAccessorName(String string) {
        return NameTable.isReservedName(string) ? "get" + NameTable.capitalize(string) : string;
    }

    public static String getStaticVarQualifiedName(IVariableBinding iVariableBinding) {
        ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass().getTypeDeclaration();
        return NameTable.getFullName(iTypeBinding) + "_" + NameTable.getName((IBinding)iVariableBinding) + (iVariableBinding.isEnumConstant() ? "" : "_");
    }

    public static String getPrimitiveConstantName(IVariableBinding iVariableBinding) {
        return String.format("%s_%s", NameTable.getFullName(iVariableBinding.getDeclaringClass()), iVariableBinding.getName());
    }

    public static String javaFieldToObjC(String string) {
        return string + "_";
    }

    public static void mapPackageToPrefix(String string, String string2) {
        NameTable.instance.prefixMap.put(string, string2);
    }

    public static String getPrefix(String string) {
        if (NameTable.hasPrefix(string)) {
            return NameTable.instance.prefixMap.get(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\\.")) {
            stringBuilder.append(NameTable.capitalize(string2));
        }
        return stringBuilder.toString();
    }

    public static boolean hasPrefix(String string) {
        return NameTable.instance.prefixMap.containsKey(string);
    }

    static {
        logger = Logger.getLogger(NameTable.class.getName());
        reservedNames = Lists.newArrayList((Object[])new String[]{ID_TYPE, "bool", "BOOL", "SEL", "IMP", "unichar", "nil", "Nil", "YES", "NO", "TRUE", "FALSE", "auto", "const", "entry", "extern", "goto", "inline", "register", "restrict", "signed", "sizeof", "struct", "typedef", "union", "unsigned", "volatile", "and", "and_eq", "asm", "bitand", "bitor", "compl", "const_cast", "delete", "dynamic_cast", "explicit", "export", "friend", "mutable", "namespace", "not", "not_eq", "operator", "or", "or_eq", "reinterpret_cast", "static_cast", "template", "typeid", "typename", "using", "virtual", "wchar_t", "xor", "xor_eq", "self", "isa", "ptrdiff_t", "size_t", "wchar_t", "wint_t", "int8_t", "int16_t", "int32_t", "int64_t", "uint8_t", "uint16_t", "uint32_t", "uint64_t", "int_least8_t", "int_least16_t", "int_least32_t", "int_least64_t", "uint_least8_t", "uint_least16_t", "uint_least32_t", "uint_least64_t", "int_fast8_t", "int_fast16_t", "int_fast32_t", "int_fast64_t", "uint_fast8_t", "uint_fast16_t", "uint_fast32_t", "uint_fast64_t", "intptr_t", "uintptr_t", "intmax_t", "uintmax_t", "INT8_MAX", "INT16_MAX", "INT32_MAX", "INT64_MAX", "INT8_MIN", "INT16_MIN", "INT32_MIN", "INT64_MIN", "UINT8_MAX", "UINT16_MAX", "UINT32_MAX", "UINT64_MAX", "INT_LEAST8_MIN", "INT_LEAST16_MIN", "INT_LEAST32_MIN", "INT_LEAST64_MIN", "INT_LEAST8_MAX", "INT_LEAST16_MAX", "INT_LEAST32_MAX", "INT_LEAST64_MAX", "INT_FAST8_MIN", "INT_FAST16_MIN", "INT_FAST32_MIN", "INT_FAST64_MIN", "INT_FAST8_MAX", "INT_FAST16_MAX", "INT_FAST32_MAX", "INT_FAST64_MAX", "UINT_FAST8_MAX", "UINT_FAST16_MAX", "UINT_FAST32_MAX", "UINT_FAST64_MAX", "INTPTR_MIN", "INTPTR_MAX", "UINTPTR_MAX", "INTMAX_MIN", "INTMAX_MAX", "UINTMAX_MAX", "PTRDIFF_MIN", "PTRDIFF_MAX", "SIZE_MAX", "WCHAR_MAX", "WCHAR_MIN", "WINT_MIN", "WINT_MAX", "SIG_ATOMIC_MIN", "SIG_ATOMIC_MAX", "INT8_MAX", "INT16_MAX", "INT32_MAX", "INT64_MAX", "UINT8_C", "UINT16_C", "UINT32_C", "UINT64_C", "INTMAX_C", "UINTMAX_C", "va_list", "fpos_t", "FILE", "off_t", "ssize_t", "BUFSIZ", "EOF", "FOPEN_MAX", "FILENAME_MAX", "TMP_MAX", "SEEK_SET", "SEEK_CUR", "SEEK_END", "stdin", "stdout", "stderr", "ct_rune_t", "rune_t", "div_t", "ldiv_t", "lldiv_t", "dev_t", "mode_t", "NULL", "EXIT_FAILURE", "EXIT_SUCCESS", "RAND_MAX", "MB_CUR_MAX", "MB_CUR_MAX_L", "errno", "EPERM", "ENOENT", "ESRCH", "EINTR", "EIO", "ENXIO", "E2BIG", "ENOEXEC", "EBADF", "ECHILD", "EDEADLK", "ENOMEM", "EACCES", "EFAULT", "ENOTBLK", "EBUSY", "EEXIST", "EXDEV", "ENODEV", "ENOTDIR", "EISDIR", "EINVAL", "ENFILE", "EMFILE", "ENOTTY", "ETXTBSY", "EFBIG", "ENOSPC", "ESPIPE", "EROFS", "EMLINK", "EPIPE", "EDOM", "ERANGE", "EAGAIN", "EWOULDBLOCK", "EINPROGRESS", "EALREADY", "ENOTSOCK", "EDESTADDRREQ", "EMSGSIZE", "EPROTOTYPE", "ENOPROTOOPT", "EPROTONOSUPPORT", "ESOCKTNOSUPPORT", "ENOTSUP", "ENOTSUPP", "EPFNOSUPPORT", "EAFNOSUPPORT", "EADDRINUSE", "EADDRNOTAVAIL", "ENETDOWN", "ENETUNREACH", "ENETRESET", "ECONNABORTED", "ECONNRESET", "ENOBUFS", "EISCONN", "ENOTCONN", "ESHUTDOWN", "ETOOMANYREFS", "ETIMEDOUT", "ECONNREFUSED", "ELOOP", "ENAMETOOLONG", "EHOSTDOWN", "EHOSTUNREACH", "ENOTEMPTY", "EPROCLIM", "EUSERS", "EDQUOT", "ESTALE", "EREMOTE", "EBADRPC", "ERPCMISMATCH", "EPROGUNAVAIL", "EPROGMISMATCH", "EPROCUNAVAIL", "ENOLCK", "ENOSYS", "EFTYPE", "EAUTH", "ENEEDAUTH", "EPWROFF", "EDEVERR", "EOVERFLOW", "EBADEXEC", "EBADARCH", "ESHLIBVERS", "EBADMACHO", "ECANCELED", "EIDRM", "ENOMSG", "ENOATTR", "EBADMSG", "EMULTIHOP", "ENODATA", "ENOLINK", "ENOSR", "ENOSTR", "EPROTO", "ETIME", "ENOPOLICY", "ENOTRECOVERABLE", "EOWNERDEAD", "EQFULL", "EILSEQ", "EOPNOTSUPP", "ELAST", "F_DUPFD", "F_GETFD", "F_SETFD", "F_GETFL", "F_SETFL", "F_GETOWN", "F_SETOWN", "F_GETLK", "F_SETLK", "F_SETLKW", "FD_CLOEXEC", "F_RDLCK", "F_UNLCK", "F_WRLCK", "SEEK_SET", "SEEK_CUR", "SEEK_END", "O_RDONLY", "O_WRONLY", "O_RDWR", "O_ACCMODE", "O_NONBLOCK", "O_APPEND", "O_SYNC", "O_CREAT", "O_TRUNC", "O_EXCL", "O_NOCTTY", "O_NOFOLLOW", "DOMAIN", "HUGE", "INFINITY", "NAN", "OVERFLOW", "SING", "UNDERFLOW", "S_IFBLK", "S_IFCHR", "S_IFDIR", "S_IFIFO", "S_IFLNK", "S_IFMT", "S_IFREG", "CFMSYSTEMCALLS", "CGLUESUPPORTED", "FUNCTION_PASCAL", "FUNCTION_DECLSPEC", "FUNCTION_WIN32CC", "GENERATING68881", "GENERATING68K", "GENERATINGCFM", "GENERATINGPOWERPC", "OLDROUTINELOCATIONS", "PRAGMA_ALIGN_SUPPORTED", "PRAGMA_ENUM_PACK", "PRAGMA_ENUM_ALWAYSINT", "PRAGMA_ENUM_OPTIONS", "PRAGMA_IMPORT", "PRAGMA_IMPORT_SUPPORTED", "PRAGMA_ONCE", "PRAGMA_STRUCT_ALIGN", "PRAGMA_STRUCT_PACK", "PRAGMA_STRUCT_PACKPUSH", "TARGET_API_MAC_CARBON", "TARGET_API_MAC_OS8", "TARGET_API_MAC_OSX", "TARGET_CARBON", "TYPE_BOOL", "TYPE_EXTENDED", "TYPE_LONGDOUBLE_IS_DOUBLE", "TYPE_LONGLONG", "UNIVERSAL_INTERFACES_VERSION", "BIG_ENDIAN", "BYTE_ORDER", "LITTLE_ENDIAN", "PDP_ENDIAN", "DEBUG", "NDEBUG", "scale"});
        nsObjectMessages = Lists.newArrayList((Object[])new String[]{"alloc", "attributeKeys", "autoContentAccessingProxy", "autorelease", "classCode", "classDescription", "classForArchiver", "classForKeyedArchiver", "classFallbacksForKeyedArchiver", "classForPortCoder", "className", "copy", "dealloc", "description", "hash", INIT_NAME, CLINIT_NAME, "isProxy", "load", "mutableCopy", "new", "release", "retain", "retainCount", "scriptingProperties", "self", "superclass", "toManyRelationshipKeys", "toOneRelationshipKeys", "version"});
        PRIMITIVE_TYPE_MAP = ImmutableMap.builder().put((Object)"boolean", (Object)"BOOL").put((Object)"byte", (Object)"char").put((Object)"char", (Object)"unichar").put((Object)"short", (Object)"short int").put((Object)"long", (Object)"long long int").build();
    }
}

