/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class MetadataGenerator {
    private final StringBuilder builder = new StringBuilder();
    private final AbstractTypeDeclaration typeNode;
    private final ITypeBinding type;
    private boolean generated = false;
    private int methodMetadataCount = 0;
    private int fieldMetadataCount = 0;

    public MetadataGenerator(AbstractTypeDeclaration abstractTypeDeclaration) {
        this.typeNode = (AbstractTypeDeclaration)Preconditions.checkNotNull((Object)abstractTypeDeclaration);
        this.type = Types.getTypeBinding(abstractTypeDeclaration);
    }

    public String getMetadataSource() {
        this.ensureGenerated();
        return this.builder.toString();
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.generateMetadata();
            this.generated = true;
        }
    }

    private void generateMetadata() {
        String string = NameTable.getFullName(this.type);
        this.println("+ (J2ObjcClassInfo *)__metadata {");
        this.generateMethodsMetadata();
        this.generateFieldsMetadata();
        int n = this.printSuperclassTypeArguments();
        this.printf("  static J2ObjcClassInfo _%s = { ", string);
        this.printf("\"%s\", ", this.type.getName());
        String string2 = this.type.getPackage().getName();
        if (Strings.isNullOrEmpty((String)string2)) {
            this.printf("NULL, ", new Object[0]);
        } else {
            this.printf("\"%s\", ", string2);
        }
        this.printf("%s, ", this.getEnclosingName());
        this.printf("0x%s, ", Integer.toHexString(this.getTypeModifiers()));
        this.printf("%s, ", Integer.toString(this.methodMetadataCount));
        this.print(this.methodMetadataCount > 0 ? "methods, " : "NULL, ");
        this.printf("%s, ", Integer.toString(this.fieldMetadataCount));
        this.print(this.fieldMetadataCount > 0 ? "fields, " : "NULL, ");
        this.printf("%s, ", Integer.toString(n));
        this.printf(n > 0 ? "superclass_type_args" : "NULL", new Object[0]);
        this.println("};");
        this.printf("  return &_%s;\n}\n\n", string);
    }

    private String getEnclosingName() {
        ITypeBinding iTypeBinding = this.type.getDeclaringClass();
        if (iTypeBinding == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder("\"");
        ArrayList arrayList = Lists.newArrayList();
        while (iTypeBinding != null) {
            arrayList.add(iTypeBinding.getName());
            iTypeBinding = iTypeBinding.getDeclaringClass();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            stringBuilder.append((String)arrayList.get(i));
            if (i <= 0) continue;
            stringBuilder.append("$");
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private void generateMethodsMetadata() {
        ArrayList arrayList = Lists.newArrayList();
        for (Object object : ASTUtil.getMethodDeclarations(this.typeNode)) {
            String string = this.getMethodMetadata(Types.getMethodBinding(object));
            if (string == null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.builder.append("  static J2ObjcMethodInfo methods[] = {\n");
            for (Object object : arrayList) {
                this.builder.append((String)object);
            }
            this.builder.append("  };\n");
        }
        this.methodMetadataCount = arrayList.size();
    }

    private void generateFieldsMetadata() {
        if (this.typeNode instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)this.typeNode;
            ArrayList arrayList = Lists.newArrayList();
            for (FieldDeclaration fieldDeclaration : typeDeclaration.getFields()) {
                for (VariableDeclarationFragment variableDeclarationFragment : fieldDeclaration.fragments()) {
                    int n = MetadataGenerator.getFieldModifiers(Types.getVariableBinding(variableDeclarationFragment));
                    String string = variableDeclarationFragment.getName().getIdentifier();
                    String string2 = NameTable.javaFieldToObjC(NameTable.getName(variableDeclarationFragment.getName()));
                    if (string2.equals(string + '_')) {
                        string = null;
                    }
                    String string3 = String.format("    { \"%s\", ", string2);
                    string3 = string3 + (string != null ? String.format("\"%s\", ", string) : "NULL, ");
                    string3 = string3 + String.format("0x%x, \"%s\" },\n", n, MetadataGenerator.getTypeName(Types.getTypeBinding(variableDeclarationFragment)));
                    arrayList.add(string3);
                }
            }
            if (arrayList.size() > 0) {
                this.builder.append("  static J2ObjcFieldInfo fields[] = {\n");
                for (String string : arrayList) {
                    this.builder.append(string);
                }
                this.builder.append("  };\n");
            }
            this.fieldMetadataCount = arrayList.size();
        }
    }

    private String getMethodMetadata(IMethodBinding iMethodBinding) {
        if (iMethodBinding.isSynthetic()) {
            return null;
        }
        String string = iMethodBinding instanceof GeneratedMethodBinding ? ((GeneratedMethodBinding)iMethodBinding).getJavaName() : iMethodBinding.getName();
        String string2 = NameTable.getMethodSelector(iMethodBinding);
        if (string2.equals(string)) {
            string = null;
        }
        int n = MetadataGenerator.getMethodModifiers(iMethodBinding);
        String string3 = iMethodBinding.isConstructor() ? null : MetadataGenerator.getTypeName(iMethodBinding.getReturnType());
        return String.format("    { \"%s\", %s, %s, 0x%x, %s },\n", string2, this.cStr(string), this.cStr(string3), n, this.cStr(this.getThrownExceptions(iMethodBinding)));
    }

    private String getThrownExceptions(IMethodBinding iMethodBinding) {
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        if (iTypeBindingArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            stringBuilder.append(MetadataGenerator.getTypeName(iTypeBindingArray[i]));
        }
        return stringBuilder.toString();
    }

    private int printSuperclassTypeArguments() {
        ITypeBinding iTypeBinding = this.type.getSuperclass();
        if (iTypeBinding == null) {
            return 0;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        if (iTypeBindingArray.length == 0) {
            return 0;
        }
        this.print("  static const char *superclass_type_args[] = {");
        for (int i = 0; i < iTypeBindingArray.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printf("\"%s\"", MetadataGenerator.getTypeName(iTypeBindingArray[i]));
        }
        this.println("};");
        return iTypeBindingArray.length;
    }

    private static String getTypeName(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isTypeVariable()) {
            return "T" + iTypeBinding.getName() + ";";
        }
        if (iTypeBinding.isPrimitive() || iTypeBinding.isArray()) {
            return iTypeBinding.getBinaryName();
        }
        return "L" + iTypeBinding.getBinaryName() + ";";
    }

    private int getTypeModifiers() {
        int n = this.type.getModifiers();
        if (this.type.isInterface()) {
            n |= 0x200;
        }
        if (this.type.isSynthetic()) {
            n |= 0x1000;
        }
        if (this.type.isAnnotation()) {
            n |= 0x2000;
        }
        if (this.type.isEnum()) {
            n |= 0x4000;
        }
        if (this.type.isAnonymous()) {
            n |= 0x8000;
        }
        return n;
    }

    private static int getMethodModifiers(IMethodBinding iMethodBinding) {
        int n = iMethodBinding.getModifiers();
        if (iMethodBinding.isVarargs()) {
            n |= 0x80;
        }
        if (iMethodBinding.isSynthetic()) {
            n |= 0x1000;
        }
        return n;
    }

    private static int getFieldModifiers(IVariableBinding iVariableBinding) {
        int n = iVariableBinding.getModifiers();
        if (iVariableBinding.isSynthetic()) {
            n |= 0x1000;
        }
        if (iVariableBinding.isEnumConstant()) {
            n |= 0x4000;
        }
        return n;
    }

    private String cStr(String string) {
        return string == null ? "NULL" : "\"" + string + "\"";
    }

    private void print(String string) {
        this.builder.append(string);
    }

    private void printf(String string, Object ... objectArray) {
        this.builder.append(String.format(string, objectArray));
    }

    private void println(String string) {
        this.builder.append(string).append('\n');
    }
}

