/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.io.Files;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.gen.SourceBuilder;
import com.google.devtools.j2objc.util.NameTable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;

public abstract class SourceFileGenerator {
    private final SourceBuilder builder;
    private final CompilationUnit unit;
    private final File outputDirectory;
    private final String sourceFileName;
    private final String source;

    public SourceFileGenerator(String string, String string2, CompilationUnit compilationUnit, boolean bl) {
        this.builder = new SourceBuilder(compilationUnit, string, string2, bl);
        this.sourceFileName = string;
        this.source = string2;
        this.unit = compilationUnit;
        this.outputDirectory = Options.getOutputDirectory();
    }

    protected String getOutputFileName(CompilationUnit compilationUnit) {
        String string = NameTable.getMainJavaName(compilationUnit, this.sourceFileName);
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        if (Options.usePackageDirectories() || packageDeclaration == null) {
            return string.replace('.', '/') + this.getSuffix();
        }
        String string2 = packageDeclaration.getName().getFullyQualifiedName();
        return string.substring(string2.length() + 1) + this.getSuffix();
    }

    protected abstract String getSuffix();

    protected boolean hasNativeCode(MethodDeclaration methodDeclaration) {
        return this.hasNativeCode(methodDeclaration, false);
    }

    protected boolean hasNativeCode(MethodDeclaration methodDeclaration, boolean bl) {
        assert ((methodDeclaration.getModifiers() & 0x100) > 0);
        String string = this.extractNativeCode(methodDeclaration.getStartPosition(), methodDeclaration.getLength(), bl);
        return string != null;
    }

    protected String extractNativeCode(int n, int n2) {
        return this.extractNativeCode(n, n2, true);
    }

    protected String extractNativeCode(int n, int n2, boolean bl) {
        String string = this.source.substring(n, n + n2);
        int n3 = string.indexOf("/*-[");
        int n4 = string.lastIndexOf("]-*/");
        if (n3 == -1 || n4 <= n3) {
            if (bl && Options.jsniWarnings()) {
                n3 = string.indexOf("/*-{");
                n4 = string.lastIndexOf("}-*/");
                if (n3 != -1 && n4 > n3) {
                    String string2 = String.format("JSNI comment found: %s:%d", this.sourceFileName, this.builder.getLineNumber(n));
                    J2ObjC.warning(string2);
                }
            }
            return null;
        }
        return string.substring(n3 + 4, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String string) {
        try {
            String string2;
            File file = new File(this.outputDirectory, string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                J2ObjC.warning("cannot create output directory: " + this.outputDirectory);
            }
            if (!(string2 = this.builder.toString()).endsWith("\n")) {
                string2 = string2 + '\n';
            }
            Files.write((CharSequence)string2, (File)file, (Charset)Options.getCharset());
        }
        catch (IOException iOException) {
            J2ObjC.error(iOException.getMessage());
        }
        finally {
            this.reset();
        }
    }

    protected void print(String string) {
        this.builder.print(string);
    }

    protected void print(char c) {
        this.builder.print(c);
    }

    protected void printf(String string, Object ... objectArray) {
        this.builder.printf(string, objectArray);
    }

    protected void println(String string) {
        this.builder.println(string);
    }

    protected void newline() {
        this.builder.newline();
    }

    protected void indent() {
        this.builder.indent();
    }

    protected void unindent() {
        this.builder.unindent();
    }

    protected void printIndent() {
        this.builder.printIndent();
    }

    protected char[] pad(int n) {
        return this.builder.pad(n);
    }

    protected void reset() {
        this.builder.reset();
    }

    protected void syncLineNumbers(ASTNode aSTNode) {
        this.builder.syncLineNumbers(aSTNode);
    }

    protected void printStart(String string) {
        this.builder.printStart(string);
    }

    protected String reindent(String string) {
        return this.builder.reindent(string);
    }

    protected CompilationUnit getUnit() {
        return this.unit;
    }

    protected SourceBuilder getBuilder() {
        return this.builder;
    }

    protected String getSourceFileName() {
        return this.sourceFileName;
    }
}

