/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.Plugin;
import com.google.devtools.j2objc.util.DeadCodeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Options {
    private static Map<String, String> compilerOptions;
    private static List<String> sourcePathEntries;
    private static List<String> classPathEntries;
    private static List<String> pluginPathEntries;
    private static String pluginOptionString;
    private static List<Plugin> plugins;
    private static File outputDirectory;
    private static boolean usePackageDirectories;
    private static J2ObjC.Language language;
    private static boolean printConvertedSources;
    private static boolean ignoreMissingImports;
    private static MemoryManagementOption memoryManagementOption;
    private static boolean emitLineDirectives;
    private static boolean warningsAsErrors;
    private static boolean deprecatedDeclarations;
    private static Map<String, String> classMappings;
    private static Map<String, String> methodMappings;
    private static boolean memoryDebug;
    private static boolean generateNativeStubs;
    private static boolean stripGwtIncompatible;
    private static boolean segmentedHeaders;
    private static String fileEncoding;
    private static boolean jsniWarnings;
    private static boolean buildClosure;
    private static boolean stripReflection;
    private static DeadCodeMap deadCodeMap;
    private static File proGuardUsageFile;
    private static final String JRE_MAPPINGS_FILE = "JRE.mappings";
    private static final List<String> mappingFiles;
    private static String fileHeader;
    private static final String FILE_HEADER_KEY = "file-header";
    private static String usageMessage;
    private static String helpMessage;
    private static final String USAGE_MSG_KEY = "usage-message";
    private static final String HELP_MSG_KEY = "help-message";
    private static String temporaryDirectory;
    private static final String XBOOTCLASSPATH = "-Xbootclasspath:";
    private static String bootclasspath;
    private static Map<String, String> packagePrefixes;
    private static final MemoryManagementOption DEFAULT_MEMORY_MANAGEMENT_OPTION;
    private static final Logger logger;

    public static String[] load(String[] stringArray) throws IOException {
        Object object;
        compilerOptions = Maps.newHashMap();
        compilerOptions.put("org.eclipse.jdt.core.compiler.source", "1.7");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        compilerOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
        logger.setLevel(Level.INFO);
        sourcePathEntries = Lists.newArrayList();
        int n = 0;
        String[] stringArray2 = new String[]{};
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.isEmpty()) {
                ++n;
                continue;
            }
            if (string.equals("-classpath")) {
                if (++n == stringArray.length) {
                    return stringArray2;
                }
                classPathEntries = Options.getPathArgument(stringArray[n]);
            } else if (string.equals("-sourcepath")) {
                if (++n == stringArray.length) {
                    Options.usage("-sourcepath requires an argument");
                }
                sourcePathEntries.addAll(Options.getPathArgument(stringArray[n]));
            } else if (string.equals("-pluginpath")) {
                if (++n == stringArray.length) {
                    Options.usage("-pluginpath requires an argument");
                }
                pluginPathEntries = Options.getPathArgument(stringArray[n]);
            } else if (string.equals("-pluginoptions")) {
                if (++n == stringArray.length) {
                    Options.usage("-pluginoptions requires an argument");
                }
                pluginOptionString = stringArray[n];
            } else if (string.equals("-d")) {
                if (++n == stringArray.length) {
                    Options.usage("-d requires an argument");
                }
                outputDirectory = new File(stringArray[n]);
            } else if (string.equals("--mapping")) {
                if (++n == stringArray.length) {
                    Options.usage("--mapping requires an argument");
                }
                mappingFiles.add(stringArray[n]);
            } else if (string.equals("--dead-code-report")) {
                if (++n == stringArray.length) {
                    Options.usage("--dead-code-report requires an argument");
                }
                proGuardUsageFile = new File(stringArray[n]);
            } else if (string.equals("--prefix")) {
                if (++n == stringArray.length) {
                    Options.usage("--prefix requires an argument");
                }
                Options.addPrefixOption(stringArray[n]);
            } else if (string.equals("--prefixes")) {
                if (++n == stringArray.length) {
                    Options.usage("--prefixes requires an argument");
                }
                Options.addPrefixesFile(stringArray[n]);
            } else if (string.equals("-x")) {
                if (++n == stringArray.length) {
                    Options.usage("-x requires an argument");
                }
                if (((String)(object = stringArray[n])).equals("objective-c")) {
                    language = J2ObjC.Language.OBJECTIVE_C;
                } else if (((String)object).equals("objective-c++")) {
                    language = J2ObjC.Language.OBJECTIVE_CPP;
                } else {
                    Options.usage("unsupported language: " + (String)object);
                }
            } else if (string.equals("--print-converted-sources")) {
                printConvertedSources = true;
            } else if (string.equals("--ignore-missing-imports")) {
                ignoreMissingImports = true;
            } else if (string.equals("-use-reference-counting")) {
                Options.checkMemoryManagementOption(MemoryManagementOption.REFERENCE_COUNTING);
            } else if (string.equals("--no-package-directories")) {
                usePackageDirectories = false;
            } else if (string.equals("-use-gc")) {
                Options.checkMemoryManagementOption(MemoryManagementOption.GC);
            } else if (string.equals("-use-arc")) {
                Options.checkMemoryManagementOption(MemoryManagementOption.ARC);
            } else if (string.equals("-g")) {
                emitLineDirectives = true;
            } else if (string.equals("-Werror")) {
                warningsAsErrors = true;
            } else if (string.equals("--generate-deprecated")) {
                deprecatedDeclarations = true;
            } else if (string.equals("-q") || string.equals("--quiet")) {
                logger.setLevel(Level.WARNING);
            } else if (string.equals("-t") || string.equals("--timing-info")) {
                logger.setLevel(Level.FINE);
            } else if (string.equals("-v") || string.equals("--verbose")) {
                logger.setLevel(Level.FINEST);
            } else if (string.startsWith(XBOOTCLASSPATH)) {
                bootclasspath = string.substring(XBOOTCLASSPATH.length());
            } else if (!string.equals("-Xno-jsni-delimiters")) {
                if (string.equals("--mem-debug")) {
                    memoryDebug = true;
                } else if (string.equals("--generate-native-stubs")) {
                    generateNativeStubs = true;
                } else if (string.equals("-Xno-jsni-warnings")) {
                    jsniWarnings = false;
                } else if (string.equals("-encoding")) {
                    if (++n == stringArray.length) {
                        Options.usage("-encoding requires an argument");
                    }
                    fileEncoding = stringArray[n];
                    try {
                        Charset.forName(fileEncoding);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        J2ObjC.warning(unsupportedCharsetException.getMessage());
                    }
                } else if (string.equals("--strip-gwt-incompatible")) {
                    stripGwtIncompatible = true;
                } else if (string.equals("--strip-reflection")) {
                    stripReflection = true;
                } else if (!string.equals("--generate-test-main") && !string.equals("--no-generate-test-main")) {
                    if (string.equals("--segmented-headers")) {
                        segmentedHeaders = true;
                    } else if (string.equals("--build-closure")) {
                        buildClosure = true;
                    } else if (string.startsWith("-h") || string.equals("--help")) {
                        Options.help(false);
                    } else {
                        if (!string.startsWith("-")) break;
                        Options.usage("invalid flag: " + string);
                    }
                }
            }
            ++n;
        }
        if (memoryManagementOption == null) {
            memoryManagementOption = MemoryManagementOption.REFERENCE_COUNTING;
        }
        int n2 = stringArray.length - n;
        object = new String[n2];
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i + n];
            if (string.endsWith(".jar")) {
                Options.appendSourcePath(string);
            }
            object[i] = string;
        }
        return object;
    }

    private static void addPrefixOption(String string) {
        int n = string.indexOf(61);
        if (n < 1 || n >= string.length() - 1) {
            Options.usage("invalid prefix format");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Options.addPackagePrefix(string2, string3);
    }

    private static void addPrefixesFile(String string) throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        fileInputStream.close();
        Options.addPrefixProperties(properties);
    }

    @VisibleForTesting
    static void addPrefixProperties(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            Options.addPackagePrefix(string, properties.getProperty(string).trim());
        }
    }

    private static void checkMemoryManagementOption(MemoryManagementOption memoryManagementOption) {
        if (Options.memoryManagementOption != null && Options.memoryManagementOption != memoryManagementOption) {
            Options.usage("Multiple memory management options cannot be set.");
        }
        Options.setMemoryManagementOption(memoryManagementOption);
    }

    public static void usage(String string) {
        System.err.println("j2objc: " + string);
        System.err.println(usageMessage);
        System.exit(1);
    }

    public static void help(boolean bl) {
        System.err.println(helpMessage);
        System.exit(bl ? 2 : 0);
    }

    private static List<String> getPathArgument(String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string2 : Splitter.on((char)':').split((CharSequence)string)) {
            String string3;
            if (new File(string2).exists()) {
                arrayList.add(string2);
                continue;
            }
            if (!string2.startsWith("~/") || !new File(string3 = System.getProperty("user.home") + string2.substring(1)).exists()) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static Map<String, String> getCompilerOptions() {
        return compilerOptions;
    }

    public static String[] getSourcePathEntries() {
        return sourcePathEntries.toArray(new String[0]);
    }

    public static void appendSourcePath(String string) {
        sourcePathEntries.add(string);
    }

    public static void insertSourcePath(int n, String string) {
        sourcePathEntries.add(n, string);
    }

    public static String[] getClassPathEntries() {
        return classPathEntries.toArray(new String[classPathEntries.size()]);
    }

    public static String[] getPluginPathEntries() {
        return pluginPathEntries.toArray(new String[pluginPathEntries.size()]);
    }

    public static String getPluginOptionString() {
        return pluginOptionString;
    }

    public static List<Plugin> getPlugins() {
        return plugins;
    }

    public static File getOutputDirectory() {
        return outputDirectory;
    }

    public static boolean memoryDebug() {
        return memoryDebug;
    }

    public static void setMemoryDebug(boolean bl) {
        memoryDebug = bl;
    }

    public static boolean generateNativeStubs() {
        return generateNativeStubs;
    }

    public static void setGenerateNativeStubs(boolean bl) {
        generateNativeStubs = bl;
    }

    public static boolean usePackageDirectories() {
        return usePackageDirectories;
    }

    public static J2ObjC.Language getLanguage() {
        return language;
    }

    public static boolean printConvertedSources() {
        return printConvertedSources;
    }

    public static boolean ignoreMissingImports() {
        return ignoreMissingImports;
    }

    public static boolean useReferenceCounting() {
        return memoryManagementOption == MemoryManagementOption.REFERENCE_COUNTING;
    }

    public static boolean useGC() {
        return memoryManagementOption == MemoryManagementOption.GC;
    }

    public static boolean useARC() {
        return memoryManagementOption == MemoryManagementOption.ARC;
    }

    public static MemoryManagementOption getMemoryManagementOption() {
        return memoryManagementOption;
    }

    public static void setMemoryManagementOption(MemoryManagementOption memoryManagementOption) {
        Options.memoryManagementOption = memoryManagementOption;
    }

    public static void resetMemoryManagementOption() {
        memoryManagementOption = DEFAULT_MEMORY_MANAGEMENT_OPTION;
    }

    public static boolean emitLineDirectives() {
        return emitLineDirectives;
    }

    public static void setEmitLineDirectives(boolean bl) {
        emitLineDirectives = bl;
    }

    public static boolean treatWarningsAsErrors() {
        return warningsAsErrors;
    }

    @VisibleForTesting
    public static void enableDeprecatedDeclarations() {
        deprecatedDeclarations = true;
    }

    @VisibleForTesting
    public static void resetDeprecatedDeclarations() {
        deprecatedDeclarations = false;
    }

    public static boolean generateDeprecatedDeclarations() {
        return deprecatedDeclarations;
    }

    public static Map<String, String> getClassMappings() {
        return classMappings;
    }

    public static Map<String, String> getMethodMappings() {
        return methodMappings;
    }

    public static List<String> getMappingFiles() {
        return mappingFiles;
    }

    public static String getUsageMessage() {
        return usageMessage;
    }

    public static String getHelpMessage() {
        return helpMessage;
    }

    public static String getFileHeader() {
        return fileHeader;
    }

    public static File getProGuardUsageFile() {
        return proGuardUsageFile;
    }

    public static DeadCodeMap getDeadCodeMap() {
        return deadCodeMap;
    }

    public static void setDeadCodeMap(DeadCodeMap deadCodeMap) {
        Options.deadCodeMap = deadCodeMap;
    }

    public static String getBootClasspath() {
        return bootclasspath != null ? bootclasspath : System.getProperty("sun.boot.class.path");
    }

    public static Map<String, String> getPackagePrefixes() {
        return packagePrefixes;
    }

    public static void addPackagePrefix(String string, String string2) {
        packagePrefixes.put(string, string2);
    }

    @VisibleForTesting
    public static void clearPackagePrefixes() {
        packagePrefixes.clear();
    }

    public static String getTemporaryDirectory() throws IOException {
        if (temporaryDirectory != null) {
            return temporaryDirectory;
        }
        File file = File.createTempFile("j2objc", Long.toString(System.nanoTime()));
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        temporaryDirectory = file.getAbsolutePath();
        return temporaryDirectory;
    }

    public static void deleteTemporaryDirectory() {
        if (temporaryDirectory != null) {
            Options.deleteDir(new File(temporaryDirectory));
            temporaryDirectory = null;
        }
    }

    private static void deleteDir(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                Options.deleteDir(file2);
                continue;
            }
            if (!file2.getName().endsWith(".java")) continue;
            file2.delete();
        }
        file.delete();
    }

    public static String fileEncoding() {
        return fileEncoding;
    }

    public static Charset getCharset() {
        return Charset.forName(fileEncoding);
    }

    public static String[] getFileEncodings() {
        int n = sourcePathEntries.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fileEncoding;
        }
        return stringArray;
    }

    public static boolean stripGwtIncompatibleMethods() {
        return stripGwtIncompatible;
    }

    @VisibleForTesting
    public static void setStripGwtIncompatibleMethods(boolean bl) {
        stripGwtIncompatible = bl;
    }

    public static boolean generateSegmentedHeaders() {
        return segmentedHeaders;
    }

    @VisibleForTesting
    public static void enableSegmentedHeaders() {
        segmentedHeaders = true;
    }

    @VisibleForTesting
    public static void resetSegmentedHeaders() {
        segmentedHeaders = false;
    }

    public static boolean jsniWarnings() {
        return jsniWarnings;
    }

    public static void setJsniWarnings(boolean bl) {
        jsniWarnings = bl;
    }

    public static boolean buildClosure() {
        return buildClosure;
    }

    public static boolean stripReflection() {
        return stripReflection;
    }

    @VisibleForTesting
    public static void setStripReflection(boolean bl) {
        stripReflection = bl;
    }

    static {
        sourcePathEntries = Lists.newArrayList((Object[])new String[]{"."});
        classPathEntries = Lists.newArrayList((Object[])new String[]{"."});
        pluginPathEntries = Lists.newArrayList();
        pluginOptionString = "";
        plugins = new ArrayList<Plugin>();
        outputDirectory = new File(".");
        usePackageDirectories = true;
        language = J2ObjC.Language.OBJECTIVE_C;
        printConvertedSources = false;
        ignoreMissingImports = false;
        memoryManagementOption = null;
        emitLineDirectives = false;
        warningsAsErrors = false;
        deprecatedDeclarations = false;
        classMappings = Maps.newLinkedHashMap();
        methodMappings = Maps.newLinkedHashMap();
        memoryDebug = false;
        generateNativeStubs = false;
        stripGwtIncompatible = false;
        segmentedHeaders = false;
        fileEncoding = System.getProperty("file.encoding", "UTF-8");
        jsniWarnings = true;
        buildClosure = false;
        stripReflection = false;
        deadCodeMap = null;
        proGuardUsageFile = null;
        mappingFiles = Lists.newArrayList((Object[])new String[]{JRE_MAPPINGS_FILE});
        bootclasspath = null;
        packagePrefixes = Maps.newHashMap();
        URL uRL = Resources.getResource(J2ObjC.class, (String)"J2ObjC.properties");
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            System.err.println("unable to access tool properties: " + iOException);
            System.exit(1);
        }
        fileHeader = properties.getProperty(FILE_HEADER_KEY);
        Preconditions.checkNotNull((Object)fileHeader);
        usageMessage = properties.getProperty(USAGE_MSG_KEY);
        Preconditions.checkNotNull((Object)usageMessage);
        helpMessage = properties.getProperty(HELP_MSG_KEY);
        Preconditions.checkNotNull((Object)helpMessage);
        DEFAULT_MEMORY_MANAGEMENT_OPTION = MemoryManagementOption.REFERENCE_COUNTING;
        logger = Logger.getLogger(J2ObjC.class.getName());
    }

    public static enum MemoryManagementOption {
        REFERENCE_COUNTING,
        GC,
        ARC;

    }
}

