/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public final class ASTFactory {
    public static List<Modifier> newModifiers(AST aST, int n) {
        return aST.newModifiers(n);
    }

    public static SimpleName newSimpleName(AST aST, IBinding iBinding) {
        String string = iBinding.getName();
        if (string.isEmpty()) {
            string = "$Unnamed$";
        }
        SimpleName simpleName = aST.newSimpleName(string);
        Types.addBinding(simpleName, iBinding);
        return simpleName;
    }

    public static QualifiedName newQualifiedName(AST aST, Name name, SimpleName simpleName) {
        QualifiedName qualifiedName = aST.newQualifiedName(name, simpleName);
        Types.addBinding(qualifiedName, Types.getBinding(simpleName));
        return qualifiedName;
    }

    public static Name newName(AST aST, Name name, IVariableBinding iVariableBinding) {
        SimpleName simpleName = ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding);
        return name == null ? simpleName : ASTFactory.newQualifiedName(aST, name, simpleName);
    }

    public static Name newName(AST aST, List<IVariableBinding> list) {
        Name name = null;
        for (IVariableBinding iVariableBinding : list) {
            name = ASTFactory.newName(aST, name, iVariableBinding);
        }
        return name;
    }

    public static FieldAccess newFieldAccess(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        FieldAccess fieldAccess = aST.newFieldAccess();
        fieldAccess.setExpression(expression);
        fieldAccess.setName(ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
        Types.addBinding(fieldAccess, (IBinding)iVariableBinding);
        return fieldAccess;
    }

    public static Assignment newAssignment(AST aST, Expression expression, Expression expression2) {
        Assignment assignment = aST.newAssignment();
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setLeftHandSide(expression);
        assignment.setRightHandSide(expression2);
        Types.addBinding(assignment, (IBinding)Types.getTypeBinding(expression));
        return assignment;
    }

    public static VariableDeclarationFragment newVariableDeclarationFragment(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
        variableDeclarationFragment.setInitializer(expression);
        Types.addBinding(variableDeclarationFragment, (IBinding)iVariableBinding);
        return variableDeclarationFragment;
    }

    public static VariableDeclarationStatement newVariableDeclarationStatement(AST aST, VariableDeclarationFragment variableDeclarationFragment) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
        VariableDeclarationStatement variableDeclarationStatement = aST.newVariableDeclarationStatement(variableDeclarationFragment);
        variableDeclarationStatement.setType(ASTFactory.newType(aST, iVariableBinding.getType()));
        ASTUtil.getModifiers(variableDeclarationStatement).addAll(ASTFactory.newModifiers(aST, iVariableBinding.getModifiers()));
        return variableDeclarationStatement;
    }

    public static VariableDeclarationStatement newVariableDeclarationStatement(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        return ASTFactory.newVariableDeclarationStatement(aST, ASTFactory.newVariableDeclarationFragment(aST, iVariableBinding, expression));
    }

    public static VariableDeclarationExpression newVariableDeclarationExpression(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        VariableDeclarationExpression variableDeclarationExpression = aST.newVariableDeclarationExpression(ASTFactory.newVariableDeclarationFragment(aST, iVariableBinding, expression));
        variableDeclarationExpression.setType(ASTFactory.newType(aST, iVariableBinding.getType()));
        ASTUtil.getModifiers(variableDeclarationExpression).addAll(ASTFactory.newModifiers(aST, iVariableBinding.getModifiers()));
        Types.addBinding(variableDeclarationExpression, (IBinding)iVariableBinding.getType());
        return variableDeclarationExpression;
    }

    public static SingleVariableDeclaration newSingleVariableDeclaration(AST aST, IVariableBinding iVariableBinding) {
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        singleVariableDeclaration.setName(ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
        singleVariableDeclaration.setType(ASTFactory.newType(aST, iVariableBinding.getType()));
        ASTUtil.getModifiers(singleVariableDeclaration).addAll(ASTFactory.newModifiers(aST, iVariableBinding.getModifiers()));
        Types.addBinding(singleVariableDeclaration, (IBinding)iVariableBinding);
        return singleVariableDeclaration;
    }

    public static FieldDeclaration newFieldDeclaration(AST aST, VariableDeclarationFragment variableDeclarationFragment) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
        FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType(ASTFactory.newType(aST, iVariableBinding.getType()));
        ASTUtil.getModifiers((BodyDeclaration)fieldDeclaration).addAll(ASTFactory.newModifiers(aST, iVariableBinding.getModifiers()));
        return fieldDeclaration;
    }

    public static FieldDeclaration newFieldDeclaration(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        return ASTFactory.newFieldDeclaration(aST, ASTFactory.newVariableDeclarationFragment(aST, iVariableBinding, expression));
    }

    public static PrefixExpression newPrefixExpression(AST aST, PrefixExpression.Operator operator, Expression expression, String string) {
        PrefixExpression prefixExpression = aST.newPrefixExpression();
        prefixExpression.setOperator(operator);
        prefixExpression.setOperand(expression);
        Types.addBinding(prefixExpression, (IBinding)aST.resolveWellKnownType(string));
        return prefixExpression;
    }

    public static InfixExpression newInfixExpression(AST aST, Expression expression, InfixExpression.Operator operator, Expression expression2, ITypeBinding iTypeBinding) {
        InfixExpression infixExpression = aST.newInfixExpression();
        infixExpression.setOperator(operator);
        infixExpression.setLeftOperand(expression);
        infixExpression.setRightOperand(expression2);
        Types.addBinding(infixExpression, (IBinding)iTypeBinding);
        return infixExpression;
    }

    public static InfixExpression newInfixExpression(AST aST, IVariableBinding iVariableBinding, InfixExpression.Operator operator, IVariableBinding iVariableBinding2, ITypeBinding iTypeBinding) {
        return ASTFactory.newInfixExpression(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding), operator, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding2), iTypeBinding);
    }

    public static PostfixExpression newPostfixExpression(AST aST, IVariableBinding iVariableBinding, PostfixExpression.Operator operator) {
        PostfixExpression postfixExpression = aST.newPostfixExpression();
        postfixExpression.setOperator(operator);
        postfixExpression.setOperand((Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
        Types.addBinding(postfixExpression, (IBinding)iVariableBinding.getType());
        return postfixExpression;
    }

    public static ArrayAccess newArrayAccess(AST aST, IVariableBinding iVariableBinding, IVariableBinding iVariableBinding2) {
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        assert (iTypeBinding.isArray());
        ArrayAccess arrayAccess = aST.newArrayAccess();
        arrayAccess.setArray((Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
        arrayAccess.setIndex((Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding2));
        Types.addBinding(arrayAccess, (IBinding)iTypeBinding.getComponentType());
        return arrayAccess;
    }

    public static ArrayCreation newArrayCreation(AST aST, ArrayInitializer arrayInitializer) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(arrayInitializer);
        ArrayCreation arrayCreation = aST.newArrayCreation();
        arrayCreation.setType((ArrayType)ASTFactory.newType(aST, iTypeBinding));
        arrayCreation.setInitializer(arrayInitializer);
        Types.addBinding(arrayCreation, (IBinding)iTypeBinding);
        return arrayCreation;
    }

    public static ForStatement newForStatement(AST aST, VariableDeclarationExpression variableDeclarationExpression, Expression expression, Expression expression2, Statement statement) {
        ForStatement forStatement = aST.newForStatement();
        ASTUtil.getInitializers(forStatement).add((Expression)variableDeclarationExpression);
        forStatement.setExpression(expression);
        ASTUtil.getUpdaters(forStatement).add(expression2);
        forStatement.setBody(statement);
        return forStatement;
    }

    public static MethodInvocation newMethodInvocation(AST aST, IMethodBinding iMethodBinding, Expression expression) {
        MethodInvocation methodInvocation = aST.newMethodInvocation();
        methodInvocation.setExpression(expression);
        methodInvocation.setName(ASTFactory.newSimpleName(aST, (IBinding)iMethodBinding));
        Types.addBinding(methodInvocation, (IBinding)iMethodBinding);
        return methodInvocation;
    }

    public static SuperMethodInvocation newSuperMethodInvocation(AST aST, IMethodBinding iMethodBinding) {
        SuperMethodInvocation superMethodInvocation = aST.newSuperMethodInvocation();
        superMethodInvocation.setName(ASTFactory.newSimpleName(aST, (IBinding)iMethodBinding));
        Types.addBinding(superMethodInvocation, (IBinding)iMethodBinding);
        return superMethodInvocation;
    }

    public static SuperConstructorInvocation newSuperConstructorInvocation(AST aST, IMethodBinding iMethodBinding) {
        SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
        Types.addBinding(superConstructorInvocation, (IBinding)iMethodBinding);
        return superConstructorInvocation;
    }

    public static MethodInvocation newDereference(AST aST, Expression expression) {
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newDereference(Types.getTypeBinding(expression));
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        ASTUtil.getArguments(methodInvocation).add(expression);
        return methodInvocation;
    }

    public static MethodInvocation newAddressOf(AST aST, Expression expression) {
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newAddressOf(Types.getTypeBinding(expression));
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        ASTUtil.getArguments(methodInvocation).add(expression);
        return methodInvocation;
    }

    public static MethodDeclaration newMethodDeclaration(AST aST, IMethodBinding iMethodBinding) {
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(iMethodBinding.isConstructor());
        methodDeclaration.setName(ASTFactory.newSimpleName(aST, (IBinding)iMethodBinding));
        methodDeclaration.setReturnType2(ASTFactory.newType(aST, iMethodBinding.getReturnType()));
        ASTUtil.getModifiers((BodyDeclaration)methodDeclaration).addAll(ASTFactory.newModifiers(aST, iMethodBinding.getModifiers()));
        Types.addBinding(methodDeclaration, (IBinding)iMethodBinding);
        return methodDeclaration;
    }

    public static SimpleName newLabel(AST aST, String string) {
        SimpleName simpleName = aST.newSimpleName(string);
        Types.addBinding(simpleName, IOSTypeBinding.newUnmappedClass(string));
        return simpleName;
    }

    public static NumberLiteral newNumberLiteral(AST aST, String string, String string2) {
        NumberLiteral numberLiteral = aST.newNumberLiteral(string);
        Types.addBinding(numberLiteral, (IBinding)aST.resolveWellKnownType(string2));
        return numberLiteral;
    }

    public static InstanceofExpression newInstanceofExpression(AST aST, Expression expression, ITypeBinding iTypeBinding) {
        InstanceofExpression instanceofExpression = aST.newInstanceofExpression();
        instanceofExpression.setLeftOperand(expression);
        instanceofExpression.setRightOperand(ASTFactory.newType(aST, iTypeBinding));
        Types.addBinding(instanceofExpression, (IBinding)aST.resolveWellKnownType("boolean"));
        return instanceofExpression;
    }

    public static CastExpression newCastExpression(AST aST, Expression expression, ITypeBinding iTypeBinding) {
        CastExpression castExpression = aST.newCastExpression();
        castExpression.setExpression(expression);
        castExpression.setType(ASTFactory.newType(aST, iTypeBinding));
        Types.addBinding(castExpression, (IBinding)iTypeBinding);
        return castExpression;
    }

    public static ThisExpression newThisExpression(AST aST, ITypeBinding iTypeBinding) {
        ThisExpression thisExpression = aST.newThisExpression();
        Types.addBinding(thisExpression, (IBinding)iTypeBinding);
        return thisExpression;
    }

    private static Expression makeLiteralInternal(AST aST, Object object) {
        if (object instanceof Boolean) {
            return aST.newBooleanLiteral(((Boolean)object).booleanValue());
        }
        if (object instanceof Character) {
            CharacterLiteral characterLiteral = aST.newCharacterLiteral();
            characterLiteral.setCharValue(((Character)object).charValue());
            return characterLiteral;
        }
        if (object instanceof Number) {
            return aST.newNumberLiteral(object.toString());
        }
        if (object instanceof String) {
            StringLiteral stringLiteral = aST.newStringLiteral();
            stringLiteral.setLiteralValue((String)object);
            return stringLiteral;
        }
        throw new AssertionError((Object)"unknown constant type");
    }

    public static Expression makeLiteral(AST aST, Object object, ITypeBinding iTypeBinding) {
        Expression expression = ASTFactory.makeLiteralInternal(aST, object);
        Types.addBinding(expression, (IBinding)iTypeBinding);
        return expression;
    }

    public static Expression makeIntLiteral(AST aST, int n) {
        return ASTFactory.makeLiteral(aST, n, aST.resolveWellKnownType("int"));
    }

    public static BooleanLiteral newBooleanLiteral(AST aST, boolean bl) {
        BooleanLiteral booleanLiteral = aST.newBooleanLiteral(bl);
        Types.addBinding(booleanLiteral, (IBinding)aST.resolveWellKnownType("boolean"));
        return booleanLiteral;
    }

    public static NullLiteral newNullLiteral(AST aST) {
        NullLiteral nullLiteral = aST.newNullLiteral();
        Types.addBinding(nullLiteral, (IBinding)aST.resolveWellKnownType("java.lang.Object"));
        return nullLiteral;
    }

    public static TypeLiteral newTypeLiteral(AST aST, ITypeBinding iTypeBinding) {
        TypeLiteral typeLiteral = aST.newTypeLiteral();
        typeLiteral.setType(ASTFactory.newType(aST, iTypeBinding));
        Types.addBinding(typeLiteral, (IBinding)iTypeBinding);
        return typeLiteral;
    }

    public static Type newType(AST aST, ITypeBinding iTypeBinding) {
        Object object = iTypeBinding.isPrimitive() ? aST.newPrimitiveType(PrimitiveType.toCode((String)iTypeBinding.getName())) : (iTypeBinding.isArray() ? aST.newArrayType(ASTFactory.newType(aST, iTypeBinding.getComponentType())) : aST.newSimpleType((Name)ASTFactory.newSimpleName(aST, (IBinding)iTypeBinding.getErasure())));
        Types.addBinding(object, (IBinding)iTypeBinding);
        return object;
    }

    public static ParenthesizedExpression newParenthesizedExpression(AST aST, Expression expression) {
        ParenthesizedExpression parenthesizedExpression = aST.newParenthesizedExpression();
        parenthesizedExpression.setExpression(expression);
        Types.addBinding(parenthesizedExpression, (IBinding)Types.getTypeBinding(expression));
        return parenthesizedExpression;
    }

    public static FieldAccess convertToFieldAccess(QualifiedName qualifiedName) {
        FieldAccess fieldAccess;
        AST aST = qualifiedName.getAST();
        ASTNode aSTNode = qualifiedName.getParent();
        if (aSTNode instanceof QualifiedName) {
            fieldAccess = ASTFactory.convertToFieldAccess((QualifiedName)aSTNode);
            Expression expression = fieldAccess.getExpression();
            assert (expression instanceof QualifiedName);
            qualifiedName = (QualifiedName)expression;
        }
        fieldAccess = ASTFactory.newFieldAccess(aST, Types.getVariableBinding(qualifiedName), (Expression)NodeCopier.copySubtree(aST, qualifiedName.getQualifier()));
        ASTUtil.setProperty((ASTNode)qualifiedName, (ASTNode)fieldAccess);
        return fieldAccess;
    }
}

