/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class CopyAllFieldsWriter
extends ErrorReportingASTVisitor {
    private static final IOSMethod COPY_ALL_PROPERTIES = IOSMethod.create("NSObject copyAllFieldsTo:(id)other");
    private final IOSMethodBinding nsObjectCopyAll = IOSMethodBinding.newMethod(COPY_ALL_PROPERTIES, 1, Types.resolveJavaType("void"), Types.resolveIOSType("NSObject"));

    public CopyAllFieldsWriter() {
        this.nsObjectCopyAll.addParameter(Types.resolveIOSType("id"));
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        List<IVariableBinding> list = CopyAllFieldsWriter.getNonStaticFields(iTypeBinding);
        if (list.size() == 0) {
            return;
        }
        AST aST = typeDeclaration.getAST();
        String string = NameTable.getFullName(iTypeBinding);
        IOSMethod iOSMethod = IOSMethod.create(String.format("%s copyAllFieldsTo:(%s *)other", string, string));
        int n = 4097;
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, n, Types.resolveJavaType("void"), iTypeBinding);
        iOSMethodBinding.addParameter(iTypeBinding);
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("other", 0, iTypeBinding, false, true, null, iOSMethodBinding);
        MethodDeclaration methodDeclaration = ASTFactory.newMethodDeclaration(typeDeclaration.getAST(), iOSMethodBinding);
        ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add((BodyDeclaration)methodDeclaration);
        SingleVariableDeclaration singleVariableDeclaration = ASTFactory.newSingleVariableDeclaration(aST, generatedVariableBinding);
        ASTUtil.getParameters(methodDeclaration).add(singleVariableDeclaration);
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        List<Statement> list2 = ASTUtil.getStatements(block);
        SuperMethodInvocation superMethodInvocation = ASTFactory.newSuperMethodInvocation(aST, this.nsObjectCopyAll);
        ASTUtil.getArguments(superMethodInvocation).add((Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        list2.add((Statement)aST.newExpressionStatement((Expression)superMethodInvocation));
        for (IVariableBinding iVariableBinding : list) {
            list2.add((Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newFieldAccess(aST, iVariableBinding, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding)), (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding))));
        }
    }

    private static List<IVariableBinding> getNonStaticFields(ITypeBinding iTypeBinding) {
        ArrayList arrayList = Lists.newArrayList();
        for (IVariableBinding iVariableBinding : iTypeBinding.getDeclaredFields()) {
            if (BindingUtil.isStatic((IBinding)iVariableBinding)) continue;
            arrayList.add(iVariableBinding);
        }
        return arrayList;
    }
}

