/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.NameTable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class Import
implements Comparable<Import> {
    private static final Set<String> FOUNDATION_TYPES = ImmutableSet.of((Object)"id", (Object)"NSObject", (Object)"NSString", (Object)"NSNumber", (Object)"NSCopying", (Object)"NSZone", (Object[])new String[0]);
    private final ITypeBinding type;
    private final String typeName;
    private final String mainTypeName;
    private final String importFileName;

    private Import(ITypeBinding iTypeBinding) {
        this.type = iTypeBinding;
        this.typeName = NameTable.getFullName(iTypeBinding);
        ITypeBinding iTypeBinding2 = iTypeBinding;
        while (!iTypeBinding2.isTopLevel()) {
            iTypeBinding2 = iTypeBinding2.getDeclaringClass();
        }
        this.mainTypeName = NameTable.getFullName(iTypeBinding2);
        this.importFileName = Import.getImportFileName(iTypeBinding2);
    }

    public ITypeBinding getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getMainTypeName() {
        return this.mainTypeName;
    }

    private static String getImportFileName(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getErasure().getQualifiedName();
        if (Options.usePackageDirectories() || string.startsWith("java") || string.startsWith("junit")) {
            return string.replace('.', '/');
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public boolean isInterface() {
        return this.type.isInterface();
    }

    @Override
    public int compareTo(Import import_) {
        return this.typeName.compareTo(import_.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Import import_ = (Import)object;
        return this.typeName.equals(import_.typeName);
    }

    public String toString() {
        return this.typeName;
    }

    public static Set<Import> getImports(ITypeBinding iTypeBinding) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        Import.addImports(iTypeBinding, linkedHashSet);
        return linkedHashSet;
    }

    public static void addImports(ITypeBinding iTypeBinding, Collection<Import> collection) {
        if (iTypeBinding == null || iTypeBinding.isPrimitive()) {
            return;
        }
        if (iTypeBinding instanceof PointerTypeBinding) {
            Import.addImports(((PointerTypeBinding)iTypeBinding).getPointeeType(), collection);
            return;
        }
        if (iTypeBinding.isTypeVariable()) {
            for (ITypeBinding iTypeBinding2 : iTypeBinding.getTypeBounds()) {
                Import.addImports(iTypeBinding2, collection);
            }
            return;
        }
        if (FOUNDATION_TYPES.contains((iTypeBinding = Types.mapType(iTypeBinding.getErasure())).getName())) {
            return;
        }
        collection.add(new Import(iTypeBinding));
    }
}

