/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapabilityUrls {
    public static final String ACTION_URL = "Action";
    public static final String CHANGE_PASSWORD_URL = "ChangePassword";
    public static final String GET_OBJECT_URL = "GetObject";
    public static final String LOGIN_URL = "Login";
    public static final String LOGIN_COMPLETE_URL = "LoginComplete";
    public static final String LOGOUT_URL = "Logout";
    public static final String SEARCH_URL = "Search";
    public static final String GET_METADATA_URL = "GetMetadata";
    public static final String UPDATE_URL = "Update";
    public static final String SERVER_INFO_URL = "ServerInformation";
    private static final Log LOG = LogFactory.getLog(CapabilityUrls.class);
    private final Map mCapabilityUrls;
    private URL mUrl;

    public CapabilityUrls() {
        this(null);
    }

    public CapabilityUrls(URL baseurl) {
        this.mUrl = baseurl;
        this.mCapabilityUrls = new HashMap();
    }

    public void setCapabilityUrl(String capability, String url) {
        if (this.mUrl != null) {
            try {
                String newurl = new URL(this.mUrl, url).toString();
                if (!newurl.equals(url)) {
                    LOG.info((Object)("qualified " + capability + "  URL different: " + url + " -> " + newurl));
                    url = newurl;
                }
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)"Couldn't normalize URL", (Throwable)e);
            }
        }
        this.mCapabilityUrls.put(capability, url);
    }

    public String getCapabilityUrl(String capability) {
        return (String)this.mCapabilityUrls.get(capability);
    }

    public void setActionUrl(String url) {
        this.setCapabilityUrl(ACTION_URL, url);
    }

    public String getActionUrl() {
        return this.getCapabilityUrl(ACTION_URL);
    }

    public void setChangePasswordUrl(String url) {
        this.setCapabilityUrl(CHANGE_PASSWORD_URL, url);
    }

    public String getChangePasswordUrl() {
        return this.getCapabilityUrl(CHANGE_PASSWORD_URL);
    }

    public void setGetObjectUrl(String url) {
        this.setCapabilityUrl(GET_OBJECT_URL, url);
    }

    public String getGetObjectUrl() {
        return this.getCapabilityUrl(GET_OBJECT_URL);
    }

    public void setLoginUrl(String url) {
        if (this.mUrl == null) {
            try {
                this.mUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.debug((Object)("java.net.URL can't parse login url: " + url));
                this.mUrl = null;
            }
        }
        this.setCapabilityUrl(LOGIN_URL, url);
    }

    public String getLoginUrl() {
        return this.getCapabilityUrl(LOGIN_URL);
    }

    public void setLoginCompleteUrl(String url) {
        this.setCapabilityUrl(LOGIN_COMPLETE_URL, url);
    }

    public String getLoginCompleteUrl() {
        return this.getCapabilityUrl(LOGIN_COMPLETE_URL);
    }

    public void setLogoutUrl(String url) {
        this.setCapabilityUrl(LOGOUT_URL, url);
    }

    public String getLogoutUrl() {
        return this.getCapabilityUrl(LOGOUT_URL);
    }

    public void setSearchUrl(String url) {
        this.setCapabilityUrl(SEARCH_URL, url);
    }

    public String getSearchUrl() {
        return this.getCapabilityUrl(SEARCH_URL);
    }

    public void setGetMetadataUrl(String url) {
        this.setCapabilityUrl(GET_METADATA_URL, url);
    }

    public String getGetMetadataUrl() {
        return this.getCapabilityUrl(GET_METADATA_URL);
    }

    public void setUpdateUrl(String url) {
        this.setCapabilityUrl(UPDATE_URL, url);
    }

    public String getUpdateUrl() {
        return this.getCapabilityUrl(UPDATE_URL);
    }

    public void setServerInfo(String url) {
        this.setCapabilityUrl(SERVER_INFO_URL, url);
    }

    public String getServerInfo() {
        return this.getCapabilityUrl(SERVER_INFO_URL);
    }
}

