/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.realtors.rets.client.CommonsHttpClientResponse;
import org.realtors.rets.client.InvalidHttpStatusException;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.RetsHttpClient;
import org.realtors.rets.client.RetsHttpRequest;
import org.realtors.rets.client.RetsHttpResponse;
import org.realtors.rets.common.util.CaseInsensitiveTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHttpClient
extends RetsHttpClient {
    private static final int DEFAULT_TIMEOUT = 300000;
    private static final String RETS_VERSION = "RETS-Version";
    private static final String RETS_SESSION_ID = "RETS-Session-ID";
    private static final String RETS_REQUEST_ID = "RETS-Request-ID";
    private static final String USER_AGENT = "User-Agent";
    private static final String RETS_UA_AUTH_HEADER = "RETS-UA-Authorization";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String DEFLATE_ENCODINGS = "gzip,deflate";
    public static final String CONTENT_TYPE = "Content-Type";
    private final ConcurrentHashMap<String, String> defaultHeaders = new ConcurrentHashMap();
    private final DefaultHttpClient httpClient;
    private final String userAgentPassword;

    public static BasicHttpParams defaultParams(int timeout) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)timeout);
        httpClientParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        return httpClientParams;
    }

    public static ThreadSafeClientConnManager defaultConnectionManager(int maxConnectionsPerRoute, int maxConnectionsTotal) {
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        connectionManager.setMaxTotal(maxConnectionsTotal);
        return connectionManager;
    }

    public CommonsHttpClient() {
        this(new DefaultHttpClient((ClientConnectionManager)CommonsHttpClient.defaultConnectionManager(Integer.MAX_VALUE, Integer.MAX_VALUE), (HttpParams)CommonsHttpClient.defaultParams(300000)), null, true);
    }

    public CommonsHttpClient(int timeout, String userAgentPassword, boolean gzip) {
        this(new DefaultHttpClient((ClientConnectionManager)CommonsHttpClient.defaultConnectionManager(Integer.MAX_VALUE, Integer.MAX_VALUE), (HttpParams)CommonsHttpClient.defaultParams(timeout)), userAgentPassword, gzip);
    }

    public CommonsHttpClient(DefaultHttpClient client, String userAgentPassword, boolean gzip) {
        this.userAgentPassword = userAgentPassword;
        this.httpClient = client;
        if (gzip) {
            this.addDefaultHeader(ACCEPT_ENCODING, DEFLATE_ENCODINGS);
        }
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void setUserCredentials(String userName, String password) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, password);
        this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)creds);
    }

    @Override
    public RetsHttpResponse doRequest(String httpMethod, RetsHttpRequest request) throws RetsException {
        return "GET".equals(StringUtils.upperCase((String)httpMethod)) ? this.doGet(request) : this.doPost(request);
    }

    public RetsHttpResponse doGet(RetsHttpRequest request) throws RetsException {
        String url = request.getUrl();
        String args = request.getHttpParameters();
        if (args != null) {
            url = url + "?" + args;
        }
        HttpGet method = new HttpGet(url);
        return this.execute((HttpRequestBase)method, request.getHeaders());
    }

    public RetsHttpResponse doPost(RetsHttpRequest request) throws RetsException {
        String url = request.getUrl();
        String body = request.getHttpParameters();
        if (body == null) {
            body = "";
        }
        HttpPost method = new HttpPost(url);
        try {
            method.setEntity((HttpEntity)new StringEntity(body, null, null));
        }
        catch (UnsupportedEncodingException e) {
            throw new RetsException(e);
        }
        method.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
        return this.execute((HttpRequestBase)method, request.getHeaders());
    }

    protected RetsHttpResponse execute(HttpRequestBase method, Map<String, String> headers) throws RetsException {
        try {
            HttpResponse response;
            StatusLine status;
            if (this.defaultHeaders != null) {
                for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
                    method.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    method.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (this.userAgentPassword != null) {
                method.setHeader(RETS_UA_AUTH_HEADER, this.calculateUaAuthHeader(method, this.getCookies()));
            }
            if ((status = (response = this.httpClient.execute((HttpUriRequest)method)).getStatusLine()).getStatusCode() != 200) {
                throw new InvalidHttpStatusException(status);
            }
            return new CommonsHttpClientResponse(response, this.getCookies());
        }
        catch (Exception e) {
            throw new RetsException(e);
        }
    }

    @Override
    public synchronized void addDefaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
        if (value == null) {
            this.defaultHeaders.remove(key);
        }
    }

    protected Map<String, String> getCookies() {
        CaseInsensitiveTreeMap<String, String> cookieMap = new CaseInsensitiveTreeMap<String, String>();
        for (Cookie cookie : this.httpClient.getCookieStore().getCookies()) {
            cookieMap.put(cookie.getName(), cookie.getValue());
        }
        return cookieMap;
    }

    protected String calculateUaAuthHeader(HttpRequestBase method, Map<String, String> cookies) {
        String userAgent = this.getHeaderValue(method, USER_AGENT);
        String requestId = this.getHeaderValue(method, RETS_REQUEST_ID);
        String sessionId = cookies.get(RETS_SESSION_ID);
        String retsVersion = this.getHeaderValue(method, RETS_VERSION);
        String secretHash = DigestUtils.md5Hex((String)String.format("%s:%s", userAgent, this.userAgentPassword));
        String pieces = String.format("%s:%s:%s:%s", secretHash, StringUtils.trimToEmpty((String)requestId), StringUtils.trimToEmpty((String)sessionId), retsVersion);
        return String.format("Digest %s", DigestUtils.md5Hex((String)pieces));
    }

    protected String getHeaderValue(HttpRequestBase method, String key) {
        Header requestHeader = method.getFirstHeader(key);
        if (requestHeader == null) {
            return null;
        }
        return requestHeader.getValue();
    }
}

