/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.realtors.rets.client.GetObjectIterator;
import org.realtors.rets.client.GetObjectResponseIterator;
import org.realtors.rets.client.InvalidReplyCodeException;
import org.realtors.rets.client.NonMultipartGetObjectResponseIterator;
import org.realtors.rets.client.ReplyCode;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.SingleObjectResponse;
import org.realtors.rets.common.util.CaseInsensitiveTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetObjectResponse {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final GetObjectIterator<SingleObjectResponse> EMPTY_OBJECT_RESPONSE_ITERATOR = new GetObjectIterator<SingleObjectResponse>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SingleObjectResponse next() {
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
        }

        @Override
        public void remove() {
        }
    };
    private final Map headers;
    private final InputStream inputStream;
    private final boolean isMultipart;
    private boolean emptyResponse = false;
    private boolean exhausted = false;

    public GetObjectResponse(Map headers, InputStream in) throws RetsException {
        boolean multiPart_xml;
        this.headers = new CaseInsensitiveTreeMap(headers);
        this.isMultipart = this.getType().contains("multipart");
        this.inputStream = in;
        boolean isXml = this.getType().equals("text/xml");
        boolean containsContentId = headers.containsKey("Content-ID");
        boolean nonMultiPart_xml_withoutContentId = !this.isMultipart && isXml && !containsContentId;
        boolean bl = multiPart_xml = this.isMultipart && isXml;
        if (multiPart_xml || nonMultiPart_xml_withoutContentId) {
            int replyCode = 0;
            try {
                this.emptyResponse = true;
                SAXBuilder builder = new SAXBuilder();
                Document mDocument = builder.build(in);
                Element root = mDocument.getRootElement();
                if (root.getName().equals("RETS")) {
                    replyCode = NumberUtils.toInt((String)root.getAttributeValue("ReplyCode"));
                    if (ReplyCode.SUCCESS.equals(replyCode)) {
                        return;
                    }
                    if (ReplyCode.NO_OBJECT_FOUND.equals(replyCode)) {
                        return;
                    }
                    throw new InvalidReplyCodeException(replyCode);
                }
                throw new RetsException("Malformed response [multipart=" + this.isMultipart + ", content-type=text/xml]. " + "Content id did not exist in response and response was not valid rets response.");
            }
            catch (JDOMException e) {
                throw new RetsException(e);
            }
            catch (IOException e) {
                throw new RetsException(e);
            }
        }
    }

    public String getType() {
        return (String)this.headers.get("Content-Type");
    }

    public String getBoundary() {
        String contentTypeValue = this.getType();
        HeaderElement[] contentType = BasicHeaderValueParser.parseElements((String)contentTypeValue, (HeaderValueParser)new BasicHeaderValueParser());
        if (contentType.length != 1) {
            throw new IllegalArgumentException("Multipart response appears to have a bad Content-Type: header value: " + contentTypeValue);
        }
        NameValuePair boundaryNV = contentType[0].getParameterByName("boundary");
        if (boundaryNV == null) {
            return null;
        }
        return GetObjectResponse.unescapeBoundary(boundaryNV.getValue());
    }

    private static String unescapeBoundary(String boundaryValue) {
        if (boundaryValue.startsWith("\"")) {
            boundaryValue = boundaryValue.substring(1);
        }
        if (boundaryValue.endsWith("\"")) {
            boundaryValue = boundaryValue.substring(0, boundaryValue.length() - 1);
        }
        return boundaryValue;
    }

    public <T extends SingleObjectResponse> GetObjectIterator<T> iterator() throws RetsException {
        return this.iterator(8192);
    }

    public <T extends SingleObjectResponse> GetObjectIterator<T> iterator(int bufferSize) throws RetsException {
        if (this.exhausted) {
            throw new RetsException("response was exhausted - cannot request iterator a second time");
        }
        if (this.emptyResponse) {
            return EMPTY_OBJECT_RESPONSE_ITERATOR;
        }
        if (this.isMultipart) {
            try {
                return GetObjectResponseIterator.createIterator(this, bufferSize);
            }
            catch (Exception e) {
                throw new RetsException("Error creating multipart GetObjectIterator", e);
            }
        }
        return new NonMultipartGetObjectResponseIterator(this.headers, this.inputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

