/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.realtors.rets.client.GetObjectIterator;
import org.realtors.rets.client.GetObjectResponse;
import org.realtors.rets.client.SingleObjectResponse;
import org.realtors.rets.client.SinglePartInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetObjectResponseIterator<T extends SingleObjectResponse>
implements GetObjectIterator<T> {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String EOL = "\r\n";
    public static final String BS = "--";
    private final PushbackInputStream multipartStream;
    private final String boundary;
    private Boolean hasNext;

    public static <T extends SingleObjectResponse> GetObjectIterator<T> createIterator(final GetObjectResponse response, int streamBufferSize) throws Exception {
        String boundary = response.getBoundary();
        if (boundary != null) {
            return new GetObjectResponseIterator<T>(response, boundary, streamBufferSize);
        }
        return new GetObjectIterator<T>(){

            @Override
            public void close() throws IOException {
                response.getInputStream().close();
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        };
    }

    private GetObjectResponseIterator(GetObjectResponse response, String boundary, int streamBufferSize) throws Exception {
        this.boundary = boundary;
        BufferedInputStream input = new BufferedInputStream(response.getInputStream(), streamBufferSize);
        this.multipartStream = new PushbackInputStream(input, BS.length() + this.boundary.length() + EOL.length());
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext != null) {
            return this.hasNext;
        }
        try {
            this.hasNext = new Boolean(this.getHaveNext());
            return this.hasNext;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        try {
            return this.getNext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.multipartStream.close();
    }

    private boolean getHaveNext() throws IOException {
        String line = null;
        while ((line = this.readLine()) != null) {
            if (line.equals(BS + this.boundary)) {
                return true;
            }
            if (!line.equals(BS + this.boundary + BS)) continue;
            return false;
        }
        return false;
    }

    private T getNext() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String header = null;
        while (StringUtils.isNotEmpty((String)(header = this.readLine()))) {
            int nvSeperatorIndex = header.indexOf(58);
            if (nvSeperatorIndex == -1) {
                headers.put(header, "");
                continue;
            }
            String name = header.substring(0, nvSeperatorIndex);
            String value = header.substring(nvSeperatorIndex + 1).trim();
            headers.put(name, value);
        }
        return (T)new SingleObjectResponse(headers, new SinglePartInputStream(this.multipartStream, BS + this.boundary));
    }

    private String readLine() throws IOException {
        int nextChar;
        boolean eolReached = false;
        StringBuffer line = new StringBuffer();
        int currentChar = -1;
        while (!eolReached && (currentChar = this.multipartStream.read()) != -1) {
            eolReached = currentChar == 13 || currentChar == 10;
            if (eolReached) continue;
            line.append((char)currentChar);
        }
        if (currentChar == -1 && line.length() == 0) {
            return null;
        }
        if (currentChar == 13 && (nextChar = this.multipartStream.read()) != 10) {
            this.multipartStream.unread(new byte[]{(byte)nextChar});
        }
        return line.toString();
    }
}

