/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import org.realtors.rets.client.GetObjectIterator;
import org.realtors.rets.client.SingleObjectResponse;

final class NonMultipartGetObjectResponseIterator
implements GetObjectIterator {
    private boolean exhausted = false;
    private final Map headers;
    private final InputStream inputStream;

    public NonMultipartGetObjectResponseIterator(Map headers, InputStream in) {
        this.headers = headers;
        this.inputStream = in;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return !this.exhausted;
    }

    public SingleObjectResponse next() {
        if (this.exhausted) {
            throw new NoSuchElementException("stream exhausted");
        }
        this.exhausted = true;
        return new SingleObjectResponse(this.headers, this.inputStream);
    }
}

