/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.realtors.rets.client.CapabilityUrls;
import org.realtors.rets.client.CommonsHttpClient;
import org.realtors.rets.client.GenericHttpRequest;
import org.realtors.rets.client.GetMetadataRequest;
import org.realtors.rets.client.GetMetadataResponse;
import org.realtors.rets.client.GetObjectRequest;
import org.realtors.rets.client.GetObjectResponse;
import org.realtors.rets.client.LoginRequest;
import org.realtors.rets.client.LoginResponse;
import org.realtors.rets.client.LogoutResponse;
import org.realtors.rets.client.MetaCollectorImpl;
import org.realtors.rets.client.NetworkEventMonitor;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.RetsHttpClient;
import org.realtors.rets.client.RetsHttpRequest;
import org.realtors.rets.client.RetsHttpResponse;
import org.realtors.rets.client.RetsTransport;
import org.realtors.rets.client.RetsVersion;
import org.realtors.rets.client.SearchRequest;
import org.realtors.rets.client.SearchResult;
import org.realtors.rets.client.SearchResultCollector;
import org.realtors.rets.client.SearchResultImpl;
import org.realtors.rets.client.SearchResultProcessor;
import org.realtors.rets.client.SearchResultSet;
import org.realtors.rets.common.metadata.Metadata;
import org.realtors.rets.common.metadata.MetadataException;

public class RetsSession {
    public static final String METADATA_TABLES = "metadata_tables.xml";
    public static final String RETS_CLIENT_VERSION = "1.5";
    private static final Log LOG = LogFactory.getLog(RetsSession.class);
    private static String sUserAgent = "crt-rets-client/1.5";
    private CapabilityUrls capabilityUrls = new CapabilityUrls();
    private RetsHttpClient httpClient;
    private RetsTransport transport;
    private String sessionId;

    public RetsSession(String loginUrl) {
        this(loginUrl, new CommonsHttpClient());
    }

    public RetsSession(String loginUrl, RetsHttpClient httpClient) {
        this(loginUrl, httpClient, RetsVersion.DEFAULT);
    }

    public RetsSession(String loginUrl, RetsHttpClient httpClient, RetsVersion retsVersion) {
        this(loginUrl, httpClient, retsVersion, sUserAgent, false);
    }

    public RetsSession(String loginUrl, RetsHttpClient httpClient, RetsVersion retsVersion, String userAgent, boolean strict) {
        this.capabilityUrls.setLoginUrl(loginUrl);
        this.httpClient = httpClient;
        this.transport = new RetsTransport(httpClient, this.capabilityUrls, retsVersion, strict);
        this.httpClient.addDefaultHeader("User-Agent", userAgent);
    }

    public RetsVersion getRetsVersion() {
        return this.transport.getRetsVersion();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        LOG.debug((Object)("setting Session-ID to: " + sessionId));
        this.sessionId = sessionId;
    }

    public void setMonitor(NetworkEventMonitor monitor) {
        this.transport.setMonitor(monitor);
    }

    public void setStrict(boolean strict) {
        this.transport.setStrict(strict);
    }

    public boolean isStrict() {
        return this.transport.isStrict();
    }

    public static void setUserAgent(String userAgent) {
        sUserAgent = userAgent;
    }

    public String getLoginUrl() {
        return this.capabilityUrls.getLoginUrl();
    }

    public Metadata getIncrementalMetadata() throws RetsException {
        try {
            return new Metadata(new MetaCollectorImpl(this.transport));
        }
        catch (MetadataException e) {
            throw new RetsException((Throwable)((Object)e));
        }
    }

    public Metadata getMetadata() throws RetsException {
        return this.transport.getMetadata("null");
    }

    public Metadata getMetadata(String location) throws RetsException {
        return this.transport.getMetadata(location);
    }

    public GetMetadataResponse getMetadata(GetMetadataRequest req) throws RetsException {
        return this.transport.getMetadata(req);
    }

    private void getAction() throws RetsException {
        String actionUrl = this.capabilityUrls.getActionUrl();
        if (actionUrl == null) {
            LOG.warn((Object)"No Action-URL available, skipping");
            return;
        }
        GenericHttpRequest actionRequest = new GenericHttpRequest(actionUrl){

            @Override
            public Map<String, String> getHeaders() {
                return null;
            }
        };
        RetsHttpResponse httpResponse = this.httpClient.doRequest("GET", actionRequest);
        try {
            httpResponse.getInputStream().close();
        }
        catch (Exception e) {
            LOG.error((Object)"Action URL weirdness", (Throwable)e);
        }
    }

    public GetObjectResponse getObject(GetObjectRequest req) throws RetsException {
        return this.transport.getObject(req);
    }

    public GetObjectResponse getObject(String resource, String type, String entity, String id) throws RetsException {
        GetObjectRequest req = new GetObjectRequest(resource, type);
        req.addObject(entity, id);
        return this.getObject(req);
    }

    public LoginResponse login(String userName, String password) throws RetsException {
        return this.login(userName, password, null, null);
    }

    public LoginResponse login(String userName, String password, String brokerCode, String brokerBranch) throws RetsException {
        this.httpClient.setUserCredentials(userName, password);
        LoginRequest request = new LoginRequest();
        request.setBrokerCode(brokerCode, brokerBranch);
        LoginResponse response = this.transport.login(request);
        this.capabilityUrls = response.getCapabilityUrls();
        this.transport.setCapabilities(this.capabilityUrls);
        this.setSessionId(response.getSessionId());
        this.getAction();
        return response;
    }

    public LogoutResponse logout() throws RetsException {
        try {
            LogoutResponse logoutResponse = this.transport.logout();
            return logoutResponse;
        }
        finally {
            this.setSessionId(null);
        }
    }

    public SearchResult search(SearchRequest req) throws RetsException {
        SearchResultImpl res = new SearchResultImpl();
        this.search(req, res);
        return res;
    }

    public void search(SearchRequest req, SearchResultCollector collector) throws RetsException {
        this.transport.search(req, collector);
    }

    public SearchResultSet search(SearchRequest req, SearchResultProcessor processor) throws RetsException {
        return this.transport.search(req, processor);
    }

    public RetsHttpResponse request(RetsHttpRequest request) throws RetsException {
        return this.transport.doRequest(request);
    }

    public void setMethod(String method) {
        this.transport.setMethod(method);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.sessionId != null) {
                this.logout();
            }
        }
        finally {
            super.finalize();
        }
    }

    public int getQueryCount(SearchRequest req) throws RetsException {
        req.setCountOnly();
        SearchResult res = this.search(req);
        return res.getCount();
    }

    public GetObjectResponse getObjectUrl(GetObjectRequest req) throws RetsException {
        req.setLocationOnly(true);
        GetObjectResponse res = this.getObject(req);
        return res;
    }
}

