/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;

class SinglePartInputStream
extends FilterInputStream {
    private static final int EOS = -1;
    private final String boundary;
    private boolean eos;

    SinglePartInputStream(PushbackInputStream partInput, String boundary) {
        super(partInput);
        this.boundary = boundary;
    }

    public int read() throws IOException {
        int read = this.getPushBackStream().read();
        if (read != 13 && read != 10) {
            return read;
        }
        this.getPushBackStream().unread(read);
        byte[] peek = new byte["\r\n".length() + this.boundary.length()];
        int peekRead = this.getPushBackStream().read(peek);
        this.getPushBackStream().unread(peek, 0, peekRead);
        if (new String(peek).contains(this.boundary)) {
            return -1;
        }
        return this.getPushBackStream().read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (this.eos) {
            return -1;
        }
        for (read = off; read < off + len; ++read) {
            int nextByte = this.read();
            if (nextByte == -1) {
                this.eos = true;
                break;
            }
            b[read] = (byte)nextByte;
        }
        return read - off;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() {
    }

    private PushbackInputStream getPushBackStream() {
        return (PushbackInputStream)this.in;
    }
}

