/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import org.realtors.rets.client.CompactRowPolicy;
import org.realtors.rets.client.InvalidReplyCodeHandler;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.SearchResultHandler;
import org.realtors.rets.client.StreamingSearchResult;
import org.xml.sax.InputSource;

class StreamingThread
extends Thread {
    private StreamingSearchResult mResult;
    private InputSource mSource;
    private InvalidReplyCodeHandler mInvalidReplyCodeHandler;
    private CompactRowPolicy badRowPolicy;

    public StreamingThread(InputSource source, StreamingSearchResult result, InvalidReplyCodeHandler invalidReplyCodeHandler, CompactRowPolicy badRowPolicy) {
        this.mSource = source;
        this.mResult = result;
        this.mInvalidReplyCodeHandler = invalidReplyCodeHandler;
        this.badRowPolicy = badRowPolicy;
    }

    public void run() {
        SearchResultHandler handler = new SearchResultHandler(this.mResult, this.mInvalidReplyCodeHandler, this.badRowPolicy);
        try {
            handler.parse(this.mSource);
        }
        catch (RetsException e) {
            this.mResult.setException(e);
        }
        catch (Exception e) {
            this.mResult.setException(new RetsException("Low level exception while attempting to parse input from source.", e));
        }
    }
}

