/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.attrib;

import org.apache.commons.lang.StringUtils;
import org.realtors.rets.common.metadata.AttrType;
import org.realtors.rets.common.metadata.MetaParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrVersion
implements AttrType<Integer> {
    @Override
    public Integer parse(String value, boolean strict) throws MetaParseException {
        int release;
        int minor;
        int major;
        String[] parts = StringUtils.split((String)value, (String)".");
        if (strict && parts != null && parts.length != 3) {
            throw new MetaParseException("Invalid version: " + value + ", " + parts.length + " parts");
        }
        try {
            major = Integer.parseInt(this.getPart(parts, 0));
            minor = Integer.parseInt(this.getPart(parts, 1));
            release = Integer.parseInt(this.getPart(parts, 2));
        }
        catch (NumberFormatException e) {
            throw new MetaParseException("Invalid version: " + value, e);
        }
        if (major < 100 && major >= 0 && minor < 100 && minor >= 0 && release < 100000 && release >= 0) {
            return new Integer(major * 10000000 + minor * 100000 + release);
        }
        if (strict) {
            throw new MetaParseException("Invalid version: " + value);
        }
        return 0;
    }

    private String getPart(String[] parts, int part) {
        if (parts != null && parts.length > part) {
            return parts[part];
        }
        return "0";
    }

    @Override
    public String render(Integer value) {
        int ver = value;
        int release = ver % 100000;
        int minor = ver / 100000 % 100;
        int major = ver / 10000000;
        String minstr = Integer.toString(minor);
        String relstr = Integer.toString(release);
        while (minstr.length() < 2) {
            minstr = "0" + minstr;
        }
        while (relstr.length() < 5) {
            relstr = "0" + relstr;
        }
        return major + "." + minstr + "." + relstr;
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

