/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Collection;
import java.util.Map;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MTable;
import org.realtors.rets.common.metadata.types.MUpdate;

public class MClass
extends MetaObject {
    public static final String CLASSNAME = "ClassName";
    public static final String VISIBLENAME = "VisibleName";
    public static final String STANDARDNAME = "StandardName";
    public static final String DESCRIPTION = "Description";
    public static final String TABLEVERSION = "TableVersion";
    public static final String TABLEDATE = "TableDate";
    public static final String UPDATEVERSION = "UpdateVersion";
    public static final String UPDATEDATE = "UpdateDate";
    public static final String DELETEDFLAGFIELD = "DeletedFlagField";
    public static final String DELETEDFLAGVALUE = "DeletedFlagValue";
    public static final String CLASSTIMESTAMP = "ClassTimeStamp";
    public static final String HASHKEYINDEX = "HasKeyIndex";
    private static MetadataType[] sTypes = new MetadataType[]{MetadataType.UPDATE, MetadataType.TABLE};

    public MClass() {
        this(false);
    }

    public MClass(boolean strictParsing) {
        super(strictParsing);
    }

    public MetadataType[] getChildTypes() {
        return sTypes;
    }

    public String getClassName() {
        return this.getStringAttribute(CLASSNAME);
    }

    public String getVisibleName() {
        return this.getStringAttribute(VISIBLENAME);
    }

    public String getStandardName() {
        return this.getStringAttribute(STANDARDNAME);
    }

    public String getDescription() {
        return this.getStringAttribute(DESCRIPTION);
    }

    public int getTableVersion() {
        return this.getIntAttribute(TABLEVERSION);
    }

    public String getTableDate() {
        return this.getDateAttribute(TABLEDATE);
    }

    public int getUpdateVersion() {
        return this.getIntAttribute(UPDATEVERSION);
    }

    public String getUpdateDate() {
        return this.getDateAttribute(UPDATEDATE);
    }

    public MUpdate getMUpdate(String updateName) {
        return (MUpdate)this.getChild(MetadataType.UPDATE, updateName);
    }

    public MUpdate[] getMUpdates() {
        MUpdate[] tmpl = new MUpdate[]{};
        return this.getChildren(MetadataType.UPDATE).toArray(tmpl);
    }

    public MTable getMTable(String systemName) {
        return (MTable)this.getChild(MetadataType.TABLE, systemName);
    }

    public MTable[] getMTables() {
        Collection children = this.getChildren(MetadataType.TABLE);
        return children.toArray(new MTable[0]);
    }

    protected String getIdAttr() {
        return CLASSNAME;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(CLASSNAME, sAlphanum32);
        attributeMap.put(VISIBLENAME, sPlaintext32);
        attributeMap.put(STANDARDNAME, sAlphanum32);
        attributeMap.put(DESCRIPTION, sPlaintext128);
        attributeMap.put(TABLEVERSION, sAttrVersion);
        attributeMap.put(TABLEDATE, sAttrDate);
        attributeMap.put(UPDATEVERSION, sAttrVersion);
        attributeMap.put(UPDATEDATE, sAttrDate);
        attributeMap.put(DELETEDFLAGFIELD, retsname);
        attributeMap.put(DELETEDFLAGVALUE, sAlphanum32);
        attributeMap.put(CLASSTIMESTAMP, retsname);
        attributeMap.put(HASHKEYINDEX, sAttrBoolean);
    }

    public String getDeletedFlagField() {
        return this.getStringAttribute(DELETEDFLAGFIELD);
    }

    public String getDeletedFlagValue() {
        return this.getStringAttribute(DELETEDFLAGVALUE);
    }

    public String getClassTimeStamp() {
        return this.getStringAttribute(CLASSTIMESTAMP);
    }

    public String getHashKeyIndex() {
        return this.getStringAttribute(HASHKEYINDEX);
    }
}

