/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.RetsHttpResponse;
import org.realtors.rets.common.util.CaseInsensitiveTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHttpClientResponse
implements RetsHttpResponse {
    private HttpResponse response;
    private Map<String, String> headers;
    private Map<String, String> cookies;

    public CommonsHttpClientResponse(HttpResponse response, Map<String, String> cookies) {
        this.response = response;
        this.cookies = new CaseInsensitiveTreeMap<String, String>(cookies);
        this.headers = new CaseInsensitiveTreeMap<String, String>();
        for (Header header : this.response.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
    }

    @Override
    public int getResponseCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String header) {
        return this.headers.get(header);
    }

    @Override
    public Map<String, String> getCookies() throws RetsException {
        return this.cookies;
    }

    @Override
    public String getCookie(String cookie) throws RetsException {
        return this.cookies.get(cookie);
    }

    @Override
    public String getCharset() {
        String contentType = StringUtils.trimToEmpty((String)this.getHeader("Content-Type")).toLowerCase();
        String[] split = StringUtils.split((String)contentType, (String)";");
        if (split == null) {
            return null;
        }
        for (String s : split) {
            String sLower = s.toLowerCase().trim();
            boolean b = sLower.startsWith("charset=");
            if (!b) continue;
            return StringUtils.substringAfter((String)s, (String)"charset=");
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws RetsException {
        try {
            InputStream inputStream = this.response.getEntity().getContent();
            String contentEncoding = StringUtils.trimToEmpty((String)this.getHeader("Content-Encoding")).toLowerCase();
            boolean gzipped = ArrayUtils.contains((Object[])"gzip,deflate".split(","), (Object)contentEncoding);
            if (gzipped) {
                inputStream = new GZIPInputStream(inputStream);
            }
            final InputStream in = inputStream;
            return new InputStream(){

                public int read() throws IOException {
                    return in.read();
                }

                public int read(byte[] b) throws IOException {
                    return in.read(b);
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    return in.read(b, off, len);
                }

                public void close() throws IOException {
                    try {
                        Closeables.close((Closeable)in, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RetsException(e);
        }
    }
}

