/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import org.apache.commons.logging.LogFactory;

public interface CompactRowPolicy {
    public static final CompactRowPolicy STRICT = new CompactRowPolicy(){

        public boolean apply(int row, String[] columns, String[] values) {
            if (values.length != columns.length) {
                throw new IllegalArgumentException(String.format("Invalid number of result columns: got %s, expected %s", values.length, columns.length));
            }
            return true;
        }
    };
    public static final CompactRowPolicy DROP = new CompactRowPolicy(){

        public boolean apply(int row, String[] columns, String[] values) {
            if (values.length != columns.length) {
                LogFactory.getLog(CompactRowPolicy.class).warn((Object)String.format("Row %s: Invalid number of result columns:  got %s, expected ", row, values.length, columns.length));
                return false;
            }
            return true;
        }
    };
    public static final CompactRowPolicy DEFAULT = new CompactRowPolicy(){

        public boolean apply(int row, String[] columns, String[] values) {
            if (values.length > columns.length) {
                throw new IllegalArgumentException(String.format("Invalid number of result columns: got %s, expected %s", values.length, columns.length));
            }
            if (values.length < columns.length) {
                LogFactory.getLog(CompactRowPolicy.class).warn((Object)String.format("Row %s: Invalid number of result columns:  got %s, expected ", row, values.length, columns.length));
            }
            return true;
        }
    };
    public static final CompactRowPolicy DROP_LONG = new CompactRowPolicy(){

        public boolean apply(int row, String[] columns, String[] values) {
            if (values.length > columns.length) {
                LogFactory.getLog(CompactRowPolicy.class).warn((Object)String.format("Row %s: Invalid number of result columns:  got %s, expected ", row, values.length, columns.length));
                return false;
            }
            if (values.length < columns.length) {
                LogFactory.getLog(CompactRowPolicy.class).warn((Object)String.format("Row %s: Invalid number of result columns:  got %s, expected ", row, values.length, columns.length));
            }
            return true;
        }
    };

    public boolean apply(int var1, String[] var2, String[] var3);
}

