/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import org.apache.commons.lang.StringUtils;
import org.realtors.rets.client.CapabilityUrls;
import org.realtors.rets.client.InvalidArgumentException;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.VersionInsensitiveRequest;

public class GetMetadataRequest
extends VersionInsensitiveRequest {
    private static final int COMPACT_FORMAT = 0;
    private static final int STANDARD_XML_FORMAT = 1;
    public static final String KEY_TYPE = "Type";
    public static final String KEY_ID = "ID";
    public static final String KEY_FORMAT = "Format";
    public static final String FORMAT_STANDARD = "STANDARD-XML";
    public static final String FORMAT_STANDARD_PREFIX = "STANDARD-XML:";
    public static final String FORMAT_COMPACT = "COMPACT";
    private int format;
    private String standardXmlVersion;

    public GetMetadataRequest(String type, String id) throws RetsException {
        this(type, new String[]{id});
    }

    public GetMetadataRequest(String type, String[] ids) throws RetsException {
        this.assertValidIds(ids);
        type = "METADATA-" + type;
        if (type.equals("METADATA-SYSTEM") || type.equals("METADATA-RESOURCE")) {
            this.assertIdZeroOrStar(ids);
        }
        this.setQueryParameter(KEY_TYPE, type);
        this.setQueryParameter(KEY_ID, StringUtils.join((Object[])ids, (String)":"));
        this.setQueryParameter(KEY_FORMAT, FORMAT_STANDARD);
        this.format = 1;
    }

    public void setUrl(CapabilityUrls urls) {
        this.setUrl(urls.getGetMetadataUrl());
    }

    private void assertValidIds(String[] ids) throws InvalidArgumentException {
        if (ids.length == 0) {
            throw new InvalidArgumentException("Expecting at least one ID");
        }
    }

    private void assertIdZeroOrStar(String[] ids) throws InvalidArgumentException {
        if (ids.length != 1) {
            throw new InvalidArgumentException("Expecting 1 ID, but found, " + ids.length);
        }
        if (!ids[0].equals("0") && !ids[0].equals("*")) {
            throw new InvalidArgumentException("Expecting ID of 0 or *, but was " + ids[0]);
        }
    }

    public void setCompactFormat() {
        this.setQueryParameter(KEY_FORMAT, FORMAT_COMPACT);
        this.format = 0;
        this.standardXmlVersion = null;
    }

    public boolean isCompactFormat() {
        return this.format == 0;
    }

    public boolean isStandardXmlFormat() {
        return this.format == 1;
    }

    public String getStandardXmlVersion() {
        return this.standardXmlVersion;
    }
}

