/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.realtors.rets.client.InvalidReplyCodeException;
import org.realtors.rets.client.ReplyCode;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.RetsVersion;

public abstract class KeyValueResponse {
    protected static final String CRLF = "\r\n";
    private static final Log LOG = LogFactory.getLog(KeyValueResponse.class);
    protected Document mDoc;
    protected int mReplyCode;
    protected boolean mStrict = false;

    public void parse(InputStream stream, RetsVersion mVersion) throws RetsException {
        try {
            Element capabilityContainer;
            int replyCode;
            SAXBuilder builder = new SAXBuilder();
            this.mDoc = builder.build(stream);
            Element retsElement = this.mDoc.getRootElement();
            if (!retsElement.getName().equals("RETS")) {
                throw new RetsException("Expecting RETS");
            }
            this.mReplyCode = replyCode = NumberUtils.toInt((String)retsElement.getAttributeValue("ReplyCode"));
            if (!this.isValidReplyCode(replyCode)) {
                throw new InvalidReplyCodeException(replyCode);
            }
            if (RetsVersion.RETS_10.equals(mVersion)) {
                capabilityContainer = retsElement;
            } else {
                List children = retsElement.getChildren();
                if (children.size() != 1) {
                    throw new RetsException("Invalid number of children: " + children.size());
                }
                capabilityContainer = (Element)children.get(0);
                if (!capabilityContainer.getName().equals("RETS-RESPONSE")) {
                    throw new RetsException("Expecting RETS-RESPONSE");
                }
            }
            this.handleRetsResponse(capabilityContainer);
        }
        catch (JDOMException e) {
            throw new RetsException(e);
        }
        catch (IOException e) {
            throw new RetsException(e);
        }
    }

    protected boolean isValidReplyCode(int replyCode) {
        return ReplyCode.SUCCESS.equals(replyCode);
    }

    private void handleRetsResponse(Element retsResponse) throws RetsException {
        StringTokenizer tokenizer = new StringTokenizer(retsResponse.getText(), CRLF);
        while (tokenizer.hasMoreTokens()) {
            String value;
            String line = tokenizer.nextToken();
            String[] splits = StringUtils.split((String)line, (String)"=");
            String key = splits[0].trim();
            String string = value = splits.length > 1 ? splits[1].trim() : "";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<" + key + "> -> <" + value + ">"));
            }
            this.handleKeyValue(key, value);
        }
    }

    protected abstract void handleKeyValue(String var1, String var2) throws RetsException;

    public void setStrict(boolean strict) {
        this.mStrict = strict;
    }

    public boolean isStrict() {
        return this.mStrict;
    }

    protected boolean matchKey(String key, String value) {
        if (this.mStrict) {
            return key.equals(value);
        }
        return key.equalsIgnoreCase(value);
    }

    protected void assertStrictWarning(Log log, String message) throws RetsException {
        if (this.mStrict) {
            throw new RetsException(message);
        }
        log.warn((Object)message);
    }
}

