/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.realtors.rets.client.CapabilityUrls;
import org.realtors.rets.client.RetsUtil;
import org.realtors.rets.client.RetsVersion;
import org.realtors.rets.common.util.CaseInsensitiveTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetsHttpRequest
implements Serializable {
    private final Map<String, String> mHeaders = new CaseInsensitiveTreeMap<String, String>();
    private final SortedMap<String, String> mQueryParameters = new TreeMap<String, String>();
    protected String mUrl;

    public abstract void setUrl(CapabilityUrls var1);

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setHeader(String key, String value) {
        this.mHeaders.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String getHttpParameters() {
        if (this.mQueryParameters.isEmpty()) {
            return null;
        }
        LinkedList<String> params = new LinkedList<String>();
        for (Map.Entry<String, String> param : this.mQueryParameters.entrySet()) {
            params.add(String.format("%s=%s", RetsUtil.urlEncode(param.getKey()), RetsUtil.urlEncode(param.getValue())));
        }
        return StringUtils.join(params.iterator(), (String)"&");
    }

    protected void setQueryParameter(String name, String value) {
        if (value == null) {
            this.mQueryParameters.remove(name);
        } else {
            this.mQueryParameters.put(name, value);
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        for (String s : this.mQueryParameters.keySet()) {
            builder.append(s, this.mQueryParameters.get(s));
        }
        return builder.toString();
    }

    public abstract void setVersion(RetsVersion var1);
}

