/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.realtors.rets.client.CapabilityUrls;
import org.realtors.rets.client.ChangePasswordRequest;
import org.realtors.rets.client.ChangePasswordResponse;
import org.realtors.rets.client.GetMetadataRequest;
import org.realtors.rets.client.GetMetadataResponse;
import org.realtors.rets.client.GetObjectRequest;
import org.realtors.rets.client.GetObjectResponse;
import org.realtors.rets.client.InvalidReplyCodeException;
import org.realtors.rets.client.LoginRequest;
import org.realtors.rets.client.LoginResponse;
import org.realtors.rets.client.LogoutRequest;
import org.realtors.rets.client.LogoutResponse;
import org.realtors.rets.client.NetworkEventMonitor;
import org.realtors.rets.client.NullNetworkEventMonitor;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.RetsHttpClient;
import org.realtors.rets.client.RetsHttpRequest;
import org.realtors.rets.client.RetsHttpResponse;
import org.realtors.rets.client.RetsVersion;
import org.realtors.rets.client.SearchRequest;
import org.realtors.rets.client.SearchResultCollector;
import org.realtors.rets.client.SearchResultHandler;
import org.realtors.rets.client.SearchResultProcessor;
import org.realtors.rets.client.SearchResultSet;
import org.realtors.rets.common.metadata.JDomCompactBuilder;
import org.realtors.rets.common.metadata.JDomStandardBuilder;
import org.realtors.rets.common.metadata.Metadata;
import org.realtors.rets.common.metadata.MetadataBuilder;

public class RetsTransport {
    private static final String RETS_SESSION_ID_HEADER = "RETS-Session-ID";
    private RetsHttpClient client;
    private CapabilityUrls capabilities;
    private String method = "GET";
    private RetsVersion version;
    private boolean strict;
    private NetworkEventMonitor monitor;
    private static final Log LOG = LogFactory.getLog(RetsTransport.class);
    private static Map MONITOR_MSGS = new HashMap(){
        {
            this.put(ChangePasswordRequest.class, "Transmitting change password request");
            this.put(GetObjectRequest.class, "Retrieving media object");
            this.put(LoginRequest.class, "Logging in");
            this.put(GetMetadataRequest.class, "Retrieving metadata");
            this.put(LogoutRequest.class, "Logging out");
            this.put(SearchRequest.class, "Executing search");
        }
    };

    public RetsTransport(RetsHttpClient client, CapabilityUrls capabilities) {
        this(client, capabilities, RetsVersion.DEFAULT, false);
    }

    public RetsTransport(RetsHttpClient client, CapabilityUrls capabilities, RetsVersion version, boolean strict) {
        this.client = client;
        this.capabilities = capabilities;
        this.doVersionHeader(version);
        this.strict = strict;
        this.client.addDefaultHeader("Accept", "*/*");
        this.monitor = new NullNetworkEventMonitor();
    }

    public RetsVersion getRetsVersion() {
        return this.version;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setMonitor(NetworkEventMonitor monitor) {
        if (monitor == null) {
            monitor = new NullNetworkEventMonitor();
        }
        this.monitor = monitor;
    }

    private void doVersionHeader(RetsVersion retsVersion) {
        if (this.client == null) {
            return;
        }
        if (retsVersion == null) {
            retsVersion = RetsVersion.DEFAULT;
        }
        this.version = retsVersion;
        this.client.addDefaultHeader("RETS-Version", this.version.toString());
    }

    public void setCapabilities(CapabilityUrls capabilities) {
        this.capabilities = capabilities;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetsHttpResponse doRequest(RetsHttpRequest req) throws RetsException {
        RetsHttpResponse httpResponse;
        Object monitorobj = null;
        String msg = this.getMonitorMessage(req);
        monitorobj = this.monitor.eventStart(msg);
        req.setVersion(this.version);
        req.setUrl(this.capabilities);
        try {
            httpResponse = this.client.doRequest(this.method, req);
        }
        finally {
            this.monitor.eventFinish(monitorobj);
        }
        return httpResponse;
    }

    private String getMonitorMessage(RetsHttpRequest req) {
        String msg = (String)MONITOR_MSGS.get(req.getClass());
        if (msg == null) {
            msg = "communicating with network";
        }
        return msg;
    }

    public LoginResponse login(LoginRequest req) throws RetsException {
        RetsHttpResponse retsHttpResponse = this.doRequest(req);
        String versionHeader = retsHttpResponse.getHeader("RETS-Version");
        RetsVersion retsVersion = RetsVersion.getVersion(versionHeader);
        if (retsVersion == null && this.strict) {
            throw new RetsException(String.format("RETS Version is a required response header, version '%s' is unrecognized", versionHeader));
        }
        if (retsVersion != null) {
            this.doVersionHeader(retsVersion);
        }
        LoginResponse response = new LoginResponse(this.capabilities.getLoginUrl());
        String sessionId = retsHttpResponse.getCookie(RETS_SESSION_ID_HEADER);
        response.setSessionId(sessionId);
        response.setStrict(this.strict);
        response.parse(retsHttpResponse.getInputStream(), this.version);
        return response;
    }

    public LogoutResponse logout() throws RetsException {
        LogoutResponse response;
        block3: {
            if (this.capabilities.getLogoutUrl() == null) {
                return null;
            }
            LogoutRequest req = new LogoutRequest();
            RetsHttpResponse httpResponse = this.doRequest(req);
            response = new LogoutResponse();
            response.setStrict(this.strict);
            try {
                response.parse(httpResponse.getInputStream(), this.version);
            }
            catch (RetsException e) {
                if (!e.getMessage().contains("Invalid number of children")) break block3;
                LOG.warn((Object)"unsual response for logout request, but log out successful.");
            }
        }
        return response;
    }

    public void search(SearchRequest req, SearchResultCollector collector) throws RetsException {
        RetsHttpResponse httpResponse = this.doRequest(req);
        new SearchResultHandler(collector).parse(httpResponse.getInputStream(), httpResponse.getCharset());
    }

    public SearchResultSet search(SearchRequest req, SearchResultProcessor processor) throws RetsException {
        RetsHttpResponse httpResponse = this.doRequest(req);
        return processor.parse(httpResponse.getInputStream());
    }

    public GetObjectResponse getObject(GetObjectRequest req) throws RetsException {
        if (this.capabilities.getGetObjectUrl() == null) {
            throw new RetsException("Server does not support GetObject transaction.");
        }
        req.setUrl(this.capabilities);
        RetsHttpResponse httpResponse = this.client.doRequest(this.method, req);
        GetObjectResponse result = new GetObjectResponse(httpResponse.getHeaders(), httpResponse.getInputStream());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata getMetadata(String location) throws RetsException {
        boolean compact = Boolean.getBoolean("rets-client.metadata.compact");
        GetMetadataRequest req = new GetMetadataRequest("SYSTEM", "*");
        if (compact) {
            req.setCompactFormat();
        }
        RetsHttpResponse httpResponse = this.doRequest(req);
        Object monitorobj = null;
        monitorobj = this.monitor.eventStart("Parsing metadata");
        try {
            SAXBuilder xmlBuilder = new SAXBuilder();
            Document xmlDocument = xmlBuilder.build(httpResponse.getInputStream());
            if (!location.equals("null")) {
                XMLOutputter outputter = new XMLOutputter();
                FileWriter writer = new FileWriter(location);
                outputter.output(xmlDocument, (Writer)writer);
                outputter.outputString(xmlDocument);
            }
            MetadataBuilder metadataBuilder = req.isCompactFormat() ? new JDomCompactBuilder() : new JDomStandardBuilder();
            metadataBuilder.setStrict(this.strict);
            Metadata metadata = metadataBuilder.doBuild(xmlDocument);
            this.monitor.eventFinish(monitorobj);
            return metadata;
        }
        catch (Throwable throwable) {
            try {
                this.monitor.eventFinish(monitorobj);
                throw throwable;
            }
            catch (Exception e) {
                throw new RetsException(e);
            }
        }
    }

    public GetMetadataResponse getMetadata(GetMetadataRequest req) throws RetsException {
        RetsHttpResponse httpResponse = this.doRequest(req);
        Object monitorobj = null;
        monitorobj = this.monitor.eventStart("Parsing metadata");
        try {
            GetMetadataResponse getMetadataResponse = new GetMetadataResponse(httpResponse.getInputStream(), req.isCompactFormat(), this.strict);
            return getMetadataResponse;
        }
        catch (InvalidReplyCodeException e) {
            e.setRequestInfo(req.toString());
            throw e;
        }
        finally {
            this.monitor.eventFinish(monitorobj);
        }
    }

    public boolean changePassword(ChangePasswordRequest req) throws RetsException {
        RetsHttpResponse httpResponse = this.doRequest(req);
        ChangePasswordResponse response = new ChangePasswordResponse(httpResponse.getInputStream());
        return response != null;
    }
}

