/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import org.realtors.rets.client.CapabilityUrls;
import org.realtors.rets.client.RetsHttpRequest;
import org.realtors.rets.client.RetsVersion;

public class SearchRequest
extends RetsHttpRequest {
    public static final int COUNT_NONE = 1;
    public static final int COUNT_FIRST = 2;
    public static final int COUNT_ONLY = 3;
    public static final String FORMAT_STANDARD_XML = "STANDARD-XML";
    public static final String FORMAT_COMPACT = "COMPACT";
    public static final String FORMAT_COMPACT_DECODED = "COMPACT-DECODED";
    public static final String RETS_DMQL1 = "DMQL";
    public static final String RETS_DMQL2 = "DMQL2";
    public static final String KEY_TYPE = "SearchType";
    public static final String KEY_CLASS = "Class";
    public static final String KEY_DMQLVERSION = "QueryType";
    public static final String KEY_QUERY = "Query";
    public static final String KEY_COUNT = "Count";
    public static final String KEY_FORMAT = "Format";
    public static final String KEY_LIMIT = "Limit";
    public static final String KEY_OFFSET = "Offset";
    public static final String KEY_SELECT = "Select";
    public static final String KEY_RESTRICTEDINDICATOR = "RestrictedIndicator";
    public static final String KEY_STANDARDNAMES = "StandardNames";
    private String type;

    public SearchRequest(String stype, String sclass, String query) {
        this.setQueryParameter(KEY_TYPE, stype);
        this.type = stype;
        this.setQueryParameter(KEY_CLASS, sclass);
        this.setQueryParameter(KEY_QUERY, query);
        this.setQueryParameter(KEY_FORMAT, FORMAT_COMPACT);
        this.setQueryParameter(KEY_DMQLVERSION, RETS_DMQL2);
    }

    public void setUrl(CapabilityUrls urls) {
        this.setUrl(urls.getSearchUrl());
    }

    public String getType() {
        return this.type;
    }

    public void setCountNone() {
        this.setQueryParameter(KEY_COUNT, null);
    }

    public void setCountFirst() {
        this.setQueryParameter(KEY_COUNT, "1");
    }

    public void setCountOnly() {
        this.setQueryParameter(KEY_COUNT, "2");
    }

    public void setFormatCompact() {
        this.setQueryParameter(KEY_FORMAT, FORMAT_COMPACT);
    }

    public void setFormatCompactDecoded() {
        this.setQueryParameter(KEY_FORMAT, FORMAT_COMPACT_DECODED);
    }

    public void setFormatStandardXml() {
        this.setQueryParameter(KEY_FORMAT, FORMAT_STANDARD_XML);
    }

    public void setFormatStandardXml(String dtdVersion) {
        this.setQueryParameter(KEY_FORMAT, "STANDARD-XML:" + dtdVersion);
    }

    public void setLimit(int count) {
        this.setQueryParameter(KEY_LIMIT, Integer.toString(count));
    }

    public void setLimitNone() {
        this.setQueryParameter(KEY_LIMIT, null);
    }

    public void setSelect(String sel) {
        this.setQueryParameter(KEY_SELECT, sel);
    }

    public void setRestrictedIndicator(String rest) {
        this.setQueryParameter(KEY_RESTRICTEDINDICATOR, rest);
    }

    public void setStandardNames() {
        this.setQueryParameter(KEY_STANDARDNAMES, "1");
    }

    public void setSystemNames() {
        this.setQueryParameter(KEY_STANDARDNAMES, null);
    }

    public void setOffset(int offset) {
        this.setQueryParameter(KEY_OFFSET, Integer.toString(offset));
    }

    public void setOffsetNone() {
        this.setQueryParameter(KEY_OFFSET, null);
    }

    public void setVersion(RetsVersion ver) {
        if (RetsVersion.RETS_10.equals(ver)) {
            this.setQueryParameter(KEY_DMQLVERSION, RETS_DMQL1);
        } else {
            this.setQueryParameter(KEY_DMQLVERSION, RETS_DMQL2);
        }
    }
}

