/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.util.LinkedList;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.logging.LogFactory;
import org.realtors.rets.client.RetsException;
import org.realtors.rets.client.SearchResultCollector;
import org.realtors.rets.client.SearchResultInfo;
import org.realtors.rets.client.SearchResultSet;

class StreamingSearchResult
implements SearchResultSet,
SearchResultCollector {
    private static final int PREPROCESS = 0;
    private static final int BUFFER_AVAILABLE = 1;
    private static final int BUFFER_FULL = 2;
    private static final int COMPLETE = 3;
    private final int timeout;
    private final int bufferSize;
    private final LinkedList<String[]> buffer;
    private boolean mMaxrows;
    private int state;
    private String[] columns;
    private int count;
    private RetsException exception;

    public StreamingSearchResult(int bufferSize, int timeout) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("[bufferSize=" + bufferSize + "] must be greater than zero");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("[timeout=" + timeout + "] must be greater than or equal to zero");
        }
        this.bufferSize = bufferSize;
        this.timeout = timeout;
        this.state = 0;
        this.buffer = new LinkedList();
        this.count = -1;
        this.columns = null;
        this.exception = null;
    }

    public synchronized boolean addRow(String[] row) {
        if (row.length > this.columns.length) {
            throw new IllegalArgumentException(String.format("Invalid number of result columns: got %s, expected %s", row.length, this.columns.length));
        }
        if (row.length < this.columns.length) {
            LogFactory.getLog(SearchResultCollector.class).warn((Object)String.format("Row %s: Invalid number of result columns:  got %s, expected ", this.count, row.length, this.columns.length));
        }
        if (this.state() > 2) {
            if (this.exception == null) {
                this.setException(new RetsException("Attempting to add rows to buffer when in complete state"));
            }
            throw new NestableRuntimeException((Throwable)((Object)this.exception));
        }
        while (this.checkRuntime() && this.state() == 2) {
            this._wait();
            if (this.state() < 2) continue;
            if (this.exception == null) {
                this.setException(new RetsException("Timeout writing to streaming result set buffer, timeout length = " + this.timeout));
            }
            throw new NestableRuntimeException((Throwable)((Object)this.exception));
        }
        this.buffer.addLast(row);
        if (this.bufferSize == this.buffer.size()) {
            this.pushState(2);
        } else {
            this.pushState(1);
        }
        this.notifyAll();
        return true;
    }

    public synchronized void setComplete() {
        this.pushState(3);
        this.notifyAll();
    }

    public synchronized void setCount(int count) {
        this.count = count;
        this.pushState(0);
        this.notifyAll();
    }

    public synchronized void setColumns(String[] columns) {
        this.columns = columns;
        this.pushState(1);
        this.notifyAll();
    }

    public synchronized void setMaxrows() {
        this.mMaxrows = true;
        this.pushState(3);
        this.notifyAll();
    }

    synchronized void setException(RetsException e) {
        this.exception = e;
        this.pushState(3);
        this.notifyAll();
    }

    public synchronized boolean hasNext() throws RetsException {
        while (this.checkException() && this.state() < 3) {
            if (!this.buffer.isEmpty()) {
                return true;
            }
            this._wait();
        }
        return !this.buffer.isEmpty();
    }

    public synchronized String[] next() throws RetsException {
        this.checkException();
        String[] row = this.buffer.removeFirst();
        if (this.state < 3) {
            this.pushState(1);
        }
        this.notifyAll();
        return row;
    }

    public synchronized int getCount() throws RetsException {
        while (this.checkException() && this.state() < 1) {
            this._wait();
        }
        return this.count;
    }

    public synchronized String[] getColumns() throws RetsException {
        while (this.checkException() && this.state() < 1) {
            this._wait();
        }
        return this.columns;
    }

    public synchronized boolean isMaxrows() throws RetsException {
        this.checkException();
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot call isMaxRows until isComplete == true");
        }
        return this.mMaxrows;
    }

    public synchronized SearchResultInfo getInfo() throws RetsException {
        this.checkException();
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot call isMaxRows until isComplete == true");
        }
        return this;
    }

    public synchronized boolean isComplete() throws RetsException {
        this.checkException();
        return this.state() >= 3;
    }

    private synchronized boolean checkRuntime() {
        try {
            return this.checkException();
        }
        catch (RetsException e) {
            throw new NestableRuntimeException((Throwable)((Object)e));
        }
    }

    private synchronized boolean checkException() throws RetsException {
        if (this.exception != null) {
            throw this.exception;
        }
        return true;
    }

    private void _wait() {
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException e) {
            this.pushState(3);
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    private void pushState(int newState) {
        if (this.state >= 3 && newState < 3) {
            throw new IllegalStateException("Cannot revert from complete state");
        }
        if (this.state > 0 && newState <= 0) {
            throw new IllegalStateException("Cannot revert to preprocess state");
        }
        if (newState < this.state && newState != 1 && this.state != 2) {
            throw new IllegalStateException("Cannot go back in state unless reverting to buffer available from full");
        }
        this.state = newState;
    }

    private int state() {
        return this.state;
    }
}

