/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.client;

import java.io.InputStream;
import java.io.Reader;
import org.realtors.rets.client.CompactRowPolicy;
import org.realtors.rets.client.InvalidReplyCodeHandler;
import org.realtors.rets.client.SearchResultProcessor;
import org.realtors.rets.client.SearchResultSet;
import org.realtors.rets.client.StreamingSearchResult;
import org.realtors.rets.client.StreamingThread;
import org.xml.sax.InputSource;

public class StreamingSearchResultProcessor
implements SearchResultProcessor {
    private final int mBufferSize;
    private final int mTimeout;
    private InvalidReplyCodeHandler mInvalidReplyCodeHandler;
    private CompactRowPolicy mCompactRowPolicy;

    public StreamingSearchResultProcessor(int bufferSize) {
        this(bufferSize, 0);
    }

    public StreamingSearchResultProcessor(int bufferSize, int timeout) {
        this.mBufferSize = bufferSize;
        this.mTimeout = timeout;
    }

    public void setCompactRowPolicy(CompactRowPolicy badRowPolicy) {
        this.mCompactRowPolicy = badRowPolicy;
    }

    private CompactRowPolicy getCompactRowPolicy() {
        if (this.mCompactRowPolicy == null) {
            return CompactRowPolicy.DEFAULT;
        }
        return this.mCompactRowPolicy;
    }

    public void setInvalidRelyCodeHandler(InvalidReplyCodeHandler invalidReplyCodeHandler) {
        this.mInvalidReplyCodeHandler = invalidReplyCodeHandler;
    }

    private InvalidReplyCodeHandler getInvalidRelyCodeHandler() {
        if (this.mInvalidReplyCodeHandler == null) {
            return InvalidReplyCodeHandler.FAIL;
        }
        return this.mInvalidReplyCodeHandler;
    }

    public SearchResultSet parse(InputStream reader) {
        return this.parse(new InputSource(reader));
    }

    public SearchResultSet parse(Reader reader) {
        return this.parse(new InputSource(reader));
    }

    public SearchResultSet parse(InputSource source) {
        StreamingSearchResult result = new StreamingSearchResult(this.mBufferSize, this.mTimeout);
        StreamingThread thread = new StreamingThread(source, result, this.getInvalidRelyCodeHandler(), this.getCompactRowPolicy());
        thread.start();
        return result;
    }
}

