/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetaParseException;
import org.realtors.rets.common.metadata.Metadata;
import org.realtors.rets.common.metadata.MetadataBuilder;
import org.realtors.rets.common.metadata.MetadataException;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MClass;
import org.realtors.rets.common.metadata.types.MEditMask;
import org.realtors.rets.common.metadata.types.MLookup;
import org.realtors.rets.common.metadata.types.MLookupType;
import org.realtors.rets.common.metadata.types.MObject;
import org.realtors.rets.common.metadata.types.MResource;
import org.realtors.rets.common.metadata.types.MSearchHelp;
import org.realtors.rets.common.metadata.types.MSystem;
import org.realtors.rets.common.metadata.types.MTable;
import org.realtors.rets.common.metadata.types.MUpdate;
import org.realtors.rets.common.metadata.types.MUpdateType;
import org.realtors.rets.common.metadata.types.MValidationExpression;
import org.realtors.rets.common.metadata.types.MValidationExternal;
import org.realtors.rets.common.metadata.types.MValidationExternalType;
import org.realtors.rets.common.metadata.types.MValidationLookup;
import org.realtors.rets.common.metadata.types.MValidationLookupType;
import org.xml.sax.InputSource;

public class JDomCompactBuilder
extends MetadataBuilder {
    public static final String CONTAINER_PREFIX = "METADATA-";
    public static final String CONTAINER_ROOT = "RETS";
    public static final String CONTAINER_METADATA = "METADATA";
    public static final String CONTAINER_SYSTEM = "METADATA-SYSTEM";
    public static final String CONTAINER_RESOURCE = "METADATA-RESOURCE";
    public static final String CONTAINER_FOREIGNKEY = "METADATA-FOREIGN_KEY";
    public static final String CONTAINER_CLASS = "METADATA-CLASS";
    public static final String CONTAINER_TABLE = "METADATA-TABLE";
    public static final String CONTAINER_UPDATE = "METADATA-UPDATE";
    public static final String CONTAINER_UPDATETYPE = "METADATA-UPDATE_TYPE";
    public static final String CONTAINER_OBJECT = "METADATA-OBJECT";
    public static final String CONTAINER_SEARCHHELP = "METADATA-SEARCH_HELP";
    public static final String CONTAINER_EDITMASK = "METADATA-EDITMASK";
    public static final String CONTAINER_UPDATEHELP = "METADATA-UPDATE_HELP";
    public static final String CONTAINER_LOOKUP = "METADATA-LOOKUP";
    public static final String CONTAINER_LOOKUPTYPE = "METADATA-LOOKUP_TYPE";
    public static final String CONTAINER_VALIDATIONLOOKUP = "METADATA-VALIDATION_LOOKUP";
    public static final String CONTAINER_VALIDATIONLOOKUPTYPE = "METADATA-VALIDATION_LOOKUP_TYPE";
    public static final String CONTAINER_VALIDATIONEXPRESSION = "METADATA-VALIDATION_EXPRESSION";
    public static final String CONTAINER_VALIDATIONEXTERNAL = "METADATA-VALIDATION_EXTERNAL";
    public static final String CONTAINER_VALIDATIONEXTERNALTYPE = "METADATA-VALIDATION_EXTERNAL_TYPE";
    public static final String ELEMENT_SYSTEM = "SYSTEM";
    public static final String COLUMNS = "COLUMNS";
    public static final String DATA = "DATA";
    public static final String ATTRIBUTE_RESOURCE = "Resource";
    public static final String ATTRIBUTE_CLASS = "Class";
    public static final String ATTRIBUTE_UPDATE = "Update";
    public static final String ATTRIBUTE_LOOKUP = "Lookup";
    public static final String ATTRIBUTE_VALIDATIONEXTERNAL = "ValidationExternal";
    public static final String ATTRIBUTE_VALIDATIONLOOKUP = "ValidationLookup";
    private static final Log LOG = LogFactory.getLog(JDomCompactBuilder.class);

    public Metadata doBuild(Object src) throws MetadataException {
        return this.build((Document)src);
    }

    public Metadata build(InputSource source) throws MetadataException {
        Document document;
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(source);
        }
        catch (JDOMException e) {
            throw new MetadataException("Couldn't build document", e);
        }
        catch (IOException e) {
            throw new MetadataException("Couldn't build document", e);
        }
        return this.build(document);
    }

    public MetaObject[] parse(Object src) throws MetadataException {
        return this.parse((Document)src);
    }

    public MetaObject[] parse(Document src) throws MetadataException {
        Element root = src.getRootElement();
        if (!root.getName().equals(CONTAINER_ROOT)) {
            throw new MetadataException("Invalid root element");
        }
        Element container = root.getChild(CONTAINER_SYSTEM);
        if (container != null) {
            MSystem sys = this.processSystem(container);
            if (root.getChild(CONTAINER_RESOURCE) != null) {
                Metadata m = new Metadata(sys);
                this.recurseAll(m, root);
            }
            return new MetaObject[]{sys};
        }
        container = root.getChild(CONTAINER_RESOURCE);
        if (container != null) {
            return this.processResource(container);
        }
        container = root.getChild(CONTAINER_CLASS);
        if (container != null) {
            return this.processClass(container);
        }
        container = root.getChild(CONTAINER_TABLE);
        if (container != null) {
            return this.processTable(container);
        }
        container = root.getChild(CONTAINER_UPDATE);
        if (container != null) {
            return this.processUpdate(container);
        }
        container = root.getChild(CONTAINER_UPDATETYPE);
        if (container != null) {
            return this.processUpdateType(container);
        }
        container = root.getChild(CONTAINER_OBJECT);
        if (container != null) {
            return this.processObject(container);
        }
        container = root.getChild(CONTAINER_SEARCHHELP);
        if (container != null) {
            return this.processSearchHelp(container);
        }
        container = root.getChild(CONTAINER_EDITMASK);
        if (container != null) {
            return this.processEditMask(container);
        }
        container = root.getChild(CONTAINER_LOOKUP);
        if (container != null) {
            return this.processLookup(container);
        }
        container = root.getChild(CONTAINER_LOOKUPTYPE);
        if (container != null) {
            return this.processLookupType(container);
        }
        container = root.getChild(CONTAINER_VALIDATIONLOOKUP);
        if (container != null) {
            return this.processValidationLookup(container);
        }
        container = root.getChild(CONTAINER_VALIDATIONLOOKUPTYPE);
        if (container != null) {
            return this.processValidationLookupType(container);
        }
        container = root.getChild(CONTAINER_VALIDATIONEXTERNAL);
        if (container != null) {
            return this.processValidationExternal(container);
        }
        container = root.getChild(CONTAINER_VALIDATIONEXTERNALTYPE);
        if (container != null) {
            return this.processValidationExternalType(container);
        }
        container = root.getChild(CONTAINER_VALIDATIONEXPRESSION);
        if (container != null) {
            return this.processValidationExpression(container);
        }
        return null;
    }

    public Metadata build(Document src) throws MetadataException {
        Element root = src.getRootElement();
        if (!root.getName().equals(CONTAINER_ROOT)) {
            throw new MetadataException("Invalid root element");
        }
        Element element = root.getChild(CONTAINER_SYSTEM);
        if (element == null) {
            throw new MetadataException("Missing element METADATA-SYSTEM");
        }
        MSystem sys = this.processSystem(element);
        Metadata metadata = new Metadata(sys);
        this.recurseAll(metadata, root);
        return metadata;
    }

    private void recurseAll(Metadata metadata, Element root) throws MetaParseException {
        this.attachResource(metadata, root);
        this.attachClass(metadata, root);
        this.attachTable(metadata, root);
        this.attachUpdate(metadata, root);
        this.attachUpdateType(metadata, root);
        this.attachObject(metadata, root);
        this.attachSearchHelp(metadata, root);
        this.attachEditMask(metadata, root);
        this.attachLookup(metadata, root);
        this.attachLookupType(metadata, root);
        this.attachValidationLookup(metadata, root);
        this.attachValidationLookupType(metadata, root);
        this.attachValidationExternal(metadata, root);
        this.attachValidationExternalType(metadata, root);
        this.attachValidationExpression(metadata, root);
    }

    private void setAttributes(MetaObject obj, String[] columns, String[] data) {
        int count = columns.length;
        if (count > data.length) {
            count = data.length;
        }
        for (int i = 0; i < count; ++i) {
            String column = columns[i];
            String datum = data[i];
            if (datum.equals("")) continue;
            JDomCompactBuilder.setAttribute(obj, column, datum);
        }
    }

    private String[] getColumns(Element el) {
        Element cols = el.getChild(COLUMNS);
        return this.split(cols);
    }

    private String[] split(Element el) {
        if (el == null) {
            return null;
        }
        String delimiter = "\t";
        StringTokenizer tkn = new StringTokenizer(el.getText(), "\t", true);
        LinkedList<String> list = new LinkedList<String>();
        tkn.nextToken();
        String last = null;
        while (tkn.hasMoreTokens()) {
            String next = tkn.nextToken();
            if (next.equals("\t")) {
                if (last == null) {
                    list.add("");
                    continue;
                }
                last = null;
                continue;
            }
            list.add(next);
            last = next;
        }
        return list.toArray(new String[0]);
    }

    private String getNonNullAttribute(Element element, String name) throws MetaParseException {
        String value = element.getAttributeValue(name);
        if (value == null) {
            throw new MetaParseException("Attribute '" + name + "' not found on tag " + this.toString(element));
        }
        return value;
    }

    private String toString(Element element) {
        StringBuffer buffer = new StringBuffer();
        List attributes = element.getAttributes();
        buffer.append("'").append(element.getName()).append("'");
        buffer.append(", attributes: ").append(attributes);
        return buffer.toString();
    }

    private MSystem processSystem(Element container) {
        Element element = container.getChild(ELEMENT_SYSTEM);
        MSystem system = this.buildSystem();
        String comment = container.getChildText("Comments");
        String systemId = element.getAttributeValue("SystemID");
        String systemDescription = element.getAttributeValue("SystemDescription");
        String version = container.getAttributeValue("Version");
        String date = container.getAttributeValue("Date");
        JDomCompactBuilder.setAttribute(system, "Comments", comment);
        JDomCompactBuilder.setAttribute(system, "SystemID", systemId);
        JDomCompactBuilder.setAttribute(system, "SystemDescription", systemDescription);
        JDomCompactBuilder.setAttribute(system, "Version", version);
        JDomCompactBuilder.setAttribute(system, "Date", date);
        return system;
    }

    private void attachResource(Metadata metadata, Element root) {
        MSystem system = metadata.getSystem();
        List containers = root.getChildren(CONTAINER_RESOURCE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource[] resources = this.processResource(container);
            for (int j = 0; j < resources.length; ++j) {
                system.addChild(MetadataType.RESOURCE, resources[j]);
            }
        }
    }

    private MResource[] processResource(Element resourceContainer) {
        String[] columns = this.getColumns(resourceContainer);
        List rows = resourceContainer.getChildren(DATA);
        MResource[] resources = new MResource[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MResource resource = this.buildResource();
            this.setAttributes(resource, columns, data);
            resources[i] = resource;
        }
        return resources;
    }

    private void attachClass(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_CLASS);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            String resourceId = this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE);
            MResource resource = metadata.getResource(resourceId);
            MClass[] classes = this.processClass(container);
            for (int j = 0; j < classes.length; ++j) {
                resource.addChild(MetadataType.CLASS, classes[j]);
            }
        }
    }

    private MClass[] processClass(Element classContainer) throws MetaParseException {
        String name = classContainer.getName();
        String resourceId = this.getNonNullAttribute(classContainer, ATTRIBUTE_RESOURCE);
        LOG.debug((Object)("resource name: " + resourceId + " for container " + name));
        String[] columns = this.getColumns(classContainer);
        List rows = classContainer.getChildren(DATA);
        MClass[] classes = new MClass[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MClass clazz = this.buildClass();
            this.setAttributes(clazz, columns, data);
            classes[i] = clazz;
        }
        return classes;
    }

    private void attachTable(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_TABLE);
        for (int i = 0; i < containers.size(); ++i) {
            String className;
            Element container = (Element)containers.get(i);
            String resourceId = this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE);
            MClass clazz = metadata.getMClass(resourceId, className = this.getNonNullAttribute(container, ATTRIBUTE_CLASS));
            if (clazz == null) {
                LOG.warn((Object)("Found table metadata for resource class: " + resourceId + ":" + className + " but there is no class metadata for " + resourceId + ":" + className));
                continue;
            }
            MTable[] fieldMetadata = this.processTable(container);
            for (int j = 0; j < fieldMetadata.length; ++j) {
                clazz.addChild(MetadataType.TABLE, fieldMetadata[j]);
            }
        }
    }

    private MTable[] processTable(Element tableContainer) {
        String[] columns = this.getColumns(tableContainer);
        List rows = tableContainer.getChildren(DATA);
        MTable[] fieldMetadata = new MTable[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MTable mTable = this.buildTable();
            this.setAttributes(mTable, columns, data);
            fieldMetadata[i] = mTable;
        }
        return fieldMetadata;
    }

    private void attachUpdate(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_UPDATE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MClass parent = metadata.getMClass(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE), this.getNonNullAttribute(container, ATTRIBUTE_CLASS));
            MUpdate[] updates = this.processUpdate(container);
            for (int j = 0; j < updates.length; ++j) {
                parent.addChild(MetadataType.UPDATE, updates[j]);
            }
        }
    }

    private MUpdate[] processUpdate(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MUpdate[] updates = new MUpdate[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MUpdate update = this.buildUpdate();
            this.setAttributes(update, columns, data);
            updates[i] = update;
        }
        return updates;
    }

    private void attachUpdateType(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_UPDATETYPE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MUpdate parent = metadata.getUpdate(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE), this.getNonNullAttribute(container, ATTRIBUTE_CLASS), this.getNonNullAttribute(container, ATTRIBUTE_UPDATE));
            MUpdateType[] updateTypes = this.processUpdateType(container);
            for (int j = 0; j < updateTypes.length; ++j) {
                parent.addChild(MetadataType.UPDATE_TYPE, updateTypes[j]);
            }
        }
    }

    private MUpdateType[] processUpdateType(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MUpdateType[] updateTypes = new MUpdateType[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MUpdateType updateType = this.buildUpdateType();
            this.setAttributes(updateType, columns, data);
            updateTypes[i] = updateType;
        }
        return updateTypes;
    }

    private void attachObject(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_OBJECT);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MObject[] objects = this.processObject(container);
            for (int j = 0; j < objects.length; ++j) {
                parent.addChild(MetadataType.OBJECT, objects[j]);
            }
        }
    }

    private MObject[] processObject(Element objectContainer) {
        String[] columns = this.getColumns(objectContainer);
        List rows = objectContainer.getChildren(DATA);
        MObject[] objects = new MObject[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MObject object = this.buildObject();
            this.setAttributes(object, columns, data);
            objects[i] = object;
        }
        return objects;
    }

    private void attachSearchHelp(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_SEARCHHELP);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MSearchHelp[] searchHelps = this.processSearchHelp(container);
            for (int j = 0; j < searchHelps.length; ++j) {
                parent.addChild(MetadataType.SEARCH_HELP, searchHelps[j]);
            }
        }
    }

    private MSearchHelp[] processSearchHelp(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MSearchHelp[] searchHelps = new MSearchHelp[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MSearchHelp searchHelp = this.buildSearchHelp();
            this.setAttributes(searchHelp, columns, data);
            searchHelps[i] = searchHelp;
        }
        return searchHelps;
    }

    private void attachEditMask(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_EDITMASK);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MEditMask[] editMasks = this.processEditMask(container);
            for (int j = 0; j < editMasks.length; ++j) {
                parent.addChild(MetadataType.EDITMASK, editMasks[j]);
            }
        }
    }

    private MEditMask[] processEditMask(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MEditMask[] editMasks = new MEditMask[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MEditMask editMask = this.buildEditMask();
            this.setAttributes(editMask, columns, data);
            editMasks[i] = editMask;
        }
        return editMasks;
    }

    private void attachLookup(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_LOOKUP);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MLookup[] lookups = this.processLookup(container);
            for (int j = 0; j < lookups.length; ++j) {
                parent.addChild(MetadataType.LOOKUP, lookups[j]);
            }
        }
    }

    private MLookup[] processLookup(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MLookup[] lookups = new MLookup[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MLookup lookup = this.buildLookup();
            this.setAttributes(lookup, columns, data);
            lookups[i] = lookup;
        }
        return lookups;
    }

    private void attachLookupType(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_LOOKUPTYPE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MLookup parent = metadata.getLookup(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE), this.getNonNullAttribute(container, ATTRIBUTE_LOOKUP));
            if (parent == null) {
                LOG.warn((Object)("Skipping lookup type: could not find lookup for tag " + this.toString(container)));
                continue;
            }
            MLookupType[] lookupTypes = this.processLookupType(container);
            for (int j = 0; j < lookupTypes.length; ++j) {
                parent.addChild(MetadataType.LOOKUP_TYPE, lookupTypes[j]);
            }
        }
    }

    private MLookupType[] processLookupType(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MLookupType[] lookupTypes = new MLookupType[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MLookupType lookupType = this.buildLookupType();
            this.setAttributes(lookupType, columns, data);
            lookupTypes[i] = lookupType;
        }
        return lookupTypes;
    }

    private void attachValidationLookup(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_VALIDATIONLOOKUP);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MValidationLookup[] validationLookups = this.processValidationLookup(container);
            for (int j = 0; j < validationLookups.length; ++j) {
                parent.addChild(MetadataType.VALIDATION_LOOKUP, validationLookups[j]);
            }
        }
    }

    private MValidationLookup[] processValidationLookup(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MValidationLookup[] validationLookups = new MValidationLookup[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MValidationLookup validationLookup = this.buildValidationLookup();
            this.setAttributes(validationLookup, columns, data);
            validationLookups[i] = validationLookup;
        }
        return validationLookups;
    }

    private void attachValidationLookupType(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_VALIDATIONLOOKUPTYPE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MValidationLookup parent = metadata.getValidationLookup(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE), this.getNonNullAttribute(container, ATTRIBUTE_VALIDATIONLOOKUP));
            MValidationLookupType[] validationLookupTypes = this.processValidationLookupType(container);
            for (int j = 0; j < validationLookupTypes.length; ++j) {
                parent.addChild(MetadataType.VALIDATION_LOOKUP_TYPE, validationLookupTypes[j]);
            }
        }
    }

    private MValidationLookupType[] processValidationLookupType(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MValidationLookupType[] validationLookupTypes = new MValidationLookupType[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MValidationLookupType validationLookupType = this.buildValidationLookupType();
            this.setAttributes(validationLookupType, columns, data);
            validationLookupTypes[i] = validationLookupType;
        }
        return validationLookupTypes;
    }

    private void attachValidationExternal(Metadata metadata, Element root) {
        List containers = root.getChildren(CONTAINER_VALIDATIONEXTERNAL);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(container.getAttributeValue(ATTRIBUTE_RESOURCE));
            MValidationExternal[] validationExternals = this.processValidationExternal(container);
            for (int j = 0; j < validationExternals.length; ++j) {
                parent.addChild(MetadataType.VALIDATION_EXTERNAL, validationExternals[j]);
            }
        }
    }

    private MValidationExternal[] processValidationExternal(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MValidationExternal[] validationExternals = new MValidationExternal[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MValidationExternal validationExternal = this.buildValidationExternal();
            this.setAttributes(validationExternal, columns, data);
            validationExternals[i] = validationExternal;
        }
        return validationExternals;
    }

    private void attachValidationExternalType(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_VALIDATIONEXTERNALTYPE);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MValidationExternal parent = metadata.getValidationExternal(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE), this.getNonNullAttribute(container, ATTRIBUTE_VALIDATIONEXTERNAL));
            MValidationExternalType[] validationExternalTypes = this.processValidationExternalType(container);
            for (int j = 0; j < validationExternalTypes.length; ++j) {
                parent.addChild(MetadataType.VALIDATION_EXTERNAL_TYPE, validationExternalTypes[j]);
            }
        }
    }

    private MValidationExternalType[] processValidationExternalType(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MValidationExternalType[] validationExternalTypes = new MValidationExternalType[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MValidationExternalType validationExternalType = this.buildValidationExternalType();
            this.setAttributes(validationExternalType, columns, data);
            validationExternalTypes[i] = validationExternalType;
        }
        return validationExternalTypes;
    }

    private void attachValidationExpression(Metadata metadata, Element root) throws MetaParseException {
        List containers = root.getChildren(CONTAINER_VALIDATIONEXPRESSION);
        for (int i = 0; i < containers.size(); ++i) {
            Element container = (Element)containers.get(i);
            MResource parent = metadata.getResource(this.getNonNullAttribute(container, ATTRIBUTE_RESOURCE));
            MValidationExpression[] expressions = this.processValidationExpression(container);
            for (int j = 0; j < expressions.length; ++j) {
                parent.addChild(MetadataType.VALIDATION_EXPRESSION, expressions[j]);
            }
        }
    }

    private MValidationExpression[] processValidationExpression(Element container) {
        String[] columns = this.getColumns(container);
        List rows = container.getChildren(DATA);
        MValidationExpression[] expressions = new MValidationExpression[rows.size()];
        for (int i = 0; i < expressions.length; ++i) {
            Element element = (Element)rows.get(i);
            String[] data = this.split(element);
            MValidationExpression expression = this.buildValidationExpression();
            this.setAttributes(expression, columns, data);
            expressions[i] = expression;
        }
        return expressions;
    }
}

