/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.Metadata;
import org.realtors.rets.common.metadata.MetadataBuilder;
import org.realtors.rets.common.metadata.MetadataException;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MClass;
import org.realtors.rets.common.metadata.types.MEditMask;
import org.realtors.rets.common.metadata.types.MForeignKey;
import org.realtors.rets.common.metadata.types.MLookup;
import org.realtors.rets.common.metadata.types.MLookupType;
import org.realtors.rets.common.metadata.types.MObject;
import org.realtors.rets.common.metadata.types.MResource;
import org.realtors.rets.common.metadata.types.MSearchHelp;
import org.realtors.rets.common.metadata.types.MSystem;
import org.realtors.rets.common.metadata.types.MTable;
import org.realtors.rets.common.metadata.types.MUpdate;
import org.realtors.rets.common.metadata.types.MUpdateHelp;
import org.realtors.rets.common.metadata.types.MUpdateType;
import org.realtors.rets.common.metadata.types.MValidationExpression;
import org.realtors.rets.common.metadata.types.MValidationExternal;
import org.realtors.rets.common.metadata.types.MValidationExternalType;
import org.realtors.rets.common.metadata.types.MValidationLookup;
import org.realtors.rets.common.metadata.types.MValidationLookupType;

public class JDomStandardBuilder
extends MetadataBuilder {
    public static final String ELEMENT_SYSTEM = "System";
    public static final String ELEMENT_RESOURCE = "Resource";
    public static final String ELEMENT_FOREIGNKEY = "ForeignKey";
    public static final String ELEMENT_CLASS = "Class";
    public static final String ELEMENT_TABLE = "Field";
    public static final String ELEMENT_UPDATE = "UpdateType";
    public static final String ELEMENT_UPDATETYPE = "UpdateField";
    public static final String ELEMENT_OBJECT = "Object";
    public static final String ELEMENT_SEARCHHELP = "SearchHelp";
    public static final String ELEMENT_EDITMASK = "EditMask";
    public static final String ELEMENT_UPDATEHELP = "UpdateHelp";
    public static final String ELEMENT_LOOKUP = "Lookup";
    public static final String ELEMENT_LOOKUPTYPE = "LookupType";
    public static final String ELEMENT_VALIDATIONLOOKUP = "ValidationLookup";
    public static final String ELEMENT_VALIDATIONLOOKUPTYPE = "ValidationLookupType";
    public static final String ELEMENT_VALIDATIONEXPRESSION = "ValidationExpression";
    public static final String ELEMENT_VALIDATIONEXTERNAL = "ValidationExternalType";
    public static final String ELEMENT_VALIDATIONEXTERNALTYPE = "ValidationExternal";
    public static final String ATTRIBUTE_RESOURCEID = "Resource";
    public static final String ATTRIBUTE_CLASSNAME = "Class";
    public static final String ATTRIBUTE_UPDATE = "UpdateType";
    public static final String ATTRIBUTE_LOOKUP = "Lookup";
    public static final String ATTRIBUTE_VALIDATIONLOOKUP = "ValidationLookup";
    public static final String ATTRIBUTE_VALIDATIONEXTERNAL = "ValidationExternalType";
    public static final Map sType2Element = new HashMap();
    public static final String CONTAINER_PREFIX = "METADATA-";
    public static final String CONTAINER_ROOT = "RETS";
    public static final String CONTAINER_METADATA = "METADATA";
    public static final String CONTAINER_SYSTEM = "METADATA-SYSTEM";
    public static final String CONTAINER_RESOURCE = "METADATA-RESOURCE";
    public static final String CONTAINER_FOREIGNKEY = "METADATA-FOREIGN_KEYS";
    public static final String CONTAINER_CLASS = "METADATA-CLASS";
    public static final String CONTAINER_TABLE = "METADATA-TABLE";
    public static final String CONTAINER_UPDATE = "METADATA-UPDATE";
    public static final String CONTAINER_UPDATE_TYPE = "METADATA-UPDATE_TYPE";
    public static final String CONTAINER_OBJECT = "METADATA-OBJECT";
    public static final String CONTAINER_SEARCH_HELP = "METADATA-SEARCH_HELP";
    public static final String CONTAINER_EDITMASK = "METADATA-EDITMASK";
    public static final String CONTAINER_UPDATEHELP = "METADATA-UPDATE_HELP";
    public static final String CONTAINER_LOOKUP = "METADATA-LOOKUP";
    public static final String CONTAINER_LOOKUPTYPE = "METADATA-LOOKUP_TYPE";
    public static final String CONTAINER_VALIDATIONLOOKUP = "METADATA-VALIDATION_LOOKUP";
    public static final String CONTAINER_VALIDATIONLOOKUPTYPE = "METADATA-VALIDATION_LOOKUP_TYPE";
    public static final String CONTAINER_VALIDATIONEXPRESSION = "METADATA-VALIDATION_EXPRESSION";
    public static final String CONTAINER_VALIDATIONEXTERNAL = "METADATA-VALIDATION_EXTERNAL";
    public static final String CONTAINER_VALIDATIONEXTERNALTYPE = "METADATA-VALIDATION_EXTERNAL_TYPE";
    public static final Map sContainer2Type;

    public Metadata doBuild(Object src) throws MetadataException {
        return this.build((Document)src);
    }

    public Metadata build(Document src) throws MetadataException {
        Element element = src.getRootElement();
        this.expectElement(element, CONTAINER_ROOT);
        element = this.getElement(element, CONTAINER_METADATA);
        return this.build(element);
    }

    public MetaObject[] parse(Object src) throws MetadataException {
        return this.parse((Document)src);
    }

    public MetaObject[] parse(Document src) throws MetadataException {
        Element element = src.getRootElement();
        this.expectElement(element, CONTAINER_ROOT);
        Element container = this.getElement(element, CONTAINER_METADATA);
        boolean recurse = this.checkForRecursion(container);
        List list = container.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return this.processContainer(null, (Element)list.get(0), recurse);
    }

    private boolean checkForRecursion(Element top) {
        for (Element element : top.getChildren()) {
            for (Element child : element.getChildren()) {
                for (Element subtype : child.getChildren()) {
                    if (!subtype.getName().startsWith(CONTAINER_PREFIX)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private MetaObject[] processContainer(MetaObject parent, Element container, boolean recursion) {
        MetadataType type = (MetadataType)((Object)sContainer2Type.get(container.getName()));
        if (type == null) {
            throw new RuntimeException("no matching type for container " + container.getName());
        }
        List elements = container.getChildren((String)sType2Element.get((Object)type));
        String path = this.getPath(container);
        LinkedList<MetaObject> output = null;
        if (parent == null) {
            output = new LinkedList<MetaObject>();
        }
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MetaObject obj = this.newType(type);
            this.setAttributes(obj, element);
            if (output != null) {
                output.add(obj);
            }
            if (parent != null) {
                parent.addChild(type, obj);
            } else if (!type.equals((Object)MetadataType.SYSTEM)) {
                obj.setPath(path);
            }
            if (!recursion) continue;
            MetadataType[] childTypes = obj.getChildTypes();
            for (int j = 0; j < childTypes.length; ++j) {
                MetadataType childType = childTypes[j];
                Element childContainer = element.getChild(CONTAINER_PREFIX + childType.name());
                if (childContainer == null) {
                    obj.addChild(childType, null);
                    continue;
                }
                this.processContainer(obj, childContainer, true);
            }
        }
        if (output == null) {
            return null;
        }
        return output.toArray(new MetaObject[0]);
    }

    String getPath(Element container) {
        String resource = container.getAttributeValue("Resource");
        if (resource == null) {
            return null;
        }
        String classname = container.getAttributeValue("Class");
        if (classname != null) {
            String update = container.getAttributeValue("UpdateType");
            if (update != null) {
                return resource + ":" + classname + ":" + update;
            }
            return resource + ":" + classname;
        }
        String lookup = container.getAttributeValue("Lookup");
        if (lookup != null) {
            return resource + ":" + lookup;
        }
        String vallkp = container.getAttributeValue("ValidationLookup");
        if (vallkp != null) {
            return resource + ":" + vallkp;
        }
        String vale = container.getAttributeValue("ValidationExternalType");
        if (vale != null) {
            return resource + ":" + vale;
        }
        return resource;
    }

    public Metadata build(Element element) throws MetadataException {
        this.expectElement(element, CONTAINER_METADATA);
        element = this.getElement(element, CONTAINER_SYSTEM);
        MSystem sys = this.processSystem(element);
        return new Metadata(sys);
    }

    private Element getElement(Element parent, String type) throws MetadataException {
        Element element = parent.getChild(type);
        if (element == null) {
            throw new MetadataException("Missing element " + type);
        }
        return element;
    }

    private void expectElement(Element element, String type) throws MetadataException {
        if (!element.getName().equalsIgnoreCase(type)) {
            throw new MetadataException("Expecting element " + type + ", got " + element.getName());
        }
    }

    private void setAttributes(MetaObject obj, Element el) {
        List children = el.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String name = child.getName();
            if (name.startsWith(CONTAINER_PREFIX)) continue;
            String value = child.getTextTrim();
            JDomStandardBuilder.setAttribute(obj, name, value);
        }
    }

    public void setAttributesFromXMLAttr(MetaObject obj, Element el) {
        for (Attribute attr : el.getParentElement().getAttributes()) {
            String name = attr.getName();
            String value = attr.getValue().trim();
            JDomStandardBuilder.setAttribute(obj, name, value);
        }
    }

    private void init(MetaObject item) {
        MetadataType[] childTypes = item.getChildTypes();
        for (int i = 0; i < childTypes.length; ++i) {
            MetadataType type = childTypes[i];
            item.addChild(type, null);
        }
    }

    private MSystem processSystem(Element container) {
        Element element = container.getChild(ELEMENT_SYSTEM);
        if (element == null) {
            element = container.getChild(ELEMENT_SYSTEM.toUpperCase());
        }
        MSystem system = this.buildSystem();
        this.init(system);
        this.setAttributesFromXMLAttr(system, element);
        this.setAttributes(system, element);
        Element child = element.getChild(CONTAINER_RESOURCE);
        if (child != null) {
            this.processResource(system, child);
        }
        if ((child = element.getChild(CONTAINER_FOREIGNKEY)) != null) {
            this.processForeignKey(system, child);
        }
        return system;
    }

    private void processResource(MSystem system, Element container) {
        List resources = container.getChildren("Resource");
        for (int i = 0; i < resources.size(); ++i) {
            Element element = (Element)resources.get(i);
            MResource resource = this.buildResource();
            this.init(resource);
            this.setAttributes(resource, element);
            system.addChild(MetadataType.RESOURCE, resource);
            Element child = element.getChild(CONTAINER_CLASS);
            if (child != null) {
                this.processClass(resource, child);
            }
            if ((child = element.getChild(CONTAINER_OBJECT)) != null) {
                this.processObject(resource, child);
            }
            if ((child = element.getChild(CONTAINER_SEARCH_HELP)) != null) {
                this.processSearchHelp(resource, child);
            }
            if ((child = element.getChild(CONTAINER_EDITMASK)) != null) {
                this.processEditMask(resource, child);
            }
            if ((child = element.getChild(CONTAINER_LOOKUP)) != null) {
                this.processLookup(resource, child);
            }
            if ((child = element.getChild(CONTAINER_UPDATEHELP)) != null) {
                this.processUpdateHelp(resource, child);
            }
            if ((child = element.getChild(CONTAINER_VALIDATIONLOOKUP)) != null) {
                this.processValidationLookup(resource, child);
            }
            if ((child = element.getChild(CONTAINER_VALIDATIONEXPRESSION)) != null) {
                this.processValidationExpression(resource, child);
            }
            if ((child = element.getChild(CONTAINER_VALIDATIONEXTERNAL)) == null) continue;
            this.processValidationExternal(resource, child);
        }
    }

    private void processEditMask(MResource parent, Element container) {
        List elements = container.getChildren(ELEMENT_EDITMASK);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MEditMask mask = this.buildEditMask();
            this.setAttributes(mask, element);
            parent.addChild(MetadataType.EDITMASK, mask);
        }
    }

    private void processLookup(MResource parent, Element container) {
        List elements15 = container.getChildren("Lookup");
        List elements17 = container.getChildren(ELEMENT_LOOKUPTYPE);
        List elements = elements15.isEmpty() ? elements17 : elements15;
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MLookup lookup = this.buildLookup();
            this.init(lookup);
            this.setAttributes(lookup, element);
            parent.addChild(MetadataType.LOOKUP, lookup);
            Element child = element.getChild(CONTAINER_LOOKUPTYPE);
            if (child == null) continue;
            this.processLookupType(lookup, child);
        }
    }

    private void processLookupType(MLookup parent, Element container) {
        List elements15 = container.getChildren(ELEMENT_LOOKUPTYPE);
        List elements17 = container.getChildren("Lookup");
        List elements = elements15.isEmpty() ? elements17 : elements15;
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MLookupType type = this.buildLookupType();
            this.setAttributes(type, element);
            parent.addChild(MetadataType.LOOKUP_TYPE, type);
        }
    }

    private void processUpdateHelp(MResource parent, Element container) {
        List elements = container.getChildren(ELEMENT_UPDATEHELP);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MUpdateHelp help = this.buildUpdateHelp();
            this.setAttributes(help, element);
            parent.addChild(MetadataType.UPDATE_HELP, help);
        }
    }

    private void processValidationLookup(MResource parent, Element container) {
        List elements = container.getChildren("ValidationLookup");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MValidationLookup lookup = this.buildValidationLookup();
            this.init(lookup);
            this.setAttributes(lookup, element);
            parent.addChild(MetadataType.VALIDATION_LOOKUP, lookup);
            Element child = element.getChild(CONTAINER_VALIDATIONLOOKUPTYPE);
            if (child == null) continue;
            this.processValidationLookupType(lookup, child);
        }
    }

    private void processValidationLookupType(MValidationLookup parent, Element container) {
        List elements = container.getChildren(ELEMENT_VALIDATIONLOOKUPTYPE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MValidationLookupType lookupType = this.buildValidationLookupType();
            this.setAttributes(lookupType, element);
            parent.addChild(MetadataType.VALIDATION_LOOKUP_TYPE, lookupType);
        }
    }

    private void processValidationExpression(MResource parent, Element container) {
        List elements = container.getChildren(ELEMENT_VALIDATIONEXPRESSION);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MValidationExpression expression = this.buildValidationExpression();
            this.setAttributes(expression, element);
            parent.addChild(MetadataType.VALIDATION_EXPRESSION, expression);
        }
    }

    private void processValidationExternal(MResource parent, Element container) {
        List elements = container.getChildren("ValidationExternalType");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MValidationExternal external = this.buildValidationExternal();
            this.init(external);
            this.setAttributes(external, element);
            parent.addChild(MetadataType.VALIDATION_EXTERNAL, external);
            Element child = element.getChild(CONTAINER_VALIDATIONEXTERNALTYPE);
            if (child == null) continue;
            this.processValidationExternalType(external, child);
        }
    }

    private void processValidationExternalType(MValidationExternal parent, Element container) {
        List elements = container.getChildren(ELEMENT_VALIDATIONEXTERNALTYPE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            MValidationExternalType type = this.buildValidationExternalType();
            this.setAttributes(type, element);
            parent.addChild(MetadataType.VALIDATION_EXTERNAL_TYPE, type);
        }
    }

    private void processSearchHelp(MResource parent, Element container) {
        List searchhelps = container.getChildren(ELEMENT_SEARCHHELP);
        for (int i = 0; i < searchhelps.size(); ++i) {
            Element element = (Element)searchhelps.get(i);
            MSearchHelp searchhelp = this.buildSearchHelp();
            this.setAttributes(searchhelp, element);
            parent.addChild(MetadataType.SEARCH_HELP, searchhelp);
        }
    }

    private void processObject(MResource parent, Element container) {
        List objects = container.getChildren(ELEMENT_OBJECT);
        for (int i = 0; i < objects.size(); ++i) {
            Element element = (Element)objects.get(i);
            MObject obj = this.buildObject();
            this.setAttributes(obj, element);
            parent.addChild(MetadataType.OBJECT, obj);
        }
    }

    private void processClass(MResource parent, Element container) {
        List classes = container.getChildren("Class");
        for (int i = 0; i < classes.size(); ++i) {
            Element element = (Element)classes.get(i);
            MClass clazz = this.buildClass();
            this.init(clazz);
            this.setAttributes(clazz, element);
            parent.addChild(MetadataType.CLASS, clazz);
            Element child = element.getChild(CONTAINER_TABLE);
            if (child != null) {
                this.processTable(clazz, child);
            }
            if ((child = element.getChild(CONTAINER_UPDATE)) == null) continue;
            this.processUpdate(clazz, child);
        }
    }

    private void processTable(MClass parent, Element container) {
        List tables = container.getChildren(ELEMENT_TABLE);
        for (int i = 0; i < tables.size(); ++i) {
            Element element = (Element)tables.get(i);
            MTable table = this.buildTable();
            this.setAttributes(table, element);
            parent.addChild(MetadataType.TABLE, table);
        }
    }

    private void processUpdate(MClass parent, Element container) {
        List updates = container.getChildren("UpdateType");
        for (int i = 0; i < updates.size(); ++i) {
            Element element = (Element)updates.get(i);
            MUpdate update = this.buildUpdate();
            this.init(update);
            this.setAttributes(update, element);
            parent.addChild(MetadataType.UPDATE, update);
            Element child = element.getChild(CONTAINER_UPDATE_TYPE);
            if (child == null) continue;
            this.processUpdateType(update, child);
        }
    }

    private void processUpdateType(MUpdate parent, Element container) {
        List updateFields = container.getChildren(ELEMENT_UPDATETYPE);
        for (int i = 0; i < updateFields.size(); ++i) {
            Element element = (Element)updateFields.get(i);
            MUpdateType updateType = this.buildUpdateType();
            parent.addChild(MetadataType.UPDATE_TYPE, updateType);
            this.setAttributes(updateType, element);
        }
    }

    private void processForeignKey(MSystem system, Element container) {
        List fkeys = container.getChildren(ELEMENT_FOREIGNKEY);
        for (int i = 0; i < fkeys.size(); ++i) {
            Element element = (Element)fkeys.get(i);
            MForeignKey foreignKey = this.buildForeignKey();
            this.setAttributes(foreignKey, element);
            system.addChild(MetadataType.FOREIGNKEYS, foreignKey);
        }
    }

    static {
        sType2Element.put(MetadataType.SYSTEM, ELEMENT_SYSTEM);
        sType2Element.put(MetadataType.RESOURCE, "Resource");
        sType2Element.put(MetadataType.FOREIGNKEYS, ELEMENT_FOREIGNKEY);
        sType2Element.put(MetadataType.CLASS, "Class");
        sType2Element.put(MetadataType.TABLE, ELEMENT_TABLE);
        sType2Element.put(MetadataType.UPDATE, "UpdateType");
        sType2Element.put(MetadataType.UPDATE_TYPE, ELEMENT_UPDATETYPE);
        sType2Element.put(MetadataType.SEARCH_HELP, ELEMENT_SEARCHHELP);
        sType2Element.put(MetadataType.EDITMASK, ELEMENT_EDITMASK);
        sType2Element.put(MetadataType.UPDATE_HELP, ELEMENT_UPDATEHELP);
        sType2Element.put(MetadataType.LOOKUP, "Lookup");
        sType2Element.put(MetadataType.LOOKUP_TYPE, ELEMENT_LOOKUPTYPE);
        sType2Element.put(MetadataType.VALIDATION_LOOKUP, "ValidationLookup");
        sType2Element.put(MetadataType.VALIDATION_LOOKUP_TYPE, ELEMENT_VALIDATIONLOOKUPTYPE);
        sType2Element.put(MetadataType.VALIDATION_EXTERNAL, "ValidationExternalType");
        sType2Element.put(MetadataType.VALIDATION_EXTERNAL_TYPE, ELEMENT_VALIDATIONEXTERNALTYPE);
        sType2Element.put(MetadataType.VALIDATION_EXPRESSION, ELEMENT_VALIDATIONEXPRESSION);
        sContainer2Type = new HashMap();
        for (int i = 0; i < MetadataType.values().length; ++i) {
            MetadataType type = MetadataType.values()[i];
            sContainer2Type.put(CONTAINER_PREFIX + type.name(), type);
        }
        sContainer2Type.remove(CONTAINER_PREFIX + MetadataType.FOREIGNKEYS.name());
        sContainer2Type.put(CONTAINER_FOREIGNKEY, MetadataType.FOREIGNKEYS);
    }
}

