/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.realtors.rets.common.metadata.AttrType;
import org.realtors.rets.common.metadata.CacheKey;
import org.realtors.rets.common.metadata.MetaCollector;
import org.realtors.rets.common.metadata.MetaParseException;
import org.realtors.rets.common.metadata.MetadataException;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.attrib.AttrAlphanum;
import org.realtors.rets.common.metadata.attrib.AttrBoolean;
import org.realtors.rets.common.metadata.attrib.AttrDate;
import org.realtors.rets.common.metadata.attrib.AttrNumeric;
import org.realtors.rets.common.metadata.attrib.AttrNumericPositive;
import org.realtors.rets.common.metadata.attrib.AttrPlaintext;
import org.realtors.rets.common.metadata.attrib.AttrText;
import org.realtors.rets.common.metadata.attrib.AttrVersion;
import org.realtors.rets.common.util.CaseInsensitiveTreeMap;

public abstract class MetaObject
implements Serializable {
    private static final Log LOG = LogFactory.getLog(MetaObject.class);
    protected static final AttrType sAlphanum = new AttrAlphanum(0, 0);
    protected static final AttrType sAlphanum64 = new AttrAlphanum(1, 64);
    protected static final AttrType sAlphanum32 = new AttrAlphanum(1, 32);
    protected static final AttrType sAlphanum24 = new AttrAlphanum(1, 24);
    protected static final AttrType sAlphanum10 = new AttrAlphanum(1, 10);
    protected static final AttrType sPlaintext = new AttrPlaintext(0, 0);
    protected static final AttrType sPlaintext1024 = new AttrPlaintext(1, 1024);
    protected static final AttrType sPlaintext512 = new AttrPlaintext(1, 512);
    protected static final AttrType sPlaintext128 = new AttrPlaintext(1, 128);
    protected static final AttrType sPlaintext64 = new AttrPlaintext(1, 64);
    protected static final AttrType sPlaintext32 = new AttrPlaintext(1, 32);
    protected static final AttrType sText = new AttrText(0, 0);
    protected static final AttrType sText1024 = new AttrText(1, 1024);
    protected static final AttrType sText512 = new AttrText(1, 512);
    protected static final AttrType sText256 = new AttrText(1, 256);
    protected static final AttrType sText128 = new AttrText(1, 128);
    protected static final AttrType sText64 = new AttrText(1, 64);
    protected static final AttrType sText32 = new AttrText(1, 32);
    protected static final AttrType sAttrBoolean = new AttrBoolean();
    protected static final AttrType sAttrDate = new AttrDate();
    protected static final AttrType sAttrNumeric = new AttrNumeric();
    protected static final AttrType sAttrNumericPositive = new AttrNumericPositive();
    protected static final AttrType sAttrVersion = new AttrVersion();
    protected static final AttrType sAttrMetadataEntryId = sAlphanum32;
    protected static final MetadataType[] sNoChildren = new MetadataType[0];
    protected static final AttrType retsid = sAlphanum32;
    protected static final AttrType retsname = sAlphanum64;
    public static final boolean STRICT_PARSING = true;
    public static final boolean LOOSE_PARSING = false;
    public static final boolean DEFAULT_PARSING = false;
    protected String path;
    protected Map childTypes;
    protected Map attributes;
    protected Map attrTypes;
    private static Map<CacheKey, Map> sAttributeMapCache = new HashMap<CacheKey, Map>();
    private MetaCollector mCollector;
    private boolean strict;

    public MetaObject(boolean strictParsing) {
        this.strict = strictParsing;
        this.attributes = strictParsing ? new HashMap() : new CaseInsensitiveTreeMap();
        this.attrTypes = this.getAttributeMap(strictParsing);
        MetadataType[] types = this.getChildTypes();
        this.childTypes = new HashMap();
        for (int i = 0; i < types.length; ++i) {
            this.childTypes.put(types[i], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAttributeMap(boolean strictParsing) {
        Map<CacheKey, Map> map = sAttributeMapCache;
        synchronized (map) {
            Map map2 = sAttributeMapCache.get(new CacheKey(this, strictParsing));
            if (map2 == null) {
                map2 = strictParsing ? new HashMap() : new CaseInsensitiveTreeMap();
                this.addAttributesToMap(map2);
                map2 = Collections.unmodifiableMap(map2);
                sAttributeMapCache.put(new CacheKey(this, strictParsing), map2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to attribute cache: " + this.getClass().getName() + ", " + strictParsing));
                }
            }
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAttributeMapCache() {
        Map<CacheKey, Map> map = sAttributeMapCache;
        synchronized (map) {
            sAttributeMapCache.clear();
        }
    }

    public Collection getChildren(MetadataType type) {
        if (!this.childTypes.containsKey((Object)type)) {
            return null;
        }
        Object o = this.childTypes.get((Object)type);
        if (o == null) {
            if (!this.fetchChildren(type)) {
                return Collections.EMPTY_SET;
            }
            o = this.childTypes.get((Object)type);
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            return m.values();
        }
        return (Collection)o;
    }

    private boolean fetchChildren(MetadataType type) {
        this.childTypes.put(type, new HashMap());
        try {
            MetaObject[] children = null;
            if (this.mCollector != null) {
                children = this.mCollector.getMetadata(type, this.getPath());
            }
            if (children == null) {
                return false;
            }
            for (int i = 0; i < children.length; ++i) {
                MetaObject child = children[i];
                this.addChild(type, child);
            }
        }
        catch (MetadataException e) {
            LOG.error((Object)(this.toString() + " unable to fetch " + type.name() + " children"));
            return false;
        }
        return true;
    }

    public MetaObject getChild(MetadataType type, String id) {
        if (id == null) {
            return null;
        }
        try {
            if (this.childTypes.get((Object)type) == null && this.mCollector != null && !this.fetchChildren(type)) {
                return null;
            }
            Map m = (Map)this.childTypes.get((Object)type);
            if (m == null) {
                return null;
            }
            return (MetaObject)m.get(id);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Set getKnownAttributes() {
        return this.attrTypes.keySet();
    }

    public String getAttributeAsString(String key) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return null;
        }
        if (this.attrTypes.containsKey(key)) {
            AttrType type = (AttrType)this.attrTypes.get(key);
            return type.render(value);
        }
        return value.toString();
    }

    protected Object getTypedAttribute(String key, Class type) {
        AttrType atype = (AttrType)this.attrTypes.get(key);
        if (atype == null) {
            return null;
        }
        if (atype.getType() == type) {
            return this.attributes.get(key);
        }
        LOG.warn((Object)("type mismatch, expected " + type.getName() + " but" + " got " + atype.getType().getName()));
        return null;
    }

    public String getDateAttribute(String key) {
        return (String)this.getTypedAttribute(key, String.class);
    }

    public String getStringAttribute(String key) {
        return (String)this.getTypedAttribute(key, String.class);
    }

    public int getIntAttribute(String key) {
        Integer i = (Integer)this.getTypedAttribute(key, Integer.class);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public boolean getBooleanAttribute(String key) {
        Boolean b = (Boolean)this.getTypedAttribute(key, Boolean.class);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            return;
        }
        if (this.attrTypes.containsKey(key)) {
            AttrType type = (AttrType)this.attrTypes.get(key);
            try {
                this.attributes.put(key, type.parse(value, this.strict));
            }
            catch (MetaParseException e) {
                LOG.warn((Object)(this.toString() + " couldn't parse attribute " + key + ", value " + value + ": " + e.getMessage()));
            }
        } else {
            this.attributes.put(key, value);
            LOG.warn((Object)("Unknown key (" + this.toString() + "): " + key));
        }
    }

    public void addChild(MetadataType type, MetaObject child) {
        if (this.childTypes.containsKey((Object)type)) {
            HashMap<String, MetaObject> map;
            Object obj = this.childTypes.get((Object)type);
            if (obj == null) {
                map = new HashMap<String, MetaObject>();
                this.childTypes.put(type, map);
            } else {
                map = (HashMap<String, MetaObject>)obj;
            }
            if (child == null) {
                return;
            }
            String id = child.getId();
            child.setPath(this.getPath());
            child.setCollector(this.mCollector);
            if (id != null) {
                map.put(id, child);
            }
            return;
        }
    }

    public String getId() {
        String idAttr = this.getIdAttr();
        if (idAttr == null) {
            return Integer.toString(this.hashCode());
        }
        return this.getAttributeAsString(idAttr);
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String parent) {
        this.path = parent == null || parent.equals("") ? this.getId() : parent + ":" + this.getId();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        for (String key : this.getKnownAttributes()) {
            tsb.append(key, (Object)this.getAttributeAsString(key));
        }
        return tsb.toString();
    }

    public void setCollector(MetaCollector c) {
        this.mCollector = c;
        for (MetadataType type : this.childTypes.keySet()) {
            Map map = (Map)this.childTypes.get((Object)type);
            if (map == null) continue;
            Collection children = map.values();
            for (MetaObject object : children) {
                object.setCollector(c);
            }
        }
    }

    public abstract MetadataType[] getChildTypes();

    protected abstract String getIdAttr();

    protected abstract void addAttributesToMap(Map var1);
}

