/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.attrib;

import org.realtors.rets.common.metadata.AttrType;
import org.realtors.rets.common.metadata.MetaParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrBoolean
implements AttrType<Boolean> {
    @Override
    public Boolean parse(String value, boolean strict) throws MetaParseException {
        if (value.equals("1")) {
            return Boolean.TRUE;
        }
        if (value.equals("0")) {
            return Boolean.FALSE;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (value.equalsIgnoreCase("Y")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("N")) {
            return Boolean.FALSE;
        }
        if (value.equals("")) {
            return Boolean.FALSE;
        }
        if (strict) {
            throw new MetaParseException("Invalid boolean value: " + value);
        }
        return false;
    }

    @Override
    public String render(Boolean value) {
        if (value.booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }
}

