/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Map;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MLookupType;

public class MLookup
extends MetaObject {
    private static final MetadataType[] CHILDREN = new MetadataType[]{MetadataType.LOOKUP_TYPE};
    private static final MLookupType[] EMPTYLOOKUPTYPES = new MLookupType[0];
    public static final String METADATAENTRYID = "MetadataEntryID";
    public static final String LOOKUPNAME = "LookupName";
    public static final String VISIBLENAME = "VisibleName";
    public static final String VERSION = "Version";
    public static final String DATE = "Date";
    public static final String LOOKUPTYPEVERSION = "LookupTypeVersion";
    public static final String LOOKUPTYPEDATE = "LookupTypeDate";

    public MLookup() {
        this(false);
    }

    public MLookup(boolean strictParsing) {
        super(strictParsing);
    }

    public String getMetadataEntryID() {
        return this.getStringAttribute(METADATAENTRYID);
    }

    public String getLookupName() {
        return this.getStringAttribute(LOOKUPNAME);
    }

    public String getVisibleName() {
        return this.getStringAttribute(VISIBLENAME);
    }

    public int getVersion() {
        int ver = this.getIntAttribute(VERSION);
        if (ver == 0) {
            ver = this.getIntAttribute(LOOKUPTYPEVERSION);
        }
        return ver;
    }

    public String getDate() {
        String date = this.getDateAttribute(DATE);
        if (date == null) {
            date = this.getDateAttribute(LOOKUPTYPEDATE);
        }
        return date;
    }

    public MLookupType getMLookupType(String value) {
        return (MLookupType)this.getChild(MetadataType.LOOKUP_TYPE, value);
    }

    public MLookupType[] getMLookupTypes() {
        return this.getChildren(MetadataType.LOOKUP_TYPE).toArray(EMPTYLOOKUPTYPES);
    }

    public MetadataType[] getChildTypes() {
        return CHILDREN;
    }

    protected String getIdAttr() {
        return LOOKUPNAME;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(METADATAENTRYID, sAttrMetadataEntryId);
        attributeMap.put(LOOKUPNAME, sAlphanum32);
        attributeMap.put(VISIBLENAME, sPlaintext32);
        attributeMap.put(VERSION, sAttrVersion);
        attributeMap.put(DATE, sAttrDate);
        attributeMap.put(LOOKUPTYPEVERSION, sAttrVersion);
        attributeMap.put(LOOKUPTYPEDATE, sAttrDate);
    }
}

