/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Map;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MClass;
import org.realtors.rets.common.metadata.types.MEditMask;
import org.realtors.rets.common.metadata.types.MLookup;
import org.realtors.rets.common.metadata.types.MObject;
import org.realtors.rets.common.metadata.types.MSearchHelp;
import org.realtors.rets.common.metadata.types.MUpdateHelp;
import org.realtors.rets.common.metadata.types.MValidationExpression;
import org.realtors.rets.common.metadata.types.MValidationExternal;
import org.realtors.rets.common.metadata.types.MValidationLookup;

public class MResource
extends MetaObject {
    private static final MetadataType[] CHILDREN = new MetadataType[]{MetadataType.VALIDATION_EXPRESSION, MetadataType.LOOKUP, MetadataType.CLASS, MetadataType.OBJECT, MetadataType.VALIDATION_EXTERNAL, MetadataType.VALIDATION_LOOKUP, MetadataType.EDITMASK, MetadataType.UPDATE_HELP, MetadataType.SEARCH_HELP};
    public static final String RESOURCEID = "ResourceID";
    public static final String STANDARDNAME = "StandardName";
    public static final String VISIBLENAME = "VisibleName";
    public static final String DESCRIPTION = "Description";
    public static final String KEYFIELD = "KeyField";
    public static final String CLASSCOUNT = "ClassCount";
    public static final String CLASSVERSION = "ClassVersion";
    public static final String CLASSDATE = "ClassDate";
    public static final String OBJECTVERSION = "ObjectVersion";
    public static final String OBJECTDATE = "ObjectDate";
    public static final String SEARCHHELPVERSION = "SearchHelpVersion";
    public static final String SEARCHHELPDATE = "SearchHelpDate";
    public static final String EDITMASKVERSION = "EditMaskVersion";
    public static final String EDITMASKDATE = "EditMaskDate";
    public static final String LOOKUPVERSION = "LookupVersion";
    public static final String LOOKUPDATE = "LookupDate";
    public static final String UPDATEHELPVERSION = "UpdateHelpVersion";
    public static final String UPDATEHELPDATE = "UpdateHelpDate";
    public static final String VALIDATIONEXPRESSIONVERSION = "ValidationExpressionVersion";
    public static final String VALIDATIONEXPRESSIONDATE = "ValidationExpressionDate";
    public static final String VALIDATIONLOOKUPVERSION = "ValidationLookupVersion";
    public static final String VALIDATIONLOOKUPDATE = "ValidationLookupDate";
    public static final String VALIDATIONEXTERNALVERSION = "ValidationExternalVersion";
    public static final String VALIDATIONEXTERNALDATE = "ValidationExternalDate";

    public MResource() {
        this(false);
    }

    public MResource(boolean strictParsing) {
        super(strictParsing);
    }

    public String getResourceID() {
        return this.getStringAttribute(RESOURCEID);
    }

    public String getStandardName() {
        return this.getStringAttribute(STANDARDNAME);
    }

    public String getVisibleName() {
        return this.getStringAttribute(VISIBLENAME);
    }

    public String getDescription() {
        return this.getStringAttribute(DESCRIPTION);
    }

    public String getKeyField() {
        return this.getStringAttribute(KEYFIELD);
    }

    public int getClassCount() {
        return this.getIntAttribute(CLASSCOUNT);
    }

    public int getClassVersion() {
        return this.getIntAttribute(CLASSVERSION);
    }

    public String getClassDate() {
        return this.getDateAttribute(CLASSDATE);
    }

    public int getObjectVersion() {
        return this.getIntAttribute(OBJECTVERSION);
    }

    public String getObjectDate() {
        return this.getDateAttribute(OBJECTDATE);
    }

    public int getSearchHelpVersion() {
        return this.getIntAttribute(SEARCHHELPVERSION);
    }

    public String getSearchHelpDate() {
        return this.getDateAttribute(SEARCHHELPDATE);
    }

    public int getEditMaskVersion() {
        return this.getIntAttribute(EDITMASKVERSION);
    }

    public String getEditMaskDate() {
        return this.getDateAttribute(EDITMASKDATE);
    }

    public int getLookupVersion() {
        return this.getIntAttribute(LOOKUPVERSION);
    }

    public String getLookupDate() {
        return this.getDateAttribute(LOOKUPDATE);
    }

    public int getUpdateHelpVersion() {
        return this.getIntAttribute(UPDATEHELPVERSION);
    }

    public String getUpdateHelpDate() {
        return this.getDateAttribute(UPDATEHELPDATE);
    }

    public int getValidationExpressionVersion() {
        return this.getIntAttribute(VALIDATIONEXPRESSIONVERSION);
    }

    public String getValidationExpressionDate() {
        return this.getDateAttribute(VALIDATIONEXPRESSIONDATE);
    }

    public int getValidationLookupVersion() {
        return this.getIntAttribute(VALIDATIONLOOKUPVERSION);
    }

    public String getValidationLookupDate() {
        return this.getDateAttribute(VALIDATIONLOOKUPDATE);
    }

    public int getValidationExternalVersion() {
        return this.getIntAttribute(VALIDATIONEXTERNALVERSION);
    }

    public String getValidationExternalDate() {
        return this.getDateAttribute(VALIDATIONEXTERNALDATE);
    }

    public MValidationExpression getMValidationExpression(String validationExpressionID) {
        return (MValidationExpression)this.getChild(MetadataType.VALIDATION_EXPRESSION, validationExpressionID);
    }

    public MValidationExpression[] getMValidationExpressions() {
        MValidationExpression[] tmpl = new MValidationExpression[]{};
        return this.getChildren(MetadataType.VALIDATION_EXPRESSION).toArray(tmpl);
    }

    public MLookup getMLookup(String lookupName) {
        return (MLookup)this.getChild(MetadataType.LOOKUP, lookupName);
    }

    public MLookup[] getMLookups() {
        MLookup[] tmpl = new MLookup[]{};
        return this.getChildren(MetadataType.LOOKUP).toArray(tmpl);
    }

    public MClass getMClass(String className) {
        return (MClass)this.getChild(MetadataType.CLASS, className);
    }

    public MClass[] getMClasses() {
        MClass[] tmpl = new MClass[]{};
        return this.getChildren(MetadataType.CLASS).toArray(tmpl);
    }

    public MObject getMObject(String objectType) {
        return (MObject)this.getChild(MetadataType.OBJECT, objectType);
    }

    public MObject[] getMObjects() {
        MObject[] tmpl = new MObject[]{};
        return this.getChildren(MetadataType.OBJECT).toArray(tmpl);
    }

    public MValidationExternal getMValidationExternal(String validationExternalName) {
        return (MValidationExternal)this.getChild(MetadataType.VALIDATION_EXTERNAL, validationExternalName);
    }

    public MValidationExternal[] getMValidationExternal() {
        MValidationExternal[] tmpl = new MValidationExternal[]{};
        return this.getChildren(MetadataType.VALIDATION_EXTERNAL).toArray(tmpl);
    }

    public MValidationLookup getMValidationLookup(String validationLookupName) {
        return (MValidationLookup)this.getChild(MetadataType.VALIDATION_LOOKUP, validationLookupName);
    }

    public MValidationLookup[] getMValidationLookups() {
        MValidationLookup[] tmpl = new MValidationLookup[]{};
        return this.getChildren(MetadataType.VALIDATION_LOOKUP).toArray(tmpl);
    }

    public MEditMask getMEditMask(String editMaskID) {
        return (MEditMask)this.getChild(MetadataType.EDITMASK, editMaskID);
    }

    public MEditMask[] getMEditMasks() {
        MEditMask[] tmpl = new MEditMask[]{};
        return this.getChildren(MetadataType.EDITMASK).toArray(tmpl);
    }

    public MUpdateHelp getMUpdateHelp(String updateHelpID) {
        return (MUpdateHelp)this.getChild(MetadataType.UPDATE_HELP, updateHelpID);
    }

    public MUpdateHelp[] getMUpdateHelps() {
        MUpdateHelp[] tmpl = new MUpdateHelp[]{};
        return this.getChildren(MetadataType.UPDATE_HELP).toArray(tmpl);
    }

    public MSearchHelp getMSearchHelp(String searchHelpID) {
        return (MSearchHelp)this.getChild(MetadataType.SEARCH_HELP, searchHelpID);
    }

    public MSearchHelp[] getMSearchHelps() {
        MSearchHelp[] tmpl = new MSearchHelp[]{};
        return this.getChildren(MetadataType.SEARCH_HELP).toArray(tmpl);
    }

    public MetadataType[] getChildTypes() {
        return CHILDREN;
    }

    protected String getIdAttr() {
        return RESOURCEID;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(RESOURCEID, sAlphanum32);
        attributeMap.put(STANDARDNAME, sAlphanum32);
        attributeMap.put(VISIBLENAME, sPlaintext32);
        attributeMap.put(DESCRIPTION, sPlaintext64);
        attributeMap.put(KEYFIELD, sAlphanum32);
        attributeMap.put(CLASSCOUNT, sAttrNumeric);
        attributeMap.put(CLASSVERSION, sAttrVersion);
        attributeMap.put(CLASSDATE, sAttrDate);
        attributeMap.put(OBJECTVERSION, sAttrVersion);
        attributeMap.put(OBJECTDATE, sAttrDate);
        attributeMap.put(SEARCHHELPVERSION, sAttrVersion);
        attributeMap.put(SEARCHHELPDATE, sAttrDate);
        attributeMap.put(EDITMASKVERSION, sAttrVersion);
        attributeMap.put(EDITMASKDATE, sAttrDate);
        attributeMap.put(LOOKUPVERSION, sAttrVersion);
        attributeMap.put(LOOKUPDATE, sAttrDate);
        attributeMap.put(UPDATEHELPVERSION, sAttrVersion);
        attributeMap.put(UPDATEHELPDATE, sAttrDate);
        attributeMap.put(VALIDATIONEXPRESSIONVERSION, sAttrVersion);
        attributeMap.put(VALIDATIONEXPRESSIONDATE, sAttrDate);
        attributeMap.put(VALIDATIONLOOKUPVERSION, sAttrVersion);
        attributeMap.put(VALIDATIONLOOKUPDATE, sAttrDate);
        attributeMap.put(VALIDATIONEXTERNALVERSION, sAttrVersion);
        attributeMap.put(VALIDATIONEXTERNALDATE, sAttrDate);
    }
}

