/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Map;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MForeignKey;
import org.realtors.rets.common.metadata.types.MResource;

public class MSystem
extends MetaObject {
    public static final String SYSTEMID = "SystemID";
    public static final String SYSTEMDESCRIPTION = "SystemDescription";
    public static final String COMMENTS = "Comments";
    public static final String DATE = "Date";
    public static final String VERSION = "Version";
    public static final String TIMEZONEOFFSET = "TimeZoneOffset";
    public static final MetadataType[] CHILDREN = new MetadataType[]{MetadataType.RESOURCE, MetadataType.FOREIGNKEYS};

    public MSystem() {
        this(false);
    }

    public MSystem(boolean strictParsing) {
        super(strictParsing);
    }

    public String getSystemID() {
        return this.getStringAttribute(SYSTEMID);
    }

    public String getComment() {
        return this.getStringAttribute(COMMENTS);
    }

    public String getSystemDescription() {
        return this.getStringAttribute(SYSTEMDESCRIPTION);
    }

    public String getDate() {
        return this.getDateAttribute(DATE);
    }

    public String getTimeZoneOffset() {
        return this.getDateAttribute(TIMEZONEOFFSET);
    }

    public int getVersion() {
        return this.getIntAttribute(VERSION);
    }

    public MResource getMResource(String resourceID) {
        return (MResource)this.getChild(MetadataType.RESOURCE, resourceID);
    }

    public MResource[] getMResources() {
        MResource[] tmpl = new MResource[]{};
        return this.getChildren(MetadataType.RESOURCE).toArray(tmpl);
    }

    public MForeignKey getMForeignKey(String foreignKeyID) {
        return (MForeignKey)this.getChild(MetadataType.FOREIGNKEYS, foreignKeyID);
    }

    public MForeignKey[] getMForeignKeys() {
        MForeignKey[] tmpl = new MForeignKey[]{};
        return this.getChildren(MetadataType.FOREIGNKEYS).toArray(tmpl);
    }

    public MetadataType[] getChildTypes() {
        return CHILDREN;
    }

    protected String getIdAttr() {
        return null;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(SYSTEMID, sAlphanum10);
        attributeMap.put(SYSTEMDESCRIPTION, sPlaintext64);
        attributeMap.put(DATE, sAttrDate);
        attributeMap.put(VERSION, sAttrVersion);
        attributeMap.put(COMMENTS, sText);
        attributeMap.put(TIMEZONEOFFSET, sAttrDate);
    }
}

