/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Map;
import org.realtors.rets.common.metadata.AttrType;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.attrib.AttrEnum;

public class MTable
extends MetaObject {
    public static final String METADATAENTRYID = "MetadataEntryID";
    public static final String SYSTEMNAME = "SystemName";
    public static final String STANDARDNAME = "StandardName";
    public static final String LONGNAME = "LongName";
    public static final String DBNAME = "DBName";
    public static final String SHORTNAME = "ShortName";
    public static final String MAXIMUMLENGTH = "MaximumLength";
    public static final String DATATYPE = "DataType";
    public static final String PRECISION = "Precision";
    public static final String SEARCHABLE = "Searchable";
    public static final String INTERPRETATION = "Interpretation";
    public static final String ALIGNMENT = "Alignment";
    public static final String USESEPARATOR = "UseSeparator";
    public static final String EDITMASKID = "EditMaskID";
    public static final String LOOKUPNAME = "LookupName";
    public static final String MAXSELECT = "MaxSelect";
    public static final String UNITS = "Units";
    public static final String INDEX = "Index";
    public static final String MINIMUM = "Minimum";
    public static final String MAXIMUM = "Maximum";
    public static final String DEFAULT = "Default";
    public static final String REQUIRED = "Required";
    public static final String SEARCHHELPID = "SearchHelpID";
    public static final String UNIQUE = "Unique";
    public static final String MODTIMESTAMP = "ModTimeStamp";
    public static final String MODTIMESTAMPNAME = "ModTimeStampName";
    public static final String FOREIGNKEYNAME = "ForeignKeyName";
    public static final String FOREIGNFIELD = "ForeignField";
    public static final String INKEYINDEX = "InKeyIndex";
    public static final String KEYQUERY = "KeyQuery";
    public static final String KEYSELECT = "KeySelect";
    private static final String[] DATATYPES = "Boolean,Character,Date,DateTime,Time,Tiny,Small,Int,Long,Decimal".split(",");
    private static final AttrType sDataTypes = new AttrEnum(DATATYPES);
    private static final String[] INTERPRETATIONS = "Number,Currency,Lookup,LookupMulti,LookupBitstring,LookupBitmask".split(",");
    private static final AttrType sInterpretations = new AttrEnum(INTERPRETATIONS);
    private static final String[] ALIGNMENTS = "Left,Right,Center,Justify".split(",");
    private static final AttrType sAlignments = new AttrEnum(ALIGNMENTS);
    private static final String[] UNITSS = "Feet,Meters,SqFt,SqMeters,Acres,Hectares".split(",");
    private static final AttrType sUnits = new AttrEnum(UNITSS);

    public MTable() {
        this(false);
    }

    public MTable(boolean strictParsing) {
        super(strictParsing);
    }

    public String getMetadataEntryID() {
        String metadataEntryID = this.getStringAttribute(METADATAENTRYID);
        if (metadataEntryID == null) {
            metadataEntryID = this.getSystemName();
        }
        return metadataEntryID;
    }

    public String getSystemName() {
        return this.getStringAttribute(SYSTEMNAME);
    }

    public String getStandardName() {
        return this.getStringAttribute(STANDARDNAME);
    }

    public String getLongName() {
        return this.getStringAttribute(LONGNAME);
    }

    public String getDBName() {
        return this.getStringAttribute(DBNAME);
    }

    public String getShortName() {
        return this.getStringAttribute(SHORTNAME);
    }

    public int getMaximumLength() {
        return this.getIntAttribute(MAXIMUMLENGTH);
    }

    public String getDataType() {
        return this.getStringAttribute(DATATYPE);
    }

    public int getPrecision() {
        return this.getIntAttribute(PRECISION);
    }

    public boolean getSearchable() {
        return this.getBooleanAttribute(SEARCHABLE);
    }

    public String getInterpretation() {
        return this.getStringAttribute(INTERPRETATION);
    }

    public boolean isLookup() {
        String interp = this.getInterpretation();
        if (interp != null && interp.startsWith("Lookup")) {
            return true;
        }
        if (this.getSystemName().equalsIgnoreCase("status")) {
            System.out.println("Field is " + this.getSystemName() + " and interp " + "is " + interp + " but isLookup() is false");
        }
        return false;
    }

    public String getAlignment() {
        return this.getStringAttribute(ALIGNMENT);
    }

    public boolean getUseSeparator() {
        return this.getBooleanAttribute(USESEPARATOR);
    }

    public String getEditMaskID() {
        return this.getStringAttribute(EDITMASKID);
    }

    public String getLookupName() {
        return this.getStringAttribute(LOOKUPNAME);
    }

    public int getMaxSelect() {
        return this.getIntAttribute(MAXSELECT);
    }

    public String getUnits() {
        return this.getStringAttribute(UNITS);
    }

    public int getIndex() {
        return this.getIntAttribute(INDEX);
    }

    public int getMinimum() {
        return this.getIntAttribute(MINIMUM);
    }

    public int getMaximum() {
        return this.getIntAttribute(MAXIMUM);
    }

    public int getDefault() {
        return this.getIntAttribute(DEFAULT);
    }

    public int getRequired() {
        return this.getIntAttribute(REQUIRED);
    }

    public String getSearchHelpID() {
        return this.getStringAttribute(SEARCHHELPID);
    }

    public boolean getUnique() {
        return this.getBooleanAttribute(UNIQUE);
    }

    public boolean getModTimestamp() {
        return this.getBooleanAttribute(MODTIMESTAMP);
    }

    public boolean getModTimestampName() {
        return this.getBooleanAttribute(MODTIMESTAMPNAME);
    }

    public boolean getInKeyIndex() {
        return this.getBooleanAttribute(INKEYINDEX);
    }

    public MetadataType[] getChildTypes() {
        return sNoChildren;
    }

    protected String getIdAttr() {
        return SYSTEMNAME;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(METADATAENTRYID, retsid);
        attributeMap.put(SYSTEMNAME, retsname);
        attributeMap.put(STANDARDNAME, retsname);
        attributeMap.put(LONGNAME, sText256);
        attributeMap.put(DBNAME, sAlphanum10);
        attributeMap.put(SHORTNAME, sText64);
        attributeMap.put(MAXIMUMLENGTH, sAttrNumericPositive);
        attributeMap.put(DATATYPE, sDataTypes);
        attributeMap.put(PRECISION, sAttrNumeric);
        attributeMap.put(SEARCHABLE, sAttrBoolean);
        attributeMap.put(INTERPRETATION, sInterpretations);
        attributeMap.put(ALIGNMENT, sAlignments);
        attributeMap.put(USESEPARATOR, sAttrBoolean);
        attributeMap.put(EDITMASKID, retsname);
        attributeMap.put(LOOKUPNAME, retsname);
        attributeMap.put(MAXSELECT, sAttrNumeric);
        attributeMap.put(UNITS, sUnits);
        attributeMap.put(INDEX, sAttrNumeric);
        attributeMap.put(MINIMUM, sAttrNumeric);
        attributeMap.put(MAXIMUM, sAttrNumeric);
        attributeMap.put(DEFAULT, sAttrNumeric);
        attributeMap.put(REQUIRED, sAttrNumeric);
        attributeMap.put(SEARCHHELPID, retsname);
        attributeMap.put(UNIQUE, sAttrBoolean);
        attributeMap.put(MODTIMESTAMP, sAttrBoolean);
        attributeMap.put(MODTIMESTAMPNAME, retsname);
        attributeMap.put(FOREIGNKEYNAME, retsid);
        attributeMap.put(FOREIGNFIELD, retsname);
        attributeMap.put(INKEYINDEX, sAttrBoolean);
        attributeMap.put(KEYQUERY, sAttrBoolean);
        attributeMap.put(KEYSELECT, sAttrBoolean);
    }

    public String getForeignKeyName() {
        return this.getStringAttribute(FOREIGNKEYNAME);
    }

    public String getForeignField() {
        return this.getStringAttribute(FOREIGNFIELD);
    }
}

