/*
 * Decompiled with CFR 0.152.
 */
package org.realtors.rets.common.metadata.types;

import java.util.Map;
import org.realtors.rets.common.metadata.MetaObject;
import org.realtors.rets.common.metadata.MetadataType;
import org.realtors.rets.common.metadata.types.MUpdateType;

public class MUpdate
extends MetaObject {
    public static final String METADATAENTRYID = "MetadataEntryID";
    public static final String UPDATENAME = "UpdateName";
    public static final String DESCRIPTION = "Description";
    public static final String KEYFIELD = "KeyField";
    public static final String VERSION = "Version";
    public static final String DATE = "Date";
    public static final String UPDATETYPEVERSION = "UpdateTypeVersion";
    public static final String UPDATETYPEDATE = "UpdateTypeDate";
    private static final MetadataType[] sTypes = new MetadataType[]{MetadataType.UPDATE_TYPE};

    public MUpdate() {
        this(false);
    }

    public MUpdate(boolean strictParsing) {
        super(strictParsing);
    }

    public String getMetadataEntryID() {
        return this.getStringAttribute(METADATAENTRYID);
    }

    public String getUpdateName() {
        return this.getStringAttribute(UPDATENAME);
    }

    public String getDescription() {
        return this.getStringAttribute(DESCRIPTION);
    }

    public String getKeyField() {
        return this.getStringAttribute(KEYFIELD);
    }

    public int getVersion() {
        int v = this.getIntAttribute(VERSION);
        if (v == 0) {
            v = this.getIntAttribute(UPDATETYPEVERSION);
        }
        return v;
    }

    public String getDate() {
        String d = this.getDateAttribute(DATE);
        if (d == null) {
            d = this.getDateAttribute(UPDATETYPEDATE);
        }
        return d;
    }

    public MUpdateType getMUpdateType(String systemName) {
        return (MUpdateType)this.getChild(MetadataType.UPDATE_TYPE, systemName);
    }

    public MUpdateType[] getMUpdateTypes() {
        MUpdateType[] tmpl = new MUpdateType[]{};
        return this.getChildren(MetadataType.UPDATE_TYPE).toArray(tmpl);
    }

    public MetadataType[] getChildTypes() {
        return sTypes;
    }

    protected String getIdAttr() {
        return UPDATENAME;
    }

    protected void addAttributesToMap(Map attributeMap) {
        attributeMap.put(METADATAENTRYID, sAttrMetadataEntryId);
        attributeMap.put(UPDATENAME, sAlphanum24);
        attributeMap.put(DESCRIPTION, sPlaintext64);
        attributeMap.put(KEYFIELD, sAlphanum32);
        attributeMap.put(VERSION, sAttrVersion);
        attributeMap.put(DATE, sAttrDate);
        attributeMap.put(UPDATETYPEVERSION, sAttrVersion);
        attributeMap.put(UPDATETYPEDATE, sAttrDate);
    }
}

