// Compiled by ClojureScript 0.0-2371
goog.provide('garden.units');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.string');
goog.require('cljs.core');
goog.require('cljs.core');
garden.units.IMagnitude = (function (){var obj9289 = {};return obj9289;
})();
garden.units._magnitude = (function _magnitude(this$){if((function (){var and__3974__auto__ = this$;if(and__3974__auto__)
{return this$.garden$units$IMagnitude$_magnitude$arity$1;
} else
{return and__3974__auto__;
}
})())
{return this$.garden$units$IMagnitude$_magnitude$arity$1(this$);
} else
{var x__4623__auto__ = (((this$ == null))?null:this$);return (function (){var or__3986__auto__ = (garden.units._magnitude[goog.typeOf(x__4623__auto__)]);if(or__3986__auto__)
{return or__3986__auto__;
} else
{var or__3986__auto____$1 = (garden.units._magnitude["_"]);if(or__3986__auto____$1)
{return or__3986__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"IMagnitude.-magnitude",this$);
}
}
})().call(null,this$);
}
});
garden.units.IMeasurement = (function (){var obj9291 = {};return obj9291;
})();
garden.units._measurement = (function _measurement(this$){if((function (){var and__3974__auto__ = this$;if(and__3974__auto__)
{return this$.garden$units$IMeasurement$_measurement$arity$1;
} else
{return and__3974__auto__;
}
})())
{return this$.garden$units$IMeasurement$_measurement$arity$1(this$);
} else
{var x__4623__auto__ = (((this$ == null))?null:this$);return (function (){var or__3986__auto__ = (garden.units._measurement[goog.typeOf(x__4623__auto__)]);if(or__3986__auto__)
{return or__3986__auto__;
} else
{var or__3986__auto____$1 = (garden.units._measurement["_"]);if(or__3986__auto____$1)
{return or__3986__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"IMeasurement.-measurement",this$);
}
}
})().call(null,this$);
}
});
garden.units.IUnit = (function (){var obj9293 = {};return obj9293;
})();
garden.units._unit = (function _unit(this$){if((function (){var and__3974__auto__ = this$;if(and__3974__auto__)
{return this$.garden$units$IUnit$_unit$arity$1;
} else
{return and__3974__auto__;
}
})())
{return this$.garden$units$IUnit$_unit$arity$1(this$);
} else
{var x__4623__auto__ = (((this$ == null))?null:this$);return (function (){var or__3986__auto__ = (garden.units._unit[goog.typeOf(x__4623__auto__)]);if(or__3986__auto__)
{return or__3986__auto__;
} else
{var or__3986__auto____$1 = (garden.units._unit["_"]);if(or__3986__auto____$1)
{return or__3986__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"IUnit.-unit",this$);
}
}
})().call(null,this$);
}
});

/**
* @constructor
* @param {*} magnitude
* @param {*} measurement
* @param {*} __meta
* @param {*} __extmap
* @param {*=} __meta 
* @param {*=} __extmap
*/
garden.units.Unit = (function (magnitude,measurement,__meta,__extmap){
this.magnitude = magnitude;
this.measurement = measurement;
this.__meta = __meta;
this.__extmap = __extmap;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
if(arguments.length>2){
this.__meta = __meta;
this.__extmap = __extmap;
} else {
this.__meta=null;
this.__extmap=null;
}
})
garden.units.Unit.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4582__auto__,k__4583__auto__){var self__ = this;
var this__4582__auto____$1 = this;return cljs.core._lookup.call(null,this__4582__auto____$1,k__4583__auto__,null);
});
garden.units.Unit.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4584__auto__,k9295,else__4585__auto__){var self__ = this;
var this__4584__auto____$1 = this;var G__9297 = (((k9295 instanceof cljs.core.Keyword))?k9295.fqn:null);switch (G__9297) {
case "measurement":
return self__.measurement;

break;
case "magnitude":
return self__.magnitude;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k9295,else__4585__auto__);

}
});
garden.units.Unit.prototype.garden$units$IMeasurement$ = true;
garden.units.Unit.prototype.garden$units$IMeasurement$_measurement$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;var temp__4124__auto__ = this$__$1.measurement;if(cljs.core.truth_(temp__4124__auto__))
{var m = temp__4124__auto__;return cljs.core.keyword.call(null,m);
} else
{return null;
}
});
garden.units.Unit.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4596__auto__,writer__4597__auto__,opts__4598__auto__){var self__ = this;
var this__4596__auto____$1 = this;var pr_pair__4599__auto__ = ((function (this__4596__auto____$1){
return (function (keyval__4600__auto__){return cljs.core.pr_sequential_writer.call(null,writer__4597__auto__,cljs.core.pr_writer,""," ","",opts__4598__auto__,keyval__4600__auto__);
});})(this__4596__auto____$1))
;return cljs.core.pr_sequential_writer.call(null,writer__4597__auto__,pr_pair__4599__auto__,"#garden.units.Unit{",", ","}",opts__4598__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"magnitude","magnitude",1924274222),self__.magnitude],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"measurement","measurement",-1778859790),self__.measurement],null))], null),self__.__extmap));
});
garden.units.Unit.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4580__auto__){var self__ = this;
var this__4580__auto____$1 = this;return self__.__meta;
});
garden.units.Unit.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4576__auto__){var self__ = this;
var this__4576__auto____$1 = this;return (new garden.units.Unit(self__.magnitude,self__.measurement,self__.__meta,self__.__extmap,self__.__hash));
});
garden.units.Unit.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4586__auto__){var self__ = this;
var this__4586__auto____$1 = this;return (2 + cljs.core.count.call(null,self__.__extmap));
});
garden.units.Unit.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4577__auto__){var self__ = this;
var this__4577__auto____$1 = this;var h__4397__auto__ = self__.__hash;if(!((h__4397__auto__ == null)))
{return h__4397__auto__;
} else
{var h__4397__auto____$1 = cljs.core.hash_imap.call(null,this__4577__auto____$1);self__.__hash = h__4397__auto____$1;
return h__4397__auto____$1;
}
});
garden.units.Unit.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__4578__auto__,other__4579__auto__){var self__ = this;
var this__4578__auto____$1 = this;if(cljs.core.truth_((function (){var and__3974__auto__ = other__4579__auto__;if(cljs.core.truth_(and__3974__auto__))
{return ((this__4578__auto____$1.constructor === other__4579__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__4578__auto____$1,other__4579__auto__));
} else
{return and__3974__auto__;
}
})()))
{return true;
} else
{return false;
}
});
garden.units.Unit.prototype.garden$units$IUnit$ = true;
garden.units.Unit.prototype.garden$units$IUnit$_unit$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return this$__$1;
});
garden.units.Unit.prototype.garden$units$IMagnitude$ = true;
garden.units.Unit.prototype.garden$units$IMagnitude$_magnitude$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return this$__$1.magnitude;
});
garden.units.Unit.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4591__auto__,k__4592__auto__){var self__ = this;
var this__4591__auto____$1 = this;if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"magnitude","magnitude",1924274222),null,new cljs.core.Keyword(null,"measurement","measurement",-1778859790),null], null), null),k__4592__auto__))
{return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4591__auto____$1),self__.__meta),k__4592__auto__);
} else
{return (new garden.units.Unit(self__.magnitude,self__.measurement,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4592__auto__)),null));
}
});
garden.units.Unit.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4589__auto__,k__4590__auto__,G__9294){var self__ = this;
var this__4589__auto____$1 = this;var pred__9298 = cljs.core.keyword_identical_QMARK_;var expr__9299 = k__4590__auto__;if(cljs.core.truth_(pred__9298.call(null,new cljs.core.Keyword(null,"magnitude","magnitude",1924274222),expr__9299)))
{return (new garden.units.Unit(G__9294,self__.measurement,self__.__meta,self__.__extmap,null));
} else
{if(cljs.core.truth_(pred__9298.call(null,new cljs.core.Keyword(null,"measurement","measurement",-1778859790),expr__9299)))
{return (new garden.units.Unit(self__.magnitude,G__9294,self__.__meta,self__.__extmap,null));
} else
{return (new garden.units.Unit(self__.magnitude,self__.measurement,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4590__auto__,G__9294),null));
}
}
});
garden.units.Unit.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4594__auto__){var self__ = this;
var this__4594__auto____$1 = this;return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"magnitude","magnitude",1924274222),self__.magnitude],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"measurement","measurement",-1778859790),self__.measurement],null))], null),self__.__extmap));
});
garden.units.Unit.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4581__auto__,G__9294){var self__ = this;
var this__4581__auto____$1 = this;return (new garden.units.Unit(self__.magnitude,self__.measurement,G__9294,self__.__extmap,self__.__hash));
});
garden.units.Unit.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4587__auto__,entry__4588__auto__){var self__ = this;
var this__4587__auto____$1 = this;if(cljs.core.vector_QMARK_.call(null,entry__4588__auto__))
{return cljs.core._assoc.call(null,this__4587__auto____$1,cljs.core._nth.call(null,entry__4588__auto__,(0)),cljs.core._nth.call(null,entry__4588__auto__,(1)));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,this__4587__auto____$1,entry__4588__auto__);
}
});
garden.units.Unit.cljs$lang$type = true;
garden.units.Unit.cljs$lang$ctorPrSeq = (function (this__4616__auto__){return cljs.core._conj.call(null,cljs.core.List.EMPTY,"garden.units/Unit");
});
garden.units.Unit.cljs$lang$ctorPrWriter = (function (this__4616__auto__,writer__4617__auto__){return cljs.core._write.call(null,writer__4617__auto__,"garden.units/Unit");
});
garden.units.__GT_Unit = (function __GT_Unit(magnitude,measurement){return (new garden.units.Unit(magnitude,measurement));
});
garden.units.map__GT_Unit = (function map__GT_Unit(G__9296){return (new garden.units.Unit(new cljs.core.Keyword(null,"magnitude","magnitude",1924274222).cljs$core$IFn$_invoke$arity$1(G__9296),new cljs.core.Keyword(null,"measurement","measurement",-1778859790).cljs$core$IFn$_invoke$arity$1(G__9296),null,cljs.core.dissoc.call(null,G__9296,new cljs.core.Keyword(null,"magnitude","magnitude",1924274222),new cljs.core.Keyword(null,"measurement","measurement",-1778859790))));
});
/**
* Return the magnitude of x. x must satisfy IMeasurement.
*/
garden.units.magnitude = (function magnitude(x){var _PERCENT_ = garden.units._magnitude.call(null,x);if(typeof _PERCENT_ === 'number')
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))))));
}
return _PERCENT_;
});
/**
* Return the measurement type of x. x must satisfy IMeasurement.
*/
garden.units.measurement = (function measurement(x){var temp__4126__auto__ = garden.units._measurement.call(null,x);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.keyword.call(null,m);
} else
{return null;
}
});
/**
* Return x as an instance of Unit. x must satisfy IUnit.
*/
garden.units.unit = (function unit(x){var _PERCENT_ = garden.units._unit.call(null,x);if((_PERCENT_ instanceof garden.units.Unit))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol(null,"Unit","Unit",1086897223,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))))));
}
return _PERCENT_;
});
/**
* Map associating unit types to their conversion values.
*/
garden.units.conversion_table = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
* Add a bidirection measurement conversion between to units m1 and m2
* with amount amt. amt represents one unit of m1 with respect to m2.
*/
garden.units.add_conversion_BANG_ = (function add_conversion_BANG_(m1,m2,amt){var m1k = cljs.core.keyword.call(null,m1);var m2k = cljs.core.keyword.call(null,m2);return cljs.core.swap_BANG_.call(null,garden.units.conversion_table,((function (m1k,m2k){
return (function (ct){return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,ct,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [m1k,m2k], null),amt),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [m2k,m1k], null),cljs.core._SLASH_.call(null,1.0,amt));
});})(m1k,m2k))
);
});
/**
* Return the conversion amount of one unit of m1 with respect to
* m2. If either m1 or m2 or both are nil the result will be 1.
*/
garden.units.get_conversion = (function get_conversion(m1,m2){if((cljs.core._EQ_.call(null,m1,m2)) || ((m1 == null)) || ((m2 == null)))
{return (1);
} else
{return cljs.core.get_in.call(null,cljs.core.deref.call(null,garden.units.conversion_table),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [m1,m2], null));
}
});
/**
* Convert an amount amt of measurement m1 to and amount of
* measurement m2. If either m1 or m2 or both are nil result will be
* equal to amt.
* 
* 
* Example:
* 
* (convert 2 :in :px)
* => 192
* 
* (convert 1 :px :in)
* => 0.010416666666666666
* 
* (convert 42 nil :px)
* => 42
* 
* (convert 42 nil nil)
* => 42
*/
garden.units.convert = (function convert(amt,m1,m2){var temp__4124__auto__ = garden.units.get_conversion.call(null,m1,m2);if(cljs.core.truth_(temp__4124__auto__))
{var c = temp__4124__auto__;return cljs.core._STAR_.call(null,c,amt);
} else
{throw cljs.core.ex_info.call(null,("Unable to convert measurement "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,m1))+" to "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,m2))),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"given","given",716253602),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [amt,m1,m2], null),new cljs.core.Keyword(null,"expected","expected",1583670997),(function (){var candidates = cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,garden.units.conversion_table),m1)));return cljs.core.sequence.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,candidates),cljs.core._conj.call(null,cljs.core.List.EMPTY,m2)));
})()], null));
}
});
/**
* Return the sum of units. The leftmost summand with a non-nil unit
* of measurement determines the resulting unit's measurement value. If
* none of the summands have a measurement value the resulting unit
* will be without measurement.
* 
* Example:
* 
* (+)
* => #garden.units.Unit{:magnitude 0, :measurement nil}
* 
* (+ 1)
* => #garden.units.Unit{:magnitude 1, :measurement nil}
* 
* (+ 1 (px 5))
* => #garden.units.Unit{:magnitude 6, :measurement :px}
* 
* (+ (cm 5) (in 5) (mm 5))
* => #garden.units.Unit{:magnitude 18.2, :measurement :cm}
* @param {...*} var_args
*/
garden.units._PLUS_ = (function() {
var _PLUS_ = null;
var _PLUS___0 = (function (){return garden.units.unit.call(null,(0));
});
var _PLUS___1 = (function (u){return garden.units.unit.call(null,u);
});
var _PLUS___2 = (function (u1,u2){var mg1 = garden.units.magnitude.call(null,u1);var mg2 = garden.units.magnitude.call(null,u2);var ms1 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u1);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u2);
}
})();var ms2 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u2);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u1);
}
})();var mg3 = garden.units.convert.call(null,mg2,ms2,ms1);return (new garden.units.Unit(cljs.core._PLUS_.call(null,mg1,mg3),(function (){var or__3986__auto__ = ms1;if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return ms2;
}
})()));
});
var _PLUS___3 = (function() { 
var G__9302__delegate = function (u1,u2,more){return cljs.core.reduce.call(null,_PLUS_,_PLUS_.call(null,u1,u2),more);
};
var G__9302 = function (u1,u2,var_args){
var more = null;if (arguments.length > 2) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__9302__delegate.call(this,u1,u2,more);};
G__9302.cljs$lang$maxFixedArity = 2;
G__9302.cljs$lang$applyTo = (function (arglist__9303){
var u1 = cljs.core.first(arglist__9303);
arglist__9303 = cljs.core.next(arglist__9303);
var u2 = cljs.core.first(arglist__9303);
var more = cljs.core.rest(arglist__9303);
return G__9302__delegate(u1,u2,more);
});
G__9302.cljs$core$IFn$_invoke$arity$variadic = G__9302__delegate;
return G__9302;
})()
;
_PLUS_ = function(u1,u2,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _PLUS___0.call(this);
case 1:
return _PLUS___1.call(this,u1);
case 2:
return _PLUS___2.call(this,u1,u2);
default:
return _PLUS___3.cljs$core$IFn$_invoke$arity$variadic(u1,u2, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_PLUS_.cljs$lang$maxFixedArity = 2;
_PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
_PLUS_.cljs$core$IFn$_invoke$arity$0 = _PLUS___0;
_PLUS_.cljs$core$IFn$_invoke$arity$1 = _PLUS___1;
_PLUS_.cljs$core$IFn$_invoke$arity$2 = _PLUS___2;
_PLUS_.cljs$core$IFn$_invoke$arity$variadic = _PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return _PLUS_;
})()
;
/**
* Return the product of units. The leftmost multiplicand with a
* non-nil unit of measurement determines the resulting unit's
* measurement value. If none of the multiplicands have a measurement
* value the resulting unit will be without measurement.
* 
* Example:
* 
* (*)
* => #garden.units.Unit{:magnitude 1, :measurement nil}
* 
* (* 1)
* => #garden.units.Unit{:magnitude 1, :measurement nil}
* 
* (* 1 (px 5))
* => #garden.units.Unit{:magnitude 5, :measurement :px}
* 
* (* (cm 5) (in 5) (mm 5))
* => #garden.units.Unit{:magnitude 31.75, :measurement :cm}
* @param {...*} var_args
*/
garden.units._STAR_ = (function() {
var _STAR_ = null;
var _STAR___0 = (function (){return garden.units.unit.call(null,(1));
});
var _STAR___1 = (function (u){return garden.units.unit.call(null,u);
});
var _STAR___2 = (function (u1,u2){var mg1 = garden.units.magnitude.call(null,u1);var mg2 = garden.units.magnitude.call(null,u2);var ms1 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u1);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u2);
}
})();var ms2 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u2);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u1);
}
})();var mg3 = garden.units.convert.call(null,mg2,ms2,ms1);return (new garden.units.Unit(cljs.core._STAR_.call(null,mg1,mg3),(function (){var or__3986__auto__ = ms1;if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return ms2;
}
})()));
});
var _STAR___3 = (function() { 
var G__9304__delegate = function (u1,u2,more){return cljs.core.reduce.call(null,_STAR_,_STAR_.call(null,u1,u2),more);
};
var G__9304 = function (u1,u2,var_args){
var more = null;if (arguments.length > 2) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__9304__delegate.call(this,u1,u2,more);};
G__9304.cljs$lang$maxFixedArity = 2;
G__9304.cljs$lang$applyTo = (function (arglist__9305){
var u1 = cljs.core.first(arglist__9305);
arglist__9305 = cljs.core.next(arglist__9305);
var u2 = cljs.core.first(arglist__9305);
var more = cljs.core.rest(arglist__9305);
return G__9304__delegate(u1,u2,more);
});
G__9304.cljs$core$IFn$_invoke$arity$variadic = G__9304__delegate;
return G__9304;
})()
;
_STAR_ = function(u1,u2,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _STAR___0.call(this);
case 1:
return _STAR___1.call(this,u1);
case 2:
return _STAR___2.call(this,u1,u2);
default:
return _STAR___3.cljs$core$IFn$_invoke$arity$variadic(u1,u2, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_STAR_.cljs$lang$maxFixedArity = 2;
_STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
_STAR_.cljs$core$IFn$_invoke$arity$0 = _STAR___0;
_STAR_.cljs$core$IFn$_invoke$arity$1 = _STAR___1;
_STAR_.cljs$core$IFn$_invoke$arity$2 = _STAR___2;
_STAR_.cljs$core$IFn$_invoke$arity$variadic = _STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return _STAR_;
})()
;
/**
* Return the difference of units. The leftmost minuend or subtrahend
* with a non-nil unit of measurement determines the resulting unit's
* measurement value. If neither minuend or subtrahends have a
* measurement value the resulting unit will be without measurement.
* 
* 
* Example:
* 
* (- 1)
* => #garden.units.Unit{:magnitude -1, :measurement nil}
* 
* (- (px 1))
* => #garden.units.Unit{:magnitude -1, :measurement :px}
* 
* (- 1 (px 5))
* => #garden.units.Unit{:magnitude -4, :measurement :px}
* 
* (- (cm 5) (in 5) (mm 5))
* => #garden.units.Unit{:magnitude -8.2, :measurement :cm}
* @param {...*} var_args
*/
garden.units._ = (function() {
var _ = null;
var ___1 = (function (u){return cljs.core.update_in.call(null,garden.units.unit.call(null,u),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"magnitude","magnitude",1924274222)], null),cljs.core._);
});
var ___2 = (function (u1,u2){var mg1 = garden.units.magnitude.call(null,u1);var mg2 = garden.units.magnitude.call(null,u2);var ms1 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u1);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u2);
}
})();var ms2 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u2);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u1);
}
})();var mg3 = garden.units.convert.call(null,mg2,ms2,ms1);return (new garden.units.Unit(cljs.core._.call(null,mg1,mg3),(function (){var or__3986__auto__ = ms1;if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return ms2;
}
})()));
});
var ___3 = (function() { 
var G__9306__delegate = function (u1,u2,more){return cljs.core.reduce.call(null,_,_.call(null,u1,u2),more);
};
var G__9306 = function (u1,u2,var_args){
var more = null;if (arguments.length > 2) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__9306__delegate.call(this,u1,u2,more);};
G__9306.cljs$lang$maxFixedArity = 2;
G__9306.cljs$lang$applyTo = (function (arglist__9307){
var u1 = cljs.core.first(arglist__9307);
arglist__9307 = cljs.core.next(arglist__9307);
var u2 = cljs.core.first(arglist__9307);
var more = cljs.core.rest(arglist__9307);
return G__9306__delegate(u1,u2,more);
});
G__9306.cljs$core$IFn$_invoke$arity$variadic = G__9306__delegate;
return G__9306;
})()
;
_ = function(u1,u2,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return ___1.call(this,u1);
case 2:
return ___2.call(this,u1,u2);
default:
return ___3.cljs$core$IFn$_invoke$arity$variadic(u1,u2, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_.cljs$lang$maxFixedArity = 2;
_.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
_.cljs$core$IFn$_invoke$arity$1 = ___1;
_.cljs$core$IFn$_invoke$arity$2 = ___2;
_.cljs$core$IFn$_invoke$arity$variadic = ___3.cljs$core$IFn$_invoke$arity$variadic;
return _;
})()
;
/**
* Return the quotient of units. The leftmost dividend or divisor with
* a non-nil unit of measurement determines the resulting unit's
* measurement value. If neither dividend or divisors have a
* measurement value the resulting unit will be without measurement.
* 
* Example:
* 
* (/ 1)
* => #garden.units.Unit{:magnitude 1, :measurement nil}
* 
* (/ (px 1))
* => #garden.units.Unit{:magnitude 1, :measurement :px}
* 
* (/ 1 (px 5))
* => #garden.units.Unit{:magnitude 1/5, :measurement :px}
* 
* (/ (cm 5) (in 5) (mm 5))
* => #garden.units.Unit{:magnitude 0.7874015748031497, :measurement :cm}
* @param {...*} var_args
*/
garden.units._SLASH_ = (function() {
var _SLASH_ = null;
var _SLASH___1 = (function (u){return cljs.core.update_in.call(null,garden.units.unit.call(null,u),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"magnitude","magnitude",1924274222)], null),cljs.core._SLASH_);
});
var _SLASH___2 = (function (u1,u2){var mg1 = garden.units.magnitude.call(null,u1);var mg2 = garden.units.magnitude.call(null,u2);var ms1 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u1);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u2);
}
})();var ms2 = (function (){var or__3986__auto__ = garden.units.measurement.call(null,u2);if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return garden.units.measurement.call(null,u1);
}
})();var mg3 = garden.units.convert.call(null,mg2,ms2,ms1);return (new garden.units.Unit(cljs.core._SLASH_.call(null,mg1,mg3),(function (){var or__3986__auto__ = ms1;if(cljs.core.truth_(or__3986__auto__))
{return or__3986__auto__;
} else
{return ms2;
}
})()));
});
var _SLASH___3 = (function() { 
var G__9308__delegate = function (u1,u2,more){return cljs.core.reduce.call(null,_SLASH_,_SLASH_.call(null,u1,u2),more);
};
var G__9308 = function (u1,u2,var_args){
var more = null;if (arguments.length > 2) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__9308__delegate.call(this,u1,u2,more);};
G__9308.cljs$lang$maxFixedArity = 2;
G__9308.cljs$lang$applyTo = (function (arglist__9309){
var u1 = cljs.core.first(arglist__9309);
arglist__9309 = cljs.core.next(arglist__9309);
var u2 = cljs.core.first(arglist__9309);
var more = cljs.core.rest(arglist__9309);
return G__9308__delegate(u1,u2,more);
});
G__9308.cljs$core$IFn$_invoke$arity$variadic = G__9308__delegate;
return G__9308;
})()
;
_SLASH_ = function(u1,u2,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _SLASH___1.call(this,u1);
case 2:
return _SLASH___2.call(this,u1,u2);
default:
return _SLASH___3.cljs$core$IFn$_invoke$arity$variadic(u1,u2, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_SLASH_.cljs$lang$maxFixedArity = 2;
_SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
_SLASH_.cljs$core$IFn$_invoke$arity$1 = _SLASH___1;
_SLASH_.cljs$core$IFn$_invoke$arity$2 = _SLASH___2;
_SLASH_.cljs$core$IFn$_invoke$arity$variadic = _SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return _SLASH_;
})()
;
garden.units.cm = (function cm(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"cm","cm",540591536));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"cm","cm",540591536)));
});
garden.units.mm = (function mm(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"mm","mm",-1652850560));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"mm","mm",-1652850560)));
});
garden.units.in$ = (function in$(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"in","in",-1531184865));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"in","in",-1531184865)));
});
garden.units.px = (function px(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"px","px",281329899));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"px","px",281329899)));
});
garden.units.pt = (function pt(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"pt","pt",556460867));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"pt","pt",556460867)));
});
garden.units.pc = (function pc(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"pc","pc",512913453));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"pc","pc",512913453)));
});
garden.units.percent = (function percent(x__7452__auto__){var mg__7453__auto__ = garden.units.magnitude.call(null,x__7452__auto__);var ms__7454__auto__ = garden.units.measurement.call(null,x__7452__auto__);var i__7455__auto__ = garden.units.convert.call(null,mg__7453__auto__,ms__7454__auto__,new cljs.core.Keyword(null,"%","%",1704198600));return (new garden.units.Unit(i__7455__auto__,"%"));
});
garden.units.em = (function em(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"em","em",707813035));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"em","em",707813035)));
});
garden.units.ex = (function ex(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"ex","ex",-1413771341));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"ex","ex",-1413771341)));
});
garden.units.ch = (function ch(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"ch","ch",-554717905));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"ch","ch",-554717905)));
});
garden.units.rem = (function rem(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"rem","rem",-976484757));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"rem","rem",-976484757)));
});
garden.units.vw = (function vw(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"vw","vw",1941049135));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"vw","vw",1941049135)));
});
garden.units.vh = (function vh(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"vh","vh",79552846));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"vh","vh",79552846)));
});
garden.units.vmin = (function vmin(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"vmin","vmin",446546816));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"vmin","vmin",446546816)));
});
garden.units.vmax = (function vmax(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"vmax","vmax",-1435213544));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"vmax","vmax",-1435213544)));
});
garden.units.deg = (function deg(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"deg","deg",-681556081));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"deg","deg",-681556081)));
});
garden.units.grad = (function grad(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"grad","grad",1125187229));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"grad","grad",1125187229)));
});
garden.units.rad = (function rad(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"rad","rad",-833983012));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"rad","rad",-833983012)));
});
garden.units.turn = (function turn(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"turn","turn",75759344));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"turn","turn",75759344)));
});
garden.units.s = (function s(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"s","s",1705939918));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"s","s",1705939918)));
});
garden.units.ms = (function ms(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"ms","ms",-1152709733));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"ms","ms",-1152709733)));
});
garden.units.Hz = (function Hz(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"Hz","Hz",-1958732916));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"Hz","Hz",-1958732916)));
});
garden.units.kHz = (function kHz(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"kHz","kHz",240398466));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"kHz","kHz",240398466)));
});
garden.units.dpi = (function dpi(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"dpi","dpi",-986162832));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"dpi","dpi",-986162832)));
});
garden.units.dpcm = (function dpcm(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"dpcm","dpcm",-1187601236));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"dpcm","dpcm",-1187601236)));
});
garden.units.dppx = (function dppx(x__7448__auto__){var mg__7449__auto__ = garden.units.magnitude.call(null,x__7448__auto__);var ms__7450__auto__ = garden.units.measurement.call(null,x__7448__auto__);var i__7451__auto__ = garden.units.convert.call(null,mg__7449__auto__,ms__7450__auto__,new cljs.core.Keyword(null,"dppx","dppx",1920508843));return (new garden.units.Unit(i__7451__auto__,new cljs.core.Keyword(null,"dppx","dppx",1920508843)));
});
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"cm","cm",540591536),new cljs.core.Keyword(null,"mm","mm",-1652850560),(10));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"cm","cm",540591536),new cljs.core.Keyword(null,"pc","pc",512913453),2.36220473);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"cm","cm",540591536),new cljs.core.Keyword(null,"pt","pt",556460867),28.3464567);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"cm","cm",540591536),new cljs.core.Keyword(null,"px","px",281329899),37.795275591);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Keyword(null,"cm","cm",540591536),2.54);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Keyword(null,"mm","mm",-1652850560),25.4);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Keyword(null,"pc","pc",512913453),(6));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Keyword(null,"pt","pt",556460867),(72));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Keyword(null,"px","px",281329899),(96));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"mm","mm",-1652850560),new cljs.core.Keyword(null,"pt","pt",556460867),2.83464567);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"mm","mm",-1652850560),new cljs.core.Keyword(null,"px","px",281329899),3.7795275591);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"pc","pc",512913453),new cljs.core.Keyword(null,"mm","mm",-1652850560),4.23333333);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"pc","pc",512913453),new cljs.core.Keyword(null,"pt","pt",556460867),(12));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"pc","pc",512913453),new cljs.core.Keyword(null,"px","px",281329899),(16));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"pt","pt",556460867),new cljs.core.Keyword(null,"px","px",281329899),1.3333333333);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"deg","deg",-681556081),new cljs.core.Keyword(null,"grad","grad",1125187229),1.111111111);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"deg","deg",-681556081),new cljs.core.Keyword(null,"rad","rad",-833983012),0.0174532925);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"deg","deg",-681556081),new cljs.core.Keyword(null,"turn","turn",75759344),0.002777778);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"grad","grad",1125187229),new cljs.core.Keyword(null,"rad","rad",-833983012),63.661977237);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"grad","grad",1125187229),new cljs.core.Keyword(null,"turn","turn",75759344),0.0025);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"rad","rad",-833983012),new cljs.core.Keyword(null,"turn","turn",75759344),0.159154943);
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"ms","ms",-1152709733),(1000));
garden.units.add_conversion_BANG_.call(null,new cljs.core.Keyword(null,"Hz","Hz",-1958732916),new cljs.core.Keyword(null,"kHz","kHz",240398466),0.001);
(garden.units.IMeasurement["number"] = true);
(garden.units._measurement["number"] = (function (this$){return null;
}));
(garden.units.IMagnitude["number"] = true);
(garden.units._magnitude["number"] = (function (this$){return this$;
}));
(garden.units.IUnit["number"] = true);
(garden.units._unit["number"] = (function (this$){return (new garden.units.Unit(this$,null));
}));
/**
* Regular expression for matching a CSS unit. The magnitude
* and unit are captured.
*/
garden.units.unit_re = /([+-]?\d+(?:\.?\d+)?)(p[xtc]|in|[cm]m|%|r?em|ex|ch|v(?:[wh]|m(?:in|ax))|deg|g?rad|turn|m?s|k?Hz|dp(?:i|cm|px))?/;
garden.units.parse_unit = (function parse_unit(s){var s_SINGLEQUOTE_ = clojure.string.trim.call(null,s);var temp__4124__auto__ = cljs.core.re_matches.call(null,garden.units.unit_re,s_SINGLEQUOTE_);if(cljs.core.truth_(temp__4124__auto__))
{var vec__9311 = temp__4124__auto__;var _ = cljs.core.nth.call(null,vec__9311,(0),null);var magnitude = cljs.core.nth.call(null,vec__9311,(1),null);var measurement = cljs.core.nth.call(null,vec__9311,(2),null);var magnitude__$1 = parseFloat(magnitude);var measurement__$1 = (function (){var and__3974__auto__ = measurement;if(cljs.core.truth_(and__3974__auto__))
{return cljs.core.keyword.call(null,measurement);
} else
{return and__3974__auto__;
}
})();return (new garden.units.Unit(magnitude__$1,measurement__$1));
} else
{throw cljs.core.ex_info.call(null,("Unable to convert "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,s))+" to Unit"),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"given","given",716253602),s,new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.sequence.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,garden.units.unit_re),cljs.core._conj.call(null,cljs.core.List.EMPTY,s)))], null));
}
});
(garden.units.IMeasurement["string"] = true);
(garden.units._measurement["string"] = (function (this$){return garden.units.parse_unit.call(null,this$).measurement;
}));
(garden.units.IMagnitude["string"] = true);
(garden.units._magnitude["string"] = (function (this$){return garden.units.parse_unit.call(null,this$).magnitude;
}));
(garden.units.IUnit["string"] = true);
(garden.units._unit["string"] = (function (this$){return garden.units.parse_unit.call(null,this$);
}));
cljs.core.Keyword.prototype.garden$units$IMeasurement$ = true;
cljs.core.Keyword.prototype.garden$units$IMeasurement$_measurement$arity$1 = (function (this$){var this$__$1 = this;return garden.units.parse_unit.call(null,cljs.core.name.call(null,this$__$1)).measurement;
});
cljs.core.Keyword.prototype.garden$units$IMagnitude$ = true;
cljs.core.Keyword.prototype.garden$units$IMagnitude$_magnitude$arity$1 = (function (this$){var this$__$1 = this;return garden.units.parse_unit.call(null,cljs.core.name.call(null,this$__$1)).magnitude;
});
cljs.core.Keyword.prototype.garden$units$IUnit$ = true;
cljs.core.Keyword.prototype.garden$units$IUnit$_unit$arity$1 = (function (this$){var this$__$1 = this;return garden.units.parse_unit.call(null,cljs.core.name.call(null,this$__$1));
});

//# sourceMappingURL=units.js.map