/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.client.HostProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticHostProvider
implements HostProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProvider.class);
    private final List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private int lastIndex = -1;
    private int currentIndex = -1;
    private boolean connectedSinceNext = true;
    private int nextAdded = 0;
    private int nextRemoved = 0;

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses) throws UnknownHostException {
        for (InetSocketAddress address : serverAddresses) {
            InetAddress[] resolvedAddresses;
            for (InetAddress resolvedAddress : resolvedAddresses = InetAddress.getAllByName(this.getHostString(address))) {
                this.serverAddresses.add(new InetSocketAddress(resolvedAddress, address.getPort()));
            }
        }
        if (this.serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        Collections.shuffle(this.serverAddresses);
    }

    private String getHostString(InetSocketAddress addr) {
        String hostString = "";
        if (addr == null) {
            return hostString;
        }
        if (!addr.isUnresolved()) {
            InetAddress ia = addr.getAddress();
            hostString = ia.toString().startsWith("/") ? ia.getHostAddress() : addr.getHostName();
        } else {
            String addrString = addr.toString();
            hostString = addrString.substring(0, addrString.lastIndexOf(58));
        }
        return hostString;
    }

    @Override
    public int size() {
        return this.serverAddresses.size();
    }

    int getNextAdded() {
        return this.nextAdded;
    }

    int getNextRemoved() {
        return this.nextRemoved;
    }

    @Override
    public InetSocketAddress next(long spinDelay) {
        InetSocketAddress curAddr;
        String curHostString;
        if (!this.connectedSinceNext && !(curHostString = this.getHostString(curAddr = this.serverAddresses.get(this.currentIndex))).equals(curAddr.getAddress().getHostAddress())) {
            LOG.info("Resolving again hostname: {}", (Object)this.getHostString(curAddr));
            try {
                int thePort = curAddr.getPort();
                InetAddress[] resolvedAddresses = InetAddress.getAllByName(curHostString);
                this.nextAdded = 0;
                this.nextRemoved = 0;
                if (resolvedAddresses.length == 1) {
                    this.serverAddresses.set(this.currentIndex, new InetSocketAddress(resolvedAddresses[0], thePort));
                    this.nextRemoved = 1;
                    this.nextAdded = 1;
                    LOG.debug("Newly resolved address: {}", (Object)resolvedAddresses[0]);
                } else {
                    int i = 0;
                    while (i < this.serverAddresses.size()) {
                        if (this.getHostString(this.serverAddresses.get(i)).equals(curHostString) && this.serverAddresses.get(i).getPort() == curAddr.getPort()) {
                            LOG.debug("Removing address: {}", (Object)this.serverAddresses.get(i));
                            this.serverAddresses.remove(i);
                            ++this.nextRemoved;
                            continue;
                        }
                        ++i;
                    }
                    for (InetAddress resolvedAddress : resolvedAddresses) {
                        InetSocketAddress newAddr = new InetSocketAddress(resolvedAddress, thePort);
                        if (this.serverAddresses.contains(newAddr)) continue;
                        LOG.debug("Adding address: {}", (Object)newAddr);
                        this.serverAddresses.add(newAddr);
                        ++this.nextAdded;
                    }
                }
            }
            catch (UnknownHostException e) {
                LOG.warn("Cannot re-resolve server: {}", (Object)curAddr, (Object)e);
            }
        }
        this.connectedSinceNext = false;
        ++this.currentIndex;
        this.currentIndex %= this.serverAddresses.size();
        if (this.currentIndex == this.lastIndex && spinDelay > 0L) {
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Unexpected exception", (Throwable)e);
            }
        } else if (this.lastIndex == -1) {
            this.lastIndex = 0;
        }
        return this.serverAddresses.get(this.currentIndex);
    }

    @Override
    public void onConnected() {
        this.lastIndex = this.currentIndex;
        this.connectedSinceNext = true;
    }
}

