# fastmath

Fast primitive based math library

## Installation

```clojure
[generateme/fastmath "0.1.0-SNAPSHOT"]
```

## Documentation

[HERE](https://generateme.github.io/fastmath/index.html)

## Content

* [PrimitiveMath](https://github.com/ztellman/primitive-math) - Zach Tellmeans' code enhanced
* [FastMath](https://github.com/jeffhain/jafama) bindings
* Processing like math functions
* Vector operations protocol and implementations:
  * 2d (`Vec2`), 3d (`Vec3`) and 4d (`Vec4`) vector types.
  * ArrayVector for fixed length long vectors
  * Clojure vector []
* Complex number functions
* Random numbers, sequences
* Random distributions
* Various noises (value, gradient, simplex, discrete)
* Statistics
* Plenty of constant values
* 1d, 2d interpolations

Almost all functions optimized to work on `double` and `long` primitives

## Supporting libraries

* [Apache Commons Math 3.6.1](http://commons.apache.org/proper/commons-math/index.html) - Apache 2.0 Licence
* [SMILE 1.5.1](http://haifengl.github.io/smile/) - Apache 2.0 Licence
* [Jafama FastMath 2.3.1](https://github.com/jeffhain/jafama) - Apache 2.0 Licence
* [PrimitiveMath](https://github.com/ztellman/primitive-math) - MIT Licence

## Licence

The Unlicence

