# tree-form

Helpers and components to deal with HTML forms in a re-frame/reagent stack

## Usage

```clojure
(ns my.super-ns
    (:require [tree-form.core :refer [form]]))
    
(defn my-form-component []
  ;; Init form with config
  [form {:id          :my-super-form
         :validate    my-validate-fn
         :on-submit   my-submit-fn
         :init        my-init-fn
         :clean-up    my-clean-up-fn
         :clear-state false
         :fields      {:my-something nil
                       :my-name      {:default "Albert"}
                       :my-age       {:default 10
                                      :validate validate-field-fn
                                      :validate-on-action true
                                      :process (comp js/parseInt #($ % :target.value))}}
         :includes    {:my-custon-prop-name [:path :to :prop :in :db]}}

    (fn [{:keys [fields errors includes on-submit]}]
      ;; Use form prop in any view component
      [:form {:on-submit on-submit}
       [:input {:on-change (-> fields :my-name :action)
                :value     (-> fields :my-name :value)}]])])
```
