// Compiled by ClojureScript 1.10.339 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__24029 = arguments.length;
switch (G__24029) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24030 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24030 = (function (f,blockable,meta24031){
this.f = f;
this.blockable = blockable;
this.meta24031 = meta24031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24032,meta24031__$1){
var self__ = this;
var _24032__$1 = this;
return (new cljs.core.async.t_cljs$core$async24030(self__.f,self__.blockable,meta24031__$1));
});

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24032){
var self__ = this;
var _24032__$1 = this;
return self__.meta24031;
});

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async24030.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async24030.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta24031","meta24031",151439468,null)], null);
});

cljs.core.async.t_cljs$core$async24030.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24030.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24030";

cljs.core.async.t_cljs$core$async24030.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async24030");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24030.
 */
cljs.core.async.__GT_t_cljs$core$async24030 = (function cljs$core$async$__GT_t_cljs$core$async24030(f__$1,blockable__$1,meta24031){
return (new cljs.core.async.t_cljs$core$async24030(f__$1,blockable__$1,meta24031));
});

}

return (new cljs.core.async.t_cljs$core$async24030(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__24036 = arguments.length;
switch (G__24036) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__24039 = arguments.length;
switch (G__24039) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__24042 = arguments.length;
switch (G__24042) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_24044 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_24044);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_24044,ret){
return (function (){
return fn1.call(null,val_24044);
});})(val_24044,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__24046 = arguments.length;
switch (G__24046) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___24048 = n;
var x_24049 = (0);
while(true){
if((x_24049 < n__4408__auto___24048)){
(a[x_24049] = (0));

var G__24050 = (x_24049 + (1));
x_24049 = G__24050;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__24051 = (i + (1));
i = G__24051;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24052 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24052 = (function (flag,meta24053){
this.flag = flag;
this.meta24053 = meta24053;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_24054,meta24053__$1){
var self__ = this;
var _24054__$1 = this;
return (new cljs.core.async.t_cljs$core$async24052(self__.flag,meta24053__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_24054){
var self__ = this;
var _24054__$1 = this;
return self__.meta24053;
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta24053","meta24053",-458132493,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async24052.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24052.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24052";

cljs.core.async.t_cljs$core$async24052.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async24052");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24052.
 */
cljs.core.async.__GT_t_cljs$core$async24052 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async24052(flag__$1,meta24053){
return (new cljs.core.async.t_cljs$core$async24052(flag__$1,meta24053));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async24052(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24055 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24055 = (function (flag,cb,meta24056){
this.flag = flag;
this.cb = cb;
this.meta24056 = meta24056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24057,meta24056__$1){
var self__ = this;
var _24057__$1 = this;
return (new cljs.core.async.t_cljs$core$async24055(self__.flag,self__.cb,meta24056__$1));
});

cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24057){
var self__ = this;
var _24057__$1 = this;
return self__.meta24056;
});

cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24055.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async24055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta24056","meta24056",965553942,null)], null);
});

cljs.core.async.t_cljs$core$async24055.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24055";

cljs.core.async.t_cljs$core$async24055.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async24055");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24055.
 */
cljs.core.async.__GT_t_cljs$core$async24055 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async24055(flag__$1,cb__$1,meta24056){
return (new cljs.core.async.t_cljs$core$async24055(flag__$1,cb__$1,meta24056));
});

}

return (new cljs.core.async.t_cljs$core$async24055(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24058_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24058_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24059_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24059_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__24060 = (i + (1));
i = G__24060;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___24066 = arguments.length;
var i__4532__auto___24067 = (0);
while(true){
if((i__4532__auto___24067 < len__4531__auto___24066)){
args__4534__auto__.push((arguments[i__4532__auto___24067]));

var G__24068 = (i__4532__auto___24067 + (1));
i__4532__auto___24067 = G__24068;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__24063){
var map__24064 = p__24063;
var map__24064__$1 = ((((!((map__24064 == null)))?(((((map__24064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24064):map__24064);
var opts = map__24064__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq24061){
var G__24062 = cljs.core.first.call(null,seq24061);
var seq24061__$1 = cljs.core.next.call(null,seq24061);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24062,seq24061__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__24070 = arguments.length;
switch (G__24070) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23969__auto___24116 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___24116){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___24116){
return (function (state_24094){
var state_val_24095 = (state_24094[(1)]);
if((state_val_24095 === (7))){
var inst_24090 = (state_24094[(2)]);
var state_24094__$1 = state_24094;
var statearr_24096_24117 = state_24094__$1;
(statearr_24096_24117[(2)] = inst_24090);

(statearr_24096_24117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (1))){
var state_24094__$1 = state_24094;
var statearr_24097_24118 = state_24094__$1;
(statearr_24097_24118[(2)] = null);

(statearr_24097_24118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (4))){
var inst_24073 = (state_24094[(7)]);
var inst_24073__$1 = (state_24094[(2)]);
var inst_24074 = (inst_24073__$1 == null);
var state_24094__$1 = (function (){var statearr_24098 = state_24094;
(statearr_24098[(7)] = inst_24073__$1);

return statearr_24098;
})();
if(cljs.core.truth_(inst_24074)){
var statearr_24099_24119 = state_24094__$1;
(statearr_24099_24119[(1)] = (5));

} else {
var statearr_24100_24120 = state_24094__$1;
(statearr_24100_24120[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (13))){
var state_24094__$1 = state_24094;
var statearr_24101_24121 = state_24094__$1;
(statearr_24101_24121[(2)] = null);

(statearr_24101_24121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (6))){
var inst_24073 = (state_24094[(7)]);
var state_24094__$1 = state_24094;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24094__$1,(11),to,inst_24073);
} else {
if((state_val_24095 === (3))){
var inst_24092 = (state_24094[(2)]);
var state_24094__$1 = state_24094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24094__$1,inst_24092);
} else {
if((state_val_24095 === (12))){
var state_24094__$1 = state_24094;
var statearr_24102_24122 = state_24094__$1;
(statearr_24102_24122[(2)] = null);

(statearr_24102_24122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (2))){
var state_24094__$1 = state_24094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24094__$1,(4),from);
} else {
if((state_val_24095 === (11))){
var inst_24083 = (state_24094[(2)]);
var state_24094__$1 = state_24094;
if(cljs.core.truth_(inst_24083)){
var statearr_24103_24123 = state_24094__$1;
(statearr_24103_24123[(1)] = (12));

} else {
var statearr_24104_24124 = state_24094__$1;
(statearr_24104_24124[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (9))){
var state_24094__$1 = state_24094;
var statearr_24105_24125 = state_24094__$1;
(statearr_24105_24125[(2)] = null);

(statearr_24105_24125[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (5))){
var state_24094__$1 = state_24094;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24106_24126 = state_24094__$1;
(statearr_24106_24126[(1)] = (8));

} else {
var statearr_24107_24127 = state_24094__$1;
(statearr_24107_24127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (14))){
var inst_24088 = (state_24094[(2)]);
var state_24094__$1 = state_24094;
var statearr_24108_24128 = state_24094__$1;
(statearr_24108_24128[(2)] = inst_24088);

(statearr_24108_24128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (10))){
var inst_24080 = (state_24094[(2)]);
var state_24094__$1 = state_24094;
var statearr_24109_24129 = state_24094__$1;
(statearr_24109_24129[(2)] = inst_24080);

(statearr_24109_24129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24095 === (8))){
var inst_24077 = cljs.core.async.close_BANG_.call(null,to);
var state_24094__$1 = state_24094;
var statearr_24110_24130 = state_24094__$1;
(statearr_24110_24130[(2)] = inst_24077);

(statearr_24110_24130[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___24116))
;
return ((function (switch__23913__auto__,c__23969__auto___24116){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_24111 = [null,null,null,null,null,null,null,null];
(statearr_24111[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_24111[(1)] = (1));

return statearr_24111;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_24094){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24112){if((e24112 instanceof Object)){
var ex__23917__auto__ = e24112;
var statearr_24113_24131 = state_24094;
(statearr_24113_24131[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24132 = state_24094;
state_24094 = G__24132;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_24094){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_24094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___24116))
})();
var state__23971__auto__ = (function (){var statearr_24114 = f__23970__auto__.call(null);
(statearr_24114[(6)] = c__23969__auto___24116);

return statearr_24114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___24116))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__24133){
var vec__24134 = p__24133;
var v = cljs.core.nth.call(null,vec__24134,(0),null);
var p = cljs.core.nth.call(null,vec__24134,(1),null);
var job = vec__24134;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23969__auto___24305 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results){
return (function (state_24141){
var state_val_24142 = (state_24141[(1)]);
if((state_val_24142 === (1))){
var state_24141__$1 = state_24141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24141__$1,(2),res,v);
} else {
if((state_val_24142 === (2))){
var inst_24138 = (state_24141[(2)]);
var inst_24139 = cljs.core.async.close_BANG_.call(null,res);
var state_24141__$1 = (function (){var statearr_24143 = state_24141;
(statearr_24143[(7)] = inst_24138);

return statearr_24143;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24141__$1,inst_24139);
} else {
return null;
}
}
});})(c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results))
;
return ((function (switch__23913__auto__,c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_24144 = [null,null,null,null,null,null,null,null];
(statearr_24144[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_24144[(1)] = (1));

return statearr_24144;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_24141){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24145){if((e24145 instanceof Object)){
var ex__23917__auto__ = e24145;
var statearr_24146_24306 = state_24141;
(statearr_24146_24306[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24307 = state_24141;
state_24141 = G__24307;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_24141){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_24141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results))
})();
var state__23971__auto__ = (function (){var statearr_24147 = f__23970__auto__.call(null);
(statearr_24147[(6)] = c__23969__auto___24305);

return statearr_24147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___24305,res,vec__24134,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__24148){
var vec__24149 = p__24148;
var v = cljs.core.nth.call(null,vec__24149,(0),null);
var p = cljs.core.nth.call(null,vec__24149,(1),null);
var job = vec__24149;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___24308 = n;
var __24309 = (0);
while(true){
if((__24309 < n__4408__auto___24308)){
var G__24152_24310 = type;
var G__24152_24311__$1 = (((G__24152_24310 instanceof cljs.core.Keyword))?G__24152_24310.fqn:null);
switch (G__24152_24311__$1) {
case "compute":
var c__23969__auto___24313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24309,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (__24309,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function (state_24165){
var state_val_24166 = (state_24165[(1)]);
if((state_val_24166 === (1))){
var state_24165__$1 = state_24165;
var statearr_24167_24314 = state_24165__$1;
(statearr_24167_24314[(2)] = null);

(statearr_24167_24314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24166 === (2))){
var state_24165__$1 = state_24165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24165__$1,(4),jobs);
} else {
if((state_val_24166 === (3))){
var inst_24163 = (state_24165[(2)]);
var state_24165__$1 = state_24165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24165__$1,inst_24163);
} else {
if((state_val_24166 === (4))){
var inst_24155 = (state_24165[(2)]);
var inst_24156 = process.call(null,inst_24155);
var state_24165__$1 = state_24165;
if(cljs.core.truth_(inst_24156)){
var statearr_24168_24315 = state_24165__$1;
(statearr_24168_24315[(1)] = (5));

} else {
var statearr_24169_24316 = state_24165__$1;
(statearr_24169_24316[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24166 === (5))){
var state_24165__$1 = state_24165;
var statearr_24170_24317 = state_24165__$1;
(statearr_24170_24317[(2)] = null);

(statearr_24170_24317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24166 === (6))){
var state_24165__$1 = state_24165;
var statearr_24171_24318 = state_24165__$1;
(statearr_24171_24318[(2)] = null);

(statearr_24171_24318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24166 === (7))){
var inst_24161 = (state_24165[(2)]);
var state_24165__$1 = state_24165;
var statearr_24172_24319 = state_24165__$1;
(statearr_24172_24319[(2)] = inst_24161);

(statearr_24172_24319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__24309,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
;
return ((function (__24309,switch__23913__auto__,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_24173 = [null,null,null,null,null,null,null];
(statearr_24173[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_24173[(1)] = (1));

return statearr_24173;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_24165){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24174){if((e24174 instanceof Object)){
var ex__23917__auto__ = e24174;
var statearr_24175_24320 = state_24165;
(statearr_24175_24320[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24174;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24321 = state_24165;
state_24165 = G__24321;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_24165){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_24165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(__24309,switch__23913__auto__,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
})();
var state__23971__auto__ = (function (){var statearr_24176 = f__23970__auto__.call(null);
(statearr_24176[(6)] = c__23969__auto___24313);

return statearr_24176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(__24309,c__23969__auto___24313,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
);


break;
case "async":
var c__23969__auto___24322 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24309,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (__24309,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function (state_24189){
var state_val_24190 = (state_24189[(1)]);
if((state_val_24190 === (1))){
var state_24189__$1 = state_24189;
var statearr_24191_24323 = state_24189__$1;
(statearr_24191_24323[(2)] = null);

(statearr_24191_24323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24190 === (2))){
var state_24189__$1 = state_24189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24189__$1,(4),jobs);
} else {
if((state_val_24190 === (3))){
var inst_24187 = (state_24189[(2)]);
var state_24189__$1 = state_24189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24189__$1,inst_24187);
} else {
if((state_val_24190 === (4))){
var inst_24179 = (state_24189[(2)]);
var inst_24180 = async.call(null,inst_24179);
var state_24189__$1 = state_24189;
if(cljs.core.truth_(inst_24180)){
var statearr_24192_24324 = state_24189__$1;
(statearr_24192_24324[(1)] = (5));

} else {
var statearr_24193_24325 = state_24189__$1;
(statearr_24193_24325[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24190 === (5))){
var state_24189__$1 = state_24189;
var statearr_24194_24326 = state_24189__$1;
(statearr_24194_24326[(2)] = null);

(statearr_24194_24326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24190 === (6))){
var state_24189__$1 = state_24189;
var statearr_24195_24327 = state_24189__$1;
(statearr_24195_24327[(2)] = null);

(statearr_24195_24327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24190 === (7))){
var inst_24185 = (state_24189[(2)]);
var state_24189__$1 = state_24189;
var statearr_24196_24328 = state_24189__$1;
(statearr_24196_24328[(2)] = inst_24185);

(statearr_24196_24328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__24309,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
;
return ((function (__24309,switch__23913__auto__,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_24197 = [null,null,null,null,null,null,null];
(statearr_24197[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_24197[(1)] = (1));

return statearr_24197;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_24189){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24198){if((e24198 instanceof Object)){
var ex__23917__auto__ = e24198;
var statearr_24199_24329 = state_24189;
(statearr_24199_24329[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24330 = state_24189;
state_24189 = G__24330;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_24189){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_24189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(__24309,switch__23913__auto__,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
})();
var state__23971__auto__ = (function (){var statearr_24200 = f__23970__auto__.call(null);
(statearr_24200[(6)] = c__23969__auto___24322);

return statearr_24200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(__24309,c__23969__auto___24322,G__24152_24310,G__24152_24311__$1,n__4408__auto___24308,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24152_24311__$1)].join('')));

}

var G__24331 = (__24309 + (1));
__24309 = G__24331;
continue;
} else {
}
break;
}

var c__23969__auto___24332 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___24332,jobs,results,process,async){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___24332,jobs,results,process,async){
return (function (state_24222){
var state_val_24223 = (state_24222[(1)]);
if((state_val_24223 === (1))){
var state_24222__$1 = state_24222;
var statearr_24224_24333 = state_24222__$1;
(statearr_24224_24333[(2)] = null);

(statearr_24224_24333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24223 === (2))){
var state_24222__$1 = state_24222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24222__$1,(4),from);
} else {
if((state_val_24223 === (3))){
var inst_24220 = (state_24222[(2)]);
var state_24222__$1 = state_24222;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24222__$1,inst_24220);
} else {
if((state_val_24223 === (4))){
var inst_24203 = (state_24222[(7)]);
var inst_24203__$1 = (state_24222[(2)]);
var inst_24204 = (inst_24203__$1 == null);
var state_24222__$1 = (function (){var statearr_24225 = state_24222;
(statearr_24225[(7)] = inst_24203__$1);

return statearr_24225;
})();
if(cljs.core.truth_(inst_24204)){
var statearr_24226_24334 = state_24222__$1;
(statearr_24226_24334[(1)] = (5));

} else {
var statearr_24227_24335 = state_24222__$1;
(statearr_24227_24335[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24223 === (5))){
var inst_24206 = cljs.core.async.close_BANG_.call(null,jobs);
var state_24222__$1 = state_24222;
var statearr_24228_24336 = state_24222__$1;
(statearr_24228_24336[(2)] = inst_24206);

(statearr_24228_24336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24223 === (6))){
var inst_24203 = (state_24222[(7)]);
var inst_24208 = (state_24222[(8)]);
var inst_24208__$1 = cljs.core.async.chan.call(null,(1));
var inst_24209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24210 = [inst_24203,inst_24208__$1];
var inst_24211 = (new cljs.core.PersistentVector(null,2,(5),inst_24209,inst_24210,null));
var state_24222__$1 = (function (){var statearr_24229 = state_24222;
(statearr_24229[(8)] = inst_24208__$1);

return statearr_24229;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24222__$1,(8),jobs,inst_24211);
} else {
if((state_val_24223 === (7))){
var inst_24218 = (state_24222[(2)]);
var state_24222__$1 = state_24222;
var statearr_24230_24337 = state_24222__$1;
(statearr_24230_24337[(2)] = inst_24218);

(statearr_24230_24337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24223 === (8))){
var inst_24208 = (state_24222[(8)]);
var inst_24213 = (state_24222[(2)]);
var state_24222__$1 = (function (){var statearr_24231 = state_24222;
(statearr_24231[(9)] = inst_24213);

return statearr_24231;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24222__$1,(9),results,inst_24208);
} else {
if((state_val_24223 === (9))){
var inst_24215 = (state_24222[(2)]);
var state_24222__$1 = (function (){var statearr_24232 = state_24222;
(statearr_24232[(10)] = inst_24215);

return statearr_24232;
})();
var statearr_24233_24338 = state_24222__$1;
(statearr_24233_24338[(2)] = null);

(statearr_24233_24338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___24332,jobs,results,process,async))
;
return ((function (switch__23913__auto__,c__23969__auto___24332,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_24234 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24234[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_24234[(1)] = (1));

return statearr_24234;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_24222){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24222);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24235){if((e24235 instanceof Object)){
var ex__23917__auto__ = e24235;
var statearr_24236_24339 = state_24222;
(statearr_24236_24339[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24222);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24235;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24340 = state_24222;
state_24222 = G__24340;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_24222){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_24222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___24332,jobs,results,process,async))
})();
var state__23971__auto__ = (function (){var statearr_24237 = f__23970__auto__.call(null);
(statearr_24237[(6)] = c__23969__auto___24332);

return statearr_24237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___24332,jobs,results,process,async))
);


var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__,jobs,results,process,async){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__,jobs,results,process,async){
return (function (state_24275){
var state_val_24276 = (state_24275[(1)]);
if((state_val_24276 === (7))){
var inst_24271 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
var statearr_24277_24341 = state_24275__$1;
(statearr_24277_24341[(2)] = inst_24271);

(statearr_24277_24341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (20))){
var state_24275__$1 = state_24275;
var statearr_24278_24342 = state_24275__$1;
(statearr_24278_24342[(2)] = null);

(statearr_24278_24342[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (1))){
var state_24275__$1 = state_24275;
var statearr_24279_24343 = state_24275__$1;
(statearr_24279_24343[(2)] = null);

(statearr_24279_24343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (4))){
var inst_24240 = (state_24275[(7)]);
var inst_24240__$1 = (state_24275[(2)]);
var inst_24241 = (inst_24240__$1 == null);
var state_24275__$1 = (function (){var statearr_24280 = state_24275;
(statearr_24280[(7)] = inst_24240__$1);

return statearr_24280;
})();
if(cljs.core.truth_(inst_24241)){
var statearr_24281_24344 = state_24275__$1;
(statearr_24281_24344[(1)] = (5));

} else {
var statearr_24282_24345 = state_24275__$1;
(statearr_24282_24345[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (15))){
var inst_24253 = (state_24275[(8)]);
var state_24275__$1 = state_24275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24275__$1,(18),to,inst_24253);
} else {
if((state_val_24276 === (21))){
var inst_24266 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
var statearr_24283_24346 = state_24275__$1;
(statearr_24283_24346[(2)] = inst_24266);

(statearr_24283_24346[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (13))){
var inst_24268 = (state_24275[(2)]);
var state_24275__$1 = (function (){var statearr_24284 = state_24275;
(statearr_24284[(9)] = inst_24268);

return statearr_24284;
})();
var statearr_24285_24347 = state_24275__$1;
(statearr_24285_24347[(2)] = null);

(statearr_24285_24347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (6))){
var inst_24240 = (state_24275[(7)]);
var state_24275__$1 = state_24275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24275__$1,(11),inst_24240);
} else {
if((state_val_24276 === (17))){
var inst_24261 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
if(cljs.core.truth_(inst_24261)){
var statearr_24286_24348 = state_24275__$1;
(statearr_24286_24348[(1)] = (19));

} else {
var statearr_24287_24349 = state_24275__$1;
(statearr_24287_24349[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (3))){
var inst_24273 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24275__$1,inst_24273);
} else {
if((state_val_24276 === (12))){
var inst_24250 = (state_24275[(10)]);
var state_24275__$1 = state_24275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24275__$1,(14),inst_24250);
} else {
if((state_val_24276 === (2))){
var state_24275__$1 = state_24275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24275__$1,(4),results);
} else {
if((state_val_24276 === (19))){
var state_24275__$1 = state_24275;
var statearr_24288_24350 = state_24275__$1;
(statearr_24288_24350[(2)] = null);

(statearr_24288_24350[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (11))){
var inst_24250 = (state_24275[(2)]);
var state_24275__$1 = (function (){var statearr_24289 = state_24275;
(statearr_24289[(10)] = inst_24250);

return statearr_24289;
})();
var statearr_24290_24351 = state_24275__$1;
(statearr_24290_24351[(2)] = null);

(statearr_24290_24351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (9))){
var state_24275__$1 = state_24275;
var statearr_24291_24352 = state_24275__$1;
(statearr_24291_24352[(2)] = null);

(statearr_24291_24352[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (5))){
var state_24275__$1 = state_24275;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24292_24353 = state_24275__$1;
(statearr_24292_24353[(1)] = (8));

} else {
var statearr_24293_24354 = state_24275__$1;
(statearr_24293_24354[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (14))){
var inst_24255 = (state_24275[(11)]);
var inst_24253 = (state_24275[(8)]);
var inst_24253__$1 = (state_24275[(2)]);
var inst_24254 = (inst_24253__$1 == null);
var inst_24255__$1 = cljs.core.not.call(null,inst_24254);
var state_24275__$1 = (function (){var statearr_24294 = state_24275;
(statearr_24294[(11)] = inst_24255__$1);

(statearr_24294[(8)] = inst_24253__$1);

return statearr_24294;
})();
if(inst_24255__$1){
var statearr_24295_24355 = state_24275__$1;
(statearr_24295_24355[(1)] = (15));

} else {
var statearr_24296_24356 = state_24275__$1;
(statearr_24296_24356[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (16))){
var inst_24255 = (state_24275[(11)]);
var state_24275__$1 = state_24275;
var statearr_24297_24357 = state_24275__$1;
(statearr_24297_24357[(2)] = inst_24255);

(statearr_24297_24357[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (10))){
var inst_24247 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
var statearr_24298_24358 = state_24275__$1;
(statearr_24298_24358[(2)] = inst_24247);

(statearr_24298_24358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (18))){
var inst_24258 = (state_24275[(2)]);
var state_24275__$1 = state_24275;
var statearr_24299_24359 = state_24275__$1;
(statearr_24299_24359[(2)] = inst_24258);

(statearr_24299_24359[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24276 === (8))){
var inst_24244 = cljs.core.async.close_BANG_.call(null,to);
var state_24275__$1 = state_24275;
var statearr_24300_24360 = state_24275__$1;
(statearr_24300_24360[(2)] = inst_24244);

(statearr_24300_24360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__,jobs,results,process,async))
;
return ((function (switch__23913__auto__,c__23969__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_24301 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24301[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__);

(statearr_24301[(1)] = (1));

return statearr_24301;
});
var cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1 = (function (state_24275){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24302){if((e24302 instanceof Object)){
var ex__23917__auto__ = e24302;
var statearr_24303_24361 = state_24275;
(statearr_24303_24361[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24362 = state_24275;
state_24275 = G__24362;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__ = function(state_24275){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1.call(this,state_24275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__,jobs,results,process,async))
})();
var state__23971__auto__ = (function (){var statearr_24304 = f__23970__auto__.call(null);
(statearr_24304[(6)] = c__23969__auto__);

return statearr_24304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__,jobs,results,process,async))
);

return c__23969__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__24364 = arguments.length;
switch (G__24364) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__24367 = arguments.length;
switch (G__24367) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__24370 = arguments.length;
switch (G__24370) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23969__auto___24419 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___24419,tc,fc){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___24419,tc,fc){
return (function (state_24396){
var state_val_24397 = (state_24396[(1)]);
if((state_val_24397 === (7))){
var inst_24392 = (state_24396[(2)]);
var state_24396__$1 = state_24396;
var statearr_24398_24420 = state_24396__$1;
(statearr_24398_24420[(2)] = inst_24392);

(statearr_24398_24420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (1))){
var state_24396__$1 = state_24396;
var statearr_24399_24421 = state_24396__$1;
(statearr_24399_24421[(2)] = null);

(statearr_24399_24421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (4))){
var inst_24373 = (state_24396[(7)]);
var inst_24373__$1 = (state_24396[(2)]);
var inst_24374 = (inst_24373__$1 == null);
var state_24396__$1 = (function (){var statearr_24400 = state_24396;
(statearr_24400[(7)] = inst_24373__$1);

return statearr_24400;
})();
if(cljs.core.truth_(inst_24374)){
var statearr_24401_24422 = state_24396__$1;
(statearr_24401_24422[(1)] = (5));

} else {
var statearr_24402_24423 = state_24396__$1;
(statearr_24402_24423[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (13))){
var state_24396__$1 = state_24396;
var statearr_24403_24424 = state_24396__$1;
(statearr_24403_24424[(2)] = null);

(statearr_24403_24424[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (6))){
var inst_24373 = (state_24396[(7)]);
var inst_24379 = p.call(null,inst_24373);
var state_24396__$1 = state_24396;
if(cljs.core.truth_(inst_24379)){
var statearr_24404_24425 = state_24396__$1;
(statearr_24404_24425[(1)] = (9));

} else {
var statearr_24405_24426 = state_24396__$1;
(statearr_24405_24426[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (3))){
var inst_24394 = (state_24396[(2)]);
var state_24396__$1 = state_24396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24396__$1,inst_24394);
} else {
if((state_val_24397 === (12))){
var state_24396__$1 = state_24396;
var statearr_24406_24427 = state_24396__$1;
(statearr_24406_24427[(2)] = null);

(statearr_24406_24427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (2))){
var state_24396__$1 = state_24396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24396__$1,(4),ch);
} else {
if((state_val_24397 === (11))){
var inst_24373 = (state_24396[(7)]);
var inst_24383 = (state_24396[(2)]);
var state_24396__$1 = state_24396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24396__$1,(8),inst_24383,inst_24373);
} else {
if((state_val_24397 === (9))){
var state_24396__$1 = state_24396;
var statearr_24407_24428 = state_24396__$1;
(statearr_24407_24428[(2)] = tc);

(statearr_24407_24428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (5))){
var inst_24376 = cljs.core.async.close_BANG_.call(null,tc);
var inst_24377 = cljs.core.async.close_BANG_.call(null,fc);
var state_24396__$1 = (function (){var statearr_24408 = state_24396;
(statearr_24408[(8)] = inst_24376);

return statearr_24408;
})();
var statearr_24409_24429 = state_24396__$1;
(statearr_24409_24429[(2)] = inst_24377);

(statearr_24409_24429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (14))){
var inst_24390 = (state_24396[(2)]);
var state_24396__$1 = state_24396;
var statearr_24410_24430 = state_24396__$1;
(statearr_24410_24430[(2)] = inst_24390);

(statearr_24410_24430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (10))){
var state_24396__$1 = state_24396;
var statearr_24411_24431 = state_24396__$1;
(statearr_24411_24431[(2)] = fc);

(statearr_24411_24431[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24397 === (8))){
var inst_24385 = (state_24396[(2)]);
var state_24396__$1 = state_24396;
if(cljs.core.truth_(inst_24385)){
var statearr_24412_24432 = state_24396__$1;
(statearr_24412_24432[(1)] = (12));

} else {
var statearr_24413_24433 = state_24396__$1;
(statearr_24413_24433[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___24419,tc,fc))
;
return ((function (switch__23913__auto__,c__23969__auto___24419,tc,fc){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_24414 = [null,null,null,null,null,null,null,null,null];
(statearr_24414[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_24414[(1)] = (1));

return statearr_24414;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_24396){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24415){if((e24415 instanceof Object)){
var ex__23917__auto__ = e24415;
var statearr_24416_24434 = state_24396;
(statearr_24416_24434[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24415;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24435 = state_24396;
state_24396 = G__24435;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_24396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_24396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___24419,tc,fc))
})();
var state__23971__auto__ = (function (){var statearr_24417 = f__23970__auto__.call(null);
(statearr_24417[(6)] = c__23969__auto___24419);

return statearr_24417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___24419,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__){
return (function (state_24456){
var state_val_24457 = (state_24456[(1)]);
if((state_val_24457 === (7))){
var inst_24452 = (state_24456[(2)]);
var state_24456__$1 = state_24456;
var statearr_24458_24476 = state_24456__$1;
(statearr_24458_24476[(2)] = inst_24452);

(statearr_24458_24476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (1))){
var inst_24436 = init;
var state_24456__$1 = (function (){var statearr_24459 = state_24456;
(statearr_24459[(7)] = inst_24436);

return statearr_24459;
})();
var statearr_24460_24477 = state_24456__$1;
(statearr_24460_24477[(2)] = null);

(statearr_24460_24477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (4))){
var inst_24439 = (state_24456[(8)]);
var inst_24439__$1 = (state_24456[(2)]);
var inst_24440 = (inst_24439__$1 == null);
var state_24456__$1 = (function (){var statearr_24461 = state_24456;
(statearr_24461[(8)] = inst_24439__$1);

return statearr_24461;
})();
if(cljs.core.truth_(inst_24440)){
var statearr_24462_24478 = state_24456__$1;
(statearr_24462_24478[(1)] = (5));

} else {
var statearr_24463_24479 = state_24456__$1;
(statearr_24463_24479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (6))){
var inst_24439 = (state_24456[(8)]);
var inst_24443 = (state_24456[(9)]);
var inst_24436 = (state_24456[(7)]);
var inst_24443__$1 = f.call(null,inst_24436,inst_24439);
var inst_24444 = cljs.core.reduced_QMARK_.call(null,inst_24443__$1);
var state_24456__$1 = (function (){var statearr_24464 = state_24456;
(statearr_24464[(9)] = inst_24443__$1);

return statearr_24464;
})();
if(inst_24444){
var statearr_24465_24480 = state_24456__$1;
(statearr_24465_24480[(1)] = (8));

} else {
var statearr_24466_24481 = state_24456__$1;
(statearr_24466_24481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (3))){
var inst_24454 = (state_24456[(2)]);
var state_24456__$1 = state_24456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24456__$1,inst_24454);
} else {
if((state_val_24457 === (2))){
var state_24456__$1 = state_24456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24456__$1,(4),ch);
} else {
if((state_val_24457 === (9))){
var inst_24443 = (state_24456[(9)]);
var inst_24436 = inst_24443;
var state_24456__$1 = (function (){var statearr_24467 = state_24456;
(statearr_24467[(7)] = inst_24436);

return statearr_24467;
})();
var statearr_24468_24482 = state_24456__$1;
(statearr_24468_24482[(2)] = null);

(statearr_24468_24482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (5))){
var inst_24436 = (state_24456[(7)]);
var state_24456__$1 = state_24456;
var statearr_24469_24483 = state_24456__$1;
(statearr_24469_24483[(2)] = inst_24436);

(statearr_24469_24483[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (10))){
var inst_24450 = (state_24456[(2)]);
var state_24456__$1 = state_24456;
var statearr_24470_24484 = state_24456__$1;
(statearr_24470_24484[(2)] = inst_24450);

(statearr_24470_24484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24457 === (8))){
var inst_24443 = (state_24456[(9)]);
var inst_24446 = cljs.core.deref.call(null,inst_24443);
var state_24456__$1 = state_24456;
var statearr_24471_24485 = state_24456__$1;
(statearr_24471_24485[(2)] = inst_24446);

(statearr_24471_24485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__23914__auto__ = null;
var cljs$core$async$reduce_$_state_machine__23914__auto____0 = (function (){
var statearr_24472 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24472[(0)] = cljs$core$async$reduce_$_state_machine__23914__auto__);

(statearr_24472[(1)] = (1));

return statearr_24472;
});
var cljs$core$async$reduce_$_state_machine__23914__auto____1 = (function (state_24456){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24473){if((e24473 instanceof Object)){
var ex__23917__auto__ = e24473;
var statearr_24474_24486 = state_24456;
(statearr_24474_24486[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24473;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24487 = state_24456;
state_24456 = G__24487;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__23914__auto__ = function(state_24456){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__23914__auto____1.call(this,state_24456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__23914__auto____0;
cljs$core$async$reduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__23914__auto____1;
return cljs$core$async$reduce_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__))
})();
var state__23971__auto__ = (function (){var statearr_24475 = f__23970__auto__.call(null);
(statearr_24475[(6)] = c__23969__auto__);

return statearr_24475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__))
);

return c__23969__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__,f__$1){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__,f__$1){
return (function (state_24493){
var state_val_24494 = (state_24493[(1)]);
if((state_val_24494 === (1))){
var inst_24488 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_24493__$1 = state_24493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24493__$1,(2),inst_24488);
} else {
if((state_val_24494 === (2))){
var inst_24490 = (state_24493[(2)]);
var inst_24491 = f__$1.call(null,inst_24490);
var state_24493__$1 = state_24493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24493__$1,inst_24491);
} else {
return null;
}
}
});})(c__23969__auto__,f__$1))
;
return ((function (switch__23913__auto__,c__23969__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__23914__auto__ = null;
var cljs$core$async$transduce_$_state_machine__23914__auto____0 = (function (){
var statearr_24495 = [null,null,null,null,null,null,null];
(statearr_24495[(0)] = cljs$core$async$transduce_$_state_machine__23914__auto__);

(statearr_24495[(1)] = (1));

return statearr_24495;
});
var cljs$core$async$transduce_$_state_machine__23914__auto____1 = (function (state_24493){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24496){if((e24496 instanceof Object)){
var ex__23917__auto__ = e24496;
var statearr_24497_24499 = state_24493;
(statearr_24497_24499[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24496;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24500 = state_24493;
state_24493 = G__24500;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__23914__auto__ = function(state_24493){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__23914__auto____1.call(this,state_24493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__23914__auto____0;
cljs$core$async$transduce_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__23914__auto____1;
return cljs$core$async$transduce_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__,f__$1))
})();
var state__23971__auto__ = (function (){var statearr_24498 = f__23970__auto__.call(null);
(statearr_24498[(6)] = c__23969__auto__);

return statearr_24498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__,f__$1))
);

return c__23969__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__24502 = arguments.length;
switch (G__24502) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__){
return (function (state_24527){
var state_val_24528 = (state_24527[(1)]);
if((state_val_24528 === (7))){
var inst_24509 = (state_24527[(2)]);
var state_24527__$1 = state_24527;
var statearr_24529_24550 = state_24527__$1;
(statearr_24529_24550[(2)] = inst_24509);

(statearr_24529_24550[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (1))){
var inst_24503 = cljs.core.seq.call(null,coll);
var inst_24504 = inst_24503;
var state_24527__$1 = (function (){var statearr_24530 = state_24527;
(statearr_24530[(7)] = inst_24504);

return statearr_24530;
})();
var statearr_24531_24551 = state_24527__$1;
(statearr_24531_24551[(2)] = null);

(statearr_24531_24551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (4))){
var inst_24504 = (state_24527[(7)]);
var inst_24507 = cljs.core.first.call(null,inst_24504);
var state_24527__$1 = state_24527;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24527__$1,(7),ch,inst_24507);
} else {
if((state_val_24528 === (13))){
var inst_24521 = (state_24527[(2)]);
var state_24527__$1 = state_24527;
var statearr_24532_24552 = state_24527__$1;
(statearr_24532_24552[(2)] = inst_24521);

(statearr_24532_24552[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (6))){
var inst_24512 = (state_24527[(2)]);
var state_24527__$1 = state_24527;
if(cljs.core.truth_(inst_24512)){
var statearr_24533_24553 = state_24527__$1;
(statearr_24533_24553[(1)] = (8));

} else {
var statearr_24534_24554 = state_24527__$1;
(statearr_24534_24554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (3))){
var inst_24525 = (state_24527[(2)]);
var state_24527__$1 = state_24527;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24527__$1,inst_24525);
} else {
if((state_val_24528 === (12))){
var state_24527__$1 = state_24527;
var statearr_24535_24555 = state_24527__$1;
(statearr_24535_24555[(2)] = null);

(statearr_24535_24555[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (2))){
var inst_24504 = (state_24527[(7)]);
var state_24527__$1 = state_24527;
if(cljs.core.truth_(inst_24504)){
var statearr_24536_24556 = state_24527__$1;
(statearr_24536_24556[(1)] = (4));

} else {
var statearr_24537_24557 = state_24527__$1;
(statearr_24537_24557[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (11))){
var inst_24518 = cljs.core.async.close_BANG_.call(null,ch);
var state_24527__$1 = state_24527;
var statearr_24538_24558 = state_24527__$1;
(statearr_24538_24558[(2)] = inst_24518);

(statearr_24538_24558[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (9))){
var state_24527__$1 = state_24527;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24539_24559 = state_24527__$1;
(statearr_24539_24559[(1)] = (11));

} else {
var statearr_24540_24560 = state_24527__$1;
(statearr_24540_24560[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (5))){
var inst_24504 = (state_24527[(7)]);
var state_24527__$1 = state_24527;
var statearr_24541_24561 = state_24527__$1;
(statearr_24541_24561[(2)] = inst_24504);

(statearr_24541_24561[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (10))){
var inst_24523 = (state_24527[(2)]);
var state_24527__$1 = state_24527;
var statearr_24542_24562 = state_24527__$1;
(statearr_24542_24562[(2)] = inst_24523);

(statearr_24542_24562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24528 === (8))){
var inst_24504 = (state_24527[(7)]);
var inst_24514 = cljs.core.next.call(null,inst_24504);
var inst_24504__$1 = inst_24514;
var state_24527__$1 = (function (){var statearr_24543 = state_24527;
(statearr_24543[(7)] = inst_24504__$1);

return statearr_24543;
})();
var statearr_24544_24563 = state_24527__$1;
(statearr_24544_24563[(2)] = null);

(statearr_24544_24563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_24545 = [null,null,null,null,null,null,null,null];
(statearr_24545[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_24545[(1)] = (1));

return statearr_24545;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_24527){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24527);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24546){if((e24546 instanceof Object)){
var ex__23917__auto__ = e24546;
var statearr_24547_24564 = state_24527;
(statearr_24547_24564[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24527);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24565 = state_24527;
state_24527 = G__24565;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_24527){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_24527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__))
})();
var state__23971__auto__ = (function (){var statearr_24548 = f__23970__auto__.call(null);
(statearr_24548[(6)] = c__23969__auto__);

return statearr_24548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__))
);

return c__23969__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,_);
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24566 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24566 = (function (ch,cs,meta24567){
this.ch = ch;
this.cs = cs;
this.meta24567 = meta24567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24568,meta24567__$1){
var self__ = this;
var _24568__$1 = this;
return (new cljs.core.async.t_cljs$core$async24566(self__.ch,self__.cs,meta24567__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24568){
var self__ = this;
var _24568__$1 = this;
return self__.meta24567;
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24567","meta24567",-1725429308,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24566.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24566.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24566";

cljs.core.async.t_cljs$core$async24566.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async24566");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24566.
 */
cljs.core.async.__GT_t_cljs$core$async24566 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24566(ch__$1,cs__$1,meta24567){
return (new cljs.core.async.t_cljs$core$async24566(ch__$1,cs__$1,meta24567));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24566(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23969__auto___24788 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___24788,cs,m,dchan,dctr,done){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___24788,cs,m,dchan,dctr,done){
return (function (state_24703){
var state_val_24704 = (state_24703[(1)]);
if((state_val_24704 === (7))){
var inst_24699 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24705_24789 = state_24703__$1;
(statearr_24705_24789[(2)] = inst_24699);

(statearr_24705_24789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (20))){
var inst_24602 = (state_24703[(7)]);
var inst_24614 = cljs.core.first.call(null,inst_24602);
var inst_24615 = cljs.core.nth.call(null,inst_24614,(0),null);
var inst_24616 = cljs.core.nth.call(null,inst_24614,(1),null);
var state_24703__$1 = (function (){var statearr_24706 = state_24703;
(statearr_24706[(8)] = inst_24615);

return statearr_24706;
})();
if(cljs.core.truth_(inst_24616)){
var statearr_24707_24790 = state_24703__$1;
(statearr_24707_24790[(1)] = (22));

} else {
var statearr_24708_24791 = state_24703__$1;
(statearr_24708_24791[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (27))){
var inst_24571 = (state_24703[(9)]);
var inst_24651 = (state_24703[(10)]);
var inst_24646 = (state_24703[(11)]);
var inst_24644 = (state_24703[(12)]);
var inst_24651__$1 = cljs.core._nth.call(null,inst_24644,inst_24646);
var inst_24652 = cljs.core.async.put_BANG_.call(null,inst_24651__$1,inst_24571,done);
var state_24703__$1 = (function (){var statearr_24709 = state_24703;
(statearr_24709[(10)] = inst_24651__$1);

return statearr_24709;
})();
if(cljs.core.truth_(inst_24652)){
var statearr_24710_24792 = state_24703__$1;
(statearr_24710_24792[(1)] = (30));

} else {
var statearr_24711_24793 = state_24703__$1;
(statearr_24711_24793[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (1))){
var state_24703__$1 = state_24703;
var statearr_24712_24794 = state_24703__$1;
(statearr_24712_24794[(2)] = null);

(statearr_24712_24794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (24))){
var inst_24602 = (state_24703[(7)]);
var inst_24621 = (state_24703[(2)]);
var inst_24622 = cljs.core.next.call(null,inst_24602);
var inst_24580 = inst_24622;
var inst_24581 = null;
var inst_24582 = (0);
var inst_24583 = (0);
var state_24703__$1 = (function (){var statearr_24713 = state_24703;
(statearr_24713[(13)] = inst_24581);

(statearr_24713[(14)] = inst_24583);

(statearr_24713[(15)] = inst_24621);

(statearr_24713[(16)] = inst_24580);

(statearr_24713[(17)] = inst_24582);

return statearr_24713;
})();
var statearr_24714_24795 = state_24703__$1;
(statearr_24714_24795[(2)] = null);

(statearr_24714_24795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (39))){
var state_24703__$1 = state_24703;
var statearr_24718_24796 = state_24703__$1;
(statearr_24718_24796[(2)] = null);

(statearr_24718_24796[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (4))){
var inst_24571 = (state_24703[(9)]);
var inst_24571__$1 = (state_24703[(2)]);
var inst_24572 = (inst_24571__$1 == null);
var state_24703__$1 = (function (){var statearr_24719 = state_24703;
(statearr_24719[(9)] = inst_24571__$1);

return statearr_24719;
})();
if(cljs.core.truth_(inst_24572)){
var statearr_24720_24797 = state_24703__$1;
(statearr_24720_24797[(1)] = (5));

} else {
var statearr_24721_24798 = state_24703__$1;
(statearr_24721_24798[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (15))){
var inst_24581 = (state_24703[(13)]);
var inst_24583 = (state_24703[(14)]);
var inst_24580 = (state_24703[(16)]);
var inst_24582 = (state_24703[(17)]);
var inst_24598 = (state_24703[(2)]);
var inst_24599 = (inst_24583 + (1));
var tmp24715 = inst_24581;
var tmp24716 = inst_24580;
var tmp24717 = inst_24582;
var inst_24580__$1 = tmp24716;
var inst_24581__$1 = tmp24715;
var inst_24582__$1 = tmp24717;
var inst_24583__$1 = inst_24599;
var state_24703__$1 = (function (){var statearr_24722 = state_24703;
(statearr_24722[(13)] = inst_24581__$1);

(statearr_24722[(18)] = inst_24598);

(statearr_24722[(14)] = inst_24583__$1);

(statearr_24722[(16)] = inst_24580__$1);

(statearr_24722[(17)] = inst_24582__$1);

return statearr_24722;
})();
var statearr_24723_24799 = state_24703__$1;
(statearr_24723_24799[(2)] = null);

(statearr_24723_24799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (21))){
var inst_24625 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24727_24800 = state_24703__$1;
(statearr_24727_24800[(2)] = inst_24625);

(statearr_24727_24800[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (31))){
var inst_24651 = (state_24703[(10)]);
var inst_24655 = done.call(null,null);
var inst_24656 = cljs.core.async.untap_STAR_.call(null,m,inst_24651);
var state_24703__$1 = (function (){var statearr_24728 = state_24703;
(statearr_24728[(19)] = inst_24655);

return statearr_24728;
})();
var statearr_24729_24801 = state_24703__$1;
(statearr_24729_24801[(2)] = inst_24656);

(statearr_24729_24801[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (32))){
var inst_24645 = (state_24703[(20)]);
var inst_24646 = (state_24703[(11)]);
var inst_24644 = (state_24703[(12)]);
var inst_24643 = (state_24703[(21)]);
var inst_24658 = (state_24703[(2)]);
var inst_24659 = (inst_24646 + (1));
var tmp24724 = inst_24645;
var tmp24725 = inst_24644;
var tmp24726 = inst_24643;
var inst_24643__$1 = tmp24726;
var inst_24644__$1 = tmp24725;
var inst_24645__$1 = tmp24724;
var inst_24646__$1 = inst_24659;
var state_24703__$1 = (function (){var statearr_24730 = state_24703;
(statearr_24730[(20)] = inst_24645__$1);

(statearr_24730[(11)] = inst_24646__$1);

(statearr_24730[(12)] = inst_24644__$1);

(statearr_24730[(21)] = inst_24643__$1);

(statearr_24730[(22)] = inst_24658);

return statearr_24730;
})();
var statearr_24731_24802 = state_24703__$1;
(statearr_24731_24802[(2)] = null);

(statearr_24731_24802[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (40))){
var inst_24671 = (state_24703[(23)]);
var inst_24675 = done.call(null,null);
var inst_24676 = cljs.core.async.untap_STAR_.call(null,m,inst_24671);
var state_24703__$1 = (function (){var statearr_24732 = state_24703;
(statearr_24732[(24)] = inst_24675);

return statearr_24732;
})();
var statearr_24733_24803 = state_24703__$1;
(statearr_24733_24803[(2)] = inst_24676);

(statearr_24733_24803[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (33))){
var inst_24662 = (state_24703[(25)]);
var inst_24664 = cljs.core.chunked_seq_QMARK_.call(null,inst_24662);
var state_24703__$1 = state_24703;
if(inst_24664){
var statearr_24734_24804 = state_24703__$1;
(statearr_24734_24804[(1)] = (36));

} else {
var statearr_24735_24805 = state_24703__$1;
(statearr_24735_24805[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (13))){
var inst_24592 = (state_24703[(26)]);
var inst_24595 = cljs.core.async.close_BANG_.call(null,inst_24592);
var state_24703__$1 = state_24703;
var statearr_24736_24806 = state_24703__$1;
(statearr_24736_24806[(2)] = inst_24595);

(statearr_24736_24806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (22))){
var inst_24615 = (state_24703[(8)]);
var inst_24618 = cljs.core.async.close_BANG_.call(null,inst_24615);
var state_24703__$1 = state_24703;
var statearr_24737_24807 = state_24703__$1;
(statearr_24737_24807[(2)] = inst_24618);

(statearr_24737_24807[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (36))){
var inst_24662 = (state_24703[(25)]);
var inst_24666 = cljs.core.chunk_first.call(null,inst_24662);
var inst_24667 = cljs.core.chunk_rest.call(null,inst_24662);
var inst_24668 = cljs.core.count.call(null,inst_24666);
var inst_24643 = inst_24667;
var inst_24644 = inst_24666;
var inst_24645 = inst_24668;
var inst_24646 = (0);
var state_24703__$1 = (function (){var statearr_24738 = state_24703;
(statearr_24738[(20)] = inst_24645);

(statearr_24738[(11)] = inst_24646);

(statearr_24738[(12)] = inst_24644);

(statearr_24738[(21)] = inst_24643);

return statearr_24738;
})();
var statearr_24739_24808 = state_24703__$1;
(statearr_24739_24808[(2)] = null);

(statearr_24739_24808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (41))){
var inst_24662 = (state_24703[(25)]);
var inst_24678 = (state_24703[(2)]);
var inst_24679 = cljs.core.next.call(null,inst_24662);
var inst_24643 = inst_24679;
var inst_24644 = null;
var inst_24645 = (0);
var inst_24646 = (0);
var state_24703__$1 = (function (){var statearr_24740 = state_24703;
(statearr_24740[(27)] = inst_24678);

(statearr_24740[(20)] = inst_24645);

(statearr_24740[(11)] = inst_24646);

(statearr_24740[(12)] = inst_24644);

(statearr_24740[(21)] = inst_24643);

return statearr_24740;
})();
var statearr_24741_24809 = state_24703__$1;
(statearr_24741_24809[(2)] = null);

(statearr_24741_24809[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (43))){
var state_24703__$1 = state_24703;
var statearr_24742_24810 = state_24703__$1;
(statearr_24742_24810[(2)] = null);

(statearr_24742_24810[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (29))){
var inst_24687 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24743_24811 = state_24703__$1;
(statearr_24743_24811[(2)] = inst_24687);

(statearr_24743_24811[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (44))){
var inst_24696 = (state_24703[(2)]);
var state_24703__$1 = (function (){var statearr_24744 = state_24703;
(statearr_24744[(28)] = inst_24696);

return statearr_24744;
})();
var statearr_24745_24812 = state_24703__$1;
(statearr_24745_24812[(2)] = null);

(statearr_24745_24812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (6))){
var inst_24635 = (state_24703[(29)]);
var inst_24634 = cljs.core.deref.call(null,cs);
var inst_24635__$1 = cljs.core.keys.call(null,inst_24634);
var inst_24636 = cljs.core.count.call(null,inst_24635__$1);
var inst_24637 = cljs.core.reset_BANG_.call(null,dctr,inst_24636);
var inst_24642 = cljs.core.seq.call(null,inst_24635__$1);
var inst_24643 = inst_24642;
var inst_24644 = null;
var inst_24645 = (0);
var inst_24646 = (0);
var state_24703__$1 = (function (){var statearr_24746 = state_24703;
(statearr_24746[(20)] = inst_24645);

(statearr_24746[(30)] = inst_24637);

(statearr_24746[(11)] = inst_24646);

(statearr_24746[(12)] = inst_24644);

(statearr_24746[(21)] = inst_24643);

(statearr_24746[(29)] = inst_24635__$1);

return statearr_24746;
})();
var statearr_24747_24813 = state_24703__$1;
(statearr_24747_24813[(2)] = null);

(statearr_24747_24813[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (28))){
var inst_24662 = (state_24703[(25)]);
var inst_24643 = (state_24703[(21)]);
var inst_24662__$1 = cljs.core.seq.call(null,inst_24643);
var state_24703__$1 = (function (){var statearr_24748 = state_24703;
(statearr_24748[(25)] = inst_24662__$1);

return statearr_24748;
})();
if(inst_24662__$1){
var statearr_24749_24814 = state_24703__$1;
(statearr_24749_24814[(1)] = (33));

} else {
var statearr_24750_24815 = state_24703__$1;
(statearr_24750_24815[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (25))){
var inst_24645 = (state_24703[(20)]);
var inst_24646 = (state_24703[(11)]);
var inst_24648 = (inst_24646 < inst_24645);
var inst_24649 = inst_24648;
var state_24703__$1 = state_24703;
if(cljs.core.truth_(inst_24649)){
var statearr_24751_24816 = state_24703__$1;
(statearr_24751_24816[(1)] = (27));

} else {
var statearr_24752_24817 = state_24703__$1;
(statearr_24752_24817[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (34))){
var state_24703__$1 = state_24703;
var statearr_24753_24818 = state_24703__$1;
(statearr_24753_24818[(2)] = null);

(statearr_24753_24818[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (17))){
var state_24703__$1 = state_24703;
var statearr_24754_24819 = state_24703__$1;
(statearr_24754_24819[(2)] = null);

(statearr_24754_24819[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (3))){
var inst_24701 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24703__$1,inst_24701);
} else {
if((state_val_24704 === (12))){
var inst_24630 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24755_24820 = state_24703__$1;
(statearr_24755_24820[(2)] = inst_24630);

(statearr_24755_24820[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (2))){
var state_24703__$1 = state_24703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24703__$1,(4),ch);
} else {
if((state_val_24704 === (23))){
var state_24703__$1 = state_24703;
var statearr_24756_24821 = state_24703__$1;
(statearr_24756_24821[(2)] = null);

(statearr_24756_24821[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (35))){
var inst_24685 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24757_24822 = state_24703__$1;
(statearr_24757_24822[(2)] = inst_24685);

(statearr_24757_24822[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (19))){
var inst_24602 = (state_24703[(7)]);
var inst_24606 = cljs.core.chunk_first.call(null,inst_24602);
var inst_24607 = cljs.core.chunk_rest.call(null,inst_24602);
var inst_24608 = cljs.core.count.call(null,inst_24606);
var inst_24580 = inst_24607;
var inst_24581 = inst_24606;
var inst_24582 = inst_24608;
var inst_24583 = (0);
var state_24703__$1 = (function (){var statearr_24758 = state_24703;
(statearr_24758[(13)] = inst_24581);

(statearr_24758[(14)] = inst_24583);

(statearr_24758[(16)] = inst_24580);

(statearr_24758[(17)] = inst_24582);

return statearr_24758;
})();
var statearr_24759_24823 = state_24703__$1;
(statearr_24759_24823[(2)] = null);

(statearr_24759_24823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (11))){
var inst_24602 = (state_24703[(7)]);
var inst_24580 = (state_24703[(16)]);
var inst_24602__$1 = cljs.core.seq.call(null,inst_24580);
var state_24703__$1 = (function (){var statearr_24760 = state_24703;
(statearr_24760[(7)] = inst_24602__$1);

return statearr_24760;
})();
if(inst_24602__$1){
var statearr_24761_24824 = state_24703__$1;
(statearr_24761_24824[(1)] = (16));

} else {
var statearr_24762_24825 = state_24703__$1;
(statearr_24762_24825[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (9))){
var inst_24632 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24763_24826 = state_24703__$1;
(statearr_24763_24826[(2)] = inst_24632);

(statearr_24763_24826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (5))){
var inst_24578 = cljs.core.deref.call(null,cs);
var inst_24579 = cljs.core.seq.call(null,inst_24578);
var inst_24580 = inst_24579;
var inst_24581 = null;
var inst_24582 = (0);
var inst_24583 = (0);
var state_24703__$1 = (function (){var statearr_24764 = state_24703;
(statearr_24764[(13)] = inst_24581);

(statearr_24764[(14)] = inst_24583);

(statearr_24764[(16)] = inst_24580);

(statearr_24764[(17)] = inst_24582);

return statearr_24764;
})();
var statearr_24765_24827 = state_24703__$1;
(statearr_24765_24827[(2)] = null);

(statearr_24765_24827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (14))){
var state_24703__$1 = state_24703;
var statearr_24766_24828 = state_24703__$1;
(statearr_24766_24828[(2)] = null);

(statearr_24766_24828[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (45))){
var inst_24693 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24767_24829 = state_24703__$1;
(statearr_24767_24829[(2)] = inst_24693);

(statearr_24767_24829[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (26))){
var inst_24635 = (state_24703[(29)]);
var inst_24689 = (state_24703[(2)]);
var inst_24690 = cljs.core.seq.call(null,inst_24635);
var state_24703__$1 = (function (){var statearr_24768 = state_24703;
(statearr_24768[(31)] = inst_24689);

return statearr_24768;
})();
if(inst_24690){
var statearr_24769_24830 = state_24703__$1;
(statearr_24769_24830[(1)] = (42));

} else {
var statearr_24770_24831 = state_24703__$1;
(statearr_24770_24831[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (16))){
var inst_24602 = (state_24703[(7)]);
var inst_24604 = cljs.core.chunked_seq_QMARK_.call(null,inst_24602);
var state_24703__$1 = state_24703;
if(inst_24604){
var statearr_24771_24832 = state_24703__$1;
(statearr_24771_24832[(1)] = (19));

} else {
var statearr_24772_24833 = state_24703__$1;
(statearr_24772_24833[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (38))){
var inst_24682 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24773_24834 = state_24703__$1;
(statearr_24773_24834[(2)] = inst_24682);

(statearr_24773_24834[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (30))){
var state_24703__$1 = state_24703;
var statearr_24774_24835 = state_24703__$1;
(statearr_24774_24835[(2)] = null);

(statearr_24774_24835[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (10))){
var inst_24581 = (state_24703[(13)]);
var inst_24583 = (state_24703[(14)]);
var inst_24591 = cljs.core._nth.call(null,inst_24581,inst_24583);
var inst_24592 = cljs.core.nth.call(null,inst_24591,(0),null);
var inst_24593 = cljs.core.nth.call(null,inst_24591,(1),null);
var state_24703__$1 = (function (){var statearr_24775 = state_24703;
(statearr_24775[(26)] = inst_24592);

return statearr_24775;
})();
if(cljs.core.truth_(inst_24593)){
var statearr_24776_24836 = state_24703__$1;
(statearr_24776_24836[(1)] = (13));

} else {
var statearr_24777_24837 = state_24703__$1;
(statearr_24777_24837[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (18))){
var inst_24628 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24778_24838 = state_24703__$1;
(statearr_24778_24838[(2)] = inst_24628);

(statearr_24778_24838[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (42))){
var state_24703__$1 = state_24703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24703__$1,(45),dchan);
} else {
if((state_val_24704 === (37))){
var inst_24571 = (state_24703[(9)]);
var inst_24671 = (state_24703[(23)]);
var inst_24662 = (state_24703[(25)]);
var inst_24671__$1 = cljs.core.first.call(null,inst_24662);
var inst_24672 = cljs.core.async.put_BANG_.call(null,inst_24671__$1,inst_24571,done);
var state_24703__$1 = (function (){var statearr_24779 = state_24703;
(statearr_24779[(23)] = inst_24671__$1);

return statearr_24779;
})();
if(cljs.core.truth_(inst_24672)){
var statearr_24780_24839 = state_24703__$1;
(statearr_24780_24839[(1)] = (39));

} else {
var statearr_24781_24840 = state_24703__$1;
(statearr_24781_24840[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (8))){
var inst_24583 = (state_24703[(14)]);
var inst_24582 = (state_24703[(17)]);
var inst_24585 = (inst_24583 < inst_24582);
var inst_24586 = inst_24585;
var state_24703__$1 = state_24703;
if(cljs.core.truth_(inst_24586)){
var statearr_24782_24841 = state_24703__$1;
(statearr_24782_24841[(1)] = (10));

} else {
var statearr_24783_24842 = state_24703__$1;
(statearr_24783_24842[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___24788,cs,m,dchan,dctr,done))
;
return ((function (switch__23913__auto__,c__23969__auto___24788,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__23914__auto__ = null;
var cljs$core$async$mult_$_state_machine__23914__auto____0 = (function (){
var statearr_24784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24784[(0)] = cljs$core$async$mult_$_state_machine__23914__auto__);

(statearr_24784[(1)] = (1));

return statearr_24784;
});
var cljs$core$async$mult_$_state_machine__23914__auto____1 = (function (state_24703){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e24785){if((e24785 instanceof Object)){
var ex__23917__auto__ = e24785;
var statearr_24786_24843 = state_24703;
(statearr_24786_24843[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24703);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24785;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24844 = state_24703;
state_24703 = G__24844;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__23914__auto__ = function(state_24703){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__23914__auto____1.call(this,state_24703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__23914__auto____0;
cljs$core$async$mult_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__23914__auto____1;
return cljs$core$async$mult_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___24788,cs,m,dchan,dctr,done))
})();
var state__23971__auto__ = (function (){var statearr_24787 = f__23970__auto__.call(null);
(statearr_24787[(6)] = c__23969__auto___24788);

return statearr_24787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___24788,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__24846 = arguments.length;
switch (G__24846) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,state_map);
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,mode);
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___24858 = arguments.length;
var i__4532__auto___24859 = (0);
while(true){
if((i__4532__auto___24859 < len__4531__auto___24858)){
args__4534__auto__.push((arguments[i__4532__auto___24859]));

var G__24860 = (i__4532__auto___24859 + (1));
i__4532__auto___24859 = G__24860;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24852){
var map__24853 = p__24852;
var map__24853__$1 = ((((!((map__24853 == null)))?(((((map__24853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24853):map__24853);
var opts = map__24853__$1;
var statearr_24855_24861 = state;
(statearr_24855_24861[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__24853,map__24853__$1,opts){
return (function (val){
var statearr_24856_24862 = state;
(statearr_24856_24862[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__24853,map__24853__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_24857_24863 = state;
(statearr_24857_24863[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24848){
var G__24849 = cljs.core.first.call(null,seq24848);
var seq24848__$1 = cljs.core.next.call(null,seq24848);
var G__24850 = cljs.core.first.call(null,seq24848__$1);
var seq24848__$2 = cljs.core.next.call(null,seq24848__$1);
var G__24851 = cljs.core.first.call(null,seq24848__$2);
var seq24848__$3 = cljs.core.next.call(null,seq24848__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24849,G__24850,G__24851,seq24848__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24864 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24864 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24865){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24865 = meta24865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24866,meta24865__$1){
var self__ = this;
var _24866__$1 = this;
return (new cljs.core.async.t_cljs$core$async24864(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24865__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24866){
var self__ = this;
var _24866__$1 = this;
return self__.meta24865;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24865","meta24865",1194735610,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24864.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24864.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24864";

cljs.core.async.t_cljs$core$async24864.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async24864");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24864.
 */
cljs.core.async.__GT_t_cljs$core$async24864 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24864(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24865){
return (new cljs.core.async.t_cljs$core$async24864(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24865));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24864(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23969__auto___25028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24968){
var state_val_24969 = (state_24968[(1)]);
if((state_val_24969 === (7))){
var inst_24883 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
var statearr_24970_25029 = state_24968__$1;
(statearr_24970_25029[(2)] = inst_24883);

(statearr_24970_25029[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (20))){
var inst_24895 = (state_24968[(7)]);
var state_24968__$1 = state_24968;
var statearr_24971_25030 = state_24968__$1;
(statearr_24971_25030[(2)] = inst_24895);

(statearr_24971_25030[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (27))){
var state_24968__$1 = state_24968;
var statearr_24972_25031 = state_24968__$1;
(statearr_24972_25031[(2)] = null);

(statearr_24972_25031[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (1))){
var inst_24870 = (state_24968[(8)]);
var inst_24870__$1 = calc_state.call(null);
var inst_24872 = (inst_24870__$1 == null);
var inst_24873 = cljs.core.not.call(null,inst_24872);
var state_24968__$1 = (function (){var statearr_24973 = state_24968;
(statearr_24973[(8)] = inst_24870__$1);

return statearr_24973;
})();
if(inst_24873){
var statearr_24974_25032 = state_24968__$1;
(statearr_24974_25032[(1)] = (2));

} else {
var statearr_24975_25033 = state_24968__$1;
(statearr_24975_25033[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (24))){
var inst_24928 = (state_24968[(9)]);
var inst_24919 = (state_24968[(10)]);
var inst_24942 = (state_24968[(11)]);
var inst_24942__$1 = inst_24919.call(null,inst_24928);
var state_24968__$1 = (function (){var statearr_24976 = state_24968;
(statearr_24976[(11)] = inst_24942__$1);

return statearr_24976;
})();
if(cljs.core.truth_(inst_24942__$1)){
var statearr_24977_25034 = state_24968__$1;
(statearr_24977_25034[(1)] = (29));

} else {
var statearr_24978_25035 = state_24968__$1;
(statearr_24978_25035[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (4))){
var inst_24886 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24886)){
var statearr_24979_25036 = state_24968__$1;
(statearr_24979_25036[(1)] = (8));

} else {
var statearr_24980_25037 = state_24968__$1;
(statearr_24980_25037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (15))){
var inst_24913 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24913)){
var statearr_24981_25038 = state_24968__$1;
(statearr_24981_25038[(1)] = (19));

} else {
var statearr_24982_25039 = state_24968__$1;
(statearr_24982_25039[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (21))){
var inst_24918 = (state_24968[(12)]);
var inst_24918__$1 = (state_24968[(2)]);
var inst_24919 = cljs.core.get.call(null,inst_24918__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24920 = cljs.core.get.call(null,inst_24918__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24921 = cljs.core.get.call(null,inst_24918__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24968__$1 = (function (){var statearr_24983 = state_24968;
(statearr_24983[(12)] = inst_24918__$1);

(statearr_24983[(10)] = inst_24919);

(statearr_24983[(13)] = inst_24920);

return statearr_24983;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24968__$1,(22),inst_24921);
} else {
if((state_val_24969 === (31))){
var inst_24950 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24950)){
var statearr_24984_25040 = state_24968__$1;
(statearr_24984_25040[(1)] = (32));

} else {
var statearr_24985_25041 = state_24968__$1;
(statearr_24985_25041[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (32))){
var inst_24927 = (state_24968[(14)]);
var state_24968__$1 = state_24968;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24968__$1,(35),out,inst_24927);
} else {
if((state_val_24969 === (33))){
var inst_24918 = (state_24968[(12)]);
var inst_24895 = inst_24918;
var state_24968__$1 = (function (){var statearr_24986 = state_24968;
(statearr_24986[(7)] = inst_24895);

return statearr_24986;
})();
var statearr_24987_25042 = state_24968__$1;
(statearr_24987_25042[(2)] = null);

(statearr_24987_25042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (13))){
var inst_24895 = (state_24968[(7)]);
var inst_24902 = inst_24895.cljs$lang$protocol_mask$partition0$;
var inst_24903 = (inst_24902 & (64));
var inst_24904 = inst_24895.cljs$core$ISeq$;
var inst_24905 = (cljs.core.PROTOCOL_SENTINEL === inst_24904);
var inst_24906 = ((inst_24903) || (inst_24905));
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24906)){
var statearr_24988_25043 = state_24968__$1;
(statearr_24988_25043[(1)] = (16));

} else {
var statearr_24989_25044 = state_24968__$1;
(statearr_24989_25044[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (22))){
var inst_24928 = (state_24968[(9)]);
var inst_24927 = (state_24968[(14)]);
var inst_24926 = (state_24968[(2)]);
var inst_24927__$1 = cljs.core.nth.call(null,inst_24926,(0),null);
var inst_24928__$1 = cljs.core.nth.call(null,inst_24926,(1),null);
var inst_24929 = (inst_24927__$1 == null);
var inst_24930 = cljs.core._EQ_.call(null,inst_24928__$1,change);
var inst_24931 = ((inst_24929) || (inst_24930));
var state_24968__$1 = (function (){var statearr_24990 = state_24968;
(statearr_24990[(9)] = inst_24928__$1);

(statearr_24990[(14)] = inst_24927__$1);

return statearr_24990;
})();
if(cljs.core.truth_(inst_24931)){
var statearr_24991_25045 = state_24968__$1;
(statearr_24991_25045[(1)] = (23));

} else {
var statearr_24992_25046 = state_24968__$1;
(statearr_24992_25046[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (36))){
var inst_24918 = (state_24968[(12)]);
var inst_24895 = inst_24918;
var state_24968__$1 = (function (){var statearr_24993 = state_24968;
(statearr_24993[(7)] = inst_24895);

return statearr_24993;
})();
var statearr_24994_25047 = state_24968__$1;
(statearr_24994_25047[(2)] = null);

(statearr_24994_25047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (29))){
var inst_24942 = (state_24968[(11)]);
var state_24968__$1 = state_24968;
var statearr_24995_25048 = state_24968__$1;
(statearr_24995_25048[(2)] = inst_24942);

(statearr_24995_25048[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (6))){
var state_24968__$1 = state_24968;
var statearr_24996_25049 = state_24968__$1;
(statearr_24996_25049[(2)] = false);

(statearr_24996_25049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (28))){
var inst_24938 = (state_24968[(2)]);
var inst_24939 = calc_state.call(null);
var inst_24895 = inst_24939;
var state_24968__$1 = (function (){var statearr_24997 = state_24968;
(statearr_24997[(7)] = inst_24895);

(statearr_24997[(15)] = inst_24938);

return statearr_24997;
})();
var statearr_24998_25050 = state_24968__$1;
(statearr_24998_25050[(2)] = null);

(statearr_24998_25050[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (25))){
var inst_24964 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
var statearr_24999_25051 = state_24968__$1;
(statearr_24999_25051[(2)] = inst_24964);

(statearr_24999_25051[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (34))){
var inst_24962 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
var statearr_25000_25052 = state_24968__$1;
(statearr_25000_25052[(2)] = inst_24962);

(statearr_25000_25052[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (17))){
var state_24968__$1 = state_24968;
var statearr_25001_25053 = state_24968__$1;
(statearr_25001_25053[(2)] = false);

(statearr_25001_25053[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (3))){
var state_24968__$1 = state_24968;
var statearr_25002_25054 = state_24968__$1;
(statearr_25002_25054[(2)] = false);

(statearr_25002_25054[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (12))){
var inst_24966 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24968__$1,inst_24966);
} else {
if((state_val_24969 === (2))){
var inst_24870 = (state_24968[(8)]);
var inst_24875 = inst_24870.cljs$lang$protocol_mask$partition0$;
var inst_24876 = (inst_24875 & (64));
var inst_24877 = inst_24870.cljs$core$ISeq$;
var inst_24878 = (cljs.core.PROTOCOL_SENTINEL === inst_24877);
var inst_24879 = ((inst_24876) || (inst_24878));
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24879)){
var statearr_25003_25055 = state_24968__$1;
(statearr_25003_25055[(1)] = (5));

} else {
var statearr_25004_25056 = state_24968__$1;
(statearr_25004_25056[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (23))){
var inst_24927 = (state_24968[(14)]);
var inst_24933 = (inst_24927 == null);
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24933)){
var statearr_25005_25057 = state_24968__$1;
(statearr_25005_25057[(1)] = (26));

} else {
var statearr_25006_25058 = state_24968__$1;
(statearr_25006_25058[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (35))){
var inst_24953 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
if(cljs.core.truth_(inst_24953)){
var statearr_25007_25059 = state_24968__$1;
(statearr_25007_25059[(1)] = (36));

} else {
var statearr_25008_25060 = state_24968__$1;
(statearr_25008_25060[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (19))){
var inst_24895 = (state_24968[(7)]);
var inst_24915 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24895);
var state_24968__$1 = state_24968;
var statearr_25009_25061 = state_24968__$1;
(statearr_25009_25061[(2)] = inst_24915);

(statearr_25009_25061[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (11))){
var inst_24895 = (state_24968[(7)]);
var inst_24899 = (inst_24895 == null);
var inst_24900 = cljs.core.not.call(null,inst_24899);
var state_24968__$1 = state_24968;
if(inst_24900){
var statearr_25010_25062 = state_24968__$1;
(statearr_25010_25062[(1)] = (13));

} else {
var statearr_25011_25063 = state_24968__$1;
(statearr_25011_25063[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (9))){
var inst_24870 = (state_24968[(8)]);
var state_24968__$1 = state_24968;
var statearr_25012_25064 = state_24968__$1;
(statearr_25012_25064[(2)] = inst_24870);

(statearr_25012_25064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (5))){
var state_24968__$1 = state_24968;
var statearr_25013_25065 = state_24968__$1;
(statearr_25013_25065[(2)] = true);

(statearr_25013_25065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (14))){
var state_24968__$1 = state_24968;
var statearr_25014_25066 = state_24968__$1;
(statearr_25014_25066[(2)] = false);

(statearr_25014_25066[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (26))){
var inst_24928 = (state_24968[(9)]);
var inst_24935 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24928);
var state_24968__$1 = state_24968;
var statearr_25015_25067 = state_24968__$1;
(statearr_25015_25067[(2)] = inst_24935);

(statearr_25015_25067[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (16))){
var state_24968__$1 = state_24968;
var statearr_25016_25068 = state_24968__$1;
(statearr_25016_25068[(2)] = true);

(statearr_25016_25068[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (38))){
var inst_24958 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
var statearr_25017_25069 = state_24968__$1;
(statearr_25017_25069[(2)] = inst_24958);

(statearr_25017_25069[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (30))){
var inst_24928 = (state_24968[(9)]);
var inst_24919 = (state_24968[(10)]);
var inst_24920 = (state_24968[(13)]);
var inst_24945 = cljs.core.empty_QMARK_.call(null,inst_24919);
var inst_24946 = inst_24920.call(null,inst_24928);
var inst_24947 = cljs.core.not.call(null,inst_24946);
var inst_24948 = ((inst_24945) && (inst_24947));
var state_24968__$1 = state_24968;
var statearr_25018_25070 = state_24968__$1;
(statearr_25018_25070[(2)] = inst_24948);

(statearr_25018_25070[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (10))){
var inst_24870 = (state_24968[(8)]);
var inst_24891 = (state_24968[(2)]);
var inst_24892 = cljs.core.get.call(null,inst_24891,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24893 = cljs.core.get.call(null,inst_24891,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24894 = cljs.core.get.call(null,inst_24891,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24895 = inst_24870;
var state_24968__$1 = (function (){var statearr_25019 = state_24968;
(statearr_25019[(16)] = inst_24894);

(statearr_25019[(17)] = inst_24893);

(statearr_25019[(18)] = inst_24892);

(statearr_25019[(7)] = inst_24895);

return statearr_25019;
})();
var statearr_25020_25071 = state_24968__$1;
(statearr_25020_25071[(2)] = null);

(statearr_25020_25071[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (18))){
var inst_24910 = (state_24968[(2)]);
var state_24968__$1 = state_24968;
var statearr_25021_25072 = state_24968__$1;
(statearr_25021_25072[(2)] = inst_24910);

(statearr_25021_25072[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (37))){
var state_24968__$1 = state_24968;
var statearr_25022_25073 = state_24968__$1;
(statearr_25022_25073[(2)] = null);

(statearr_25022_25073[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24969 === (8))){
var inst_24870 = (state_24968[(8)]);
var inst_24888 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24870);
var state_24968__$1 = state_24968;
var statearr_25023_25074 = state_24968__$1;
(statearr_25023_25074[(2)] = inst_24888);

(statearr_25023_25074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__23913__auto__,c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__23914__auto__ = null;
var cljs$core$async$mix_$_state_machine__23914__auto____0 = (function (){
var statearr_25024 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25024[(0)] = cljs$core$async$mix_$_state_machine__23914__auto__);

(statearr_25024[(1)] = (1));

return statearr_25024;
});
var cljs$core$async$mix_$_state_machine__23914__auto____1 = (function (state_24968){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_24968);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25025){if((e25025 instanceof Object)){
var ex__23917__auto__ = e25025;
var statearr_25026_25075 = state_24968;
(statearr_25026_25075[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24968);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25025;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25076 = state_24968;
state_24968 = G__25076;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__23914__auto__ = function(state_24968){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__23914__auto____1.call(this,state_24968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__23914__auto____0;
cljs$core$async$mix_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__23914__auto____1;
return cljs$core$async$mix_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23971__auto__ = (function (){var statearr_25027 = f__23970__auto__.call(null);
(statearr_25027[(6)] = c__23969__auto___25028);

return statearr_25027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25028,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__25078 = arguments.length;
switch (G__25078) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__25082 = arguments.length;
switch (G__25082) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3949__auto__,mults){
return (function (p1__25080_SHARP_){
if(cljs.core.truth_(p1__25080_SHARP_.call(null,topic))){
return p1__25080_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__25080_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25083 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25083 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25084){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25084 = meta25084;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_25085,meta25084__$1){
var self__ = this;
var _25085__$1 = this;
return (new cljs.core.async.t_cljs$core$async25083(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25084__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_25085){
var self__ = this;
var _25085__$1 = this;
return self__.meta25084;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta25084","meta25084",392537370,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25083.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25083.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25083";

cljs.core.async.t_cljs$core$async25083.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25083");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25083.
 */
cljs.core.async.__GT_t_cljs$core$async25083 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async25083(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25084){
return (new cljs.core.async.t_cljs$core$async25083(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25084));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async25083(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23969__auto___25203 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25203,mults,ensure_mult,p){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25203,mults,ensure_mult,p){
return (function (state_25157){
var state_val_25158 = (state_25157[(1)]);
if((state_val_25158 === (7))){
var inst_25153 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25159_25204 = state_25157__$1;
(statearr_25159_25204[(2)] = inst_25153);

(statearr_25159_25204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (20))){
var state_25157__$1 = state_25157;
var statearr_25160_25205 = state_25157__$1;
(statearr_25160_25205[(2)] = null);

(statearr_25160_25205[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (1))){
var state_25157__$1 = state_25157;
var statearr_25161_25206 = state_25157__$1;
(statearr_25161_25206[(2)] = null);

(statearr_25161_25206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (24))){
var inst_25136 = (state_25157[(7)]);
var inst_25145 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_25136);
var state_25157__$1 = state_25157;
var statearr_25162_25207 = state_25157__$1;
(statearr_25162_25207[(2)] = inst_25145);

(statearr_25162_25207[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (4))){
var inst_25088 = (state_25157[(8)]);
var inst_25088__$1 = (state_25157[(2)]);
var inst_25089 = (inst_25088__$1 == null);
var state_25157__$1 = (function (){var statearr_25163 = state_25157;
(statearr_25163[(8)] = inst_25088__$1);

return statearr_25163;
})();
if(cljs.core.truth_(inst_25089)){
var statearr_25164_25208 = state_25157__$1;
(statearr_25164_25208[(1)] = (5));

} else {
var statearr_25165_25209 = state_25157__$1;
(statearr_25165_25209[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (15))){
var inst_25130 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25166_25210 = state_25157__$1;
(statearr_25166_25210[(2)] = inst_25130);

(statearr_25166_25210[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (21))){
var inst_25150 = (state_25157[(2)]);
var state_25157__$1 = (function (){var statearr_25167 = state_25157;
(statearr_25167[(9)] = inst_25150);

return statearr_25167;
})();
var statearr_25168_25211 = state_25157__$1;
(statearr_25168_25211[(2)] = null);

(statearr_25168_25211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (13))){
var inst_25112 = (state_25157[(10)]);
var inst_25114 = cljs.core.chunked_seq_QMARK_.call(null,inst_25112);
var state_25157__$1 = state_25157;
if(inst_25114){
var statearr_25169_25212 = state_25157__$1;
(statearr_25169_25212[(1)] = (16));

} else {
var statearr_25170_25213 = state_25157__$1;
(statearr_25170_25213[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (22))){
var inst_25142 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
if(cljs.core.truth_(inst_25142)){
var statearr_25171_25214 = state_25157__$1;
(statearr_25171_25214[(1)] = (23));

} else {
var statearr_25172_25215 = state_25157__$1;
(statearr_25172_25215[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (6))){
var inst_25138 = (state_25157[(11)]);
var inst_25088 = (state_25157[(8)]);
var inst_25136 = (state_25157[(7)]);
var inst_25136__$1 = topic_fn.call(null,inst_25088);
var inst_25137 = cljs.core.deref.call(null,mults);
var inst_25138__$1 = cljs.core.get.call(null,inst_25137,inst_25136__$1);
var state_25157__$1 = (function (){var statearr_25173 = state_25157;
(statearr_25173[(11)] = inst_25138__$1);

(statearr_25173[(7)] = inst_25136__$1);

return statearr_25173;
})();
if(cljs.core.truth_(inst_25138__$1)){
var statearr_25174_25216 = state_25157__$1;
(statearr_25174_25216[(1)] = (19));

} else {
var statearr_25175_25217 = state_25157__$1;
(statearr_25175_25217[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (25))){
var inst_25147 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25176_25218 = state_25157__$1;
(statearr_25176_25218[(2)] = inst_25147);

(statearr_25176_25218[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (17))){
var inst_25112 = (state_25157[(10)]);
var inst_25121 = cljs.core.first.call(null,inst_25112);
var inst_25122 = cljs.core.async.muxch_STAR_.call(null,inst_25121);
var inst_25123 = cljs.core.async.close_BANG_.call(null,inst_25122);
var inst_25124 = cljs.core.next.call(null,inst_25112);
var inst_25098 = inst_25124;
var inst_25099 = null;
var inst_25100 = (0);
var inst_25101 = (0);
var state_25157__$1 = (function (){var statearr_25177 = state_25157;
(statearr_25177[(12)] = inst_25101);

(statearr_25177[(13)] = inst_25100);

(statearr_25177[(14)] = inst_25098);

(statearr_25177[(15)] = inst_25099);

(statearr_25177[(16)] = inst_25123);

return statearr_25177;
})();
var statearr_25178_25219 = state_25157__$1;
(statearr_25178_25219[(2)] = null);

(statearr_25178_25219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (3))){
var inst_25155 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25157__$1,inst_25155);
} else {
if((state_val_25158 === (12))){
var inst_25132 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25179_25220 = state_25157__$1;
(statearr_25179_25220[(2)] = inst_25132);

(statearr_25179_25220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (2))){
var state_25157__$1 = state_25157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25157__$1,(4),ch);
} else {
if((state_val_25158 === (23))){
var state_25157__$1 = state_25157;
var statearr_25180_25221 = state_25157__$1;
(statearr_25180_25221[(2)] = null);

(statearr_25180_25221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (19))){
var inst_25138 = (state_25157[(11)]);
var inst_25088 = (state_25157[(8)]);
var inst_25140 = cljs.core.async.muxch_STAR_.call(null,inst_25138);
var state_25157__$1 = state_25157;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25157__$1,(22),inst_25140,inst_25088);
} else {
if((state_val_25158 === (11))){
var inst_25112 = (state_25157[(10)]);
var inst_25098 = (state_25157[(14)]);
var inst_25112__$1 = cljs.core.seq.call(null,inst_25098);
var state_25157__$1 = (function (){var statearr_25181 = state_25157;
(statearr_25181[(10)] = inst_25112__$1);

return statearr_25181;
})();
if(inst_25112__$1){
var statearr_25182_25222 = state_25157__$1;
(statearr_25182_25222[(1)] = (13));

} else {
var statearr_25183_25223 = state_25157__$1;
(statearr_25183_25223[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (9))){
var inst_25134 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25184_25224 = state_25157__$1;
(statearr_25184_25224[(2)] = inst_25134);

(statearr_25184_25224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (5))){
var inst_25095 = cljs.core.deref.call(null,mults);
var inst_25096 = cljs.core.vals.call(null,inst_25095);
var inst_25097 = cljs.core.seq.call(null,inst_25096);
var inst_25098 = inst_25097;
var inst_25099 = null;
var inst_25100 = (0);
var inst_25101 = (0);
var state_25157__$1 = (function (){var statearr_25185 = state_25157;
(statearr_25185[(12)] = inst_25101);

(statearr_25185[(13)] = inst_25100);

(statearr_25185[(14)] = inst_25098);

(statearr_25185[(15)] = inst_25099);

return statearr_25185;
})();
var statearr_25186_25225 = state_25157__$1;
(statearr_25186_25225[(2)] = null);

(statearr_25186_25225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (14))){
var state_25157__$1 = state_25157;
var statearr_25190_25226 = state_25157__$1;
(statearr_25190_25226[(2)] = null);

(statearr_25190_25226[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (16))){
var inst_25112 = (state_25157[(10)]);
var inst_25116 = cljs.core.chunk_first.call(null,inst_25112);
var inst_25117 = cljs.core.chunk_rest.call(null,inst_25112);
var inst_25118 = cljs.core.count.call(null,inst_25116);
var inst_25098 = inst_25117;
var inst_25099 = inst_25116;
var inst_25100 = inst_25118;
var inst_25101 = (0);
var state_25157__$1 = (function (){var statearr_25191 = state_25157;
(statearr_25191[(12)] = inst_25101);

(statearr_25191[(13)] = inst_25100);

(statearr_25191[(14)] = inst_25098);

(statearr_25191[(15)] = inst_25099);

return statearr_25191;
})();
var statearr_25192_25227 = state_25157__$1;
(statearr_25192_25227[(2)] = null);

(statearr_25192_25227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (10))){
var inst_25101 = (state_25157[(12)]);
var inst_25100 = (state_25157[(13)]);
var inst_25098 = (state_25157[(14)]);
var inst_25099 = (state_25157[(15)]);
var inst_25106 = cljs.core._nth.call(null,inst_25099,inst_25101);
var inst_25107 = cljs.core.async.muxch_STAR_.call(null,inst_25106);
var inst_25108 = cljs.core.async.close_BANG_.call(null,inst_25107);
var inst_25109 = (inst_25101 + (1));
var tmp25187 = inst_25100;
var tmp25188 = inst_25098;
var tmp25189 = inst_25099;
var inst_25098__$1 = tmp25188;
var inst_25099__$1 = tmp25189;
var inst_25100__$1 = tmp25187;
var inst_25101__$1 = inst_25109;
var state_25157__$1 = (function (){var statearr_25193 = state_25157;
(statearr_25193[(12)] = inst_25101__$1);

(statearr_25193[(13)] = inst_25100__$1);

(statearr_25193[(14)] = inst_25098__$1);

(statearr_25193[(15)] = inst_25099__$1);

(statearr_25193[(17)] = inst_25108);

return statearr_25193;
})();
var statearr_25194_25228 = state_25157__$1;
(statearr_25194_25228[(2)] = null);

(statearr_25194_25228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (18))){
var inst_25127 = (state_25157[(2)]);
var state_25157__$1 = state_25157;
var statearr_25195_25229 = state_25157__$1;
(statearr_25195_25229[(2)] = inst_25127);

(statearr_25195_25229[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25158 === (8))){
var inst_25101 = (state_25157[(12)]);
var inst_25100 = (state_25157[(13)]);
var inst_25103 = (inst_25101 < inst_25100);
var inst_25104 = inst_25103;
var state_25157__$1 = state_25157;
if(cljs.core.truth_(inst_25104)){
var statearr_25196_25230 = state_25157__$1;
(statearr_25196_25230[(1)] = (10));

} else {
var statearr_25197_25231 = state_25157__$1;
(statearr_25197_25231[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25203,mults,ensure_mult,p))
;
return ((function (switch__23913__auto__,c__23969__auto___25203,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25198[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25198[(1)] = (1));

return statearr_25198;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25157){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25199){if((e25199 instanceof Object)){
var ex__23917__auto__ = e25199;
var statearr_25200_25232 = state_25157;
(statearr_25200_25232[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25233 = state_25157;
state_25157 = G__25233;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25157){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25203,mults,ensure_mult,p))
})();
var state__23971__auto__ = (function (){var statearr_25201 = f__23970__auto__.call(null);
(statearr_25201[(6)] = c__23969__auto___25203);

return statearr_25201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25203,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__25235 = arguments.length;
switch (G__25235) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__25238 = arguments.length;
switch (G__25238) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__25241 = arguments.length;
switch (G__25241) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23969__auto___25308 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25280){
var state_val_25281 = (state_25280[(1)]);
if((state_val_25281 === (7))){
var state_25280__$1 = state_25280;
var statearr_25282_25309 = state_25280__$1;
(statearr_25282_25309[(2)] = null);

(statearr_25282_25309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (1))){
var state_25280__$1 = state_25280;
var statearr_25283_25310 = state_25280__$1;
(statearr_25283_25310[(2)] = null);

(statearr_25283_25310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (4))){
var inst_25244 = (state_25280[(7)]);
var inst_25246 = (inst_25244 < cnt);
var state_25280__$1 = state_25280;
if(cljs.core.truth_(inst_25246)){
var statearr_25284_25311 = state_25280__$1;
(statearr_25284_25311[(1)] = (6));

} else {
var statearr_25285_25312 = state_25280__$1;
(statearr_25285_25312[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (15))){
var inst_25276 = (state_25280[(2)]);
var state_25280__$1 = state_25280;
var statearr_25286_25313 = state_25280__$1;
(statearr_25286_25313[(2)] = inst_25276);

(statearr_25286_25313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (13))){
var inst_25269 = cljs.core.async.close_BANG_.call(null,out);
var state_25280__$1 = state_25280;
var statearr_25287_25314 = state_25280__$1;
(statearr_25287_25314[(2)] = inst_25269);

(statearr_25287_25314[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (6))){
var state_25280__$1 = state_25280;
var statearr_25288_25315 = state_25280__$1;
(statearr_25288_25315[(2)] = null);

(statearr_25288_25315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (3))){
var inst_25278 = (state_25280[(2)]);
var state_25280__$1 = state_25280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25280__$1,inst_25278);
} else {
if((state_val_25281 === (12))){
var inst_25266 = (state_25280[(8)]);
var inst_25266__$1 = (state_25280[(2)]);
var inst_25267 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25266__$1);
var state_25280__$1 = (function (){var statearr_25289 = state_25280;
(statearr_25289[(8)] = inst_25266__$1);

return statearr_25289;
})();
if(cljs.core.truth_(inst_25267)){
var statearr_25290_25316 = state_25280__$1;
(statearr_25290_25316[(1)] = (13));

} else {
var statearr_25291_25317 = state_25280__$1;
(statearr_25291_25317[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (2))){
var inst_25243 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25244 = (0);
var state_25280__$1 = (function (){var statearr_25292 = state_25280;
(statearr_25292[(9)] = inst_25243);

(statearr_25292[(7)] = inst_25244);

return statearr_25292;
})();
var statearr_25293_25318 = state_25280__$1;
(statearr_25293_25318[(2)] = null);

(statearr_25293_25318[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (11))){
var inst_25244 = (state_25280[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25280,(10),Object,null,(9));
var inst_25253 = chs__$1.call(null,inst_25244);
var inst_25254 = done.call(null,inst_25244);
var inst_25255 = cljs.core.async.take_BANG_.call(null,inst_25253,inst_25254);
var state_25280__$1 = state_25280;
var statearr_25294_25319 = state_25280__$1;
(statearr_25294_25319[(2)] = inst_25255);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25280__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (9))){
var inst_25244 = (state_25280[(7)]);
var inst_25257 = (state_25280[(2)]);
var inst_25258 = (inst_25244 + (1));
var inst_25244__$1 = inst_25258;
var state_25280__$1 = (function (){var statearr_25295 = state_25280;
(statearr_25295[(10)] = inst_25257);

(statearr_25295[(7)] = inst_25244__$1);

return statearr_25295;
})();
var statearr_25296_25320 = state_25280__$1;
(statearr_25296_25320[(2)] = null);

(statearr_25296_25320[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (5))){
var inst_25264 = (state_25280[(2)]);
var state_25280__$1 = (function (){var statearr_25297 = state_25280;
(statearr_25297[(11)] = inst_25264);

return statearr_25297;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25280__$1,(12),dchan);
} else {
if((state_val_25281 === (14))){
var inst_25266 = (state_25280[(8)]);
var inst_25271 = cljs.core.apply.call(null,f,inst_25266);
var state_25280__$1 = state_25280;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25280__$1,(16),out,inst_25271);
} else {
if((state_val_25281 === (16))){
var inst_25273 = (state_25280[(2)]);
var state_25280__$1 = (function (){var statearr_25298 = state_25280;
(statearr_25298[(12)] = inst_25273);

return statearr_25298;
})();
var statearr_25299_25321 = state_25280__$1;
(statearr_25299_25321[(2)] = null);

(statearr_25299_25321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (10))){
var inst_25248 = (state_25280[(2)]);
var inst_25249 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25280__$1 = (function (){var statearr_25300 = state_25280;
(statearr_25300[(13)] = inst_25248);

return statearr_25300;
})();
var statearr_25301_25322 = state_25280__$1;
(statearr_25301_25322[(2)] = inst_25249);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25280__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25281 === (8))){
var inst_25262 = (state_25280[(2)]);
var state_25280__$1 = state_25280;
var statearr_25302_25323 = state_25280__$1;
(statearr_25302_25323[(2)] = inst_25262);

(statearr_25302_25323[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__23913__auto__,c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25303 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25303[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25303[(1)] = (1));

return statearr_25303;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25280){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25304){if((e25304 instanceof Object)){
var ex__23917__auto__ = e25304;
var statearr_25305_25324 = state_25280;
(statearr_25305_25324[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25280);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25304;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25325 = state_25280;
state_25280 = G__25325;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25280){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23971__auto__ = (function (){var statearr_25306 = f__23970__auto__.call(null);
(statearr_25306[(6)] = c__23969__auto___25308);

return statearr_25306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25308,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__25328 = arguments.length;
switch (G__25328) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25382 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25382,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25382,out){
return (function (state_25360){
var state_val_25361 = (state_25360[(1)]);
if((state_val_25361 === (7))){
var inst_25339 = (state_25360[(7)]);
var inst_25340 = (state_25360[(8)]);
var inst_25339__$1 = (state_25360[(2)]);
var inst_25340__$1 = cljs.core.nth.call(null,inst_25339__$1,(0),null);
var inst_25341 = cljs.core.nth.call(null,inst_25339__$1,(1),null);
var inst_25342 = (inst_25340__$1 == null);
var state_25360__$1 = (function (){var statearr_25362 = state_25360;
(statearr_25362[(7)] = inst_25339__$1);

(statearr_25362[(9)] = inst_25341);

(statearr_25362[(8)] = inst_25340__$1);

return statearr_25362;
})();
if(cljs.core.truth_(inst_25342)){
var statearr_25363_25383 = state_25360__$1;
(statearr_25363_25383[(1)] = (8));

} else {
var statearr_25364_25384 = state_25360__$1;
(statearr_25364_25384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (1))){
var inst_25329 = cljs.core.vec.call(null,chs);
var inst_25330 = inst_25329;
var state_25360__$1 = (function (){var statearr_25365 = state_25360;
(statearr_25365[(10)] = inst_25330);

return statearr_25365;
})();
var statearr_25366_25385 = state_25360__$1;
(statearr_25366_25385[(2)] = null);

(statearr_25366_25385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (4))){
var inst_25330 = (state_25360[(10)]);
var state_25360__$1 = state_25360;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25360__$1,(7),inst_25330);
} else {
if((state_val_25361 === (6))){
var inst_25356 = (state_25360[(2)]);
var state_25360__$1 = state_25360;
var statearr_25367_25386 = state_25360__$1;
(statearr_25367_25386[(2)] = inst_25356);

(statearr_25367_25386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (3))){
var inst_25358 = (state_25360[(2)]);
var state_25360__$1 = state_25360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25360__$1,inst_25358);
} else {
if((state_val_25361 === (2))){
var inst_25330 = (state_25360[(10)]);
var inst_25332 = cljs.core.count.call(null,inst_25330);
var inst_25333 = (inst_25332 > (0));
var state_25360__$1 = state_25360;
if(cljs.core.truth_(inst_25333)){
var statearr_25369_25387 = state_25360__$1;
(statearr_25369_25387[(1)] = (4));

} else {
var statearr_25370_25388 = state_25360__$1;
(statearr_25370_25388[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (11))){
var inst_25330 = (state_25360[(10)]);
var inst_25349 = (state_25360[(2)]);
var tmp25368 = inst_25330;
var inst_25330__$1 = tmp25368;
var state_25360__$1 = (function (){var statearr_25371 = state_25360;
(statearr_25371[(11)] = inst_25349);

(statearr_25371[(10)] = inst_25330__$1);

return statearr_25371;
})();
var statearr_25372_25389 = state_25360__$1;
(statearr_25372_25389[(2)] = null);

(statearr_25372_25389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (9))){
var inst_25340 = (state_25360[(8)]);
var state_25360__$1 = state_25360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25360__$1,(11),out,inst_25340);
} else {
if((state_val_25361 === (5))){
var inst_25354 = cljs.core.async.close_BANG_.call(null,out);
var state_25360__$1 = state_25360;
var statearr_25373_25390 = state_25360__$1;
(statearr_25373_25390[(2)] = inst_25354);

(statearr_25373_25390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (10))){
var inst_25352 = (state_25360[(2)]);
var state_25360__$1 = state_25360;
var statearr_25374_25391 = state_25360__$1;
(statearr_25374_25391[(2)] = inst_25352);

(statearr_25374_25391[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25361 === (8))){
var inst_25339 = (state_25360[(7)]);
var inst_25341 = (state_25360[(9)]);
var inst_25330 = (state_25360[(10)]);
var inst_25340 = (state_25360[(8)]);
var inst_25344 = (function (){var cs = inst_25330;
var vec__25335 = inst_25339;
var v = inst_25340;
var c = inst_25341;
return ((function (cs,vec__25335,v,c,inst_25339,inst_25341,inst_25330,inst_25340,state_val_25361,c__23969__auto___25382,out){
return (function (p1__25326_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25326_SHARP_);
});
;})(cs,vec__25335,v,c,inst_25339,inst_25341,inst_25330,inst_25340,state_val_25361,c__23969__auto___25382,out))
})();
var inst_25345 = cljs.core.filterv.call(null,inst_25344,inst_25330);
var inst_25330__$1 = inst_25345;
var state_25360__$1 = (function (){var statearr_25375 = state_25360;
(statearr_25375[(10)] = inst_25330__$1);

return statearr_25375;
})();
var statearr_25376_25392 = state_25360__$1;
(statearr_25376_25392[(2)] = null);

(statearr_25376_25392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25382,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25382,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25377 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25377[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25377[(1)] = (1));

return statearr_25377;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25360){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25378){if((e25378 instanceof Object)){
var ex__23917__auto__ = e25378;
var statearr_25379_25393 = state_25360;
(statearr_25379_25393[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25394 = state_25360;
state_25360 = G__25394;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25382,out))
})();
var state__23971__auto__ = (function (){var statearr_25380 = f__23970__auto__.call(null);
(statearr_25380[(6)] = c__23969__auto___25382);

return statearr_25380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25382,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__25396 = arguments.length;
switch (G__25396) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25441,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25441,out){
return (function (state_25420){
var state_val_25421 = (state_25420[(1)]);
if((state_val_25421 === (7))){
var inst_25402 = (state_25420[(7)]);
var inst_25402__$1 = (state_25420[(2)]);
var inst_25403 = (inst_25402__$1 == null);
var inst_25404 = cljs.core.not.call(null,inst_25403);
var state_25420__$1 = (function (){var statearr_25422 = state_25420;
(statearr_25422[(7)] = inst_25402__$1);

return statearr_25422;
})();
if(inst_25404){
var statearr_25423_25442 = state_25420__$1;
(statearr_25423_25442[(1)] = (8));

} else {
var statearr_25424_25443 = state_25420__$1;
(statearr_25424_25443[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (1))){
var inst_25397 = (0);
var state_25420__$1 = (function (){var statearr_25425 = state_25420;
(statearr_25425[(8)] = inst_25397);

return statearr_25425;
})();
var statearr_25426_25444 = state_25420__$1;
(statearr_25426_25444[(2)] = null);

(statearr_25426_25444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (4))){
var state_25420__$1 = state_25420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25420__$1,(7),ch);
} else {
if((state_val_25421 === (6))){
var inst_25415 = (state_25420[(2)]);
var state_25420__$1 = state_25420;
var statearr_25427_25445 = state_25420__$1;
(statearr_25427_25445[(2)] = inst_25415);

(statearr_25427_25445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (3))){
var inst_25417 = (state_25420[(2)]);
var inst_25418 = cljs.core.async.close_BANG_.call(null,out);
var state_25420__$1 = (function (){var statearr_25428 = state_25420;
(statearr_25428[(9)] = inst_25417);

return statearr_25428;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25420__$1,inst_25418);
} else {
if((state_val_25421 === (2))){
var inst_25397 = (state_25420[(8)]);
var inst_25399 = (inst_25397 < n);
var state_25420__$1 = state_25420;
if(cljs.core.truth_(inst_25399)){
var statearr_25429_25446 = state_25420__$1;
(statearr_25429_25446[(1)] = (4));

} else {
var statearr_25430_25447 = state_25420__$1;
(statearr_25430_25447[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (11))){
var inst_25397 = (state_25420[(8)]);
var inst_25407 = (state_25420[(2)]);
var inst_25408 = (inst_25397 + (1));
var inst_25397__$1 = inst_25408;
var state_25420__$1 = (function (){var statearr_25431 = state_25420;
(statearr_25431[(8)] = inst_25397__$1);

(statearr_25431[(10)] = inst_25407);

return statearr_25431;
})();
var statearr_25432_25448 = state_25420__$1;
(statearr_25432_25448[(2)] = null);

(statearr_25432_25448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (9))){
var state_25420__$1 = state_25420;
var statearr_25433_25449 = state_25420__$1;
(statearr_25433_25449[(2)] = null);

(statearr_25433_25449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (5))){
var state_25420__$1 = state_25420;
var statearr_25434_25450 = state_25420__$1;
(statearr_25434_25450[(2)] = null);

(statearr_25434_25450[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (10))){
var inst_25412 = (state_25420[(2)]);
var state_25420__$1 = state_25420;
var statearr_25435_25451 = state_25420__$1;
(statearr_25435_25451[(2)] = inst_25412);

(statearr_25435_25451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25421 === (8))){
var inst_25402 = (state_25420[(7)]);
var state_25420__$1 = state_25420;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25420__$1,(11),out,inst_25402);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25441,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25441,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25436 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25436[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25436[(1)] = (1));

return statearr_25436;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25420){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25437){if((e25437 instanceof Object)){
var ex__23917__auto__ = e25437;
var statearr_25438_25452 = state_25420;
(statearr_25438_25452[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25420);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25437;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25453 = state_25420;
state_25420 = G__25453;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25441,out))
})();
var state__23971__auto__ = (function (){var statearr_25439 = f__23970__auto__.call(null);
(statearr_25439[(6)] = c__23969__auto___25441);

return statearr_25439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25441,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25455 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25455 = (function (f,ch,meta25456){
this.f = f;
this.ch = ch;
this.meta25456 = meta25456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25457,meta25456__$1){
var self__ = this;
var _25457__$1 = this;
return (new cljs.core.async.t_cljs$core$async25455(self__.f,self__.ch,meta25456__$1));
});

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25457){
var self__ = this;
var _25457__$1 = this;
return self__.meta25456;
});

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25458 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25458 = (function (f,ch,meta25456,_,fn1,meta25459){
this.f = f;
this.ch = ch;
this.meta25456 = meta25456;
this._ = _;
this.fn1 = fn1;
this.meta25459 = meta25459;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25460,meta25459__$1){
var self__ = this;
var _25460__$1 = this;
return (new cljs.core.async.t_cljs$core$async25458(self__.f,self__.ch,self__.meta25456,self__._,self__.fn1,meta25459__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25460){
var self__ = this;
var _25460__$1 = this;
return self__.meta25459;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25454_SHARP_){
return f1.call(null,(((p1__25454_SHARP_ == null))?null:self__.f.call(null,p1__25454_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25456","meta25456",610039483,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25455","cljs.core.async/t_cljs$core$async25455",-1476835033,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25459","meta25459",1814552284,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25458.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25458.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25458";

cljs.core.async.t_cljs$core$async25458.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25458");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25458.
 */
cljs.core.async.__GT_t_cljs$core$async25458 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25458(f__$1,ch__$1,meta25456__$1,___$2,fn1__$1,meta25459){
return (new cljs.core.async.t_cljs$core$async25458(f__$1,ch__$1,meta25456__$1,___$2,fn1__$1,meta25459));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25458(self__.f,self__.ch,self__.meta25456,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25455.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25455.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25456","meta25456",610039483,null)], null);
});

cljs.core.async.t_cljs$core$async25455.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25455";

cljs.core.async.t_cljs$core$async25455.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25455");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25455.
 */
cljs.core.async.__GT_t_cljs$core$async25455 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25455(f__$1,ch__$1,meta25456){
return (new cljs.core.async.t_cljs$core$async25455(f__$1,ch__$1,meta25456));
});

}

return (new cljs.core.async.t_cljs$core$async25455(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25461 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25461 = (function (f,ch,meta25462){
this.f = f;
this.ch = ch;
this.meta25462 = meta25462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25463,meta25462__$1){
var self__ = this;
var _25463__$1 = this;
return (new cljs.core.async.t_cljs$core$async25461(self__.f,self__.ch,meta25462__$1));
});

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25463){
var self__ = this;
var _25463__$1 = this;
return self__.meta25462;
});

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25461.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25462","meta25462",-265815372,null)], null);
});

cljs.core.async.t_cljs$core$async25461.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25461";

cljs.core.async.t_cljs$core$async25461.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25461");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25461.
 */
cljs.core.async.__GT_t_cljs$core$async25461 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25461(f__$1,ch__$1,meta25462){
return (new cljs.core.async.t_cljs$core$async25461(f__$1,ch__$1,meta25462));
});

}

return (new cljs.core.async.t_cljs$core$async25461(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25464 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25464 = (function (p,ch,meta25465){
this.p = p;
this.ch = ch;
this.meta25465 = meta25465;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25466,meta25465__$1){
var self__ = this;
var _25466__$1 = this;
return (new cljs.core.async.t_cljs$core$async25464(self__.p,self__.ch,meta25465__$1));
});

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25466){
var self__ = this;
var _25466__$1 = this;
return self__.meta25465;
});

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25464.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25464.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25465","meta25465",1379729734,null)], null);
});

cljs.core.async.t_cljs$core$async25464.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25464.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25464";

cljs.core.async.t_cljs$core$async25464.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25464");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25464.
 */
cljs.core.async.__GT_t_cljs$core$async25464 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25464(p__$1,ch__$1,meta25465){
return (new cljs.core.async.t_cljs$core$async25464(p__$1,ch__$1,meta25465));
});

}

return (new cljs.core.async.t_cljs$core$async25464(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__25468 = arguments.length;
switch (G__25468) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25508 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25508,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25508,out){
return (function (state_25489){
var state_val_25490 = (state_25489[(1)]);
if((state_val_25490 === (7))){
var inst_25485 = (state_25489[(2)]);
var state_25489__$1 = state_25489;
var statearr_25491_25509 = state_25489__$1;
(statearr_25491_25509[(2)] = inst_25485);

(statearr_25491_25509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (1))){
var state_25489__$1 = state_25489;
var statearr_25492_25510 = state_25489__$1;
(statearr_25492_25510[(2)] = null);

(statearr_25492_25510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (4))){
var inst_25471 = (state_25489[(7)]);
var inst_25471__$1 = (state_25489[(2)]);
var inst_25472 = (inst_25471__$1 == null);
var state_25489__$1 = (function (){var statearr_25493 = state_25489;
(statearr_25493[(7)] = inst_25471__$1);

return statearr_25493;
})();
if(cljs.core.truth_(inst_25472)){
var statearr_25494_25511 = state_25489__$1;
(statearr_25494_25511[(1)] = (5));

} else {
var statearr_25495_25512 = state_25489__$1;
(statearr_25495_25512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (6))){
var inst_25471 = (state_25489[(7)]);
var inst_25476 = p.call(null,inst_25471);
var state_25489__$1 = state_25489;
if(cljs.core.truth_(inst_25476)){
var statearr_25496_25513 = state_25489__$1;
(statearr_25496_25513[(1)] = (8));

} else {
var statearr_25497_25514 = state_25489__$1;
(statearr_25497_25514[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (3))){
var inst_25487 = (state_25489[(2)]);
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25489__$1,inst_25487);
} else {
if((state_val_25490 === (2))){
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25489__$1,(4),ch);
} else {
if((state_val_25490 === (11))){
var inst_25479 = (state_25489[(2)]);
var state_25489__$1 = state_25489;
var statearr_25498_25515 = state_25489__$1;
(statearr_25498_25515[(2)] = inst_25479);

(statearr_25498_25515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (9))){
var state_25489__$1 = state_25489;
var statearr_25499_25516 = state_25489__$1;
(statearr_25499_25516[(2)] = null);

(statearr_25499_25516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (5))){
var inst_25474 = cljs.core.async.close_BANG_.call(null,out);
var state_25489__$1 = state_25489;
var statearr_25500_25517 = state_25489__$1;
(statearr_25500_25517[(2)] = inst_25474);

(statearr_25500_25517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (10))){
var inst_25482 = (state_25489[(2)]);
var state_25489__$1 = (function (){var statearr_25501 = state_25489;
(statearr_25501[(8)] = inst_25482);

return statearr_25501;
})();
var statearr_25502_25518 = state_25489__$1;
(statearr_25502_25518[(2)] = null);

(statearr_25502_25518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25490 === (8))){
var inst_25471 = (state_25489[(7)]);
var state_25489__$1 = state_25489;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25489__$1,(11),out,inst_25471);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25508,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25508,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25503 = [null,null,null,null,null,null,null,null,null];
(statearr_25503[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25503[(1)] = (1));

return statearr_25503;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25489){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25504){if((e25504 instanceof Object)){
var ex__23917__auto__ = e25504;
var statearr_25505_25519 = state_25489;
(statearr_25505_25519[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25489);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25504;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25520 = state_25489;
state_25489 = G__25520;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25489){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25508,out))
})();
var state__23971__auto__ = (function (){var statearr_25506 = f__23970__auto__.call(null);
(statearr_25506[(6)] = c__23969__auto___25508);

return statearr_25506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25508,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__25522 = arguments.length;
switch (G__25522) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__){
return (function (state_25585){
var state_val_25586 = (state_25585[(1)]);
if((state_val_25586 === (7))){
var inst_25581 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25587_25625 = state_25585__$1;
(statearr_25587_25625[(2)] = inst_25581);

(statearr_25587_25625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (20))){
var inst_25551 = (state_25585[(7)]);
var inst_25562 = (state_25585[(2)]);
var inst_25563 = cljs.core.next.call(null,inst_25551);
var inst_25537 = inst_25563;
var inst_25538 = null;
var inst_25539 = (0);
var inst_25540 = (0);
var state_25585__$1 = (function (){var statearr_25588 = state_25585;
(statearr_25588[(8)] = inst_25537);

(statearr_25588[(9)] = inst_25539);

(statearr_25588[(10)] = inst_25538);

(statearr_25588[(11)] = inst_25540);

(statearr_25588[(12)] = inst_25562);

return statearr_25588;
})();
var statearr_25589_25626 = state_25585__$1;
(statearr_25589_25626[(2)] = null);

(statearr_25589_25626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (1))){
var state_25585__$1 = state_25585;
var statearr_25590_25627 = state_25585__$1;
(statearr_25590_25627[(2)] = null);

(statearr_25590_25627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (4))){
var inst_25526 = (state_25585[(13)]);
var inst_25526__$1 = (state_25585[(2)]);
var inst_25527 = (inst_25526__$1 == null);
var state_25585__$1 = (function (){var statearr_25591 = state_25585;
(statearr_25591[(13)] = inst_25526__$1);

return statearr_25591;
})();
if(cljs.core.truth_(inst_25527)){
var statearr_25592_25628 = state_25585__$1;
(statearr_25592_25628[(1)] = (5));

} else {
var statearr_25593_25629 = state_25585__$1;
(statearr_25593_25629[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (15))){
var state_25585__$1 = state_25585;
var statearr_25597_25630 = state_25585__$1;
(statearr_25597_25630[(2)] = null);

(statearr_25597_25630[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (21))){
var state_25585__$1 = state_25585;
var statearr_25598_25631 = state_25585__$1;
(statearr_25598_25631[(2)] = null);

(statearr_25598_25631[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (13))){
var inst_25537 = (state_25585[(8)]);
var inst_25539 = (state_25585[(9)]);
var inst_25538 = (state_25585[(10)]);
var inst_25540 = (state_25585[(11)]);
var inst_25547 = (state_25585[(2)]);
var inst_25548 = (inst_25540 + (1));
var tmp25594 = inst_25537;
var tmp25595 = inst_25539;
var tmp25596 = inst_25538;
var inst_25537__$1 = tmp25594;
var inst_25538__$1 = tmp25596;
var inst_25539__$1 = tmp25595;
var inst_25540__$1 = inst_25548;
var state_25585__$1 = (function (){var statearr_25599 = state_25585;
(statearr_25599[(8)] = inst_25537__$1);

(statearr_25599[(9)] = inst_25539__$1);

(statearr_25599[(10)] = inst_25538__$1);

(statearr_25599[(11)] = inst_25540__$1);

(statearr_25599[(14)] = inst_25547);

return statearr_25599;
})();
var statearr_25600_25632 = state_25585__$1;
(statearr_25600_25632[(2)] = null);

(statearr_25600_25632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (22))){
var state_25585__$1 = state_25585;
var statearr_25601_25633 = state_25585__$1;
(statearr_25601_25633[(2)] = null);

(statearr_25601_25633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (6))){
var inst_25526 = (state_25585[(13)]);
var inst_25535 = f.call(null,inst_25526);
var inst_25536 = cljs.core.seq.call(null,inst_25535);
var inst_25537 = inst_25536;
var inst_25538 = null;
var inst_25539 = (0);
var inst_25540 = (0);
var state_25585__$1 = (function (){var statearr_25602 = state_25585;
(statearr_25602[(8)] = inst_25537);

(statearr_25602[(9)] = inst_25539);

(statearr_25602[(10)] = inst_25538);

(statearr_25602[(11)] = inst_25540);

return statearr_25602;
})();
var statearr_25603_25634 = state_25585__$1;
(statearr_25603_25634[(2)] = null);

(statearr_25603_25634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (17))){
var inst_25551 = (state_25585[(7)]);
var inst_25555 = cljs.core.chunk_first.call(null,inst_25551);
var inst_25556 = cljs.core.chunk_rest.call(null,inst_25551);
var inst_25557 = cljs.core.count.call(null,inst_25555);
var inst_25537 = inst_25556;
var inst_25538 = inst_25555;
var inst_25539 = inst_25557;
var inst_25540 = (0);
var state_25585__$1 = (function (){var statearr_25604 = state_25585;
(statearr_25604[(8)] = inst_25537);

(statearr_25604[(9)] = inst_25539);

(statearr_25604[(10)] = inst_25538);

(statearr_25604[(11)] = inst_25540);

return statearr_25604;
})();
var statearr_25605_25635 = state_25585__$1;
(statearr_25605_25635[(2)] = null);

(statearr_25605_25635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (3))){
var inst_25583 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25585__$1,inst_25583);
} else {
if((state_val_25586 === (12))){
var inst_25571 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25606_25636 = state_25585__$1;
(statearr_25606_25636[(2)] = inst_25571);

(statearr_25606_25636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (2))){
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25585__$1,(4),in$);
} else {
if((state_val_25586 === (23))){
var inst_25579 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25607_25637 = state_25585__$1;
(statearr_25607_25637[(2)] = inst_25579);

(statearr_25607_25637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (19))){
var inst_25566 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25608_25638 = state_25585__$1;
(statearr_25608_25638[(2)] = inst_25566);

(statearr_25608_25638[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (11))){
var inst_25537 = (state_25585[(8)]);
var inst_25551 = (state_25585[(7)]);
var inst_25551__$1 = cljs.core.seq.call(null,inst_25537);
var state_25585__$1 = (function (){var statearr_25609 = state_25585;
(statearr_25609[(7)] = inst_25551__$1);

return statearr_25609;
})();
if(inst_25551__$1){
var statearr_25610_25639 = state_25585__$1;
(statearr_25610_25639[(1)] = (14));

} else {
var statearr_25611_25640 = state_25585__$1;
(statearr_25611_25640[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (9))){
var inst_25573 = (state_25585[(2)]);
var inst_25574 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25585__$1 = (function (){var statearr_25612 = state_25585;
(statearr_25612[(15)] = inst_25573);

return statearr_25612;
})();
if(cljs.core.truth_(inst_25574)){
var statearr_25613_25641 = state_25585__$1;
(statearr_25613_25641[(1)] = (21));

} else {
var statearr_25614_25642 = state_25585__$1;
(statearr_25614_25642[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (5))){
var inst_25529 = cljs.core.async.close_BANG_.call(null,out);
var state_25585__$1 = state_25585;
var statearr_25615_25643 = state_25585__$1;
(statearr_25615_25643[(2)] = inst_25529);

(statearr_25615_25643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (14))){
var inst_25551 = (state_25585[(7)]);
var inst_25553 = cljs.core.chunked_seq_QMARK_.call(null,inst_25551);
var state_25585__$1 = state_25585;
if(inst_25553){
var statearr_25616_25644 = state_25585__$1;
(statearr_25616_25644[(1)] = (17));

} else {
var statearr_25617_25645 = state_25585__$1;
(statearr_25617_25645[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (16))){
var inst_25569 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25618_25646 = state_25585__$1;
(statearr_25618_25646[(2)] = inst_25569);

(statearr_25618_25646[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (10))){
var inst_25538 = (state_25585[(10)]);
var inst_25540 = (state_25585[(11)]);
var inst_25545 = cljs.core._nth.call(null,inst_25538,inst_25540);
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25585__$1,(13),out,inst_25545);
} else {
if((state_val_25586 === (18))){
var inst_25551 = (state_25585[(7)]);
var inst_25560 = cljs.core.first.call(null,inst_25551);
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25585__$1,(20),out,inst_25560);
} else {
if((state_val_25586 === (8))){
var inst_25539 = (state_25585[(9)]);
var inst_25540 = (state_25585[(11)]);
var inst_25542 = (inst_25540 < inst_25539);
var inst_25543 = inst_25542;
var state_25585__$1 = state_25585;
if(cljs.core.truth_(inst_25543)){
var statearr_25619_25647 = state_25585__$1;
(statearr_25619_25647[(1)] = (10));

} else {
var statearr_25620_25648 = state_25585__$1;
(statearr_25620_25648[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0 = (function (){
var statearr_25621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25621[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__);

(statearr_25621[(1)] = (1));

return statearr_25621;
});
var cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1 = (function (state_25585){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25622){if((e25622 instanceof Object)){
var ex__23917__auto__ = e25622;
var statearr_25623_25649 = state_25585;
(statearr_25623_25649[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25585);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25622;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25650 = state_25585;
state_25585 = G__25650;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__ = function(state_25585){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1.call(this,state_25585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__23914__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__))
})();
var state__23971__auto__ = (function (){var statearr_25624 = f__23970__auto__.call(null);
(statearr_25624[(6)] = c__23969__auto__);

return statearr_25624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__))
);

return c__23969__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__25652 = arguments.length;
switch (G__25652) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__25655 = arguments.length;
switch (G__25655) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__25658 = arguments.length;
switch (G__25658) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25705 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25705,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25705,out){
return (function (state_25682){
var state_val_25683 = (state_25682[(1)]);
if((state_val_25683 === (7))){
var inst_25677 = (state_25682[(2)]);
var state_25682__$1 = state_25682;
var statearr_25684_25706 = state_25682__$1;
(statearr_25684_25706[(2)] = inst_25677);

(statearr_25684_25706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (1))){
var inst_25659 = null;
var state_25682__$1 = (function (){var statearr_25685 = state_25682;
(statearr_25685[(7)] = inst_25659);

return statearr_25685;
})();
var statearr_25686_25707 = state_25682__$1;
(statearr_25686_25707[(2)] = null);

(statearr_25686_25707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (4))){
var inst_25662 = (state_25682[(8)]);
var inst_25662__$1 = (state_25682[(2)]);
var inst_25663 = (inst_25662__$1 == null);
var inst_25664 = cljs.core.not.call(null,inst_25663);
var state_25682__$1 = (function (){var statearr_25687 = state_25682;
(statearr_25687[(8)] = inst_25662__$1);

return statearr_25687;
})();
if(inst_25664){
var statearr_25688_25708 = state_25682__$1;
(statearr_25688_25708[(1)] = (5));

} else {
var statearr_25689_25709 = state_25682__$1;
(statearr_25689_25709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (6))){
var state_25682__$1 = state_25682;
var statearr_25690_25710 = state_25682__$1;
(statearr_25690_25710[(2)] = null);

(statearr_25690_25710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (3))){
var inst_25679 = (state_25682[(2)]);
var inst_25680 = cljs.core.async.close_BANG_.call(null,out);
var state_25682__$1 = (function (){var statearr_25691 = state_25682;
(statearr_25691[(9)] = inst_25679);

return statearr_25691;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25682__$1,inst_25680);
} else {
if((state_val_25683 === (2))){
var state_25682__$1 = state_25682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25682__$1,(4),ch);
} else {
if((state_val_25683 === (11))){
var inst_25662 = (state_25682[(8)]);
var inst_25671 = (state_25682[(2)]);
var inst_25659 = inst_25662;
var state_25682__$1 = (function (){var statearr_25692 = state_25682;
(statearr_25692[(7)] = inst_25659);

(statearr_25692[(10)] = inst_25671);

return statearr_25692;
})();
var statearr_25693_25711 = state_25682__$1;
(statearr_25693_25711[(2)] = null);

(statearr_25693_25711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (9))){
var inst_25662 = (state_25682[(8)]);
var state_25682__$1 = state_25682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25682__$1,(11),out,inst_25662);
} else {
if((state_val_25683 === (5))){
var inst_25662 = (state_25682[(8)]);
var inst_25659 = (state_25682[(7)]);
var inst_25666 = cljs.core._EQ_.call(null,inst_25662,inst_25659);
var state_25682__$1 = state_25682;
if(inst_25666){
var statearr_25695_25712 = state_25682__$1;
(statearr_25695_25712[(1)] = (8));

} else {
var statearr_25696_25713 = state_25682__$1;
(statearr_25696_25713[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (10))){
var inst_25674 = (state_25682[(2)]);
var state_25682__$1 = state_25682;
var statearr_25697_25714 = state_25682__$1;
(statearr_25697_25714[(2)] = inst_25674);

(statearr_25697_25714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25683 === (8))){
var inst_25659 = (state_25682[(7)]);
var tmp25694 = inst_25659;
var inst_25659__$1 = tmp25694;
var state_25682__$1 = (function (){var statearr_25698 = state_25682;
(statearr_25698[(7)] = inst_25659__$1);

return statearr_25698;
})();
var statearr_25699_25715 = state_25682__$1;
(statearr_25699_25715[(2)] = null);

(statearr_25699_25715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25705,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25705,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25700 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25700[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25700[(1)] = (1));

return statearr_25700;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25682){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25701){if((e25701 instanceof Object)){
var ex__23917__auto__ = e25701;
var statearr_25702_25716 = state_25682;
(statearr_25702_25716[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25701;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25717 = state_25682;
state_25682 = G__25717;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25682){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25705,out))
})();
var state__23971__auto__ = (function (){var statearr_25703 = f__23970__auto__.call(null);
(statearr_25703[(6)] = c__23969__auto___25705);

return statearr_25703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25705,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__25719 = arguments.length;
switch (G__25719) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25785,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25785,out){
return (function (state_25757){
var state_val_25758 = (state_25757[(1)]);
if((state_val_25758 === (7))){
var inst_25753 = (state_25757[(2)]);
var state_25757__$1 = state_25757;
var statearr_25759_25786 = state_25757__$1;
(statearr_25759_25786[(2)] = inst_25753);

(statearr_25759_25786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (1))){
var inst_25720 = (new Array(n));
var inst_25721 = inst_25720;
var inst_25722 = (0);
var state_25757__$1 = (function (){var statearr_25760 = state_25757;
(statearr_25760[(7)] = inst_25721);

(statearr_25760[(8)] = inst_25722);

return statearr_25760;
})();
var statearr_25761_25787 = state_25757__$1;
(statearr_25761_25787[(2)] = null);

(statearr_25761_25787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (4))){
var inst_25725 = (state_25757[(9)]);
var inst_25725__$1 = (state_25757[(2)]);
var inst_25726 = (inst_25725__$1 == null);
var inst_25727 = cljs.core.not.call(null,inst_25726);
var state_25757__$1 = (function (){var statearr_25762 = state_25757;
(statearr_25762[(9)] = inst_25725__$1);

return statearr_25762;
})();
if(inst_25727){
var statearr_25763_25788 = state_25757__$1;
(statearr_25763_25788[(1)] = (5));

} else {
var statearr_25764_25789 = state_25757__$1;
(statearr_25764_25789[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (15))){
var inst_25747 = (state_25757[(2)]);
var state_25757__$1 = state_25757;
var statearr_25765_25790 = state_25757__$1;
(statearr_25765_25790[(2)] = inst_25747);

(statearr_25765_25790[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (13))){
var state_25757__$1 = state_25757;
var statearr_25766_25791 = state_25757__$1;
(statearr_25766_25791[(2)] = null);

(statearr_25766_25791[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (6))){
var inst_25722 = (state_25757[(8)]);
var inst_25743 = (inst_25722 > (0));
var state_25757__$1 = state_25757;
if(cljs.core.truth_(inst_25743)){
var statearr_25767_25792 = state_25757__$1;
(statearr_25767_25792[(1)] = (12));

} else {
var statearr_25768_25793 = state_25757__$1;
(statearr_25768_25793[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (3))){
var inst_25755 = (state_25757[(2)]);
var state_25757__$1 = state_25757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25757__$1,inst_25755);
} else {
if((state_val_25758 === (12))){
var inst_25721 = (state_25757[(7)]);
var inst_25745 = cljs.core.vec.call(null,inst_25721);
var state_25757__$1 = state_25757;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25757__$1,(15),out,inst_25745);
} else {
if((state_val_25758 === (2))){
var state_25757__$1 = state_25757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25757__$1,(4),ch);
} else {
if((state_val_25758 === (11))){
var inst_25737 = (state_25757[(2)]);
var inst_25738 = (new Array(n));
var inst_25721 = inst_25738;
var inst_25722 = (0);
var state_25757__$1 = (function (){var statearr_25769 = state_25757;
(statearr_25769[(7)] = inst_25721);

(statearr_25769[(10)] = inst_25737);

(statearr_25769[(8)] = inst_25722);

return statearr_25769;
})();
var statearr_25770_25794 = state_25757__$1;
(statearr_25770_25794[(2)] = null);

(statearr_25770_25794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (9))){
var inst_25721 = (state_25757[(7)]);
var inst_25735 = cljs.core.vec.call(null,inst_25721);
var state_25757__$1 = state_25757;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25757__$1,(11),out,inst_25735);
} else {
if((state_val_25758 === (5))){
var inst_25725 = (state_25757[(9)]);
var inst_25721 = (state_25757[(7)]);
var inst_25722 = (state_25757[(8)]);
var inst_25730 = (state_25757[(11)]);
var inst_25729 = (inst_25721[inst_25722] = inst_25725);
var inst_25730__$1 = (inst_25722 + (1));
var inst_25731 = (inst_25730__$1 < n);
var state_25757__$1 = (function (){var statearr_25771 = state_25757;
(statearr_25771[(11)] = inst_25730__$1);

(statearr_25771[(12)] = inst_25729);

return statearr_25771;
})();
if(cljs.core.truth_(inst_25731)){
var statearr_25772_25795 = state_25757__$1;
(statearr_25772_25795[(1)] = (8));

} else {
var statearr_25773_25796 = state_25757__$1;
(statearr_25773_25796[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (14))){
var inst_25750 = (state_25757[(2)]);
var inst_25751 = cljs.core.async.close_BANG_.call(null,out);
var state_25757__$1 = (function (){var statearr_25775 = state_25757;
(statearr_25775[(13)] = inst_25750);

return statearr_25775;
})();
var statearr_25776_25797 = state_25757__$1;
(statearr_25776_25797[(2)] = inst_25751);

(statearr_25776_25797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (10))){
var inst_25741 = (state_25757[(2)]);
var state_25757__$1 = state_25757;
var statearr_25777_25798 = state_25757__$1;
(statearr_25777_25798[(2)] = inst_25741);

(statearr_25777_25798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25758 === (8))){
var inst_25721 = (state_25757[(7)]);
var inst_25730 = (state_25757[(11)]);
var tmp25774 = inst_25721;
var inst_25721__$1 = tmp25774;
var inst_25722 = inst_25730;
var state_25757__$1 = (function (){var statearr_25778 = state_25757;
(statearr_25778[(7)] = inst_25721__$1);

(statearr_25778[(8)] = inst_25722);

return statearr_25778;
})();
var statearr_25779_25799 = state_25757__$1;
(statearr_25779_25799[(2)] = null);

(statearr_25779_25799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25785,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25785,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25780[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25780[(1)] = (1));

return statearr_25780;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25757){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25781){if((e25781 instanceof Object)){
var ex__23917__auto__ = e25781;
var statearr_25782_25800 = state_25757;
(statearr_25782_25800[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25757);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25781;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25801 = state_25757;
state_25757 = G__25801;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25757){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25785,out))
})();
var state__23971__auto__ = (function (){var statearr_25783 = f__23970__auto__.call(null);
(statearr_25783[(6)] = c__23969__auto___25785);

return statearr_25783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25785,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__25803 = arguments.length;
switch (G__25803) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23969__auto___25873 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___25873,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___25873,out){
return (function (state_25845){
var state_val_25846 = (state_25845[(1)]);
if((state_val_25846 === (7))){
var inst_25841 = (state_25845[(2)]);
var state_25845__$1 = state_25845;
var statearr_25847_25874 = state_25845__$1;
(statearr_25847_25874[(2)] = inst_25841);

(statearr_25847_25874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (1))){
var inst_25804 = [];
var inst_25805 = inst_25804;
var inst_25806 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25845__$1 = (function (){var statearr_25848 = state_25845;
(statearr_25848[(7)] = inst_25805);

(statearr_25848[(8)] = inst_25806);

return statearr_25848;
})();
var statearr_25849_25875 = state_25845__$1;
(statearr_25849_25875[(2)] = null);

(statearr_25849_25875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (4))){
var inst_25809 = (state_25845[(9)]);
var inst_25809__$1 = (state_25845[(2)]);
var inst_25810 = (inst_25809__$1 == null);
var inst_25811 = cljs.core.not.call(null,inst_25810);
var state_25845__$1 = (function (){var statearr_25850 = state_25845;
(statearr_25850[(9)] = inst_25809__$1);

return statearr_25850;
})();
if(inst_25811){
var statearr_25851_25876 = state_25845__$1;
(statearr_25851_25876[(1)] = (5));

} else {
var statearr_25852_25877 = state_25845__$1;
(statearr_25852_25877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (15))){
var inst_25835 = (state_25845[(2)]);
var state_25845__$1 = state_25845;
var statearr_25853_25878 = state_25845__$1;
(statearr_25853_25878[(2)] = inst_25835);

(statearr_25853_25878[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (13))){
var state_25845__$1 = state_25845;
var statearr_25854_25879 = state_25845__$1;
(statearr_25854_25879[(2)] = null);

(statearr_25854_25879[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (6))){
var inst_25805 = (state_25845[(7)]);
var inst_25830 = inst_25805.length;
var inst_25831 = (inst_25830 > (0));
var state_25845__$1 = state_25845;
if(cljs.core.truth_(inst_25831)){
var statearr_25855_25880 = state_25845__$1;
(statearr_25855_25880[(1)] = (12));

} else {
var statearr_25856_25881 = state_25845__$1;
(statearr_25856_25881[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (3))){
var inst_25843 = (state_25845[(2)]);
var state_25845__$1 = state_25845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25845__$1,inst_25843);
} else {
if((state_val_25846 === (12))){
var inst_25805 = (state_25845[(7)]);
var inst_25833 = cljs.core.vec.call(null,inst_25805);
var state_25845__$1 = state_25845;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25845__$1,(15),out,inst_25833);
} else {
if((state_val_25846 === (2))){
var state_25845__$1 = state_25845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25845__$1,(4),ch);
} else {
if((state_val_25846 === (11))){
var inst_25813 = (state_25845[(10)]);
var inst_25809 = (state_25845[(9)]);
var inst_25823 = (state_25845[(2)]);
var inst_25824 = [];
var inst_25825 = inst_25824.push(inst_25809);
var inst_25805 = inst_25824;
var inst_25806 = inst_25813;
var state_25845__$1 = (function (){var statearr_25857 = state_25845;
(statearr_25857[(11)] = inst_25823);

(statearr_25857[(7)] = inst_25805);

(statearr_25857[(8)] = inst_25806);

(statearr_25857[(12)] = inst_25825);

return statearr_25857;
})();
var statearr_25858_25882 = state_25845__$1;
(statearr_25858_25882[(2)] = null);

(statearr_25858_25882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (9))){
var inst_25805 = (state_25845[(7)]);
var inst_25821 = cljs.core.vec.call(null,inst_25805);
var state_25845__$1 = state_25845;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25845__$1,(11),out,inst_25821);
} else {
if((state_val_25846 === (5))){
var inst_25813 = (state_25845[(10)]);
var inst_25809 = (state_25845[(9)]);
var inst_25806 = (state_25845[(8)]);
var inst_25813__$1 = f.call(null,inst_25809);
var inst_25814 = cljs.core._EQ_.call(null,inst_25813__$1,inst_25806);
var inst_25815 = cljs.core.keyword_identical_QMARK_.call(null,inst_25806,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25816 = ((inst_25814) || (inst_25815));
var state_25845__$1 = (function (){var statearr_25859 = state_25845;
(statearr_25859[(10)] = inst_25813__$1);

return statearr_25859;
})();
if(cljs.core.truth_(inst_25816)){
var statearr_25860_25883 = state_25845__$1;
(statearr_25860_25883[(1)] = (8));

} else {
var statearr_25861_25884 = state_25845__$1;
(statearr_25861_25884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (14))){
var inst_25838 = (state_25845[(2)]);
var inst_25839 = cljs.core.async.close_BANG_.call(null,out);
var state_25845__$1 = (function (){var statearr_25863 = state_25845;
(statearr_25863[(13)] = inst_25838);

return statearr_25863;
})();
var statearr_25864_25885 = state_25845__$1;
(statearr_25864_25885[(2)] = inst_25839);

(statearr_25864_25885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (10))){
var inst_25828 = (state_25845[(2)]);
var state_25845__$1 = state_25845;
var statearr_25865_25886 = state_25845__$1;
(statearr_25865_25886[(2)] = inst_25828);

(statearr_25865_25886[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25846 === (8))){
var inst_25805 = (state_25845[(7)]);
var inst_25813 = (state_25845[(10)]);
var inst_25809 = (state_25845[(9)]);
var inst_25818 = inst_25805.push(inst_25809);
var tmp25862 = inst_25805;
var inst_25805__$1 = tmp25862;
var inst_25806 = inst_25813;
var state_25845__$1 = (function (){var statearr_25866 = state_25845;
(statearr_25866[(7)] = inst_25805__$1);

(statearr_25866[(14)] = inst_25818);

(statearr_25866[(8)] = inst_25806);

return statearr_25866;
})();
var statearr_25867_25887 = state_25845__$1;
(statearr_25867_25887[(2)] = null);

(statearr_25867_25887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___25873,out))
;
return ((function (switch__23913__auto__,c__23969__auto___25873,out){
return (function() {
var cljs$core$async$state_machine__23914__auto__ = null;
var cljs$core$async$state_machine__23914__auto____0 = (function (){
var statearr_25868 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25868[(0)] = cljs$core$async$state_machine__23914__auto__);

(statearr_25868[(1)] = (1));

return statearr_25868;
});
var cljs$core$async$state_machine__23914__auto____1 = (function (state_25845){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_25845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e25869){if((e25869 instanceof Object)){
var ex__23917__auto__ = e25869;
var statearr_25870_25888 = state_25845;
(statearr_25870_25888[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25845);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25889 = state_25845;
state_25845 = G__25889;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
cljs$core$async$state_machine__23914__auto__ = function(state_25845){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__23914__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__23914__auto____1.call(this,state_25845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__23914__auto____0;
cljs$core$async$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__23914__auto____1;
return cljs$core$async$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___25873,out))
})();
var state__23971__auto__ = (function (){var statearr_25871 = f__23970__auto__.call(null);
(statearr_25871[(6)] = c__23969__auto___25873);

return statearr_25871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___25873,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1540478330275
