// Compiled by ClojureScript 1.10.339 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.16";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e31652){if((e31652 instanceof Error)){
var e = e31652;
return "Error: Unable to stringify";
} else {
throw e31652;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__31655 = arguments.length;
switch (G__31655) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__31653_SHARP_){
if(typeof p1__31653_SHARP_ === 'string'){
return p1__31653_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__31653_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___31658 = arguments.length;
var i__4532__auto___31659 = (0);
while(true){
if((i__4532__auto___31659 < len__4531__auto___31658)){
args__4534__auto__.push((arguments[i__4532__auto___31659]));

var G__31660 = (i__4532__auto___31659 + (1));
i__4532__auto___31659 = G__31660;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq31657){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31657));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___31662 = arguments.length;
var i__4532__auto___31663 = (0);
while(true){
if((i__4532__auto___31663 < len__4531__auto___31662)){
args__4534__auto__.push((arguments[i__4532__auto___31663]));

var G__31664 = (i__4532__auto___31663 + (1));
i__4532__auto___31663 = G__31664;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq31661){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq31661));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__31665){
var map__31666 = p__31665;
var map__31666__$1 = ((((!((map__31666 == null)))?(((((map__31666.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31666.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31666):map__31666);
var message = cljs.core.get.call(null,map__31666__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__31666__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3949__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3938__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__3938__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3938__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__23969__auto___31745 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___31745,ch){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___31745,ch){
return (function (state_31717){
var state_val_31718 = (state_31717[(1)]);
if((state_val_31718 === (7))){
var inst_31713 = (state_31717[(2)]);
var state_31717__$1 = state_31717;
var statearr_31719_31746 = state_31717__$1;
(statearr_31719_31746[(2)] = inst_31713);

(statearr_31719_31746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (1))){
var state_31717__$1 = state_31717;
var statearr_31720_31747 = state_31717__$1;
(statearr_31720_31747[(2)] = null);

(statearr_31720_31747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (4))){
var inst_31670 = (state_31717[(7)]);
var inst_31670__$1 = (state_31717[(2)]);
var state_31717__$1 = (function (){var statearr_31721 = state_31717;
(statearr_31721[(7)] = inst_31670__$1);

return statearr_31721;
})();
if(cljs.core.truth_(inst_31670__$1)){
var statearr_31722_31748 = state_31717__$1;
(statearr_31722_31748[(1)] = (5));

} else {
var statearr_31723_31749 = state_31717__$1;
(statearr_31723_31749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (15))){
var inst_31677 = (state_31717[(8)]);
var inst_31692 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_31677);
var inst_31693 = cljs.core.first.call(null,inst_31692);
var inst_31694 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_31693);
var inst_31695 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31694)].join('');
var inst_31696 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_31695);
var state_31717__$1 = state_31717;
var statearr_31724_31750 = state_31717__$1;
(statearr_31724_31750[(2)] = inst_31696);

(statearr_31724_31750[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (13))){
var inst_31701 = (state_31717[(2)]);
var state_31717__$1 = state_31717;
var statearr_31725_31751 = state_31717__$1;
(statearr_31725_31751[(2)] = inst_31701);

(statearr_31725_31751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (6))){
var state_31717__$1 = state_31717;
var statearr_31726_31752 = state_31717__$1;
(statearr_31726_31752[(2)] = null);

(statearr_31726_31752[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (17))){
var inst_31699 = (state_31717[(2)]);
var state_31717__$1 = state_31717;
var statearr_31727_31753 = state_31717__$1;
(statearr_31727_31753[(2)] = inst_31699);

(statearr_31727_31753[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (3))){
var inst_31715 = (state_31717[(2)]);
var state_31717__$1 = state_31717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31717__$1,inst_31715);
} else {
if((state_val_31718 === (12))){
var inst_31676 = (state_31717[(9)]);
var inst_31690 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_31676,opts);
var state_31717__$1 = state_31717;
if(cljs.core.truth_(inst_31690)){
var statearr_31728_31754 = state_31717__$1;
(statearr_31728_31754[(1)] = (15));

} else {
var statearr_31729_31755 = state_31717__$1;
(statearr_31729_31755[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (2))){
var state_31717__$1 = state_31717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31717__$1,(4),ch);
} else {
if((state_val_31718 === (11))){
var inst_31677 = (state_31717[(8)]);
var inst_31682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31683 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_31677);
var inst_31684 = cljs.core.async.timeout.call(null,(1000));
var inst_31685 = [inst_31683,inst_31684];
var inst_31686 = (new cljs.core.PersistentVector(null,2,(5),inst_31682,inst_31685,null));
var state_31717__$1 = state_31717;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31717__$1,(14),inst_31686);
} else {
if((state_val_31718 === (9))){
var inst_31677 = (state_31717[(8)]);
var inst_31703 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_31704 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_31677);
var inst_31705 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_31704);
var inst_31706 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31705)].join('');
var inst_31707 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_31706);
var state_31717__$1 = (function (){var statearr_31730 = state_31717;
(statearr_31730[(10)] = inst_31703);

return statearr_31730;
})();
var statearr_31731_31756 = state_31717__$1;
(statearr_31731_31756[(2)] = inst_31707);

(statearr_31731_31756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (5))){
var inst_31670 = (state_31717[(7)]);
var inst_31672 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_31673 = (new cljs.core.PersistentArrayMap(null,2,inst_31672,null));
var inst_31674 = (new cljs.core.PersistentHashSet(null,inst_31673,null));
var inst_31675 = figwheel.client.focus_msgs.call(null,inst_31674,inst_31670);
var inst_31676 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_31675);
var inst_31677 = cljs.core.first.call(null,inst_31675);
var inst_31678 = figwheel.client.autoload_QMARK_.call(null);
var state_31717__$1 = (function (){var statearr_31732 = state_31717;
(statearr_31732[(8)] = inst_31677);

(statearr_31732[(9)] = inst_31676);

return statearr_31732;
})();
if(cljs.core.truth_(inst_31678)){
var statearr_31733_31757 = state_31717__$1;
(statearr_31733_31757[(1)] = (8));

} else {
var statearr_31734_31758 = state_31717__$1;
(statearr_31734_31758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (14))){
var inst_31688 = (state_31717[(2)]);
var state_31717__$1 = state_31717;
var statearr_31735_31759 = state_31717__$1;
(statearr_31735_31759[(2)] = inst_31688);

(statearr_31735_31759[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (16))){
var state_31717__$1 = state_31717;
var statearr_31736_31760 = state_31717__$1;
(statearr_31736_31760[(2)] = null);

(statearr_31736_31760[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (10))){
var inst_31709 = (state_31717[(2)]);
var state_31717__$1 = (function (){var statearr_31737 = state_31717;
(statearr_31737[(11)] = inst_31709);

return statearr_31737;
})();
var statearr_31738_31761 = state_31717__$1;
(statearr_31738_31761[(2)] = null);

(statearr_31738_31761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31718 === (8))){
var inst_31676 = (state_31717[(9)]);
var inst_31680 = figwheel.client.reload_file_state_QMARK_.call(null,inst_31676,opts);
var state_31717__$1 = state_31717;
if(cljs.core.truth_(inst_31680)){
var statearr_31739_31762 = state_31717__$1;
(statearr_31739_31762[(1)] = (11));

} else {
var statearr_31740_31763 = state_31717__$1;
(statearr_31740_31763[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto___31745,ch))
;
return ((function (switch__23913__auto__,c__23969__auto___31745,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____0 = (function (){
var statearr_31741 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31741[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__);

(statearr_31741[(1)] = (1));

return statearr_31741;
});
var figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____1 = (function (state_31717){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31742){if((e31742 instanceof Object)){
var ex__23917__auto__ = e31742;
var statearr_31743_31764 = state_31717;
(statearr_31743_31764[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31717);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31765 = state_31717;
state_31717 = G__31765;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__ = function(state_31717){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____1.call(this,state_31717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__23914__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___31745,ch))
})();
var state__23971__auto__ = (function (){var statearr_31744 = f__23970__auto__.call(null);
(statearr_31744[(6)] = c__23969__auto___31745);

return statearr_31744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___31745,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__31766_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__31766_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_31770 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_31770){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_31768 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_31769 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_31768,_STAR_print_fn_STAR_31769,sb,base_path_31770){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_31768,_STAR_print_fn_STAR_31769,sb,base_path_31770))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_31769;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_31768;
}}catch (e31767){if((e31767 instanceof Error)){
var e = e31767;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_31770], null));
} else {
var e = e31767;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_31770))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__31771){
var map__31772 = p__31771;
var map__31772__$1 = ((((!((map__31772 == null)))?(((((map__31772.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31772.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31772):map__31772);
var opts = map__31772__$1;
var build_id = cljs.core.get.call(null,map__31772__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__31772,map__31772__$1,opts,build_id){
return (function (p__31774){
var vec__31775 = p__31774;
var seq__31776 = cljs.core.seq.call(null,vec__31775);
var first__31777 = cljs.core.first.call(null,seq__31776);
var seq__31776__$1 = cljs.core.next.call(null,seq__31776);
var map__31778 = first__31777;
var map__31778__$1 = ((((!((map__31778 == null)))?(((((map__31778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31778):map__31778);
var msg = map__31778__$1;
var msg_name = cljs.core.get.call(null,map__31778__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__31776__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__31775,seq__31776,first__31777,seq__31776__$1,map__31778,map__31778__$1,msg,msg_name,_,map__31772,map__31772__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__31775,seq__31776,first__31777,seq__31776__$1,map__31778,map__31778__$1,msg,msg_name,_,map__31772,map__31772__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__31772,map__31772__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__31780){
var vec__31781 = p__31780;
var seq__31782 = cljs.core.seq.call(null,vec__31781);
var first__31783 = cljs.core.first.call(null,seq__31782);
var seq__31782__$1 = cljs.core.next.call(null,seq__31782);
var map__31784 = first__31783;
var map__31784__$1 = ((((!((map__31784 == null)))?(((((map__31784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31784):map__31784);
var msg = map__31784__$1;
var msg_name = cljs.core.get.call(null,map__31784__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__31782__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__31786){
var map__31787 = p__31786;
var map__31787__$1 = ((((!((map__31787 == null)))?(((((map__31787.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31787.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31787):map__31787);
var on_compile_warning = cljs.core.get.call(null,map__31787__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__31787__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__31787,map__31787__$1,on_compile_warning,on_compile_fail){
return (function (p__31789){
var vec__31790 = p__31789;
var seq__31791 = cljs.core.seq.call(null,vec__31790);
var first__31792 = cljs.core.first.call(null,seq__31791);
var seq__31791__$1 = cljs.core.next.call(null,seq__31791);
var map__31793 = first__31792;
var map__31793__$1 = ((((!((map__31793 == null)))?(((((map__31793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31793.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31793):map__31793);
var msg = map__31793__$1;
var msg_name = cljs.core.get.call(null,map__31793__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__31791__$1;
var pred__31795 = cljs.core._EQ_;
var expr__31796 = msg_name;
if(cljs.core.truth_(pred__31795.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__31796))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__31795.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__31796))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__31787,map__31787__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__,msg_hist,msg_names,msg){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__,msg_hist,msg_names,msg){
return (function (state_31885){
var state_val_31886 = (state_31885[(1)]);
if((state_val_31886 === (7))){
var inst_31805 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31805)){
var statearr_31887_31934 = state_31885__$1;
(statearr_31887_31934[(1)] = (8));

} else {
var statearr_31888_31935 = state_31885__$1;
(statearr_31888_31935[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (20))){
var inst_31879 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31889_31936 = state_31885__$1;
(statearr_31889_31936[(2)] = inst_31879);

(statearr_31889_31936[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (27))){
var inst_31875 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31890_31937 = state_31885__$1;
(statearr_31890_31937[(2)] = inst_31875);

(statearr_31890_31937[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (1))){
var inst_31798 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31798)){
var statearr_31891_31938 = state_31885__$1;
(statearr_31891_31938[(1)] = (2));

} else {
var statearr_31892_31939 = state_31885__$1;
(statearr_31892_31939[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (24))){
var inst_31877 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31893_31940 = state_31885__$1;
(statearr_31893_31940[(2)] = inst_31877);

(statearr_31893_31940[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (4))){
var inst_31883 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31885__$1,inst_31883);
} else {
if((state_val_31886 === (15))){
var inst_31881 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31894_31941 = state_31885__$1;
(statearr_31894_31941[(2)] = inst_31881);

(statearr_31894_31941[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (21))){
var inst_31834 = (state_31885[(2)]);
var inst_31835 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31836 = figwheel.client.auto_jump_to_error.call(null,opts,inst_31835);
var state_31885__$1 = (function (){var statearr_31895 = state_31885;
(statearr_31895[(7)] = inst_31834);

return statearr_31895;
})();
var statearr_31896_31942 = state_31885__$1;
(statearr_31896_31942[(2)] = inst_31836);

(statearr_31896_31942[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (31))){
var inst_31864 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31864)){
var statearr_31897_31943 = state_31885__$1;
(statearr_31897_31943[(1)] = (34));

} else {
var statearr_31898_31944 = state_31885__$1;
(statearr_31898_31944[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (32))){
var inst_31873 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31899_31945 = state_31885__$1;
(statearr_31899_31945[(2)] = inst_31873);

(statearr_31899_31945[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (33))){
var inst_31860 = (state_31885[(2)]);
var inst_31861 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31862 = figwheel.client.auto_jump_to_error.call(null,opts,inst_31861);
var state_31885__$1 = (function (){var statearr_31900 = state_31885;
(statearr_31900[(8)] = inst_31860);

return statearr_31900;
})();
var statearr_31901_31946 = state_31885__$1;
(statearr_31901_31946[(2)] = inst_31862);

(statearr_31901_31946[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (13))){
var inst_31819 = figwheel.client.heads_up.clear.call(null);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(16),inst_31819);
} else {
if((state_val_31886 === (22))){
var inst_31840 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31841 = figwheel.client.heads_up.append_warning_message.call(null,inst_31840);
var state_31885__$1 = state_31885;
var statearr_31902_31947 = state_31885__$1;
(statearr_31902_31947[(2)] = inst_31841);

(statearr_31902_31947[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (36))){
var inst_31871 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31903_31948 = state_31885__$1;
(statearr_31903_31948[(2)] = inst_31871);

(statearr_31903_31948[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (29))){
var inst_31851 = (state_31885[(2)]);
var inst_31852 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31853 = figwheel.client.auto_jump_to_error.call(null,opts,inst_31852);
var state_31885__$1 = (function (){var statearr_31904 = state_31885;
(statearr_31904[(9)] = inst_31851);

return statearr_31904;
})();
var statearr_31905_31949 = state_31885__$1;
(statearr_31905_31949[(2)] = inst_31853);

(statearr_31905_31949[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (6))){
var inst_31800 = (state_31885[(10)]);
var state_31885__$1 = state_31885;
var statearr_31906_31950 = state_31885__$1;
(statearr_31906_31950[(2)] = inst_31800);

(statearr_31906_31950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (28))){
var inst_31847 = (state_31885[(2)]);
var inst_31848 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31849 = figwheel.client.heads_up.display_warning.call(null,inst_31848);
var state_31885__$1 = (function (){var statearr_31907 = state_31885;
(statearr_31907[(11)] = inst_31847);

return statearr_31907;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(29),inst_31849);
} else {
if((state_val_31886 === (25))){
var inst_31845 = figwheel.client.heads_up.clear.call(null);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(28),inst_31845);
} else {
if((state_val_31886 === (34))){
var inst_31866 = figwheel.client.heads_up.flash_loaded.call(null);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(37),inst_31866);
} else {
if((state_val_31886 === (17))){
var inst_31825 = (state_31885[(2)]);
var inst_31826 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31827 = figwheel.client.auto_jump_to_error.call(null,opts,inst_31826);
var state_31885__$1 = (function (){var statearr_31908 = state_31885;
(statearr_31908[(12)] = inst_31825);

return statearr_31908;
})();
var statearr_31909_31951 = state_31885__$1;
(statearr_31909_31951[(2)] = inst_31827);

(statearr_31909_31951[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (3))){
var inst_31817 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31817)){
var statearr_31910_31952 = state_31885__$1;
(statearr_31910_31952[(1)] = (13));

} else {
var statearr_31911_31953 = state_31885__$1;
(statearr_31911_31953[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (12))){
var inst_31813 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31912_31954 = state_31885__$1;
(statearr_31912_31954[(2)] = inst_31813);

(statearr_31912_31954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (2))){
var inst_31800 = (state_31885[(10)]);
var inst_31800__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_31885__$1 = (function (){var statearr_31913 = state_31885;
(statearr_31913[(10)] = inst_31800__$1);

return statearr_31913;
})();
if(cljs.core.truth_(inst_31800__$1)){
var statearr_31914_31955 = state_31885__$1;
(statearr_31914_31955[(1)] = (5));

} else {
var statearr_31915_31956 = state_31885__$1;
(statearr_31915_31956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (23))){
var inst_31843 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31843)){
var statearr_31916_31957 = state_31885__$1;
(statearr_31916_31957[(1)] = (25));

} else {
var statearr_31917_31958 = state_31885__$1;
(statearr_31917_31958[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (35))){
var state_31885__$1 = state_31885;
var statearr_31918_31959 = state_31885__$1;
(statearr_31918_31959[(2)] = null);

(statearr_31918_31959[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (19))){
var inst_31838 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31838)){
var statearr_31919_31960 = state_31885__$1;
(statearr_31919_31960[(1)] = (22));

} else {
var statearr_31920_31961 = state_31885__$1;
(statearr_31920_31961[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (11))){
var inst_31809 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31921_31962 = state_31885__$1;
(statearr_31921_31962[(2)] = inst_31809);

(statearr_31921_31962[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (9))){
var inst_31811 = figwheel.client.heads_up.clear.call(null);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(12),inst_31811);
} else {
if((state_val_31886 === (5))){
var inst_31802 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_31885__$1 = state_31885;
var statearr_31922_31963 = state_31885__$1;
(statearr_31922_31963[(2)] = inst_31802);

(statearr_31922_31963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (14))){
var inst_31829 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31829)){
var statearr_31923_31964 = state_31885__$1;
(statearr_31923_31964[(1)] = (18));

} else {
var statearr_31924_31965 = state_31885__$1;
(statearr_31924_31965[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (26))){
var inst_31855 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_31885__$1 = state_31885;
if(cljs.core.truth_(inst_31855)){
var statearr_31925_31966 = state_31885__$1;
(statearr_31925_31966[(1)] = (30));

} else {
var statearr_31926_31967 = state_31885__$1;
(statearr_31926_31967[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (16))){
var inst_31821 = (state_31885[(2)]);
var inst_31822 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31823 = figwheel.client.heads_up.display_exception.call(null,inst_31822);
var state_31885__$1 = (function (){var statearr_31927 = state_31885;
(statearr_31927[(13)] = inst_31821);

return statearr_31927;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(17),inst_31823);
} else {
if((state_val_31886 === (30))){
var inst_31857 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31858 = figwheel.client.heads_up.display_warning.call(null,inst_31857);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(33),inst_31858);
} else {
if((state_val_31886 === (10))){
var inst_31815 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31928_31968 = state_31885__$1;
(statearr_31928_31968[(2)] = inst_31815);

(statearr_31928_31968[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (18))){
var inst_31831 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_31832 = figwheel.client.heads_up.display_exception.call(null,inst_31831);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(21),inst_31832);
} else {
if((state_val_31886 === (37))){
var inst_31868 = (state_31885[(2)]);
var state_31885__$1 = state_31885;
var statearr_31929_31969 = state_31885__$1;
(statearr_31929_31969[(2)] = inst_31868);

(statearr_31929_31969[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31886 === (8))){
var inst_31807 = figwheel.client.heads_up.flash_loaded.call(null);
var state_31885__$1 = state_31885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31885__$1,(11),inst_31807);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__23913__auto__,c__23969__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____0 = (function (){
var statearr_31930 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31930[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__);

(statearr_31930[(1)] = (1));

return statearr_31930;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____1 = (function (state_31885){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31931){if((e31931 instanceof Object)){
var ex__23917__auto__ = e31931;
var statearr_31932_31970 = state_31885;
(statearr_31932_31970[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31931;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31971 = state_31885;
state_31885 = G__31971;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__ = function(state_31885){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____1.call(this,state_31885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__,msg_hist,msg_names,msg))
})();
var state__23971__auto__ = (function (){var statearr_31933 = f__23970__auto__.call(null);
(statearr_31933[(6)] = c__23969__auto__);

return statearr_31933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__,msg_hist,msg_names,msg))
);

return c__23969__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__23969__auto___32000 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___32000,ch){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___32000,ch){
return (function (state_31986){
var state_val_31987 = (state_31986[(1)]);
if((state_val_31987 === (1))){
var state_31986__$1 = state_31986;
var statearr_31988_32001 = state_31986__$1;
(statearr_31988_32001[(2)] = null);

(statearr_31988_32001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31987 === (2))){
var state_31986__$1 = state_31986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31986__$1,(4),ch);
} else {
if((state_val_31987 === (3))){
var inst_31984 = (state_31986[(2)]);
var state_31986__$1 = state_31986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31986__$1,inst_31984);
} else {
if((state_val_31987 === (4))){
var inst_31974 = (state_31986[(7)]);
var inst_31974__$1 = (state_31986[(2)]);
var state_31986__$1 = (function (){var statearr_31989 = state_31986;
(statearr_31989[(7)] = inst_31974__$1);

return statearr_31989;
})();
if(cljs.core.truth_(inst_31974__$1)){
var statearr_31990_32002 = state_31986__$1;
(statearr_31990_32002[(1)] = (5));

} else {
var statearr_31991_32003 = state_31986__$1;
(statearr_31991_32003[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31987 === (5))){
var inst_31974 = (state_31986[(7)]);
var inst_31976 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_31974);
var state_31986__$1 = state_31986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31986__$1,(8),inst_31976);
} else {
if((state_val_31987 === (6))){
var state_31986__$1 = state_31986;
var statearr_31992_32004 = state_31986__$1;
(statearr_31992_32004[(2)] = null);

(statearr_31992_32004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31987 === (7))){
var inst_31982 = (state_31986[(2)]);
var state_31986__$1 = state_31986;
var statearr_31993_32005 = state_31986__$1;
(statearr_31993_32005[(2)] = inst_31982);

(statearr_31993_32005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31987 === (8))){
var inst_31978 = (state_31986[(2)]);
var state_31986__$1 = (function (){var statearr_31994 = state_31986;
(statearr_31994[(8)] = inst_31978);

return statearr_31994;
})();
var statearr_31995_32006 = state_31986__$1;
(statearr_31995_32006[(2)] = null);

(statearr_31995_32006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__23969__auto___32000,ch))
;
return ((function (switch__23913__auto__,c__23969__auto___32000,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__23914__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__23914__auto____0 = (function (){
var statearr_31996 = [null,null,null,null,null,null,null,null,null];
(statearr_31996[(0)] = figwheel$client$heads_up_plugin_$_state_machine__23914__auto__);

(statearr_31996[(1)] = (1));

return statearr_31996;
});
var figwheel$client$heads_up_plugin_$_state_machine__23914__auto____1 = (function (state_31986){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31997){if((e31997 instanceof Object)){
var ex__23917__auto__ = e31997;
var statearr_31998_32007 = state_31986;
(statearr_31998_32007[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32008 = state_31986;
state_31986 = G__32008;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__23914__auto__ = function(state_31986){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__23914__auto____1.call(this,state_31986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__23914__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__23914__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___32000,ch))
})();
var state__23971__auto__ = (function (){var statearr_31999 = f__23970__auto__.call(null);
(statearr_31999[(6)] = c__23969__auto___32000);

return statearr_31999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___32000,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__){
return (function (state_32014){
var state_val_32015 = (state_32014[(1)]);
if((state_val_32015 === (1))){
var inst_32009 = cljs.core.async.timeout.call(null,(3000));
var state_32014__$1 = state_32014;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32014__$1,(2),inst_32009);
} else {
if((state_val_32015 === (2))){
var inst_32011 = (state_32014[(2)]);
var inst_32012 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_32014__$1 = (function (){var statearr_32016 = state_32014;
(statearr_32016[(7)] = inst_32011);

return statearr_32016;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32014__$1,inst_32012);
} else {
return null;
}
}
});})(c__23969__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____0 = (function (){
var statearr_32017 = [null,null,null,null,null,null,null,null];
(statearr_32017[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__);

(statearr_32017[(1)] = (1));

return statearr_32017;
});
var figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____1 = (function (state_32014){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_32014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e32018){if((e32018 instanceof Object)){
var ex__23917__auto__ = e32018;
var statearr_32019_32021 = state_32014;
(statearr_32019_32021[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32018;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32022 = state_32014;
state_32014 = G__32022;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__ = function(state_32014){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____1.call(this,state_32014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__23914__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__))
})();
var state__23971__auto__ = (function (){var statearr_32020 = f__23970__auto__.call(null);
(statearr_32020[(6)] = c__23969__auto__);

return statearr_32020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__))
);

return c__23969__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__,figwheel_version,temp__5457__auto__){
return (function (state_32029){
var state_val_32030 = (state_32029[(1)]);
if((state_val_32030 === (1))){
var inst_32023 = cljs.core.async.timeout.call(null,(2000));
var state_32029__$1 = state_32029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32029__$1,(2),inst_32023);
} else {
if((state_val_32030 === (2))){
var inst_32025 = (state_32029[(2)]);
var inst_32026 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_32027 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_32026);
var state_32029__$1 = (function (){var statearr_32031 = state_32029;
(statearr_32031[(7)] = inst_32025);

return statearr_32031;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32029__$1,inst_32027);
} else {
return null;
}
}
});})(c__23969__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____0 = (function (){
var statearr_32032 = [null,null,null,null,null,null,null,null];
(statearr_32032[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__);

(statearr_32032[(1)] = (1));

return statearr_32032;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____1 = (function (state_32029){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_32029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e32033){if((e32033 instanceof Object)){
var ex__23917__auto__ = e32033;
var statearr_32034_32036 = state_32029;
(statearr_32034_32036[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32037 = state_32029;
state_32029 = G__32037;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__ = function(state_32029){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____1.call(this,state_32029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__,figwheel_version,temp__5457__auto__))
})();
var state__23971__auto__ = (function (){var statearr_32035 = f__23970__auto__.call(null);
(statearr_32035[(6)] = c__23969__auto__);

return statearr_32035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__,figwheel_version,temp__5457__auto__))
);

return c__23969__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__32038){
var map__32039 = p__32038;
var map__32039__$1 = ((((!((map__32039 == null)))?(((((map__32039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32039):map__32039);
var file = cljs.core.get.call(null,map__32039__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__32039__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__32039__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__32041 = "";
var G__32041__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32041),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__32041);
var G__32041__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32041__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__32041__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = line;
if(cljs.core.truth_(and__3938__auto__)){
return column;
} else {
return and__3938__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32041__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__32041__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__32042){
var map__32043 = p__32042;
var map__32043__$1 = ((((!((map__32043 == null)))?(((((map__32043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32043):map__32043);
var ed = map__32043__$1;
var formatted_exception = cljs.core.get.call(null,map__32043__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__32043__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__32043__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__32045_32049 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__32046_32050 = null;
var count__32047_32051 = (0);
var i__32048_32052 = (0);
while(true){
if((i__32048_32052 < count__32047_32051)){
var msg_32053 = cljs.core._nth.call(null,chunk__32046_32050,i__32048_32052);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32053);


var G__32054 = seq__32045_32049;
var G__32055 = chunk__32046_32050;
var G__32056 = count__32047_32051;
var G__32057 = (i__32048_32052 + (1));
seq__32045_32049 = G__32054;
chunk__32046_32050 = G__32055;
count__32047_32051 = G__32056;
i__32048_32052 = G__32057;
continue;
} else {
var temp__5457__auto___32058 = cljs.core.seq.call(null,seq__32045_32049);
if(temp__5457__auto___32058){
var seq__32045_32059__$1 = temp__5457__auto___32058;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32045_32059__$1)){
var c__4351__auto___32060 = cljs.core.chunk_first.call(null,seq__32045_32059__$1);
var G__32061 = cljs.core.chunk_rest.call(null,seq__32045_32059__$1);
var G__32062 = c__4351__auto___32060;
var G__32063 = cljs.core.count.call(null,c__4351__auto___32060);
var G__32064 = (0);
seq__32045_32049 = G__32061;
chunk__32046_32050 = G__32062;
count__32047_32051 = G__32063;
i__32048_32052 = G__32064;
continue;
} else {
var msg_32065 = cljs.core.first.call(null,seq__32045_32059__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32065);


var G__32066 = cljs.core.next.call(null,seq__32045_32059__$1);
var G__32067 = null;
var G__32068 = (0);
var G__32069 = (0);
seq__32045_32049 = G__32066;
chunk__32046_32050 = G__32067;
count__32047_32051 = G__32068;
i__32048_32052 = G__32069;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__32070){
var map__32071 = p__32070;
var map__32071__$1 = ((((!((map__32071 == null)))?(((((map__32071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32071.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32071):map__32071);
var w = map__32071__$1;
var message = cljs.core.get.call(null,map__32071__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3938__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3938__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__32073 = cljs.core.seq.call(null,plugins);
var chunk__32074 = null;
var count__32075 = (0);
var i__32076 = (0);
while(true){
if((i__32076 < count__32075)){
var vec__32077 = cljs.core._nth.call(null,chunk__32074,i__32076);
var k = cljs.core.nth.call(null,vec__32077,(0),null);
var plugin = cljs.core.nth.call(null,vec__32077,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32083 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32073,chunk__32074,count__32075,i__32076,pl_32083,vec__32077,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_32083.call(null,msg_hist);
});})(seq__32073,chunk__32074,count__32075,i__32076,pl_32083,vec__32077,k,plugin))
);
} else {
}


var G__32084 = seq__32073;
var G__32085 = chunk__32074;
var G__32086 = count__32075;
var G__32087 = (i__32076 + (1));
seq__32073 = G__32084;
chunk__32074 = G__32085;
count__32075 = G__32086;
i__32076 = G__32087;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32073);
if(temp__5457__auto__){
var seq__32073__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32073__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__32073__$1);
var G__32088 = cljs.core.chunk_rest.call(null,seq__32073__$1);
var G__32089 = c__4351__auto__;
var G__32090 = cljs.core.count.call(null,c__4351__auto__);
var G__32091 = (0);
seq__32073 = G__32088;
chunk__32074 = G__32089;
count__32075 = G__32090;
i__32076 = G__32091;
continue;
} else {
var vec__32080 = cljs.core.first.call(null,seq__32073__$1);
var k = cljs.core.nth.call(null,vec__32080,(0),null);
var plugin = cljs.core.nth.call(null,vec__32080,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32092 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32073,chunk__32074,count__32075,i__32076,pl_32092,vec__32080,k,plugin,seq__32073__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_32092.call(null,msg_hist);
});})(seq__32073,chunk__32074,count__32075,i__32076,pl_32092,vec__32080,k,plugin,seq__32073__$1,temp__5457__auto__))
);
} else {
}


var G__32093 = cljs.core.next.call(null,seq__32073__$1);
var G__32094 = null;
var G__32095 = (0);
var G__32096 = (0);
seq__32073 = G__32093;
chunk__32074 = G__32094;
count__32075 = G__32095;
i__32076 = G__32096;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__32098 = arguments.length;
switch (G__32098) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__32099_32104 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__32100_32105 = null;
var count__32101_32106 = (0);
var i__32102_32107 = (0);
while(true){
if((i__32102_32107 < count__32101_32106)){
var msg_32108 = cljs.core._nth.call(null,chunk__32100_32105,i__32102_32107);
figwheel.client.socket.handle_incoming_message.call(null,msg_32108);


var G__32109 = seq__32099_32104;
var G__32110 = chunk__32100_32105;
var G__32111 = count__32101_32106;
var G__32112 = (i__32102_32107 + (1));
seq__32099_32104 = G__32109;
chunk__32100_32105 = G__32110;
count__32101_32106 = G__32111;
i__32102_32107 = G__32112;
continue;
} else {
var temp__5457__auto___32113 = cljs.core.seq.call(null,seq__32099_32104);
if(temp__5457__auto___32113){
var seq__32099_32114__$1 = temp__5457__auto___32113;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32099_32114__$1)){
var c__4351__auto___32115 = cljs.core.chunk_first.call(null,seq__32099_32114__$1);
var G__32116 = cljs.core.chunk_rest.call(null,seq__32099_32114__$1);
var G__32117 = c__4351__auto___32115;
var G__32118 = cljs.core.count.call(null,c__4351__auto___32115);
var G__32119 = (0);
seq__32099_32104 = G__32116;
chunk__32100_32105 = G__32117;
count__32101_32106 = G__32118;
i__32102_32107 = G__32119;
continue;
} else {
var msg_32120 = cljs.core.first.call(null,seq__32099_32114__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_32120);


var G__32121 = cljs.core.next.call(null,seq__32099_32114__$1);
var G__32122 = null;
var G__32123 = (0);
var G__32124 = (0);
seq__32099_32104 = G__32121;
chunk__32100_32105 = G__32122;
count__32101_32106 = G__32123;
i__32102_32107 = G__32124;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32129 = arguments.length;
var i__4532__auto___32130 = (0);
while(true){
if((i__4532__auto___32130 < len__4531__auto___32129)){
args__4534__auto__.push((arguments[i__4532__auto___32130]));

var G__32131 = (i__4532__auto___32130 + (1));
i__4532__auto___32130 = G__32131;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__32126){
var map__32127 = p__32126;
var map__32127__$1 = ((((!((map__32127 == null)))?(((((map__32127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32127.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32127):map__32127);
var opts = map__32127__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq32125){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32125));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e32132){if((e32132 instanceof Error)){
var e = e32132;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e32132;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__32133){
var map__32134 = p__32133;
var map__32134__$1 = ((((!((map__32134 == null)))?(((((map__32134.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32134.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32134):map__32134);
var msg_name = cljs.core.get.call(null,map__32134__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1540478351990
