// Compiled by ClojureScript 1.10.339 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3949__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__3949__auto__){
return or__3949__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3949__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__30792_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__30792_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__30793 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__30794 = null;
var count__30795 = (0);
var i__30796 = (0);
while(true){
if((i__30796 < count__30795)){
var n = cljs.core._nth.call(null,chunk__30794,i__30796);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30797 = seq__30793;
var G__30798 = chunk__30794;
var G__30799 = count__30795;
var G__30800 = (i__30796 + (1));
seq__30793 = G__30797;
chunk__30794 = G__30798;
count__30795 = G__30799;
i__30796 = G__30800;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30793);
if(temp__5457__auto__){
var seq__30793__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30793__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__30793__$1);
var G__30801 = cljs.core.chunk_rest.call(null,seq__30793__$1);
var G__30802 = c__4351__auto__;
var G__30803 = cljs.core.count.call(null,c__4351__auto__);
var G__30804 = (0);
seq__30793 = G__30801;
chunk__30794 = G__30802;
count__30795 = G__30803;
i__30796 = G__30804;
continue;
} else {
var n = cljs.core.first.call(null,seq__30793__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30805 = cljs.core.next.call(null,seq__30793__$1);
var G__30806 = null;
var G__30807 = (0);
var G__30808 = (0);
seq__30793 = G__30805;
chunk__30794 = G__30806;
count__30795 = G__30807;
i__30796 = G__30808;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__30809){
var vec__30810 = p__30809;
var _ = cljs.core.nth.call(null,vec__30810,(0),null);
var v = cljs.core.nth.call(null,vec__30810,(1),null);
var and__3938__auto__ = v;
if(cljs.core.truth_(and__3938__auto__)){
return v.call(null,dep);
} else {
return and__3938__auto__;
}
}),cljs.core.filter.call(null,(function (p__30813){
var vec__30814 = p__30813;
var k = cljs.core.nth.call(null,vec__30814,(0),null);
var v = cljs.core.nth.call(null,vec__30814,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__30826_30834 = cljs.core.seq.call(null,deps);
var chunk__30827_30835 = null;
var count__30828_30836 = (0);
var i__30829_30837 = (0);
while(true){
if((i__30829_30837 < count__30828_30836)){
var dep_30838 = cljs.core._nth.call(null,chunk__30827_30835,i__30829_30837);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_30838;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30838));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30838,(depth + (1)),state);
} else {
}


var G__30839 = seq__30826_30834;
var G__30840 = chunk__30827_30835;
var G__30841 = count__30828_30836;
var G__30842 = (i__30829_30837 + (1));
seq__30826_30834 = G__30839;
chunk__30827_30835 = G__30840;
count__30828_30836 = G__30841;
i__30829_30837 = G__30842;
continue;
} else {
var temp__5457__auto___30843 = cljs.core.seq.call(null,seq__30826_30834);
if(temp__5457__auto___30843){
var seq__30826_30844__$1 = temp__5457__auto___30843;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30826_30844__$1)){
var c__4351__auto___30845 = cljs.core.chunk_first.call(null,seq__30826_30844__$1);
var G__30846 = cljs.core.chunk_rest.call(null,seq__30826_30844__$1);
var G__30847 = c__4351__auto___30845;
var G__30848 = cljs.core.count.call(null,c__4351__auto___30845);
var G__30849 = (0);
seq__30826_30834 = G__30846;
chunk__30827_30835 = G__30847;
count__30828_30836 = G__30848;
i__30829_30837 = G__30849;
continue;
} else {
var dep_30850 = cljs.core.first.call(null,seq__30826_30844__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_30850;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30850));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30850,(depth + (1)),state);
} else {
}


var G__30851 = cljs.core.next.call(null,seq__30826_30844__$1);
var G__30852 = null;
var G__30853 = (0);
var G__30854 = (0);
seq__30826_30834 = G__30851;
chunk__30827_30835 = G__30852;
count__30828_30836 = G__30853;
i__30829_30837 = G__30854;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__30830){
var vec__30831 = p__30830;
var seq__30832 = cljs.core.seq.call(null,vec__30831);
var first__30833 = cljs.core.first.call(null,seq__30832);
var seq__30832__$1 = cljs.core.next.call(null,seq__30832);
var x = first__30833;
var xs = seq__30832__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__30831,seq__30832,first__30833,seq__30832__$1,x,xs,get_deps__$1){
return (function (p1__30817_SHARP_){
return clojure.set.difference.call(null,p1__30817_SHARP_,x);
});})(vec__30831,seq__30832,first__30833,seq__30832__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__30855 = cljs.core.seq.call(null,provides);
var chunk__30856 = null;
var count__30857 = (0);
var i__30858 = (0);
while(true){
if((i__30858 < count__30857)){
var prov = cljs.core._nth.call(null,chunk__30856,i__30858);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30859_30867 = cljs.core.seq.call(null,requires);
var chunk__30860_30868 = null;
var count__30861_30869 = (0);
var i__30862_30870 = (0);
while(true){
if((i__30862_30870 < count__30861_30869)){
var req_30871 = cljs.core._nth.call(null,chunk__30860_30868,i__30862_30870);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30871,prov);


var G__30872 = seq__30859_30867;
var G__30873 = chunk__30860_30868;
var G__30874 = count__30861_30869;
var G__30875 = (i__30862_30870 + (1));
seq__30859_30867 = G__30872;
chunk__30860_30868 = G__30873;
count__30861_30869 = G__30874;
i__30862_30870 = G__30875;
continue;
} else {
var temp__5457__auto___30876 = cljs.core.seq.call(null,seq__30859_30867);
if(temp__5457__auto___30876){
var seq__30859_30877__$1 = temp__5457__auto___30876;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30859_30877__$1)){
var c__4351__auto___30878 = cljs.core.chunk_first.call(null,seq__30859_30877__$1);
var G__30879 = cljs.core.chunk_rest.call(null,seq__30859_30877__$1);
var G__30880 = c__4351__auto___30878;
var G__30881 = cljs.core.count.call(null,c__4351__auto___30878);
var G__30882 = (0);
seq__30859_30867 = G__30879;
chunk__30860_30868 = G__30880;
count__30861_30869 = G__30881;
i__30862_30870 = G__30882;
continue;
} else {
var req_30883 = cljs.core.first.call(null,seq__30859_30877__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30883,prov);


var G__30884 = cljs.core.next.call(null,seq__30859_30877__$1);
var G__30885 = null;
var G__30886 = (0);
var G__30887 = (0);
seq__30859_30867 = G__30884;
chunk__30860_30868 = G__30885;
count__30861_30869 = G__30886;
i__30862_30870 = G__30887;
continue;
}
} else {
}
}
break;
}


var G__30888 = seq__30855;
var G__30889 = chunk__30856;
var G__30890 = count__30857;
var G__30891 = (i__30858 + (1));
seq__30855 = G__30888;
chunk__30856 = G__30889;
count__30857 = G__30890;
i__30858 = G__30891;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30855);
if(temp__5457__auto__){
var seq__30855__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30855__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__30855__$1);
var G__30892 = cljs.core.chunk_rest.call(null,seq__30855__$1);
var G__30893 = c__4351__auto__;
var G__30894 = cljs.core.count.call(null,c__4351__auto__);
var G__30895 = (0);
seq__30855 = G__30892;
chunk__30856 = G__30893;
count__30857 = G__30894;
i__30858 = G__30895;
continue;
} else {
var prov = cljs.core.first.call(null,seq__30855__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30863_30896 = cljs.core.seq.call(null,requires);
var chunk__30864_30897 = null;
var count__30865_30898 = (0);
var i__30866_30899 = (0);
while(true){
if((i__30866_30899 < count__30865_30898)){
var req_30900 = cljs.core._nth.call(null,chunk__30864_30897,i__30866_30899);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30900,prov);


var G__30901 = seq__30863_30896;
var G__30902 = chunk__30864_30897;
var G__30903 = count__30865_30898;
var G__30904 = (i__30866_30899 + (1));
seq__30863_30896 = G__30901;
chunk__30864_30897 = G__30902;
count__30865_30898 = G__30903;
i__30866_30899 = G__30904;
continue;
} else {
var temp__5457__auto___30905__$1 = cljs.core.seq.call(null,seq__30863_30896);
if(temp__5457__auto___30905__$1){
var seq__30863_30906__$1 = temp__5457__auto___30905__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30863_30906__$1)){
var c__4351__auto___30907 = cljs.core.chunk_first.call(null,seq__30863_30906__$1);
var G__30908 = cljs.core.chunk_rest.call(null,seq__30863_30906__$1);
var G__30909 = c__4351__auto___30907;
var G__30910 = cljs.core.count.call(null,c__4351__auto___30907);
var G__30911 = (0);
seq__30863_30896 = G__30908;
chunk__30864_30897 = G__30909;
count__30865_30898 = G__30910;
i__30866_30899 = G__30911;
continue;
} else {
var req_30912 = cljs.core.first.call(null,seq__30863_30906__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30912,prov);


var G__30913 = cljs.core.next.call(null,seq__30863_30906__$1);
var G__30914 = null;
var G__30915 = (0);
var G__30916 = (0);
seq__30863_30896 = G__30913;
chunk__30864_30897 = G__30914;
count__30865_30898 = G__30915;
i__30866_30899 = G__30916;
continue;
}
} else {
}
}
break;
}


var G__30917 = cljs.core.next.call(null,seq__30855__$1);
var G__30918 = null;
var G__30919 = (0);
var G__30920 = (0);
seq__30855 = G__30917;
chunk__30856 = G__30918;
count__30857 = G__30919;
i__30858 = G__30920;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__30921_30925 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__30922_30926 = null;
var count__30923_30927 = (0);
var i__30924_30928 = (0);
while(true){
if((i__30924_30928 < count__30923_30927)){
var ns_30929 = cljs.core._nth.call(null,chunk__30922_30926,i__30924_30928);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30929);


var G__30930 = seq__30921_30925;
var G__30931 = chunk__30922_30926;
var G__30932 = count__30923_30927;
var G__30933 = (i__30924_30928 + (1));
seq__30921_30925 = G__30930;
chunk__30922_30926 = G__30931;
count__30923_30927 = G__30932;
i__30924_30928 = G__30933;
continue;
} else {
var temp__5457__auto___30934 = cljs.core.seq.call(null,seq__30921_30925);
if(temp__5457__auto___30934){
var seq__30921_30935__$1 = temp__5457__auto___30934;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30921_30935__$1)){
var c__4351__auto___30936 = cljs.core.chunk_first.call(null,seq__30921_30935__$1);
var G__30937 = cljs.core.chunk_rest.call(null,seq__30921_30935__$1);
var G__30938 = c__4351__auto___30936;
var G__30939 = cljs.core.count.call(null,c__4351__auto___30936);
var G__30940 = (0);
seq__30921_30925 = G__30937;
chunk__30922_30926 = G__30938;
count__30923_30927 = G__30939;
i__30924_30928 = G__30940;
continue;
} else {
var ns_30941 = cljs.core.first.call(null,seq__30921_30935__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30941);


var G__30942 = cljs.core.next.call(null,seq__30921_30935__$1);
var G__30943 = null;
var G__30944 = (0);
var G__30945 = (0);
seq__30921_30925 = G__30942;
chunk__30922_30926 = G__30943;
count__30923_30927 = G__30944;
i__30924_30928 = G__30945;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3949__auto__ = goog.require__;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__30946__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__30946 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__30947__i = 0, G__30947__a = new Array(arguments.length -  0);
while (G__30947__i < G__30947__a.length) {G__30947__a[G__30947__i] = arguments[G__30947__i + 0]; ++G__30947__i;}
  args = new cljs.core.IndexedSeq(G__30947__a,0,null);
} 
return G__30946__delegate.call(this,args);};
G__30946.cljs$lang$maxFixedArity = 0;
G__30946.cljs$lang$applyTo = (function (arglist__30948){
var args = cljs.core.seq(arglist__30948);
return G__30946__delegate(args);
});
G__30946.cljs$core$IFn$_invoke$arity$variadic = G__30946__delegate;
return G__30946;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__30949_SHARP_,p2__30950_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30949_SHARP_)].join('')),p2__30950_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__30951_SHARP_,p2__30952_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30951_SHARP_)].join(''),p2__30952_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__30953 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__30953.addCallback(((function (G__30953){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__30953))
);

G__30953.addErrback(((function (G__30953){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__30953))
);

return G__30953;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e30954){if((e30954 instanceof Error)){
var e = e30954;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30954;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e30955){if((e30955 instanceof Error)){
var e = e30955;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30955;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__30956 = cljs.core._EQ_;
var expr__30957 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__30956.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__30957))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__30956.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__30957))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__30956.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__30957))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__30956,expr__30957){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__30956,expr__30957))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__30959,callback){
var map__30960 = p__30959;
var map__30960__$1 = ((((!((map__30960 == null)))?(((((map__30960.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30960.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30960):map__30960);
var file_msg = map__30960__$1;
var request_url = cljs.core.get.call(null,map__30960__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3949__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__30960,map__30960__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__30960,map__30960__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__){
return (function (state_30998){
var state_val_30999 = (state_30998[(1)]);
if((state_val_30999 === (7))){
var inst_30994 = (state_30998[(2)]);
var state_30998__$1 = state_30998;
var statearr_31000_31026 = state_30998__$1;
(statearr_31000_31026[(2)] = inst_30994);

(statearr_31000_31026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (1))){
var state_30998__$1 = state_30998;
var statearr_31001_31027 = state_30998__$1;
(statearr_31001_31027[(2)] = null);

(statearr_31001_31027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (4))){
var inst_30964 = (state_30998[(7)]);
var inst_30964__$1 = (state_30998[(2)]);
var state_30998__$1 = (function (){var statearr_31002 = state_30998;
(statearr_31002[(7)] = inst_30964__$1);

return statearr_31002;
})();
if(cljs.core.truth_(inst_30964__$1)){
var statearr_31003_31028 = state_30998__$1;
(statearr_31003_31028[(1)] = (5));

} else {
var statearr_31004_31029 = state_30998__$1;
(statearr_31004_31029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (15))){
var inst_30977 = (state_30998[(8)]);
var inst_30979 = (state_30998[(9)]);
var inst_30981 = inst_30979.call(null,inst_30977);
var state_30998__$1 = state_30998;
var statearr_31005_31030 = state_30998__$1;
(statearr_31005_31030[(2)] = inst_30981);

(statearr_31005_31030[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (13))){
var inst_30988 = (state_30998[(2)]);
var state_30998__$1 = state_30998;
var statearr_31006_31031 = state_30998__$1;
(statearr_31006_31031[(2)] = inst_30988);

(statearr_31006_31031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (6))){
var state_30998__$1 = state_30998;
var statearr_31007_31032 = state_30998__$1;
(statearr_31007_31032[(2)] = null);

(statearr_31007_31032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (17))){
var inst_30985 = (state_30998[(2)]);
var state_30998__$1 = state_30998;
var statearr_31008_31033 = state_30998__$1;
(statearr_31008_31033[(2)] = inst_30985);

(statearr_31008_31033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (3))){
var inst_30996 = (state_30998[(2)]);
var state_30998__$1 = state_30998;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30998__$1,inst_30996);
} else {
if((state_val_30999 === (12))){
var state_30998__$1 = state_30998;
var statearr_31009_31034 = state_30998__$1;
(statearr_31009_31034[(2)] = null);

(statearr_31009_31034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (2))){
var state_30998__$1 = state_30998;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30998__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_30999 === (11))){
var inst_30969 = (state_30998[(10)]);
var inst_30975 = figwheel.client.file_reloading.blocking_load.call(null,inst_30969);
var state_30998__$1 = state_30998;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30998__$1,(14),inst_30975);
} else {
if((state_val_30999 === (9))){
var inst_30969 = (state_30998[(10)]);
var state_30998__$1 = state_30998;
if(cljs.core.truth_(inst_30969)){
var statearr_31010_31035 = state_30998__$1;
(statearr_31010_31035[(1)] = (11));

} else {
var statearr_31011_31036 = state_30998__$1;
(statearr_31011_31036[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (5))){
var inst_30964 = (state_30998[(7)]);
var inst_30970 = (state_30998[(11)]);
var inst_30969 = cljs.core.nth.call(null,inst_30964,(0),null);
var inst_30970__$1 = cljs.core.nth.call(null,inst_30964,(1),null);
var state_30998__$1 = (function (){var statearr_31012 = state_30998;
(statearr_31012[(10)] = inst_30969);

(statearr_31012[(11)] = inst_30970__$1);

return statearr_31012;
})();
if(cljs.core.truth_(inst_30970__$1)){
var statearr_31013_31037 = state_30998__$1;
(statearr_31013_31037[(1)] = (8));

} else {
var statearr_31014_31038 = state_30998__$1;
(statearr_31014_31038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (14))){
var inst_30979 = (state_30998[(9)]);
var inst_30969 = (state_30998[(10)]);
var inst_30977 = (state_30998[(2)]);
var inst_30978 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_30979__$1 = cljs.core.get.call(null,inst_30978,inst_30969);
var state_30998__$1 = (function (){var statearr_31015 = state_30998;
(statearr_31015[(8)] = inst_30977);

(statearr_31015[(9)] = inst_30979__$1);

return statearr_31015;
})();
if(cljs.core.truth_(inst_30979__$1)){
var statearr_31016_31039 = state_30998__$1;
(statearr_31016_31039[(1)] = (15));

} else {
var statearr_31017_31040 = state_30998__$1;
(statearr_31017_31040[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (16))){
var inst_30977 = (state_30998[(8)]);
var inst_30983 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_30977);
var state_30998__$1 = state_30998;
var statearr_31018_31041 = state_30998__$1;
(statearr_31018_31041[(2)] = inst_30983);

(statearr_31018_31041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (10))){
var inst_30990 = (state_30998[(2)]);
var state_30998__$1 = (function (){var statearr_31019 = state_30998;
(statearr_31019[(12)] = inst_30990);

return statearr_31019;
})();
var statearr_31020_31042 = state_30998__$1;
(statearr_31020_31042[(2)] = null);

(statearr_31020_31042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30999 === (8))){
var inst_30970 = (state_30998[(11)]);
var inst_30972 = eval(inst_30970);
var state_30998__$1 = state_30998;
var statearr_31021_31043 = state_30998__$1;
(statearr_31021_31043[(2)] = inst_30972);

(statearr_31021_31043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__))
;
return ((function (switch__23913__auto__,c__23969__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__23914__auto__ = null;
var figwheel$client$file_reloading$state_machine__23914__auto____0 = (function (){
var statearr_31022 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31022[(0)] = figwheel$client$file_reloading$state_machine__23914__auto__);

(statearr_31022[(1)] = (1));

return statearr_31022;
});
var figwheel$client$file_reloading$state_machine__23914__auto____1 = (function (state_30998){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_30998);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31023){if((e31023 instanceof Object)){
var ex__23917__auto__ = e31023;
var statearr_31024_31044 = state_30998;
(statearr_31024_31044[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30998);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31045 = state_30998;
state_30998 = G__31045;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__23914__auto__ = function(state_30998){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__23914__auto____1.call(this,state_30998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__23914__auto____0;
figwheel$client$file_reloading$state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__23914__auto____1;
return figwheel$client$file_reloading$state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__))
})();
var state__23971__auto__ = (function (){var statearr_31025 = f__23970__auto__.call(null);
(statearr_31025[(6)] = c__23969__auto__);

return statearr_31025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__))
);

return c__23969__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__31047 = arguments.length;
switch (G__31047) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__31049,callback){
var map__31050 = p__31049;
var map__31050__$1 = ((((!((map__31050 == null)))?(((((map__31050.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31050.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31050):map__31050);
var file_msg = map__31050__$1;
var namespace = cljs.core.get.call(null,map__31050__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__31050,map__31050__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__31050,map__31050__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__31052){
var map__31053 = p__31052;
var map__31053__$1 = ((((!((map__31053 == null)))?(((((map__31053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31053.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31053):map__31053);
var file_msg = map__31053__$1;
var namespace = cljs.core.get.call(null,map__31053__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__31055){
var map__31056 = p__31055;
var map__31056__$1 = ((((!((map__31056 == null)))?(((((map__31056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31056.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31056):map__31056);
var file_msg = map__31056__$1;
var namespace = cljs.core.get.call(null,map__31056__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3938__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3938__auto__){
var or__3949__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
var or__3949__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3949__auto____$2)){
return or__3949__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3938__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__31058,callback){
var map__31059 = p__31058;
var map__31059__$1 = ((((!((map__31059 == null)))?(((((map__31059.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31059.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31059):map__31059);
var file_msg = map__31059__$1;
var request_url = cljs.core.get.call(null,map__31059__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__31059__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23969__auto___31109 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto___31109,out){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto___31109,out){
return (function (state_31094){
var state_val_31095 = (state_31094[(1)]);
if((state_val_31095 === (1))){
var inst_31068 = cljs.core.seq.call(null,files);
var inst_31069 = cljs.core.first.call(null,inst_31068);
var inst_31070 = cljs.core.next.call(null,inst_31068);
var inst_31071 = files;
var state_31094__$1 = (function (){var statearr_31096 = state_31094;
(statearr_31096[(7)] = inst_31071);

(statearr_31096[(8)] = inst_31069);

(statearr_31096[(9)] = inst_31070);

return statearr_31096;
})();
var statearr_31097_31110 = state_31094__$1;
(statearr_31097_31110[(2)] = null);

(statearr_31097_31110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31095 === (2))){
var inst_31071 = (state_31094[(7)]);
var inst_31077 = (state_31094[(10)]);
var inst_31076 = cljs.core.seq.call(null,inst_31071);
var inst_31077__$1 = cljs.core.first.call(null,inst_31076);
var inst_31078 = cljs.core.next.call(null,inst_31076);
var inst_31079 = (inst_31077__$1 == null);
var inst_31080 = cljs.core.not.call(null,inst_31079);
var state_31094__$1 = (function (){var statearr_31098 = state_31094;
(statearr_31098[(11)] = inst_31078);

(statearr_31098[(10)] = inst_31077__$1);

return statearr_31098;
})();
if(inst_31080){
var statearr_31099_31111 = state_31094__$1;
(statearr_31099_31111[(1)] = (4));

} else {
var statearr_31100_31112 = state_31094__$1;
(statearr_31100_31112[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31095 === (3))){
var inst_31092 = (state_31094[(2)]);
var state_31094__$1 = state_31094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31094__$1,inst_31092);
} else {
if((state_val_31095 === (4))){
var inst_31077 = (state_31094[(10)]);
var inst_31082 = figwheel.client.file_reloading.reload_js_file.call(null,inst_31077);
var state_31094__$1 = state_31094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31094__$1,(7),inst_31082);
} else {
if((state_val_31095 === (5))){
var inst_31088 = cljs.core.async.close_BANG_.call(null,out);
var state_31094__$1 = state_31094;
var statearr_31101_31113 = state_31094__$1;
(statearr_31101_31113[(2)] = inst_31088);

(statearr_31101_31113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31095 === (6))){
var inst_31090 = (state_31094[(2)]);
var state_31094__$1 = state_31094;
var statearr_31102_31114 = state_31094__$1;
(statearr_31102_31114[(2)] = inst_31090);

(statearr_31102_31114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31095 === (7))){
var inst_31078 = (state_31094[(11)]);
var inst_31084 = (state_31094[(2)]);
var inst_31085 = cljs.core.async.put_BANG_.call(null,out,inst_31084);
var inst_31071 = inst_31078;
var state_31094__$1 = (function (){var statearr_31103 = state_31094;
(statearr_31103[(7)] = inst_31071);

(statearr_31103[(12)] = inst_31085);

return statearr_31103;
})();
var statearr_31104_31115 = state_31094__$1;
(statearr_31104_31115[(2)] = null);

(statearr_31104_31115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23969__auto___31109,out))
;
return ((function (switch__23913__auto__,c__23969__auto___31109,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____0 = (function (){
var statearr_31105 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31105[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__);

(statearr_31105[(1)] = (1));

return statearr_31105;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____1 = (function (state_31094){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31106){if((e31106 instanceof Object)){
var ex__23917__auto__ = e31106;
var statearr_31107_31116 = state_31094;
(statearr_31107_31116[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31117 = state_31094;
state_31094 = G__31117;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__ = function(state_31094){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____1.call(this,state_31094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto___31109,out))
})();
var state__23971__auto__ = (function (){var statearr_31108 = f__23970__auto__.call(null);
(statearr_31108[(6)] = c__23969__auto___31109);

return statearr_31108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto___31109,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__31118,opts){
var map__31119 = p__31118;
var map__31119__$1 = ((((!((map__31119 == null)))?(((((map__31119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31119):map__31119);
var eval_body = cljs.core.get.call(null,map__31119__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__31119__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__3938__auto__ = eval_body;
if(cljs.core.truth_(and__3938__auto__)){
return typeof eval_body === 'string';
} else {
return and__3938__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e31121){var e = e31121;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__31122_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31122_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__31123){
var vec__31124 = p__31123;
var k = cljs.core.nth.call(null,vec__31124,(0),null);
var v = cljs.core.nth.call(null,vec__31124,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__31127){
var vec__31128 = p__31127;
var k = cljs.core.nth.call(null,vec__31128,(0),null);
var v = cljs.core.nth.call(null,vec__31128,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__31134,p__31135){
var map__31136 = p__31134;
var map__31136__$1 = ((((!((map__31136 == null)))?(((((map__31136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31136.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31136):map__31136);
var opts = map__31136__$1;
var before_jsload = cljs.core.get.call(null,map__31136__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__31136__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__31136__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__31137 = p__31135;
var map__31137__$1 = ((((!((map__31137 == null)))?(((((map__31137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31137.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31137):map__31137);
var msg = map__31137__$1;
var files = cljs.core.get.call(null,map__31137__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__31137__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__31137__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23969__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23970__auto__ = (function (){var switch__23913__auto__ = ((function (c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_31291){
var state_val_31292 = (state_31291[(1)]);
if((state_val_31292 === (7))){
var inst_31153 = (state_31291[(7)]);
var inst_31151 = (state_31291[(8)]);
var inst_31152 = (state_31291[(9)]);
var inst_31154 = (state_31291[(10)]);
var inst_31159 = cljs.core._nth.call(null,inst_31152,inst_31154);
var inst_31160 = figwheel.client.file_reloading.eval_body.call(null,inst_31159,opts);
var inst_31161 = (inst_31154 + (1));
var tmp31293 = inst_31153;
var tmp31294 = inst_31151;
var tmp31295 = inst_31152;
var inst_31151__$1 = tmp31294;
var inst_31152__$1 = tmp31295;
var inst_31153__$1 = tmp31293;
var inst_31154__$1 = inst_31161;
var state_31291__$1 = (function (){var statearr_31296 = state_31291;
(statearr_31296[(11)] = inst_31160);

(statearr_31296[(7)] = inst_31153__$1);

(statearr_31296[(8)] = inst_31151__$1);

(statearr_31296[(9)] = inst_31152__$1);

(statearr_31296[(10)] = inst_31154__$1);

return statearr_31296;
})();
var statearr_31297_31380 = state_31291__$1;
(statearr_31297_31380[(2)] = null);

(statearr_31297_31380[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (20))){
var inst_31194 = (state_31291[(12)]);
var inst_31202 = figwheel.client.file_reloading.sort_files.call(null,inst_31194);
var state_31291__$1 = state_31291;
var statearr_31298_31381 = state_31291__$1;
(statearr_31298_31381[(2)] = inst_31202);

(statearr_31298_31381[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (27))){
var state_31291__$1 = state_31291;
var statearr_31299_31382 = state_31291__$1;
(statearr_31299_31382[(2)] = null);

(statearr_31299_31382[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (1))){
var inst_31143 = (state_31291[(13)]);
var inst_31140 = before_jsload.call(null,files);
var inst_31141 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_31142 = (function (){return ((function (inst_31143,inst_31140,inst_31141,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31131_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31131_SHARP_);
});
;})(inst_31143,inst_31140,inst_31141,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31143__$1 = cljs.core.filter.call(null,inst_31142,files);
var inst_31144 = cljs.core.not_empty.call(null,inst_31143__$1);
var state_31291__$1 = (function (){var statearr_31300 = state_31291;
(statearr_31300[(14)] = inst_31140);

(statearr_31300[(13)] = inst_31143__$1);

(statearr_31300[(15)] = inst_31141);

return statearr_31300;
})();
if(cljs.core.truth_(inst_31144)){
var statearr_31301_31383 = state_31291__$1;
(statearr_31301_31383[(1)] = (2));

} else {
var statearr_31302_31384 = state_31291__$1;
(statearr_31302_31384[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (24))){
var state_31291__$1 = state_31291;
var statearr_31303_31385 = state_31291__$1;
(statearr_31303_31385[(2)] = null);

(statearr_31303_31385[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (39))){
var inst_31244 = (state_31291[(16)]);
var state_31291__$1 = state_31291;
var statearr_31304_31386 = state_31291__$1;
(statearr_31304_31386[(2)] = inst_31244);

(statearr_31304_31386[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (46))){
var inst_31286 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31305_31387 = state_31291__$1;
(statearr_31305_31387[(2)] = inst_31286);

(statearr_31305_31387[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (4))){
var inst_31188 = (state_31291[(2)]);
var inst_31189 = cljs.core.List.EMPTY;
var inst_31190 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_31189);
var inst_31191 = (function (){return ((function (inst_31188,inst_31189,inst_31190,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31132_SHARP_){
var and__3938__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31132_SHARP_);
if(cljs.core.truth_(and__3938__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31132_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__31132_SHARP_))));
} else {
return and__3938__auto__;
}
});
;})(inst_31188,inst_31189,inst_31190,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31192 = cljs.core.filter.call(null,inst_31191,files);
var inst_31193 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_31194 = cljs.core.concat.call(null,inst_31192,inst_31193);
var state_31291__$1 = (function (){var statearr_31306 = state_31291;
(statearr_31306[(12)] = inst_31194);

(statearr_31306[(17)] = inst_31188);

(statearr_31306[(18)] = inst_31190);

return statearr_31306;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_31307_31388 = state_31291__$1;
(statearr_31307_31388[(1)] = (16));

} else {
var statearr_31308_31389 = state_31291__$1;
(statearr_31308_31389[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (15))){
var inst_31178 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31309_31390 = state_31291__$1;
(statearr_31309_31390[(2)] = inst_31178);

(statearr_31309_31390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (21))){
var inst_31204 = (state_31291[(19)]);
var inst_31204__$1 = (state_31291[(2)]);
var inst_31205 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_31204__$1);
var state_31291__$1 = (function (){var statearr_31310 = state_31291;
(statearr_31310[(19)] = inst_31204__$1);

return statearr_31310;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31291__$1,(22),inst_31205);
} else {
if((state_val_31292 === (31))){
var inst_31289 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31291__$1,inst_31289);
} else {
if((state_val_31292 === (32))){
var inst_31244 = (state_31291[(16)]);
var inst_31249 = inst_31244.cljs$lang$protocol_mask$partition0$;
var inst_31250 = (inst_31249 & (64));
var inst_31251 = inst_31244.cljs$core$ISeq$;
var inst_31252 = (cljs.core.PROTOCOL_SENTINEL === inst_31251);
var inst_31253 = ((inst_31250) || (inst_31252));
var state_31291__$1 = state_31291;
if(cljs.core.truth_(inst_31253)){
var statearr_31311_31391 = state_31291__$1;
(statearr_31311_31391[(1)] = (35));

} else {
var statearr_31312_31392 = state_31291__$1;
(statearr_31312_31392[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (40))){
var inst_31266 = (state_31291[(20)]);
var inst_31265 = (state_31291[(2)]);
var inst_31266__$1 = cljs.core.get.call(null,inst_31265,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_31267 = cljs.core.get.call(null,inst_31265,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_31268 = cljs.core.not_empty.call(null,inst_31266__$1);
var state_31291__$1 = (function (){var statearr_31313 = state_31291;
(statearr_31313[(21)] = inst_31267);

(statearr_31313[(20)] = inst_31266__$1);

return statearr_31313;
})();
if(cljs.core.truth_(inst_31268)){
var statearr_31314_31393 = state_31291__$1;
(statearr_31314_31393[(1)] = (41));

} else {
var statearr_31315_31394 = state_31291__$1;
(statearr_31315_31394[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (33))){
var state_31291__$1 = state_31291;
var statearr_31316_31395 = state_31291__$1;
(statearr_31316_31395[(2)] = false);

(statearr_31316_31395[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (13))){
var inst_31164 = (state_31291[(22)]);
var inst_31168 = cljs.core.chunk_first.call(null,inst_31164);
var inst_31169 = cljs.core.chunk_rest.call(null,inst_31164);
var inst_31170 = cljs.core.count.call(null,inst_31168);
var inst_31151 = inst_31169;
var inst_31152 = inst_31168;
var inst_31153 = inst_31170;
var inst_31154 = (0);
var state_31291__$1 = (function (){var statearr_31317 = state_31291;
(statearr_31317[(7)] = inst_31153);

(statearr_31317[(8)] = inst_31151);

(statearr_31317[(9)] = inst_31152);

(statearr_31317[(10)] = inst_31154);

return statearr_31317;
})();
var statearr_31318_31396 = state_31291__$1;
(statearr_31318_31396[(2)] = null);

(statearr_31318_31396[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (22))){
var inst_31212 = (state_31291[(23)]);
var inst_31207 = (state_31291[(24)]);
var inst_31208 = (state_31291[(25)]);
var inst_31204 = (state_31291[(19)]);
var inst_31207__$1 = (state_31291[(2)]);
var inst_31208__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31207__$1);
var inst_31209 = (function (){var all_files = inst_31204;
var res_SINGLEQUOTE_ = inst_31207__$1;
var res = inst_31208__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_31212,inst_31207,inst_31208,inst_31204,inst_31207__$1,inst_31208__$1,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31133_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__31133_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_31212,inst_31207,inst_31208,inst_31204,inst_31207__$1,inst_31208__$1,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31210 = cljs.core.filter.call(null,inst_31209,inst_31207__$1);
var inst_31211 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_31212__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31211);
var inst_31213 = cljs.core.not_empty.call(null,inst_31212__$1);
var state_31291__$1 = (function (){var statearr_31319 = state_31291;
(statearr_31319[(23)] = inst_31212__$1);

(statearr_31319[(24)] = inst_31207__$1);

(statearr_31319[(25)] = inst_31208__$1);

(statearr_31319[(26)] = inst_31210);

return statearr_31319;
})();
if(cljs.core.truth_(inst_31213)){
var statearr_31320_31397 = state_31291__$1;
(statearr_31320_31397[(1)] = (23));

} else {
var statearr_31321_31398 = state_31291__$1;
(statearr_31321_31398[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (36))){
var state_31291__$1 = state_31291;
var statearr_31322_31399 = state_31291__$1;
(statearr_31322_31399[(2)] = false);

(statearr_31322_31399[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (41))){
var inst_31266 = (state_31291[(20)]);
var inst_31270 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_31271 = cljs.core.map.call(null,inst_31270,inst_31266);
var inst_31272 = cljs.core.pr_str.call(null,inst_31271);
var inst_31273 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31272)].join('');
var inst_31274 = figwheel.client.utils.log.call(null,inst_31273);
var state_31291__$1 = state_31291;
var statearr_31323_31400 = state_31291__$1;
(statearr_31323_31400[(2)] = inst_31274);

(statearr_31323_31400[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (43))){
var inst_31267 = (state_31291[(21)]);
var inst_31277 = (state_31291[(2)]);
var inst_31278 = cljs.core.not_empty.call(null,inst_31267);
var state_31291__$1 = (function (){var statearr_31324 = state_31291;
(statearr_31324[(27)] = inst_31277);

return statearr_31324;
})();
if(cljs.core.truth_(inst_31278)){
var statearr_31325_31401 = state_31291__$1;
(statearr_31325_31401[(1)] = (44));

} else {
var statearr_31326_31402 = state_31291__$1;
(statearr_31326_31402[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (29))){
var inst_31212 = (state_31291[(23)]);
var inst_31207 = (state_31291[(24)]);
var inst_31208 = (state_31291[(25)]);
var inst_31210 = (state_31291[(26)]);
var inst_31244 = (state_31291[(16)]);
var inst_31204 = (state_31291[(19)]);
var inst_31240 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_31243 = (function (){var all_files = inst_31204;
var res_SINGLEQUOTE_ = inst_31207;
var res = inst_31208;
var files_not_loaded = inst_31210;
var dependencies_that_loaded = inst_31212;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31244,inst_31204,inst_31240,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31242){
var map__31327 = p__31242;
var map__31327__$1 = ((((!((map__31327 == null)))?(((((map__31327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31327.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31327):map__31327);
var namespace = cljs.core.get.call(null,map__31327__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31244,inst_31204,inst_31240,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31244__$1 = cljs.core.group_by.call(null,inst_31243,inst_31210);
var inst_31246 = (inst_31244__$1 == null);
var inst_31247 = cljs.core.not.call(null,inst_31246);
var state_31291__$1 = (function (){var statearr_31329 = state_31291;
(statearr_31329[(28)] = inst_31240);

(statearr_31329[(16)] = inst_31244__$1);

return statearr_31329;
})();
if(inst_31247){
var statearr_31330_31403 = state_31291__$1;
(statearr_31330_31403[(1)] = (32));

} else {
var statearr_31331_31404 = state_31291__$1;
(statearr_31331_31404[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (44))){
var inst_31267 = (state_31291[(21)]);
var inst_31280 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_31267);
var inst_31281 = cljs.core.pr_str.call(null,inst_31280);
var inst_31282 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31281)].join('');
var inst_31283 = figwheel.client.utils.log.call(null,inst_31282);
var state_31291__$1 = state_31291;
var statearr_31332_31405 = state_31291__$1;
(statearr_31332_31405[(2)] = inst_31283);

(statearr_31332_31405[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (6))){
var inst_31185 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31333_31406 = state_31291__$1;
(statearr_31333_31406[(2)] = inst_31185);

(statearr_31333_31406[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (28))){
var inst_31210 = (state_31291[(26)]);
var inst_31237 = (state_31291[(2)]);
var inst_31238 = cljs.core.not_empty.call(null,inst_31210);
var state_31291__$1 = (function (){var statearr_31334 = state_31291;
(statearr_31334[(29)] = inst_31237);

return statearr_31334;
})();
if(cljs.core.truth_(inst_31238)){
var statearr_31335_31407 = state_31291__$1;
(statearr_31335_31407[(1)] = (29));

} else {
var statearr_31336_31408 = state_31291__$1;
(statearr_31336_31408[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (25))){
var inst_31208 = (state_31291[(25)]);
var inst_31224 = (state_31291[(2)]);
var inst_31225 = cljs.core.not_empty.call(null,inst_31208);
var state_31291__$1 = (function (){var statearr_31337 = state_31291;
(statearr_31337[(30)] = inst_31224);

return statearr_31337;
})();
if(cljs.core.truth_(inst_31225)){
var statearr_31338_31409 = state_31291__$1;
(statearr_31338_31409[(1)] = (26));

} else {
var statearr_31339_31410 = state_31291__$1;
(statearr_31339_31410[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (34))){
var inst_31260 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
if(cljs.core.truth_(inst_31260)){
var statearr_31340_31411 = state_31291__$1;
(statearr_31340_31411[(1)] = (38));

} else {
var statearr_31341_31412 = state_31291__$1;
(statearr_31341_31412[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (17))){
var state_31291__$1 = state_31291;
var statearr_31342_31413 = state_31291__$1;
(statearr_31342_31413[(2)] = recompile_dependents);

(statearr_31342_31413[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (3))){
var state_31291__$1 = state_31291;
var statearr_31343_31414 = state_31291__$1;
(statearr_31343_31414[(2)] = null);

(statearr_31343_31414[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (12))){
var inst_31181 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31344_31415 = state_31291__$1;
(statearr_31344_31415[(2)] = inst_31181);

(statearr_31344_31415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (2))){
var inst_31143 = (state_31291[(13)]);
var inst_31150 = cljs.core.seq.call(null,inst_31143);
var inst_31151 = inst_31150;
var inst_31152 = null;
var inst_31153 = (0);
var inst_31154 = (0);
var state_31291__$1 = (function (){var statearr_31345 = state_31291;
(statearr_31345[(7)] = inst_31153);

(statearr_31345[(8)] = inst_31151);

(statearr_31345[(9)] = inst_31152);

(statearr_31345[(10)] = inst_31154);

return statearr_31345;
})();
var statearr_31346_31416 = state_31291__$1;
(statearr_31346_31416[(2)] = null);

(statearr_31346_31416[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (23))){
var inst_31212 = (state_31291[(23)]);
var inst_31207 = (state_31291[(24)]);
var inst_31208 = (state_31291[(25)]);
var inst_31210 = (state_31291[(26)]);
var inst_31204 = (state_31291[(19)]);
var inst_31215 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_31217 = (function (){var all_files = inst_31204;
var res_SINGLEQUOTE_ = inst_31207;
var res = inst_31208;
var files_not_loaded = inst_31210;
var dependencies_that_loaded = inst_31212;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31215,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31216){
var map__31347 = p__31216;
var map__31347__$1 = ((((!((map__31347 == null)))?(((((map__31347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31347):map__31347);
var request_url = cljs.core.get.call(null,map__31347__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31215,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31218 = cljs.core.reverse.call(null,inst_31212);
var inst_31219 = cljs.core.map.call(null,inst_31217,inst_31218);
var inst_31220 = cljs.core.pr_str.call(null,inst_31219);
var inst_31221 = figwheel.client.utils.log.call(null,inst_31220);
var state_31291__$1 = (function (){var statearr_31349 = state_31291;
(statearr_31349[(31)] = inst_31215);

return statearr_31349;
})();
var statearr_31350_31417 = state_31291__$1;
(statearr_31350_31417[(2)] = inst_31221);

(statearr_31350_31417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (35))){
var state_31291__$1 = state_31291;
var statearr_31351_31418 = state_31291__$1;
(statearr_31351_31418[(2)] = true);

(statearr_31351_31418[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (19))){
var inst_31194 = (state_31291[(12)]);
var inst_31200 = figwheel.client.file_reloading.expand_files.call(null,inst_31194);
var state_31291__$1 = state_31291;
var statearr_31352_31419 = state_31291__$1;
(statearr_31352_31419[(2)] = inst_31200);

(statearr_31352_31419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (11))){
var state_31291__$1 = state_31291;
var statearr_31353_31420 = state_31291__$1;
(statearr_31353_31420[(2)] = null);

(statearr_31353_31420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (9))){
var inst_31183 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31354_31421 = state_31291__$1;
(statearr_31354_31421[(2)] = inst_31183);

(statearr_31354_31421[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (5))){
var inst_31153 = (state_31291[(7)]);
var inst_31154 = (state_31291[(10)]);
var inst_31156 = (inst_31154 < inst_31153);
var inst_31157 = inst_31156;
var state_31291__$1 = state_31291;
if(cljs.core.truth_(inst_31157)){
var statearr_31355_31422 = state_31291__$1;
(statearr_31355_31422[(1)] = (7));

} else {
var statearr_31356_31423 = state_31291__$1;
(statearr_31356_31423[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (14))){
var inst_31164 = (state_31291[(22)]);
var inst_31173 = cljs.core.first.call(null,inst_31164);
var inst_31174 = figwheel.client.file_reloading.eval_body.call(null,inst_31173,opts);
var inst_31175 = cljs.core.next.call(null,inst_31164);
var inst_31151 = inst_31175;
var inst_31152 = null;
var inst_31153 = (0);
var inst_31154 = (0);
var state_31291__$1 = (function (){var statearr_31357 = state_31291;
(statearr_31357[(7)] = inst_31153);

(statearr_31357[(32)] = inst_31174);

(statearr_31357[(8)] = inst_31151);

(statearr_31357[(9)] = inst_31152);

(statearr_31357[(10)] = inst_31154);

return statearr_31357;
})();
var statearr_31358_31424 = state_31291__$1;
(statearr_31358_31424[(2)] = null);

(statearr_31358_31424[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (45))){
var state_31291__$1 = state_31291;
var statearr_31359_31425 = state_31291__$1;
(statearr_31359_31425[(2)] = null);

(statearr_31359_31425[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (26))){
var inst_31212 = (state_31291[(23)]);
var inst_31207 = (state_31291[(24)]);
var inst_31208 = (state_31291[(25)]);
var inst_31210 = (state_31291[(26)]);
var inst_31204 = (state_31291[(19)]);
var inst_31227 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_31229 = (function (){var all_files = inst_31204;
var res_SINGLEQUOTE_ = inst_31207;
var res = inst_31208;
var files_not_loaded = inst_31210;
var dependencies_that_loaded = inst_31212;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31227,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31228){
var map__31360 = p__31228;
var map__31360__$1 = ((((!((map__31360 == null)))?(((((map__31360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31360):map__31360);
var namespace = cljs.core.get.call(null,map__31360__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__31360__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31227,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31230 = cljs.core.map.call(null,inst_31229,inst_31208);
var inst_31231 = cljs.core.pr_str.call(null,inst_31230);
var inst_31232 = figwheel.client.utils.log.call(null,inst_31231);
var inst_31233 = (function (){var all_files = inst_31204;
var res_SINGLEQUOTE_ = inst_31207;
var res = inst_31208;
var files_not_loaded = inst_31210;
var dependencies_that_loaded = inst_31212;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31227,inst_31229,inst_31230,inst_31231,inst_31232,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31212,inst_31207,inst_31208,inst_31210,inst_31204,inst_31227,inst_31229,inst_31230,inst_31231,inst_31232,state_val_31292,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31234 = setTimeout(inst_31233,(10));
var state_31291__$1 = (function (){var statearr_31362 = state_31291;
(statearr_31362[(33)] = inst_31232);

(statearr_31362[(34)] = inst_31227);

return statearr_31362;
})();
var statearr_31363_31426 = state_31291__$1;
(statearr_31363_31426[(2)] = inst_31234);

(statearr_31363_31426[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (16))){
var state_31291__$1 = state_31291;
var statearr_31364_31427 = state_31291__$1;
(statearr_31364_31427[(2)] = reload_dependents);

(statearr_31364_31427[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (38))){
var inst_31244 = (state_31291[(16)]);
var inst_31262 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31244);
var state_31291__$1 = state_31291;
var statearr_31365_31428 = state_31291__$1;
(statearr_31365_31428[(2)] = inst_31262);

(statearr_31365_31428[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (30))){
var state_31291__$1 = state_31291;
var statearr_31366_31429 = state_31291__$1;
(statearr_31366_31429[(2)] = null);

(statearr_31366_31429[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (10))){
var inst_31164 = (state_31291[(22)]);
var inst_31166 = cljs.core.chunked_seq_QMARK_.call(null,inst_31164);
var state_31291__$1 = state_31291;
if(inst_31166){
var statearr_31367_31430 = state_31291__$1;
(statearr_31367_31430[(1)] = (13));

} else {
var statearr_31368_31431 = state_31291__$1;
(statearr_31368_31431[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (18))){
var inst_31198 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
if(cljs.core.truth_(inst_31198)){
var statearr_31369_31432 = state_31291__$1;
(statearr_31369_31432[(1)] = (19));

} else {
var statearr_31370_31433 = state_31291__$1;
(statearr_31370_31433[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (42))){
var state_31291__$1 = state_31291;
var statearr_31371_31434 = state_31291__$1;
(statearr_31371_31434[(2)] = null);

(statearr_31371_31434[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (37))){
var inst_31257 = (state_31291[(2)]);
var state_31291__$1 = state_31291;
var statearr_31372_31435 = state_31291__$1;
(statearr_31372_31435[(2)] = inst_31257);

(statearr_31372_31435[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31292 === (8))){
var inst_31151 = (state_31291[(8)]);
var inst_31164 = (state_31291[(22)]);
var inst_31164__$1 = cljs.core.seq.call(null,inst_31151);
var state_31291__$1 = (function (){var statearr_31373 = state_31291;
(statearr_31373[(22)] = inst_31164__$1);

return statearr_31373;
})();
if(inst_31164__$1){
var statearr_31374_31436 = state_31291__$1;
(statearr_31374_31436[(1)] = (10));

} else {
var statearr_31375_31437 = state_31291__$1;
(statearr_31375_31437[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__23913__auto__,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____0 = (function (){
var statearr_31376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31376[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__);

(statearr_31376[(1)] = (1));

return statearr_31376;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____1 = (function (state_31291){
while(true){
var ret_value__23915__auto__ = (function (){try{while(true){
var result__23916__auto__ = switch__23913__auto__.call(null,state_31291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23916__auto__;
}
break;
}
}catch (e31377){if((e31377 instanceof Object)){
var ex__23917__auto__ = e31377;
var statearr_31378_31438 = state_31291;
(statearr_31378_31438[(5)] = ex__23917__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23915__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31439 = state_31291;
state_31291 = G__31439;
continue;
} else {
return ret_value__23915__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__ = function(state_31291){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____1.call(this,state_31291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23914__auto__;
})()
;})(switch__23913__auto__,c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23971__auto__ = (function (){var statearr_31379 = f__23970__auto__.call(null);
(statearr_31379[(6)] = c__23969__auto__);

return statearr_31379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23971__auto__);
});})(c__23969__auto__,map__31136,map__31136__$1,opts,before_jsload,on_jsload,reload_dependents,map__31137,map__31137__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23969__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__31442,link){
var map__31443 = p__31442;
var map__31443__$1 = ((((!((map__31443 == null)))?(((((map__31443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31443.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31443):map__31443);
var file = cljs.core.get.call(null,map__31443__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__31443,map__31443__$1,file){
return (function (p1__31440_SHARP_,p2__31441_SHARP_){
if(cljs.core._EQ_.call(null,p1__31440_SHARP_,p2__31441_SHARP_)){
return p1__31440_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__31443,map__31443__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__31446){
var map__31447 = p__31446;
var map__31447__$1 = ((((!((map__31447 == null)))?(((((map__31447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31447):map__31447);
var match_length = cljs.core.get.call(null,map__31447__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__31447__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__31445_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__31445_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__31449_SHARP_,p2__31450_SHARP_){
return cljs.core.assoc.call(null,p1__31449_SHARP_,cljs.core.get.call(null,p2__31450_SHARP_,key),p2__31450_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_31451 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_31451);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_31451);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__31452,p__31453){
var map__31454 = p__31452;
var map__31454__$1 = ((((!((map__31454 == null)))?(((((map__31454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31454):map__31454);
var on_cssload = cljs.core.get.call(null,map__31454__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__31455 = p__31453;
var map__31455__$1 = ((((!((map__31455 == null)))?(((((map__31455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31455):map__31455);
var files_msg = map__31455__$1;
var files = cljs.core.get.call(null,map__31455__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1540478351168
