// Compiled by ClojureScript 1.10.339 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__27613__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__27610 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__27611 = cljs.core.seq.call(null,vec__27610);
var first__27612 = cljs.core.first.call(null,seq__27611);
var seq__27611__$1 = cljs.core.next.call(null,seq__27611);
var tag = first__27612;
var body = seq__27611__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args))], null),cljs.core.rest.call(null,body));
} else {
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first.call(null,args)], null),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__27613 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__27614__i = 0, G__27614__a = new Array(arguments.length -  0);
while (G__27614__i < G__27614__a.length) {G__27614__a[G__27614__i] = arguments[G__27614__i + 0]; ++G__27614__i;}
  args = new cljs.core.IndexedSeq(G__27614__a,0,null);
} 
return G__27613__delegate.call(this,args);};
G__27613.cljs$lang$maxFixedArity = 0;
G__27613.cljs$lang$applyTo = (function (arglist__27615){
var args = cljs.core.seq(arglist__27615);
return G__27613__delegate(args);
});
G__27613.cljs$core$IFn$_invoke$arity$variadic = G__27613__delegate;
return G__27613;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4324__auto__ = (function sablono$core$update_arglists_$_iter__27616(s__27617){
return (new cljs.core.LazySeq(null,(function (){
var s__27617__$1 = s__27617;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27617__$1);
if(temp__5457__auto__){
var s__27617__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27617__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27617__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27619 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27618 = (0);
while(true){
if((i__27618 < size__4323__auto__)){
var args = cljs.core._nth.call(null,c__4322__auto__,i__27618);
cljs.core.chunk_append.call(null,b__27619,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__27620 = (i__27618 + (1));
i__27618 = G__27620;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27619),sablono$core$update_arglists_$_iter__27616.call(null,cljs.core.chunk_rest.call(null,s__27617__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27619),null);
}
} else {
var args = cljs.core.first.call(null,s__27617__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__27616.call(null,cljs.core.rest.call(null,s__27617__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27626 = arguments.length;
var i__4532__auto___27627 = (0);
while(true){
if((i__4532__auto___27627 < len__4531__auto___27626)){
args__4534__auto__.push((arguments[i__4532__auto___27627]));

var G__27628 = (i__4532__auto___27627 + (1));
i__4532__auto___27627 = G__27628;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4324__auto__ = (function sablono$core$iter__27622(s__27623){
return (new cljs.core.LazySeq(null,(function (){
var s__27623__$1 = s__27623;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27623__$1);
if(temp__5457__auto__){
var s__27623__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27623__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27623__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27625 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27624 = (0);
while(true){
if((i__27624 < size__4323__auto__)){
var style = cljs.core._nth.call(null,c__4322__auto__,i__27624);
cljs.core.chunk_append.call(null,b__27625,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__27629 = (i__27624 + (1));
i__27624 = G__27629;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27625),sablono$core$iter__27622.call(null,cljs.core.chunk_rest.call(null,s__27623__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27625),null);
}
} else {
var style = cljs.core.first.call(null,s__27623__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__27622.call(null,cljs.core.rest.call(null,s__27623__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
sablono.core.include_css.cljs$lang$applyTo = (function (seq27621){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27621));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to27630 = (function sablono$core$link_to27630(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27633 = arguments.length;
var i__4532__auto___27634 = (0);
while(true){
if((i__4532__auto___27634 < len__4531__auto___27633)){
args__4534__auto__.push((arguments[i__4532__auto___27634]));

var G__27635 = (i__4532__auto___27634 + (1));
i__4532__auto___27634 = G__27635;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to27630.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

sablono.core.link_to27630.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to27630.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.link_to27630.cljs$lang$applyTo = (function (seq27631){
var G__27632 = cljs.core.first.call(null,seq27631);
var seq27631__$1 = cljs.core.next.call(null,seq27631);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27632,seq27631__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to27630);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to27636 = (function sablono$core$mail_to27636(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27643 = arguments.length;
var i__4532__auto___27644 = (0);
while(true){
if((i__4532__auto___27644 < len__4531__auto___27643)){
args__4534__auto__.push((arguments[i__4532__auto___27644]));

var G__27645 = (i__4532__auto___27644 + (1));
i__4532__auto___27644 = G__27645;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to27636.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

sablono.core.mail_to27636.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__27639){
var vec__27640 = p__27639;
var content = cljs.core.nth.call(null,vec__27640,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__3949__auto__ = content;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to27636.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.mail_to27636.cljs$lang$applyTo = (function (seq27637){
var G__27638 = cljs.core.first.call(null,seq27637);
var seq27637__$1 = cljs.core.next.call(null,seq27637);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27638,seq27637__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to27636);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list27646 = (function sablono$core$unordered_list27646(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4324__auto__ = (function sablono$core$unordered_list27646_$_iter__27647(s__27648){
return (new cljs.core.LazySeq(null,(function (){
var s__27648__$1 = s__27648;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27648__$1);
if(temp__5457__auto__){
var s__27648__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27648__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27648__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27650 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27649 = (0);
while(true){
if((i__27649 < size__4323__auto__)){
var x = cljs.core._nth.call(null,c__4322__auto__,i__27649);
cljs.core.chunk_append.call(null,b__27650,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__27651 = (i__27649 + (1));
i__27649 = G__27651;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27650),sablono$core$unordered_list27646_$_iter__27647.call(null,cljs.core.chunk_rest.call(null,s__27648__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27650),null);
}
} else {
var x = cljs.core.first.call(null,s__27648__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list27646_$_iter__27647.call(null,cljs.core.rest.call(null,s__27648__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list27646);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list27652 = (function sablono$core$ordered_list27652(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4324__auto__ = (function sablono$core$ordered_list27652_$_iter__27653(s__27654){
return (new cljs.core.LazySeq(null,(function (){
var s__27654__$1 = s__27654;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27654__$1);
if(temp__5457__auto__){
var s__27654__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27654__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27654__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27656 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27655 = (0);
while(true){
if((i__27655 < size__4323__auto__)){
var x = cljs.core._nth.call(null,c__4322__auto__,i__27655);
cljs.core.chunk_append.call(null,b__27656,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__27657 = (i__27655 + (1));
i__27655 = G__27657;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27656),sablono$core$ordered_list27652_$_iter__27653.call(null,cljs.core.chunk_rest.call(null,s__27654__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27656),null);
}
} else {
var x = cljs.core.first.call(null,s__27654__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list27652_$_iter__27653.call(null,cljs.core.rest.call(null,s__27654__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list27652);
/**
 * Create an image element.
 */
sablono.core.image27658 = (function sablono$core$image27658(var_args){
var G__27660 = arguments.length;
switch (G__27660) {
case 1:
return sablono.core.image27658.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image27658.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image27658.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image27658.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image27658.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image27658);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__27662_SHARP_,p2__27663_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27662_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__27663_SHARP_),"]"].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__27664_SHARP_,p2__27665_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27664_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__27665_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__27667 = arguments.length;
switch (G__27667) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__3949__auto__ = value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Creates a color input field.
 */
sablono.core.color_field27669 = (function sablono$core$color_field27669(var_args){
var G__27671 = arguments.length;
switch (G__27671) {
case 1:
return sablono.core.color_field27669.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field27669.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field27669.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__27600__auto__);
});

sablono.core.color_field27669.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.color_field27669.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field27669);

/**
 * Creates a date input field.
 */
sablono.core.date_field27672 = (function sablono$core$date_field27672(var_args){
var G__27674 = arguments.length;
switch (G__27674) {
case 1:
return sablono.core.date_field27672.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field27672.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field27672.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__27600__auto__);
});

sablono.core.date_field27672.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.date_field27672.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field27672);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field27675 = (function sablono$core$datetime_field27675(var_args){
var G__27677 = arguments.length;
switch (G__27677) {
case 1:
return sablono.core.datetime_field27675.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field27675.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field27675.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__27600__auto__);
});

sablono.core.datetime_field27675.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.datetime_field27675.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field27675);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field27678 = (function sablono$core$datetime_local_field27678(var_args){
var G__27680 = arguments.length;
switch (G__27680) {
case 1:
return sablono.core.datetime_local_field27678.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field27678.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field27678.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__27600__auto__);
});

sablono.core.datetime_local_field27678.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.datetime_local_field27678.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field27678);

/**
 * Creates a email input field.
 */
sablono.core.email_field27681 = (function sablono$core$email_field27681(var_args){
var G__27683 = arguments.length;
switch (G__27683) {
case 1:
return sablono.core.email_field27681.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field27681.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field27681.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__27600__auto__);
});

sablono.core.email_field27681.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.email_field27681.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field27681);

/**
 * Creates a file input field.
 */
sablono.core.file_field27684 = (function sablono$core$file_field27684(var_args){
var G__27686 = arguments.length;
switch (G__27686) {
case 1:
return sablono.core.file_field27684.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field27684.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field27684.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__27600__auto__);
});

sablono.core.file_field27684.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.file_field27684.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field27684);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field27687 = (function sablono$core$hidden_field27687(var_args){
var G__27689 = arguments.length;
switch (G__27689) {
case 1:
return sablono.core.hidden_field27687.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field27687.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field27687.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__27600__auto__);
});

sablono.core.hidden_field27687.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.hidden_field27687.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field27687);

/**
 * Creates a month input field.
 */
sablono.core.month_field27690 = (function sablono$core$month_field27690(var_args){
var G__27692 = arguments.length;
switch (G__27692) {
case 1:
return sablono.core.month_field27690.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field27690.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field27690.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__27600__auto__);
});

sablono.core.month_field27690.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.month_field27690.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field27690);

/**
 * Creates a number input field.
 */
sablono.core.number_field27693 = (function sablono$core$number_field27693(var_args){
var G__27695 = arguments.length;
switch (G__27695) {
case 1:
return sablono.core.number_field27693.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field27693.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field27693.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__27600__auto__);
});

sablono.core.number_field27693.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.number_field27693.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field27693);

/**
 * Creates a password input field.
 */
sablono.core.password_field27696 = (function sablono$core$password_field27696(var_args){
var G__27698 = arguments.length;
switch (G__27698) {
case 1:
return sablono.core.password_field27696.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field27696.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field27696.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__27600__auto__);
});

sablono.core.password_field27696.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.password_field27696.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field27696);

/**
 * Creates a range input field.
 */
sablono.core.range_field27699 = (function sablono$core$range_field27699(var_args){
var G__27701 = arguments.length;
switch (G__27701) {
case 1:
return sablono.core.range_field27699.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field27699.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field27699.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__27600__auto__);
});

sablono.core.range_field27699.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.range_field27699.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field27699);

/**
 * Creates a search input field.
 */
sablono.core.search_field27702 = (function sablono$core$search_field27702(var_args){
var G__27704 = arguments.length;
switch (G__27704) {
case 1:
return sablono.core.search_field27702.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field27702.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field27702.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__27600__auto__);
});

sablono.core.search_field27702.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.search_field27702.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field27702);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field27705 = (function sablono$core$tel_field27705(var_args){
var G__27707 = arguments.length;
switch (G__27707) {
case 1:
return sablono.core.tel_field27705.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field27705.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field27705.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__27600__auto__);
});

sablono.core.tel_field27705.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.tel_field27705.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field27705);

/**
 * Creates a text input field.
 */
sablono.core.text_field27708 = (function sablono$core$text_field27708(var_args){
var G__27710 = arguments.length;
switch (G__27710) {
case 1:
return sablono.core.text_field27708.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field27708.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field27708.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__27600__auto__);
});

sablono.core.text_field27708.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.text_field27708.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field27708);

/**
 * Creates a time input field.
 */
sablono.core.time_field27711 = (function sablono$core$time_field27711(var_args){
var G__27713 = arguments.length;
switch (G__27713) {
case 1:
return sablono.core.time_field27711.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field27711.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field27711.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__27600__auto__);
});

sablono.core.time_field27711.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.time_field27711.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field27711);

/**
 * Creates a url input field.
 */
sablono.core.url_field27714 = (function sablono$core$url_field27714(var_args){
var G__27716 = arguments.length;
switch (G__27716) {
case 1:
return sablono.core.url_field27714.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field27714.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field27714.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__27600__auto__);
});

sablono.core.url_field27714.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.url_field27714.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field27714);

/**
 * Creates a week input field.
 */
sablono.core.week_field27717 = (function sablono$core$week_field27717(var_args){
var G__27719 = arguments.length;
switch (G__27719) {
case 1:
return sablono.core.week_field27717.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field27717.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field27717.cljs$core$IFn$_invoke$arity$1 = (function (name__27600__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__27600__auto__);
});

sablono.core.week_field27717.cljs$core$IFn$_invoke$arity$2 = (function (name__27600__auto__,value__27601__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__27600__auto__,value__27601__auto__);
});

sablono.core.week_field27717.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field27717);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box27737 = (function sablono$core$check_box27737(var_args){
var G__27739 = arguments.length;
switch (G__27739) {
case 1:
return sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box27737.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box27737.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box27737);
/**
 * Creates a radio button.
 */
sablono.core.radio_button27741 = (function sablono$core$radio_button27741(var_args){
var G__27743 = arguments.length;
switch (G__27743) {
case 1:
return sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group))], null)], null);
});

sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group)),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button27741.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button27741.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button27741);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options27745 = (function sablono$core$select_options27745(coll){
var iter__4324__auto__ = (function sablono$core$select_options27745_$_iter__27746(s__27747){
return (new cljs.core.LazySeq(null,(function (){
var s__27747__$1 = s__27747;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27747__$1);
if(temp__5457__auto__){
var s__27747__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27747__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27747__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27749 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27748 = (0);
while(true){
if((i__27748 < size__4323__auto__)){
var x = cljs.core._nth.call(null,c__4322__auto__,i__27748);
cljs.core.chunk_append.call(null,b__27749,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__27750 = x;
var text = cljs.core.nth.call(null,vec__27750,(0),null);
var val = cljs.core.nth.call(null,vec__27750,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__27750,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options27745.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__27756 = (i__27748 + (1));
i__27748 = G__27756;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27749),sablono$core$select_options27745_$_iter__27746.call(null,cljs.core.chunk_rest.call(null,s__27747__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27749),null);
}
} else {
var x = cljs.core.first.call(null,s__27747__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__27753 = x;
var text = cljs.core.nth.call(null,vec__27753,(0),null);
var val = cljs.core.nth.call(null,vec__27753,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__27753,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options27745.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options27745_$_iter__27746.call(null,cljs.core.rest.call(null,s__27747__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options27745);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down27757 = (function sablono$core$drop_down27757(var_args){
var G__27759 = arguments.length;
switch (G__27759) {
case 2:
return sablono.core.drop_down27757.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down27757.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down27757.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down27757.call(null,name,options,null);
});

sablono.core.drop_down27757.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down27757.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down27757);
/**
 * Creates a text area element.
 */
sablono.core.text_area27761 = (function sablono$core$text_area27761(var_args){
var G__27763 = arguments.length;
switch (G__27763) {
case 1:
return sablono.core.text_area27761.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area27761.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area27761.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.text_area27761.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__3949__auto__ = value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area27761.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area27761);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label27765 = (function sablono$core$label27765(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label27765);
/**
 * Creates a submit button.
 */
sablono.core.submit_button27766 = (function sablono$core$submit_button27766(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button27766);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button27767 = (function sablono$core$reset_button27767(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button27767);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to27768 = (function sablono$core$form_to27768(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27775 = arguments.length;
var i__4532__auto___27776 = (0);
while(true){
if((i__4532__auto___27776 < len__4531__auto___27775)){
args__4534__auto__.push((arguments[i__4532__auto___27776]));

var G__27777 = (i__4532__auto___27776 + (1));
i__4532__auto___27776 = G__27777;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to27768.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

sablono.core.form_to27768.cljs$core$IFn$_invoke$arity$variadic = (function (p__27771,body){
var vec__27772 = p__27771;
var method = cljs.core.nth.call(null,vec__27772,(0),null);
var action = cljs.core.nth.call(null,vec__27772,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to27768.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.form_to27768.cljs$lang$applyTo = (function (seq27769){
var G__27770 = cljs.core.first.call(null,seq27769);
var seq27769__$1 = cljs.core.next.call(null,seq27769);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27770,seq27769__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to27768);

//# sourceMappingURL=core.js.map?rel=1540478334287
