// Compiled by ClojureScript 1.10.339 {}
goog.provide('tree_form.utils');
goog.require('cljs.core');
goog.require('reagent.interop');
goog.require('re_frame.core');
tree_form.utils.nil_fn = cljs.core.constantly.call(null,null);
/**
 * Prepare form fields to save inside DB
 *   Result is:
 * 
 *   {:field-name default-value
 * ...}
 *   
 */
tree_form.utils.prepare_form_fields = (function tree_form$utils$prepare_form_fields(fields){
return cljs.core.reduce_kv.call(null,(function (fields__$1,id,field){
return cljs.core.assoc.call(null,fields__$1,id,new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(field));
}),cljs.core.PersistentArrayMap.EMPTY,fields);
});
/**
 * Extract value from DOM event
 */
tree_form.utils.event__GT_value = (function tree_form$utils$event__GT_value(event){
return (event["target"]["value"]);
});
/**
 * Prepare form fields to use inside UI components
 *   Result is:
 * 
 *   {:field-name {:action fn
 *              :value field-value}
 * ...}
 *   
 */
tree_form.utils.create_fields = (function tree_form$utils$create_fields(raw_fields,p__32541){
var map__32542 = p__32541;
var map__32542__$1 = ((((!((map__32542 == null)))?(((((map__32542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32542):map__32542);
var id = cljs.core.get.call(null,map__32542__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var fields = cljs.core.get.call(null,map__32542__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
return cljs.core.reduce_kv.call(null,((function (map__32542,map__32542__$1,id,fields){
return (function (fields__$1,field_id,field){
return cljs.core.assoc.call(null,fields__$1,field_id,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,raw_fields,field_id),new cljs.core.Keyword(null,"action","action",-811238024),((function (map__32542,map__32542__$1,id,fields){
return (function() { 
var G__32544__delegate = function (args){
var process = (function (){var or__3949__auto__ = new cljs.core.Keyword(null,"process","process",1643192938).cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return tree_form.utils.event__GT_value;
}
})();
var value = cljs.core.apply.call(null,process,args);
var validate = new cljs.core.Keyword(null,"validate","validate",-201300827).cljs$core$IFn$_invoke$arity$1(field);
var validate_on_action = new cljs.core.Keyword(null,"validate-on-action","validate-on-action",76090743).cljs$core$IFn$_invoke$arity$1(field);
var error = (cljs.core.truth_(validate_on_action)?validate.call(null,value):null);
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","update-form-field","tree-form/update-form-field",1407490309),id,field_id,value], null));

if(cljs.core.truth_(error)){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","set-form-field-error","tree-form/set-form-field-error",-52971566),id,field_id,error], null));
} else {
return null;
}
};
var G__32544 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__32545__i = 0, G__32545__a = new Array(arguments.length -  0);
while (G__32545__i < G__32545__a.length) {G__32545__a[G__32545__i] = arguments[G__32545__i + 0]; ++G__32545__i;}
  args = new cljs.core.IndexedSeq(G__32545__a,0,null);
} 
return G__32544__delegate.call(this,args);};
G__32544.cljs$lang$maxFixedArity = 0;
G__32544.cljs$lang$applyTo = (function (arglist__32546){
var args = cljs.core.seq(arglist__32546);
return G__32544__delegate(args);
});
G__32544.cljs$core$IFn$_invoke$arity$variadic = G__32544__delegate;
return G__32544;
})()
;})(map__32542,map__32542__$1,id,fields))
], null));
});})(map__32542,map__32542__$1,id,fields))
,cljs.core.PersistentArrayMap.EMPTY,fields);
});
/**
 * Create subscriptions from config map {:subscription-name subscription-path}
 */
tree_form.utils.create_subscriptions = (function tree_form$utils$create_subscriptions(config){
return cljs.core.reduce_kv.call(null,(function (subs,subs_name,subs_path){
return cljs.core.assoc.call(null,subs,subs_name,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tree-form","to-path","tree-form/to-path",-33062865),subs_path], null)));
}),cljs.core.PersistentArrayMap.EMPTY,config);
});
/**
 * Deref all subscriptions in subscriptions map
 */
tree_form.utils.deref_subscriptions = (function tree_form$utils$deref_subscriptions(subs_map){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p1__32547_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.first.call(null,p1__32547_SHARP_),cljs.core.deref.call(null,cljs.core.second.call(null,p1__32547_SHARP_))],null));
}),subs_map));
});
tree_form.utils.extract_fields_with_validators = (function tree_form$utils$extract_fields_with_validators(fields){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p1__32548_SHARP_){
return new cljs.core.Keyword(null,"validate","validate",-201300827).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__32548_SHARP_));
}),fields));
});
tree_form.utils.validate_form = (function tree_form$utils$validate_form(validate,fields_with_validators,form_fields){
var form_errors = (cljs.core.truth_(validate)?validate.call(null,form_fields):cljs.core.PersistentArrayMap.EMPTY);
var fields_errors = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (form_errors){
return (function (p1__32549_SHARP_){
return !((cljs.core.second.call(null,p1__32549_SHARP_) == null));
});})(form_errors))
,cljs.core.reduce_kv.call(null,((function (form_errors){
return (function (errors,field_id,field_with_validator){
var value = cljs.core.get.call(null,form_fields,field_id);
var validator = new cljs.core.Keyword(null,"validate","validate",-201300827).cljs$core$IFn$_invoke$arity$1(field_with_validator);
return cljs.core.assoc.call(null,errors,field_id,validator.call(null,value));
});})(form_errors))
,cljs.core.PersistentArrayMap.EMPTY,fields_with_validators)));
return cljs.core.merge.call(null,form_errors,fields_errors);
});

//# sourceMappingURL=utils.js.map?rel=1541071439635
